package com.ejie.y41b.service;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjuntarAlertaprograDao;
import com.ejie.y41b.dao.AdjuntarDistribuidorDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.AlertaProgramacionDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntarAlertaprogra;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjuntarAlertaprograServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntarAlertaprograService")
public class AdjuntarAlertaprograServiceImpl implements AdjuntarAlertaprograService {

	@Autowired
	private AdjuntarAlertaprograDao adjuntarAlertaprograDao;
	@Autowired
	private AdjuntarDistribuidorDao adjuntarDistribuidorDao;
	@Autowired
	private AdjuntarDistribuidorService adjuntarDistribuidorService;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private DocumentoHechoDao documentoHechoDao;
	@Autowired
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired
	private TramiteInspeccionDao tramiteInspeccionDao;
	@Autowired
	private AlertaProgramacionDao alertaProgramacionDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserta los registros en la tabla temporal de programacin de la alerta
	 * 
	 * @param alerta
	 *            Alerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addAlertaprograTableTemporal(Alerta alerta) {

		this.adjuntarAlertaprograDao.removeAllAlertaprogra(alerta);
		this.adjuntarDistribuidorDao.removeAllAlertaDistribuidor(alerta);
		this.adjuntarDistribuidorDao.addAlertaDistribuidor(alerta);
		this.adjuntarAlertaprograDao.addAlertaprogra(alerta);

		AdjuntarAlertaprogra adjuntarAlertaprogra = new AdjuntarAlertaprogra();
		adjuntarAlertaprogra.setCrcoal(alerta.getAlcodigo());

		List<AdjuntarAlertaprogra> listAdjuntarAlertaprogra = this.adjuntarAlertaprograDao.findAll(adjuntarAlertaprogra,
				null);

		for (AdjuntarAlertaprogra adjuntarAlertaprograAux : listAdjuntarAlertaprogra) {
			this.adjuntardocsDao.removeAllDocsTableTemporal(adjuntarAlertaprograAux.getCrcodigo());
			this.documentoHechoDao.addAdjuntarDocs(adjuntarAlertaprograAux.getCrcodigo());
		}
	}

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarAlertaprogra add(AdjuntarAlertaprogra adjuntarAlertaprogra) {
		return this.adjuntarAlertaprograDao.add(adjuntarAlertaprogra);
	}

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarAlertaprogra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarAlertaprogra addAlertaprogra(AdjuntarAlertaprogra adjuntarAlertaprogra, String codAlertaAlta) {
		adjuntarAlertaprogra.setCrcoal(codAlertaAlta);
		adjuntarAlertaprogra = this.adjuntarAlertaprograDao.add(adjuntarAlertaprogra);

		AdjuntarAlertaprogra adjuntarAlertaprograAux = new AdjuntarAlertaprogra();
		adjuntarAlertaprograAux.setCrcoal(adjuntarAlertaprogra.getCrcoal());
		adjuntarAlertaprograAux.setCrcoor(adjuntarAlertaprogra.getCrcoor());
		adjuntarAlertaprograAux.setCrcodigodistribuidor(adjuntarAlertaprogra.getCrcodigodistribuidor());
		adjuntarAlertaprograAux.setCrfechacomunicacion(adjuntarAlertaprogra.getCrfechacomunicacion());

		if (this.adjuntarAlertaprograDao.findAllCount(adjuntarAlertaprograAux) > 1) {
			throw new Y41bUDAException("error.alerta.programacionException", true, null);
		}

		if (adjuntarAlertaprogra.getAnyadirPlantilla() == null) {
			if (adjuntarAlertaprogra.getCracuerdoinicio() != null
					&& adjuntarAlertaprogra.getCracuerdoinicio().equals(Y41bConstantes.VALOR_SI)) {
				Adjuntardocs adjuntardocsAux2 = new Adjuntardocs();
				TipoDocumento tipoDocumentoAux2 = new TipoDocumento();
				tipoDocumentoAux2.setIdTipodoc(Y41bConstantes.TIPO_DOC_AIP);

				adjuntardocsAux2.setTipoDocumento(tipoDocumentoAux2);
				adjuntardocsAux2.setThidExpediente(adjuntarAlertaprogra.getCrcodigo());

				Long numAcuerdoInicioProcedimiento = this.adjuntardocsDao.findAllCount(adjuntardocsAux2);

				if (numAcuerdoInicioProcedimiento < 1) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, null);
				}
			}
		}

		return adjuntarAlertaprogra;
	}

	/**
	 * Updates a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarAlertaprogra update(AdjuntarAlertaprogra adjuntarAlertaprogra) {
		return this.adjuntarAlertaprograDao.update(adjuntarAlertaprogra);
	}

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarAlertaprogra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarAlertaprogra updateAlertaprogra(AdjuntarAlertaprogra adjuntarAlertaprogra, String codAlertaAlta) {
		adjuntarAlertaprogra.setCrcoal(codAlertaAlta);
		adjuntarAlertaprogra = this.adjuntarAlertaprograDao.update(adjuntarAlertaprogra);

		AdjuntarAlertaprogra adjuntarAlertaprograAux = new AdjuntarAlertaprogra();
		adjuntarAlertaprograAux.setCrcoal(adjuntarAlertaprogra.getCrcoal());
		adjuntarAlertaprograAux.setCrcoor(adjuntarAlertaprogra.getCrcoor());
		adjuntarAlertaprograAux.setCrcodigodistribuidor(adjuntarAlertaprogra.getCrcodigodistribuidor());
		adjuntarAlertaprograAux.setCrfechacomunicacion(adjuntarAlertaprogra.getCrfechacomunicacion());

		if (this.adjuntarAlertaprograDao.findAllCount(adjuntarAlertaprograAux) > 1) {
			throw new Y41bUDAException("error.alerta.programacionException", true, null);
		}

		if (adjuntarAlertaprogra.getAnyadirPlantilla() == null) {
			if (adjuntarAlertaprogra.getCracuerdoinicio() != null
					&& adjuntarAlertaprogra.getCracuerdoinicio().equals(Y41bConstantes.VALOR_SI)) {
				Adjuntardocs adjuntardocsAux2 = new Adjuntardocs();
				TipoDocumento tipoDocumentoAux2 = new TipoDocumento();
				tipoDocumentoAux2.setIdTipodoc(Y41bConstantes.TIPO_DOC_AIP);

				adjuntardocsAux2.setTipoDocumento(tipoDocumentoAux2);
				adjuntardocsAux2.setThidExpediente(adjuntarAlertaprogra.getCrcodigo());

				Long numAcuerdoInicioProcedimiento = this.adjuntardocsDao.findAllCount(adjuntardocsAux2);

				if (numAcuerdoInicioProcedimiento < 1) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, null);
				}
			}
		}

		return adjuntarAlertaprogra;
	}

	/**
	 * Update a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarAlertaprogra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjuntarAlertaprogra updateNumProgramacionesAlertaProgramacion(AdjuntarAlertaprogra adjuntarAlertaprogra,
			String codAlertaAlta) {

		AlertaProgramacion alertaProgramacion = new AlertaProgramacion();
		alertaProgramacion.setCrcodigo(adjuntarAlertaprogra.getCrcodigo());
		alertaProgramacion = this.alertaProgramacionDao.find(alertaProgramacion);

		// Comparar las inspecciones solicitadas ahora con las inspecciones
		// solicitadas antes, si es menor no dejar, lanzar error.
		if (alertaProgramacion != null) {
			if (adjuntarAlertaprogra.getCrcnactu() < alertaProgramacion.getCrcnactu()) {
				String[] args = new String[1];
				args[0] = alertaProgramacion.getCrcnactu().toString();

				String errormsg = this.appMessageSource.getMessage("error.alerta.numInspeccionesException", args,
						LocaleContextHolder.getLocale());

				throw new Y41bUDAException(errormsg, true, null);
			}
		}

		adjuntarAlertaprogra.setCrcoal(codAlertaAlta);
		adjuntarAlertaprogra = this.adjuntarAlertaprograDao.updateNumActuaciones(adjuntarAlertaprogra);

		return adjuntarAlertaprogra;
	}

	/**
	 * Finds a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra find(AdjuntarAlertaprogra adjuntarAlertaprogra) {
		return (AdjuntarAlertaprogra) this.adjuntarAlertaprograDao.find(adjuntarAlertaprogra);
	}

	/**
	 * Finds a List of rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjuntarAlertaprogra> findAll(AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination) {
		List<AdjuntarAlertaprogra> listAdjuntarAlertaprogra = (List<AdjuntarAlertaprogra>) this.adjuntarAlertaprograDao
				.findAll(adjuntarAlertaprogra, pagination);

		AdjuntarDistribuidor adjuntarDistribuidor = null;
		for (AdjuntarAlertaprogra adjuntarAlertaprograAux : listAdjuntarAlertaprogra) {

			adjuntarDistribuidor = new AdjuntarDistribuidor();
			adjuntarDistribuidor.setRdcodigo(adjuntarAlertaprograAux.getCrcodigodistribuidor());

			adjuntarDistribuidor = this.adjuntarDistribuidorService.find(adjuntarDistribuidor);

			if (adjuntarDistribuidor != null) {
				adjuntarAlertaprograAux.setNombredistribuidor(adjuntarDistribuidor.getNombre());
				adjuntarAlertaprograAux.setEsnocodistribuidor(adjuntarDistribuidor.getEsnoco());
			}

			// Campos calculados
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcoal(adjuntarAlertaprograAux.getCrcoal());
			actuacion.setAtcocr(adjuntarAlertaprograAux.getCrcodigo());
			Long numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);

			adjuntarAlertaprograAux.setCrnumInspeccionesRealizadas(numInspeccionesRealizadas.intValue());

			Long numInspeccionesEnCurso = this.actuacionDao.findAllInspeccionesEnCursoCount(actuacion);

			adjuntarAlertaprograAux.setCrnumInspeccionesEnCurso(numInspeccionesEnCurso.intValue());

			Actuacion actuacionAux = this.actuacionDao.findNumProductosActuacion(actuacion);

			if (actuacionAux != null) {
				adjuntarAlertaprograAux.setCrnumProductosInmovilizados(actuacionAux.getAtuinmovilizadas().intValue());
				adjuntarAlertaprograAux.setCrnumProductosDestruidos(actuacionAux.getAtudestruidas().intValue());
				adjuntarAlertaprograAux
						.setCrnumProductosDevueltosOrigen(actuacionAux.getAtudevolucionorigen().intValue());
				adjuntarAlertaprograAux
						.setCrnumProductosLibreComercializacion(actuacionAux.getAtulibrecomercializacion().intValue());
				adjuntarAlertaprograAux.setCrnumProductosOtros(actuacionAux.getAtuotros().intValue());
				adjuntarAlertaprograAux.setCrnumProductosTomaMuestras(actuacionAux.getAtutomamuestras().intValue());

				adjuntarAlertaprograAux.setCrnumProductosRecuperados(actuacionAux.getAturecuperadas().intValue());
				adjuntarAlertaprograAux.setCrnumProductosPendientes(actuacionAux.getAtupendientes().intValue());
			} else {
				adjuntarAlertaprograAux.setCrnumProductosInmovilizados(0);
				adjuntarAlertaprograAux.setCrnumProductosDestruidos(0);
				adjuntarAlertaprograAux.setCrnumProductosDevueltosOrigen(0);
				adjuntarAlertaprograAux.setCrnumProductosLibreComercializacion(0);
				adjuntarAlertaprograAux.setCrnumProductosOtros(0);
				adjuntarAlertaprograAux.setCrnumProductosTomaMuestras(0);
				adjuntarAlertaprograAux.setCrnumProductosRecuperados(0);
				adjuntarAlertaprograAux.setCrnumProductosPendientes(0);
			}
		}

		return listAdjuntarAlertaprogra;
	}

	/**
	 * Counts rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return Long
	 */
	public Long findAllCount(AdjuntarAlertaprogra adjuntarAlertaprogra) {
		return this.adjuntarAlertaprograDao.findAllCount(adjuntarAlertaprogra);
	}

	/**
	 * Finds rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjuntarAlertaprogra> findAllLike(AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination,
			Boolean startsWith) {
		return (List<AdjuntarAlertaprogra>) this.adjuntarAlertaprograDao.findAllLike(adjuntarAlertaprogra, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjuntarAlertaprogra adjuntarAlertaprogra, Boolean startsWith) {
		return this.adjuntarAlertaprograDao.findAllLikeCount(adjuntarAlertaprogra, startsWith);
	}

	/**
	 * Deletes a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjuntarAlertaprogra adjuntarAlertaprogra) {
		// buscar la programacion
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcocr(adjuntarAlertaprogra.getCrcodigo());
		Long numInspeccionesIniciada = this.tramiteInspeccionDao
				.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacion);

		// Si tiene expedientes abiertos se lanza error
		if (numInspeccionesIniciada > 0) {
			throw new Y41bUDAException("error.alerta.InspeccionesAbiertasException", true, new Exception());
		}

		AdjuntarAlertaprogra adjuntarAlertaprograAux = this.adjuntarAlertaprograDao.find(adjuntarAlertaprogra);

		// Programacin creada en L21GEST
		if (adjuntarAlertaprograAux != null && adjuntarAlertaprograAux.getCrfechacomunicacion() == null) {
			throw new Y41bUDAException("error.alerta.ProgramacionL21Exception", true, new Exception());
		}

		this.adjuntarAlertaprograDao.remove(adjuntarAlertaprogra);

		this.adjuntardocsDao.removeAllDocsTableTemporal(adjuntarAlertaprogra.getCrcodigo());
	}

	/**
	 * Deletes multiple rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprograList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<AdjuntarAlertaprogra> adjuntarAlertaprograList) {
		for (AdjuntarAlertaprogra adjuntarAlertaprograAux : adjuntarAlertaprograList) {
			this.adjuntarAlertaprograDao.remove(adjuntarAlertaprograAux);
		}
	}

}
