package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarAlertaprogra;
import com.ejie.y41b.model.Alerta;

/**
 * AdjuntarAlertaprograService  
 * 
 *  
 */

public interface AdjuntarAlertaprograService {

	/**
	 * Inserta los registros en la tabla temporal de programacin de la alerta
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void addAlertaprograTableTemporal(Alerta alerta);

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	AdjuntarAlertaprogra add(AdjuntarAlertaprogra adjuntarAlertaprogra);

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra addAlertaprogra(
			AdjuntarAlertaprogra adjuntarAlertaprogra, String codAlertaAlta);

	/**
	 * Updates a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	AdjuntarAlertaprogra update(AdjuntarAlertaprogra adjuntarAlertaprogra);

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra updateAlertaprogra(
			AdjuntarAlertaprogra adjuntarAlertaprogra, String codAlertaAlta);

	/**
	 * Update a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param codAlertaAlta
	 *            String
	 * @return AdjuntarAlertaprogra
	 */
	public AdjuntarAlertaprogra updateNumProgramacionesAlertaProgramacion(
			AdjuntarAlertaprogra adjuntarAlertaprogra, String codAlertaAlta);

	/**
	 * Finds a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return AdjuntarAlertaprogra
	 */
	AdjuntarAlertaprogra find(AdjuntarAlertaprogra adjuntarAlertaprogra);

	/**
	 * Finds a List of rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarAlertaprogra> findAll(
			AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination);

	/**
	 * Counts rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return Long
	 */
	Long findAllCount(AdjuntarAlertaprogra adjuntarAlertaprogra);

	/**
	 * Finds rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarAlertaprogra> findAllLike(
			AdjuntarAlertaprogra adjuntarAlertaprogra, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarAlertaprogra table using like.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarAlertaprogra adjuntarAlertaprogra,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprogra
	 *            AdjuntarAlertaprogra
	 * @return
	 */
	void remove(AdjuntarAlertaprogra adjuntarAlertaprogra);

	/**
	 * Deletes multiple rows in the AdjuntarAlertaprogra table.
	 * 
	 * @param adjuntarAlertaprograList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjuntarAlertaprogra> adjuntarAlertaprograList);

}
