package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunInfraccHechoDenunDao;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjunInfraccHechoDenunServiceImpl  
 * 
 *  
 */

@Service(value = "adjunInfraccHechoDenunService")
public class AdjunInfraccHechoDenunServiceImpl implements
		AdjunInfraccHechoDenunService {

	@Autowired
	private AdjunInfraccHechoDenunDao adjunInfraccHechoDenunDao;
	@Autowired
	private InfraccHechoDenDao infraccHechoDenDao;

	/**
	 * Inserta los documentos en la tabla temporal de infracciones
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addInfraccionesTableTemporal(TramiteComun tramiteComun) {
		this.adjunInfraccHechoDenunDao
				.removeAllAdjuntarInfracciones(tramiteComun);
		this.infraccHechoDenDao.addAdjuntarInfracciones(tramiteComun);
	}

	/**
	 * Inserta los documentos en la tabla temporal de infracciones
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addInfraccionesTableTemporalControlMercado(
			TramiteComun tramiteComun) {
		this.adjunInfraccHechoDenunDao
				.removeAllAdjuntarInfracciones(tramiteComun);
		this.infraccHechoDenDao
				.addAdjuntarInfraccionesControlMercado(tramiteComun);
	}

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunInfraccHechoDenun add(
			AdjunInfraccHechoDenun adjunInfraccHechoDenun) {
		try {
			adjunInfraccHechoDenun.setHicodigo(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));
			return this.adjunInfraccHechoDenunDao.add(adjunInfraccHechoDenun);
		} catch (DuplicateKeyException ex) {
			throw new Y41bUDAException(
					"error.adjuntarinfracciones.duplicateException", true,
					new Exception());
		}
	}

	/**
	 * Updates a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunInfraccHechoDenun update(
			AdjunInfraccHechoDenun adjunInfraccHechoDenun) {
		return this.adjunInfraccHechoDenunDao.update(adjunInfraccHechoDenun);
	}

	/**
	 * Finds a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	public AdjunInfraccHechoDenun find(
			AdjunInfraccHechoDenun adjunInfraccHechoDenun) {
		return (AdjunInfraccHechoDenun) this.adjunInfraccHechoDenunDao
				.find(adjunInfraccHechoDenun);
	}

	/**
	 * Finds a List of rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjunInfraccHechoDenun> findAll(
			AdjunInfraccHechoDenun adjunInfraccHechoDenun, Pagination pagination) {
		return (List<AdjunInfraccHechoDenun>) this.adjunInfraccHechoDenunDao
				.findAll(adjunInfraccHechoDenun, pagination);
	}

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return Long
	 */
	public Long findAllCount(AdjunInfraccHechoDenun adjunInfraccHechoDenun) {
		return this.adjunInfraccHechoDenunDao
				.findAllCount(adjunInfraccHechoDenun);
	}

	/**
	 * Finds rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjunInfraccHechoDenun> findAllLike(
			AdjunInfraccHechoDenun adjunInfraccHechoDenun,
			Pagination pagination, Boolean startsWith) {
		return (List<AdjunInfraccHechoDenun>) this.adjunInfraccHechoDenunDao
				.findAllLike(adjunInfraccHechoDenun, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjunInfraccHechoDenun adjunInfraccHechoDenun,
			Boolean startsWith) {
		return this.adjunInfraccHechoDenunDao.findAllLikeCount(
				adjunInfraccHechoDenun, startsWith);
	}

	/**
	 * Deletes a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjunInfraccHechoDenun adjunInfraccHechoDenun) {

		AdjunInfraccHechoDenun adjunInfraccHechoDenunAux = this.adjunInfraccHechoDenunDao
				.find(adjunInfraccHechoDenun);

		if (adjunInfraccHechoDenunAux != null
				&& adjunInfraccHechoDenunAux.getHicotp() != null) {
			throw new Y41bUDAException("error.acta.infraccionesException",
					true, new Exception());
		}

		this.adjunInfraccHechoDenunDao.remove(adjunInfraccHechoDenun);
	}

	/**
	 * Deletes multiple rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenunList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<AdjunInfraccHechoDenun> adjunInfraccHechoDenunList) {
		for (AdjunInfraccHechoDenun adjunInfraccHechoDenunAux : adjunInfraccHechoDenunList) {
			this.adjunInfraccHechoDenunDao.remove(adjunInfraccHechoDenunAux);
		}
	}

}
