package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.TramiteComun;

/**
 * AdjunInfraccHechoDenunService  
 * 
 *  
 */

public interface AdjunInfraccHechoDenunService {

	/**
	 * Inserta los documentos en la tabla temporal de infracciones
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addInfraccionesTableTemporal(TramiteComun tramiteComun);

	/**
	 * Inserta los documentos en la tabla temporal de infracciones
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addInfraccionesTableTemporalControlMercado(
			TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	AdjunInfraccHechoDenun add(AdjunInfraccHechoDenun adjunInfraccHechoDenun);

	/**
	 * Updates a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	AdjunInfraccHechoDenun update(AdjunInfraccHechoDenun adjunInfraccHechoDenun);

	/**
	 * Finds a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return AdjunInfraccHechoDenun
	 */
	AdjunInfraccHechoDenun find(AdjunInfraccHechoDenun adjunInfraccHechoDenun);

	/**
	 * Finds a List of rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjunInfraccHechoDenun> findAll(
			AdjunInfraccHechoDenun adjunInfraccHechoDenun, Pagination pagination);

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return Long
	 */
	Long findAllCount(AdjunInfraccHechoDenun adjunInfraccHechoDenun);

	/**
	 * Finds rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjunInfraccHechoDenun> findAllLike(
			AdjunInfraccHechoDenun adjunInfraccHechoDenun,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjunInfraccHechoDenun table using like.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjunInfraccHechoDenun adjunInfraccHechoDenun,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @return
	 */
	void remove(AdjunInfraccHechoDenun adjunInfraccHechoDenun);

	/**
	 * Deletes multiple rows in the AdjunInfraccHechoDenun table.
	 * 
	 * @param adjunInfraccHechoDenunList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjunInfraccHechoDenun> adjunInfraccHechoDenunList);

}
