package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunInfraccArbDao;
import com.ejie.y41b.model.AdjunInfraccArb;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AdjunInfraccArbServiceImpl  
 * 
 *  
 */

@Service(value = "adjunInfraccArbService")
public class AdjunInfraccArbServiceImpl implements AdjunInfraccArbService {

	@Autowired
	private AdjunInfraccArbDao adjunInfraccArbDao;

	/**
	 * Inserts a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunInfraccArb add(AdjunInfraccArb adjunInfraccArb) {
		try {
			adjunInfraccArb.setHicodigo(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));
			return this.adjunInfraccArbDao.add(adjunInfraccArb);
		} catch (DuplicateKeyException ex) {
			throw new Y41bUDAException(
					"error.adjuntarinfracciones.duplicateException", true,
					new Exception());
		}
	}

	/**
	 * Updates a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunInfraccArb update(AdjunInfraccArb adjunInfraccArb) {
		return this.adjunInfraccArbDao.update(adjunInfraccArb);
	}

	/**
	 * Finds a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	public AdjunInfraccArb find(AdjunInfraccArb adjunInfraccArb) {
		return (AdjunInfraccArb) this.adjunInfraccArbDao.find(adjunInfraccArb);
	}

	/**
	 * Finds a List of rows in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjunInfraccArb> findAll(AdjunInfraccArb adjunInfraccArb,
			Pagination pagination) {
		return (List<AdjunInfraccArb>) this.adjunInfraccArbDao.findAll(
				adjunInfraccArb, pagination);
	}

	/**
	 * Counts rows in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return Long
	 */
	public Long findAllCount(AdjunInfraccArb adjunInfraccArb) {
		return this.adjunInfraccArbDao.findAllCount(adjunInfraccArb);
	}

	/**
	 * Finds rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjunInfraccArb> findAllLike(AdjunInfraccArb adjunInfraccArb,
			Pagination pagination, Boolean startsWith) {
		return (List<AdjunInfraccArb>) this.adjunInfraccArbDao.findAllLike(
				adjunInfraccArb, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjunInfraccArb adjunInfraccArb,
			Boolean startsWith) {
		return this.adjunInfraccArbDao.findAllLikeCount(adjunInfraccArb,
				startsWith);
	}

	/**
	 * Deletes a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjunInfraccArb adjunInfraccArb) {
		this.adjunInfraccArbDao.remove(adjunInfraccArb);
	}

	/**
	 * Deletes multiple rows in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArbList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<AdjunInfraccArb> adjunInfraccArbList) {
		for (AdjunInfraccArb adjunInfraccArbAux : adjunInfraccArbList) {
			this.adjunInfraccArbDao.remove(adjunInfraccArbAux);
		}
	}

}
