package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.AdjunInfraccArb;

/**
 * AdjunInfraccArbService  
 * 
 *  
 */

public interface AdjunInfraccArbService {

	/**
	 * Inserts a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	AdjunInfraccArb add(AdjunInfraccArb adjunInfraccArb);

	/**
	 * Updates a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	AdjunInfraccArb update(AdjunInfraccArb adjunInfraccArb);

	/**
	 * Finds a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return AdjunInfraccArb
	 */
	AdjunInfraccArb find(AdjunInfraccArb adjunInfraccArb);

	/**
	 * Finds a List of rows in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjunInfraccArb> findAll(AdjunInfraccArb adjunInfraccArb,
			Pagination pagination);

	/**
	 * Counts rows in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return Long
	 */
	Long findAllCount(AdjunInfraccArb adjunInfraccArb);

	/**
	 * Finds rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjunInfraccArb> findAllLike(AdjunInfraccArb adjunInfraccArb,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjunInfraccArb table using like.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjunInfraccArb adjunInfraccArb, Boolean startsWith);

	/**
	 * Deletes a single row in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArb
	 *            AdjunInfraccArb
	 * @return
	 */
	void remove(AdjunInfraccArb adjunInfraccArb);

	/**
	 * Deletes multiple rows in the AdjunInfraccArb table.
	 * 
	 * @param adjunInfraccArbList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjunInfraccArb> adjunInfraccArbList);

}
