package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunDatosMailSedeDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.AdjunDatosMailSede;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AdjunDatosMailSedeServiceImpl  
 * 
 *  
 */

@Service(value = "adjunDatosMailSedeService")
public class AdjunDatosMailSedeServiceImpl implements AdjunDatosMailSedeService {

	@Autowired
	private AdjunDatosMailSedeDao adjunDatosMailSedeDao;

	/**
	 * Inserts a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @return AdjunDatosMailSede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunDatosMailSede add(AdjunDatosMailSede adjunDatosMailSede) {
		adjunDatosMailSede.setIdDatomail(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		return this.adjunDatosMailSedeDao.add(adjunDatosMailSede);
	}

	/**
	 * Updates a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @return AdjunDatosMailSede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunDatosMailSede update(AdjunDatosMailSede adjunDatosMailSede) {
		return this.adjunDatosMailSedeDao.update(adjunDatosMailSede);
	}

	/**
	 * Finds a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @return AdjunDatosMailSede
	 */
	public AdjunDatosMailSede find(AdjunDatosMailSede adjunDatosMailSede) {
		return (AdjunDatosMailSede) this.adjunDatosMailSedeDao
				.find(adjunDatosMailSede);
	}

	/**
	 * Finds a List of rows in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjunDatosMailSede> findAll(
			AdjunDatosMailSede adjunDatosMailSede, Pagination pagination) {
		return (List<AdjunDatosMailSede>) this.adjunDatosMailSedeDao.findAll(
				adjunDatosMailSede, pagination);
	}

	/**
	 * Counts rows in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @return Long
	 */
	public Long findAllCount(AdjunDatosMailSede adjunDatosMailSede) {
		return this.adjunDatosMailSedeDao.findAllCount(adjunDatosMailSede);
	}

	/**
	 * Finds rows in the AdjunDatosMailSede table using like.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjunDatosMailSede> findAllLike(
			AdjunDatosMailSede adjunDatosMailSede, Pagination pagination,
			Boolean startsWith) {
		return (List<AdjunDatosMailSede>) this.adjunDatosMailSedeDao
				.findAllLike(adjunDatosMailSede, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjunDatosMailSede table using like.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjunDatosMailSede adjunDatosMailSede,
			Boolean startsWith) {
		return this.adjunDatosMailSedeDao.findAllLikeCount(adjunDatosMailSede,
				startsWith);
	}

	/**
	 * Deletes a single row in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjunDatosMailSede adjunDatosMailSede) {
		this.adjunDatosMailSedeDao.remove(adjunDatosMailSede);
	}

	/**
	 * Deletes multiple rows in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSedeList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<AdjunDatosMailSede> adjunDatosMailSedeList) {
		for (AdjunDatosMailSede adjunDatosMailSedeAux : adjunDatosMailSedeList) {
			this.adjunDatosMailSedeDao.remove(adjunDatosMailSedeAux);
		}
	}

	/**
	 * Counts rows in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @return Long
	 */
	public Long countDescripciones(AdjunDatosMailSede adjunDatosMailSede) {
		return this.adjunDatosMailSedeDao
				.countDescripciones(adjunDatosMailSede);
	}

}
