package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunDatosMailEstablecDao;
import com.ejie.y41b.model.AdjunDatosMailEstablec;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AdjunDatosMailEstablecServiceImpl  
 * 
 *  
 */

@Service(value = "adjunDatosMailEstablecService")
public class AdjunDatosMailEstablecServiceImpl implements
		AdjunDatosMailEstablecService {

	@Autowired
	private AdjunDatosMailEstablecDao adjunDatosMailEstablecDao;

	/**
	 * Inserts a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return AdjunDatosMailEstablec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunDatosMailEstablec add(
			AdjunDatosMailEstablec adjunDatosMailEstablec) {
		adjunDatosMailEstablec.setIdDatomail(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		return this.adjunDatosMailEstablecDao.add(adjunDatosMailEstablec);
	}

	/**
	 * Updates a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return AdjunDatosMailEstablec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunDatosMailEstablec update(
			AdjunDatosMailEstablec adjunDatosMailEstablec) {
		return this.adjunDatosMailEstablecDao.update(adjunDatosMailEstablec);
	}

	/**
	 * Finds a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return AdjunDatosMailEstablec
	 */
	public AdjunDatosMailEstablec find(
			AdjunDatosMailEstablec adjunDatosMailEstablec) {
		return (AdjunDatosMailEstablec) this.adjunDatosMailEstablecDao
				.find(adjunDatosMailEstablec);
	}

	/**
	 * Finds a List of rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjunDatosMailEstablec> findAll(
			AdjunDatosMailEstablec adjunDatosMailEstablec, Pagination pagination) {
		return (List<AdjunDatosMailEstablec>) this.adjunDatosMailEstablecDao
				.findAll(adjunDatosMailEstablec, pagination);
	}

	/**
	 * Counts rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return Long
	 */
	public Long findAllCount(AdjunDatosMailEstablec adjunDatosMailEstablec) {
		return this.adjunDatosMailEstablecDao
				.findAllCount(adjunDatosMailEstablec);
	}

	/**
	 * Finds rows in the AdjunDatosMailEstablec table using like.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjunDatosMailEstablec> findAllLike(
			AdjunDatosMailEstablec adjunDatosMailEstablec,
			Pagination pagination, Boolean startsWith) {
		return (List<AdjunDatosMailEstablec>) this.adjunDatosMailEstablecDao
				.findAllLike(adjunDatosMailEstablec, pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjunDatosMailEstablec table using like.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjunDatosMailEstablec adjunDatosMailEstablec,
			Boolean startsWith) {
		return this.adjunDatosMailEstablecDao.findAllLikeCount(
				adjunDatosMailEstablec, startsWith);
	}

	/**
	 * Deletes a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjunDatosMailEstablec adjunDatosMailEstablec) {
		this.adjunDatosMailEstablecDao.remove(adjunDatosMailEstablec);
	}

	/**
	 * Deletes multiple rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablecList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<AdjunDatosMailEstablec> adjunDatosMailEstablecList) {
		for (AdjunDatosMailEstablec adjunDatosMailEstablecAux : adjunDatosMailEstablecList) {
			this.adjunDatosMailEstablecDao.remove(adjunDatosMailEstablecAux);
		}
	}

	/**
	 * Counts rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return Long
	 */
	public Long countDescripciones(AdjunDatosMailEstablec adjunDatosMailEstablec) {
		return this.adjunDatosMailEstablecDao
				.countDescripciones(adjunDatosMailEstablec);
	}

}
