package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunDatosMailEstablec;

/**
 * AdjunDatosMailEstablecService  
 * 
 *  
 */

public interface AdjunDatosMailEstablecService {

	/**
	 * Inserts a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return AdjunDatosMailEstablec
	 */
	AdjunDatosMailEstablec add(AdjunDatosMailEstablec adjunDatosMailEstablec);

	/**
	 * Updates a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return AdjunDatosMailEstablec
	 */
	AdjunDatosMailEstablec update(AdjunDatosMailEstablec adjunDatosMailEstablec);

	/**
	 * Finds a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return AdjunDatosMailEstablec
	 */
	AdjunDatosMailEstablec find(AdjunDatosMailEstablec adjunDatosMailEstablec);

	/**
	 * Finds a List of rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjunDatosMailEstablec> findAll(
			AdjunDatosMailEstablec adjunDatosMailEstablec, Pagination pagination);

	/**
	 * Counts rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return Long
	 */
	Long findAllCount(AdjunDatosMailEstablec adjunDatosMailEstablec);

	/**
	 * Finds rows in the AdjunDatosMailEstablec table using like.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjunDatosMailEstablec> findAllLike(
			AdjunDatosMailEstablec adjunDatosMailEstablec,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AdjunDatosMailEstablec table using like.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjunDatosMailEstablec adjunDatosMailEstablec,
			Boolean startsWith);

	/**
	 * Deletes a single row in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return
	 */
	void remove(AdjunDatosMailEstablec adjunDatosMailEstablec);

	/**
	 * Deletes multiple rows in the AdjunDatosMailEstablec table.
	 * 
	 * @param adjunDatosMailEstablecList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjunDatosMailEstablec> adjunDatosMailEstablecList);

	/**
	 * Counts rows in the AdjunDatosMailSede table.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @return Long
	 */
	public Long countDescripciones(AdjunDatosMailEstablec adjunDatosMailEstablec);

}
