package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunDatosAvisosEstablecDao;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AdjunDatosAvisosEstablecServiceImpl  
 * 
 *  
 */

@Service(value = "adjunDatosAvisosEstablecService")
public class AdjunDatosAvisosEstablecServiceImpl implements AdjunDatosAvisosEstablecService {

	@Autowired
	private AdjunDatosAvisosEstablecDao adjunDatosAvisosEstablecDao;

	/**
	 * Inserts a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunDatosAvisosEstablec add(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		adjunDatosAvisosEstablec.setYiiddatomail(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		return this.adjunDatosAvisosEstablecDao.add(adjunDatosAvisosEstablec);
	}

	/**
	 * Updates a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AdjunDatosAvisosEstablec update(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		return this.adjunDatosAvisosEstablecDao.update(adjunDatosAvisosEstablec);
	}

	/**
	 * Finds a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	public AdjunDatosAvisosEstablec find(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		return (AdjunDatosAvisosEstablec) this.adjunDatosAvisosEstablecDao.find(adjunDatosAvisosEstablec);
	}

	/**
	 * Finds a List of rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AdjunDatosAvisosEstablec> findAll(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec,
			Pagination pagination) {
		return (List<AdjunDatosAvisosEstablec>) this.adjunDatosAvisosEstablecDao.findAll(adjunDatosAvisosEstablec,
				pagination);
	}

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */
	public Long findAllCount(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		return this.adjunDatosAvisosEstablecDao.findAllCount(adjunDatosAvisosEstablec);
	}

	/**
	 * Finds rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<AdjunDatosAvisosEstablec> findAllLike(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec,
			Pagination pagination, Boolean startsWith) {
		return (List<AdjunDatosAvisosEstablec>) this.adjunDatosAvisosEstablecDao.findAllLike(adjunDatosAvisosEstablec,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec, Boolean startsWith) {
		return this.adjunDatosAvisosEstablecDao.findAllLikeCount(adjunDatosAvisosEstablec, startsWith);
	}

	/**
	 * Deletes a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		this.adjunDatosAvisosEstablecDao.remove(adjunDatosAvisosEstablec);
	}

	/**
	 * Deletes multiple rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablecList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablecList) {
		for (AdjunDatosAvisosEstablec adjunDatosAvisosEstablecAux : adjunDatosAvisosEstablecList) {
			this.adjunDatosAvisosEstablecDao.remove(adjunDatosAvisosEstablecAux);
		}
	}

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */
	public Long countDescripciones(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {
		return this.adjunDatosAvisosEstablecDao.countDescripciones(adjunDatosAvisosEstablec);
	}

	/**
	 * Borra de la temporal los docs de ese codigo establecimiento (limpia tabla
	 * temporal) Inserta en la temporal los docs de la final para trabajar con
	 * ellos
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addAvisosMultipleFinalATemporal(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {

		// limpiar la temporal de avisos con ese codigo establecimiento
		this.adjunDatosAvisosEstablecDao.removeAllAvisosFromTemp(adjunDatosAvisosEstablec);

		// copiar los avisos de la final a la temporal
		this.adjunDatosAvisosEstablecDao.addAllAvisosFromFinalToTemp(adjunDatosAvisosEstablec);

	}

	/**
	 * Guardamos los cambios en la tabla AdjunDatosAvisosEstablec (final) de
	 * avisos
	 *
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return void
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void guardarAvisosMultiple(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) throws Exception {

		// borramos todos de ese cod establecimiento de la final
		this.adjunDatosAvisosEstablecDao.removeAllAvisosFromFinal(adjunDatosAvisosEstablec);

		// aadimos todos los de ese cod de la temp a la final
		this.adjunDatosAvisosEstablecDao.addAllAvisosFromTempToFinal(adjunDatosAvisosEstablec);

		// borramos todos los de ese cif de la temporal
		this.adjunDatosAvisosEstablecDao.removeAllAvisosFromTemp(adjunDatosAvisosEstablec);
	}

	/**
	 * Borra de la temporal los docs de ese codigo establecimiento (limpia tabla
	 * temporal)
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAllAvisosFromTemp(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) {

		// limpiar la temporal de avisos con ese codigo establecimiento
		this.adjunDatosAvisosEstablecDao.removeAllAvisosFromTemp(adjunDatosAvisosEstablec);
	}
}
