package com.ejie.y41b.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;

/**
 * AdjunDatosAvisosEstablecService  
 * 
 *  
 */

public interface AdjunDatosAvisosEstablecService {

	/**
	 * Inserts a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	AdjunDatosAvisosEstablec add(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Updates a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	AdjunDatosAvisosEstablec update(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Finds a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return AdjunDatosAvisosEstablec
	 */
	AdjunDatosAvisosEstablec find(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Finds a List of rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjunDatosAvisosEstablec> findAll(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec, Pagination pagination);

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */
	Long findAllCount(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Finds rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjunDatosAvisosEstablec> findAllLike(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjunDatosAvisosEstablec table using like.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec, Boolean startsWith);

	/**
	 * Deletes a single row in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return
	 */
	void remove(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Deletes multiple rows in the AdjunDatosAvisosEstablec table.
	 * 
	 * @param adjunDatosAvisosEstablecList
	 *            List
	 * @return
	 */
	void removeMultiple(List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablecList);

	/**
	 * Counts rows in the AdjunDatosAvisosSede table.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return Long
	 */
	Long countDescripciones(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Guardar los avisos relacionados al estblecimiento de la tabla final a la
	 * temporal
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * 
	 */
	void addAvisosMultipleFinalATemporal(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

	/**
	 * Guardamos los cambios en la tabla AdjunDatosAvisosEstablec (final) de
	 * avisos
	 *
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @return void
	 */
	void guardarAvisosMultiple(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec) throws Exception;

	/**
	 * Borra de la temporal los docs de ese codigo establecimiento (limpia tabla
	 * temporal)
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 */
	void removeAllAvisosFromTemp(AdjunDatosAvisosEstablec adjunDatosAvisosEstablec);

}
