package com.ejie.y41b.service;

import java.util.List;
import java.util.ListIterator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.InspeccionEnvios;
import com.ejie.y41b.model.ProductosCampanhaActuacion;
import com.ejie.y41b.model.TramiteComun;

/**
 * ActuacionServiceImpl  
 * 
 *  
 */

@Service(value = "actuacionService")
public class ActuacionServiceImpl implements ActuacionService {

	@Autowired()
	private ActuacionDao actuacionDao;

	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion add(Actuacion actuacion) {
		return this.actuacionDao.add(actuacion);
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion update(Actuacion actuacion) {
		return this.actuacionDao.update(actuacion);
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion find(Actuacion actuacion) {
		return (Actuacion) this.actuacionDao.find(actuacion);
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Actuacion> findAll(Actuacion actuacion, Pagination pagination) {
		return (List<Actuacion>) this.actuacionDao.findAll(actuacion,
				pagination);
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllCount(Actuacion actuacion) {
		return this.actuacionDao.findAllCount(actuacion);
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ProductosCampanhaActuacion> findAllProductosCampanha(
			Actuacion actuacion, Pagination pagination) {
		return (List<ProductosCampanhaActuacion>) this.actuacionDao
				.findAllProductosCampanha(actuacion, pagination);
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllProductosCampanhaCount(Actuacion actuacion) {
		return this.actuacionDao.findAllProductosCampanhaCount(actuacion);
	}

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Actuacion> findAllLike(Actuacion actuacion,
			Pagination pagination, Boolean startsWith) {
		return (List<Actuacion>) this.actuacionDao.findAllLike(actuacion,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Actuacion actuacion, Boolean startsWith) {
		return this.actuacionDao.findAllLikeCount(actuacion, startsWith);
	}

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Actuacion actuacion) {
		this.actuacionDao.remove(actuacion);
	}

	/**
	 * Deletes multiple rows in the Actuacion table.
	 * 
	 * @param actuacionList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Actuacion> actuacionList) {
		for (Actuacion actuacionAux : actuacionList) {
			this.actuacionDao.remove(actuacionAux);
		}
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public String findNumExpedienteInspeccion(Actuacion actuacion) {
		Actuacion actu = this.actuacionDao.find(actuacion);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES)
				.append("-").append(actu.getActa().getAccoor()).append("-")
				.append(actu.getActa().getAcnror()).append("-")
				.append(actu.getActa().getAcnran()).append("-")
				.append(actu.getAtnror());

		return numeroExpediente.toString();
	}

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllInspeccionEnviosCount(Actuacion actuacion) {
		return this.actuacionDao.findAllInspeccionEnviosCount(actuacion);
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<InspeccionEnvios> findAllInspeccionEnvios(Actuacion actuacion,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null
					|| pagination.getSort().equals("fechaenvio")) {
				pagination.setSort("FECHAENVIO");
			}
			if (pagination.getSort() == null
					|| pagination.getSort().equals("fechaacuse")) {
				pagination.setSort("FECHAACUSE");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("nombretramite")) {
				pagination.setSort("TIPONOTIFICACIONPLATEA");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("nombretramitee")) {
				pagination.setSort("TIPONOTIFICACIONPLATEA");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("estado")) {
				pagination.setSort("ESTADO");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("destinatario")) {
				pagination.setSort("DESTINATARIO");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipoenvio")) {
				pagination.setSort("TIPOENVIO");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("rmestado")) {
				pagination.setSort("ESTADOREMESA");
			}

		}
		List<InspeccionEnvios> listInspeccionEnvios = this.actuacionDao
				.findAllSolicitudEnvios(actuacion, pagination);

		if (listInspeccionEnvios != null && listInspeccionEnvios.size() > 0) {
			ListIterator iter = listInspeccionEnvios
					.listIterator(listInspeccionEnvios.size());

			InspeccionEnvios inspeccionEnviosAux = null;

			while (iter.hasPrevious()) {
				inspeccionEnviosAux = (InspeccionEnvios) iter.previous();

				// buscar los documentos del tramite
				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdTramite(inspeccionEnviosAux.getTicodigo());

				List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
						.findAllDocumentosTramite(tramiteComun, null);

				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null
						&& listDocumentoHecho.size() == 1) {
					inspeccionEnviosAux
							.setIndVariosDocumentos(Y41bConstantes.NO);

					inspeccionEnviosAux.setQ5codocumento(listDocumentoHecho
							.get(0).getQ5codocumento());
					inspeccionEnviosAux.setQ5nofile(listDocumentoHecho.get(0)
							.getQ5nofile());
					inspeccionEnviosAux.setQ5sizefile(listDocumentoHecho.get(0)
							.getQ5sizefile());
					inspeccionEnviosAux.setQ5contenttypefile(listDocumentoHecho
							.get(0).getQ5contenttypefile());
					inspeccionEnviosAux.setQ5tedesfile(listDocumentoHecho
							.get(0).getQ5tedesfile());
				} else {
					if (listDocumentoHecho != null
							&& listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						inspeccionEnviosAux
								.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}
			}
		}

		return listInspeccionEnvios;
	}

}
