package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.InspeccionEnvios;
import com.ejie.y41b.model.ProductosCampanhaActuacion;

/**
 * ActuacionService  
 * 
 *  
 */

public interface ActuacionService {

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllInspeccionEnviosCount(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Tramite Hecho table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<InspeccionEnvios> findAllInspeccionEnvios(Actuacion actuacion,
			Pagination pagination);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return SolicitudDetalle
	 */
	String findNumExpedienteInspeccion(Actuacion actuacion);

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion add(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion update(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion find(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> findAll(Actuacion actuacion, Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllCount(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ProductosCampanhaActuacion> findAllProductosCampanha(
			Actuacion actuacion, Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllProductosCampanhaCount(Actuacion actuacion);

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Actuacion> findAllLike(Actuacion actuacion, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Actuacion actuacion, Boolean startsWith);

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	void remove(Actuacion actuacion);

	/**
	 * Deletes multiple rows in the Actuacion table.
	 * 
	 * @param actuacionList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Actuacion> actuacionList);

}
