package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.ActaNuevaDao;
import com.ejie.y41b.dao.ActdecDao;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AlertaDao;
import com.ejie.y41b.dao.CampanhaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DetalleConstatacion;
import com.ejie.y41b.model.DetalleDocumentos;
import com.ejie.y41b.model.DetalleInfraccion;
import com.ejie.y41b.model.DetalleMuestra;
import com.ejie.y41b.model.DetalleProtocolo;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.InspeccionMovilidad;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.PlantillaInspeccionDetalle;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ActaServiceImpl  
 * 
 *  
 */

@Service(value = "actaService")
public class ActaServiceImpl implements ActaService {

	@Autowired()
	private ActaDao actaDao;

	@Autowired()
	private ActuacionDao actuacionDao;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private EstablecimientoService establecimientoService;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private TramiteInspeccionService tramiteInspeccionService;

	@Autowired()
	private ActdecDao actdecDao;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired
	private CampanhaDao campanhaDao;

	@Autowired
	private AlertaDao alertaDao;

	@Autowired()
	private BandejaInspeccionesService bandejaInspeccionesService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired
	private ActaNuevaDao actaNuevaDao;

	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	/**
	 * Inserts a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Acta add(Acta acta) {
		return this.actaDao.add(acta);
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Acta update(Acta acta) {
		return this.actaDao.update(acta);
	}

	/**
	 * Finds a Vista row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	public Acta findVisita(Actuacion actuacion) {
		return (Acta) this.actaDao.findVisita(actuacion);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	public Acta findActuacion(Actuacion actuacion) {
		return (Acta) this.actaDao.findActuacion(actuacion);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleConstatacion>
	 */
	public List<DetalleConstatacion> findConstatacion(Actuacion actuacion, Pagination pagination) {
		return this.actaDao.findConstatacion(actuacion, pagination);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */
	public List<DetalleProtocolo> findProtocolo(Actuacion actuacion, TipProtocolo tipProtocolo, Pagination pagination) {
		return this.actaDao.findProtocolo(actuacion, tipProtocolo, pagination);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */
	public List<DetalleProtocolo> findProtocolo(Actuacion actuacion, Pagination pagination) {
		return this.actaDao.findProtocolo(actuacion, pagination);
	}

	/**
	 * Finds a single row in the Protocolo Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return DetalleProtocolo
	 */
	public DetalleProtocolo findRespuestaPreguntaProtocolo(Actuacion actuacion, TipPregProtoc tipPregProtoc) {
		return this.actaDao.findRespuestaPreguntaProtocolo(actuacion, tipPregProtoc);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List<DetalleProtocolo>
	 */
	public List<DetalleDocumentos> findDocumentos(Actuacion actuacion, Pagination pagination) {
		return this.actaDao.findDocumentos(actuacion, pagination);
	}

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Acta> findAll(Acta acta, Pagination pagination) {
		return (List<Acta>) this.actaDao.findAll(acta, pagination);
	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Long
	 */
	public Long findAllCount(Acta acta) {
		return this.actaDao.findAllCount(acta);
	}

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Acta> findAllLike(Acta acta, Pagination pagination, Boolean startsWith) {

		if (pagination.getSort() != null && pagination.getSort().equals("monombreExpediente")) {
			pagination.setSort("MONOMBRE");
		}

		return (List<Acta>) this.actaDao.findAllLike(acta, pagination, startsWith);
	}

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllActaLike(Acta acta, Pagination pagination) {
		if (pagination != null && pagination.getSidx() != null && pagination.getSidx().equals("acfere")) {
			pagination.setSidx(" to_date(acfere,'DD-MM-YYYY') ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("accoor")) {
			pagination.setSort("ACCOOR ASC, ACNRAN ASC, LPAD(ACNROR, 12) ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("accoor")) {
			pagination.setSort("ACCOOR DESC, ACNRAN DESC, LPAD(ACNROR, 12) ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("atnoprse")) {
			pagination.setSort("ATNOPRSE ASC, ATNOMAPS ASC, ATNOMOPS ASC, ATNRLOPS ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("atnoprse")) {
			pagination.setSort("ATNOPRSE DESC, ATNOMAPS DESC, ATNOMOPS DESC, ATNRLOPS ");
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("tipoorigen")) {
				pagination.setSidx("TIPOORIGEN");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("codigoorigen")) {
				pagination.setSidx("ORIGEN");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("numProdsEncontrados")) {
				pagination.setSidx("NUMPRODSENCONTRADOS");
			}
		}

		List<BusquedaInspeccion> busquedaInspeccion = this.actaDao.findAllActaLike(acta, pagination);

		for (BusquedaInspeccion bInsp : busquedaInspeccion) {

			// Si es un expediente antiguo...
			if (!Y41bConstantes.SI.equals(bInsp.getIskontsumobide())) {

				// buscar establecimiento responsable del producto
				if (bInsp.getAtcoes() != null) {
					Establecimiento rp = new Establecimiento();
					rp.setEscodigo(bInsp.getAtcoes());
					rp = this.establecimientoDao.find(rp);

					bInsp.setRpnombre(rp.getEsnombre());
					bInsp.setRpnoco(rp.getEsnoco());
				}

				// buscar establecimiento destinatario
				if (bInsp.getAccoes() != null) {
					Establecimiento es = new Establecimiento();
					es.setEscodigo(bInsp.getAccoes());
					es = this.establecimientoDao.find(es);

					bInsp.setEsnombre(es.getEsnombre());
					bInsp.setEsnoco(es.getEsnoco());
				}
			}

			if (Y41bUtils.isFilled(bInsp.getAtcocm())) {
				// contar tramite emision informe
				// tramitado
				// o acta tramitada
				// ligado a protocolo
				ActaNueva actaNueva = new ActaNueva();
				actaNueva.setAncodins(bInsp.getAtcodigo());
				actaNueva.setAnligadoprotocolo(Y41bConstantes.VALOR_SI);

				Long numActaInfraccionProtocolo = this.actaNuevaDao
						.findAllActaInfraccionProtocoloTramitadaCount(actaNueva);

				TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalle.setAtcodigo(bInsp.getAtcodigo());
				Long numEmisionInformeProtocolo = this.tramiteInspeccionDao
						.findAllTramiteEmisionInformeProtocoloTramitadoCount(tramiteInspeccionDetalle);

				if ((numActaInfraccionProtocolo != null && numActaInfraccionProtocolo > 0)
						|| (numEmisionInformeProtocolo != null && numEmisionInformeProtocolo > 0)) {
					bInsp.setAtligadoProtocolo(Y41bConstantes.VALOR_SI);
				}
			}
		}

		return busquedaInspeccion;
	}

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Acta acta, Boolean startsWith) {
		return this.actaDao.findAllLikeCount(acta, startsWith);
	}

	/**
	 * Deletes a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Acta acta) {
		this.actaDao.remove(acta);
	}

	/**
	 * Deletes multiple rows in the Acta table.
	 * 
	 * @param actaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Acta> actaList) {
		for (Acta actaAux : actaList) {
			this.actaDao.remove(actaAux);
		}
	}

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	public String findNumExpediente(Actuacion actuacion) {
		return this.actaDao.findNumExpediente(actuacion);
	}

	/**
	 * Finds rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	public Long findConstatacionCount(Actuacion actuacion) {
		return this.actaDao.findConstatacionCount(actuacion);
	}

	/**
	 * Finds in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return String
	 */
	public List<DetalleInfraccion> findInfracciones(Actuacion actuacion, Pagination pagination, Boolean startsWith) {
		return this.actaDao.findInfracciones(actuacion, pagination);
	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	public Long findInfraccionesCount(Actuacion actuacion) {
		return this.actaDao.findInfraccionesCount(actuacion);
	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	public Long findProtocoloCount(Actuacion actuacion) {
		return this.actaDao.findProtocoloCount(actuacion);
	}

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	public Long findDocumentosCount(Actuacion actuacion) {
		return this.actaDao.findDocumentosCount(actuacion);
	}

	/**
	 * Finds a row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	public DetalleMuestra findMuestra(Actuacion actuacion) {
		return this.actaDao.findMuestra(actuacion);
	}

	/**
	 * Generates a new Inspeccion.
	 * 
	 * @param acta
	 *            Acta
	 * @param actuacion
	 *            Actuacion
	 */
	public void generarInspeccion(Acta acta, Actuacion actuacion) {

		this.actaDao.add(acta);
		this.actuacionDao.add(actuacion);
	}

	/**
	 * Finds an inspection
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	public InspeccionDetalle findInspeccion(Actuacion actuacion, CensoMonitor censoMonitor) {
		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		if (this.tratamientoSeguridad(inspeccionDetalle, censoMonitor)) {
			inspeccionDetalle.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			inspeccionDetalle.setPermisoModificacion(Y41bConstantes.NO);
		}

		Actuacion actuacionAux = new Actuacion();
		actuacionAux.setAtcodigo(inspeccionDetalle.getAtcodigo());

		Long tramiteAsignacionResponsableInspeccionTramitado = this.tramiteInspeccionDao
				.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacionAux);

		if (tramiteAsignacionResponsableInspeccionTramitado > 0) {
			inspeccionDetalle.setPermisoModificacionCambioResponsable(Y41bConstantes.SI);
		} else {
			inspeccionDetalle.setPermisoModificacionCambioResponsable(Y41bConstantes.NO);
		}

		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(inspeccionDetalle.getAtcodigo());
		Long tramiteRegistroInspeccionTramitado = this.tramiteInspeccionDao
				.findAllTramiteRegistroInspeccionTramitadoCount(tramiteInspeccionDetalle);

		if (tramiteRegistroInspeccionTramitado > 0) {
			inspeccionDetalle.setPermisoModificacionActa(Y41bConstantes.SI);
		} else {
			inspeccionDetalle.setPermisoModificacionActa(Y41bConstantes.NO);
		}

		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(inspeccionDetalle.getAtcodigo());
			this.denunciaService.actualizarDocumentosLocalizados(solicitudDetalle);
		} catch (Exception e) {
			// throw new Y41bUDAException("error.generico", true, e);
		}

		// Obtener el valor de estado de adhesion del censo
		if (inspeccionDetalle.getEstablecimientoR() != null
				&& inspeccionDetalle.getEstablecimientoR().getEscodigo() != null) {
			inspeccionDetalle.getEstablecimientoR().setInadar((this.establecimientoService
					.estadoAdhesionEstablecimientoCenso(inspeccionDetalle.getEstablecimientoR().getEscodigo())));
		}
		if (inspeccionDetalle.getEstablecimientoV() != null
				&& inspeccionDetalle.getEstablecimientoV().getEscodigo() != null) {
			inspeccionDetalle.getEstablecimientoV().setInadar((this.establecimientoService
					.estadoAdhesionEstablecimientoCenso(inspeccionDetalle.getEstablecimientoV().getEscodigo())));
		}

		// 0157454: Incluir literal Establecimiento cerrado en la
		// pestaa hecho de los expedientes
		String cerrado = "";

		if (inspeccionDetalle.getEstablecimientoR() != null
				&& !Y41bUtils.esNullOCadenaVacia(inspeccionDetalle.getEstablecimientoR().getEscodigo())) {

			cerrado = this.establecimientoService
					.estadoCerradoEstablecimientoCenso(inspeccionDetalle.getEstablecimientoR().getEscodigo());
			inspeccionDetalle.getEstablecimientoR().setEstablecimientoCerrado(cerrado);
		}

		if (inspeccionDetalle.getEstablecimientoV() != null
				&& !Y41bUtils.esNullOCadenaVacia(inspeccionDetalle.getEstablecimientoV().getEscodigo())) {

			cerrado = this.establecimientoService
					.estadoCerradoEstablecimientoCenso(inspeccionDetalle.getEstablecimientoV().getEscodigo());
			inspeccionDetalle.getEstablecimientoV().setEstablecimientoCerrado(cerrado);
		}
		// 0157454: Incluir literal Establecimiento cerrado en la
		// pestaa hecho de los expedientes

		return inspeccionDetalle;
	}

	/**
	 * Metodo que devuelve S si tiene permiso de modificacion, N si no tiene
	 * permiso de modificacion
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	private boolean tratamientoSeguridad(InspeccionDetalle inspeccionDetalle, CensoMonitor censoMonitor) {

		if (censoMonitor == null) {
			return false;
		}

		// Si la campaa est inactiva no se podr modificar
		if (Y41bUtils.isFilled(inspeccionDetalle.getAtcocm())) {
			// buscar campaa
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(inspeccionDetalle.getAtcocm());
			Campanha campanhaAux = this.campanhaDao.find(campanha);

			// Si es distinto de activa return false
			if (campanhaAux != null && (!Y41bUtils.isFilled(campanhaAux.getCmactiva())
					|| !campanhaAux.getCmactiva().equals(Y41bConstantes.VALOR_SI))) {
				return false;
			}
		}

		// Si la alerta est inactiva no se podr modificar
		if (Y41bUtils.isFilled(inspeccionDetalle.getAtcoal())) {
			// buscar alerta
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(inspeccionDetalle.getAtcoal());
			Alerta alertaAux = this.alertaDao.find(alerta);

			// Si es distinto de activa return false
			if (alertaAux != null && (!Y41bUtils.isFilled(alertaAux.getAlactiva())
					|| !alertaAux.getAlactiva().equals(Y41bConstantes.VALOR_SI))) {
				return false;
			}
		}

		// comprobar si el organismo propietario del expediente es igual al
		// organismo del usuario conectado
		if (inspeccionDetalle != null
				&& inspeccionDetalle.getAdcoor().equals(censoMonitor.getOrganismo().getCodOrg())) {

			if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {

				// Miro si la solicitud esta cerrada
				if (inspeccionDetalle.getAtfechacierre() == null) {
					return true;
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
				if (inspeccionDetalle.getMocodigo() != null
						&& inspeccionDetalle.getMocodigo().equals(censoMonitor.getMocodigo())) {
					// Miro si la solicitud esta cerrada
					if (inspeccionDetalle.getAtfechacierre() == null) {
						return true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO)) {
				// Miro si la solicitud esta cerrada
				if (inspeccionDetalle.getAtfechacierre() == null) {
					return true;
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				// Miro si la solicitud esta cerrada
				if (inspeccionDetalle.getAtfechacierre() == null) {
					return true;
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
				return false;
			} else {
				return false;
			}

		} else {
			// si el usuario conectado tiene perfil de supervisior, le damos
			// permiso para modificar
			if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				// Miro si la inspeccion esta cerrada
				if (inspeccionDetalle.getAtfechacierre() == null) {
					return true;
				} else {
					return false;
				}
				// si el usuario conectado tiene perfil de control de mercado,
				// le damos
				// permiso para modificar
			} else if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
				// Miro si la inspeccion esta cerrada
				if (inspeccionDetalle.getAtfechacierre() == null) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
	}

	/**
	 * Finds a row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return String
	 */
	public String findNumActa(Acta acta) {
		return this.actaDao.findNumActa(acta);
	}

	/**
	 * Finds a single row in the Tramite Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return TramiteInspeccion
	 */
	@Transactional(readOnly = true)
	public Tramite findUltimoTramite(Actuacion actuacion) {
		return this.actaDao.findUltimoTramite(actuacion);
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor, CensoMonitor censoMonitor)
			throws Exception {

		Actuacion actuacion = new Actuacion();
		Acta actaAux = new Acta();
		actaAux.setAccodigo(solicitudCambioInstructor.getIdExpediente());
		actuacion.setActa(actaAux);

		List<Actuacion> actuaciones = this.actuacionDao.findAll(actuacion, null);
		actuacion = actuaciones.get(0);

		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		// comprobar si el organismo es diferente al del expediente
		if (inspeccionDetalle.getAdcoor().equals(solicitudCambioInstructor.getOrganismo().getCodOrg())) {
			actaAux = new Acta();
			actaAux.setAccodigo(solicitudCambioInstructor.getIdExpediente());
			actaAux.setAccomo(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());

			// si es igual el organismo
			// update del instructor
			this.actaDao.updateInspector(actaAux);

			// buscar tramites pendientes y modificar el usuario asignado
			TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(inspeccionDetalle.getAtcodigo());

			List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = this.tramiteInspeccionDao
					.findAllTramiteInspeccionPendientes(tramiteInspeccionDetalle, null);

			TramiteInspeccion tramiteInspeccion = null;
			for (TramiteInspeccionDetalle tramiteInspeccionDetalleAux : listTramiteInspeccionDetalle) {
				tramiteInspeccion = new TramiteInspeccion();
				tramiteInspeccion.setTicomoasignado(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
				tramiteInspeccion.setTicodigo(tramiteInspeccionDetalleAux.getTicodigo());

				this.tramiteInspeccionDao.updateInstructor(tramiteInspeccion);
			}

			tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTiatcodigo(inspeccionDetalle.getAtcodigo());

			this.tramiteInspeccionService.actualizarUltimoTramite(tramiteInspeccion);
		} else {
			// Coordinador
			CensoMonitor censoMonitorCoordinador = new CensoMonitor();
			try {
				censoMonitorCoordinador.setOrganismo(solicitudCambioInstructor.getOrganismo());

				censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorInspecciones(censoMonitorCoordinador);
			} catch (Exception e) {
				censoMonitorCoordinador = new CensoMonitor();
			}

			Organismo organismo = new Organismo();
			organismo.setCodOrg(solicitudCambioInstructor.getOrganismo().getCodOrg());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			// buscar el interviniente interesado
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_ADMINISTRACION);

			Intervinientes intervinientesAux = new Intervinientes(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
					organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null,
					null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
					esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
					organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
					organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
					organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
					organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
					organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
					Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_ADMINISTRACION, intervinientes.getIdExpediente(),
					null, null, null, null);

			this.intervinientesDao.add(intervinientesAux);

			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteInspeccion.setTiatcodigo(inspeccionDetalle.getAtcodigo());
			tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_TRASLADO_KONBIDE);

			tramiteInspeccion.setTifechainicio(new Date());
			tramiteInspeccion.setTicomoasignado(solicitudCambioInstructor.getInstructorActual().getMocodigo());
			tramiteInspeccion.setTifechafin(new Date());
			tramiteInspeccion.setTicomoejecucion(solicitudCambioInstructor.getInstructorActual().getMocodigo());
			tramiteInspeccion.setTicomentario("");

			tramiteInspeccion.setTicoortraspaso(solicitudCambioInstructor.getOrganismo().getCodOrg());

			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

			Actdec actdec = new Actdec();
			actdec.setAdcoat(inspeccionDetalle.getAtcodigo());
			actdec = this.actdecDao.findDecisionInspeccion(actdec);

			actdec.setAdcoor(solicitudCambioInstructor.getOrganismo().getCodOrg());

			this.actdecDao.updateOrganismoTraslado(actdec);

			if (censoMonitor != null && censoMonitor.getPerfilInspecciones() != null
					&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null
					&& censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				if (Y41bUtils.isFilled(solicitudCambioInstructor.getInstructorNuevo().getMocodigo())) {
					this.instramexpService.generarTramiteAsignacionInstructor(inspeccionDetalle.getAtcodigo(),
							censoMonitor.getMocodigo(), solicitudCambioInstructor.getInstructorNuevo().getMocodigo(),
							true);

					// cambiar el instructor del expediente al responsable
					// seleccionado
					actaAux = new Acta();
					actaAux.setAccodigo(solicitudCambioInstructor.getIdExpediente());
					actaAux.setAccomo(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
					// si es igual el organismo
					// update del instructor
					this.actaDao.updateInspector(actaAux);
				} else {
					this.instramexpService.generarTramiteAsignacionInstructor(inspeccionDetalle.getAtcodigo(),
							censoMonitorCoordinador.getMocodigo(), censoMonitorCoordinador.getMocodigo(), false);

					if (censoMonitorCoordinador.getMocodigo() != null) {
						// cambiar el instructor del expediente al coordinador
						actaAux = new Acta();
						actaAux.setAccodigo(solicitudCambioInstructor.getIdExpediente());
						actaAux.setAccomo(censoMonitorCoordinador.getMocodigo());
						// si es igual el organismo
						// update del instructor
						this.actaDao.updateInspector(actaAux);
					}
				}
			} else {
				this.instramexpService.generarTramiteAsignacionInstructor(inspeccionDetalle.getAtcodigo(),
						censoMonitorCoordinador.getMocodigo(), censoMonitorCoordinador.getMocodigo(), false);

				if (censoMonitorCoordinador.getMocodigo() != null) {
					// cambiar el instructor del expediente al coordinador
					actaAux = new Acta();
					actaAux.setAccodigo(solicitudCambioInstructor.getIdExpediente());
					actaAux.setAccomo(censoMonitorCoordinador.getMocodigo());
					// si es igual el organismo
					// update del instructor
					this.actaDao.updateInspector(actaAux);
				}
			}
		}

		BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
		bandejaInspecciones.setAtcodigo(inspeccionDetalle.getAtcodigo());

		this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);

		if (inspeccionDetalle.getAtatablet() != null
				&& inspeccionDetalle.getAtatablet().equalsIgnoreCase(Y41bConstantes.SI)) {
			// Actualizar tabla Y5 (sincronizacion movilidad al cambiar el
			// responsable)
			CensoMonitor censoMonitorAux = new CensoMonitor();
			censoMonitorAux.setMocodigo(actaAux.getAccomo());

			// actualizacion tabla sincronizacion
			if (this.documentoHechoDao.findSincronizacion(censoMonitorAux) > 0) {
				this.documentoHechoDao.updateTablaSincronizacion(censoMonitorAux);
			} else {
				this.documentoHechoDao.addTablaSincronizacion(censoMonitorAux);
			}
		}
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateTrasvaseTotalCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor) {

		Actuacion actuacion = new Actuacion();
		Acta actaAux = new Acta();
		actaAux.setAccodigo(solicitudCambioInstructor.getIdExpediente());
		actuacion.setActa(actaAux);

		List<Actuacion> actuaciones = this.actuacionDao.findAll(actuacion, null);
		actuacion = actuaciones.get(0);

		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		// comprobar si el organismo es diferente al del expediente
		if (inspeccionDetalle.getAdcoor().equals(solicitudCambioInstructor.getOrganismo().getCodOrg())) {
			Acta acta = new Acta();
			acta.setAccomo(solicitudCambioInstructor.getInstructorActual().getMocodigo());
			acta.setAccoor(solicitudCambioInstructor.getOrganismo().getCodOrg());

			// buscar todos los expedientes abiertos del instructor origen
			List<BusquedaInspeccion> listBusquedaInspeccion = this.actaDao.findAllInspeccionesAbiertasInstructor(acta,
					null);

			// por cada expediente abierto, cambiar el instructor
			for (BusquedaInspeccion ins : listBusquedaInspeccion) {

				actaAux = new Acta();
				actaAux.setAccodigo(ins.getAccodigo());
				actaAux.setAccomo(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
				// si es igual el organismo
				// update del instructor
				this.actaDao.updateInspector(actaAux);

				// buscar tramites pendientes y modificar el usuario asignado
				TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalle.setAtcodigo(ins.getAtcodigo());

				List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = this.tramiteInspeccionDao
						.findAllTramiteInspeccionPendientes(tramiteInspeccionDetalle, null);

				TramiteInspeccion tramiteInspeccion = null;
				for (TramiteInspeccionDetalle tramiteInspeccionDetalleAux : listTramiteInspeccionDetalle) {
					tramiteInspeccion = new TramiteInspeccion();
					tramiteInspeccion.setTicomoasignado(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
					tramiteInspeccion.setTicodigo(tramiteInspeccionDetalleAux.getTicodigo());

					this.tramiteInspeccionDao.updateInstructor(tramiteInspeccion);
				}

				tramiteInspeccion = new TramiteInspeccion();
				tramiteInspeccion.setTiatcodigo(ins.getAtcodigo());

				this.tramiteInspeccionService.actualizarUltimoTramite(tramiteInspeccion);

				BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
				bandejaInspecciones.setAtcodigo(ins.getAtcodigo());

				this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);

				if (inspeccionDetalle.getAtatablet().equalsIgnoreCase(Y41bConstantes.SI)) {
					// Actualizar tabla Y5 (sincronizacion movilidad al cambiar
					// el
					// responsable)
					CensoMonitor censoMonitorAux = new CensoMonitor();
					censoMonitorAux.setMocodigo(actaAux.getAccomo());

					// actualizacion tabla sincronizacion
					if (this.documentoHechoDao.findSincronizacion(censoMonitorAux) > 0) {
						this.documentoHechoDao.updateTablaSincronizacion(censoMonitorAux);
					} else {
						this.documentoHechoDao.addTablaSincronizacion(censoMonitorAux);
					}
				}

			}

		} else {
			throw new Y41bUDAException("error.solicitud.organismoException", true, new Exception());
		}
	}

	/**
	 * Finds a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Actdec
	 */
	@Transactional(readOnly = true)
	public Actdec findDecisionInspeccion(Actdec actdec) {
		return this.actdecDao.findDecisionInspeccion(actdec);
	}

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param actas
	 *            List<Acta>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long updateInspector(List<Acta> actas, CensoMonitor censoMonitor) {

		Long total = 0L;
		try {
			for (Acta acta : actas) {

				if (acta.getAccodigo() == null) {
					throw new Y41bUDAException("error.inspeccion.bandeja.sinActas", true, null);
				}

				this.actaDao.updateInspector(acta);

				Actuacion actuacion = new Actuacion();
				Acta actaAux = new Acta();
				actaAux.setAccodigo(acta.getAccodigo());
				actuacion.setActa(actaAux);

				List<Actuacion> actuaciones = this.actuacionDao.findAll(actuacion, null);
				actuacion = actuaciones.get(0);

				// Extraemos el origen para saber como se van a crear los
				// tramites.
				if (actuacion.getAtcocm() == null && actuacion.getAtcohd() == null && actuacion.getAtcoat() == null
						&& actuacion.getAtcoal() == null && actuacion.getAtidcomunicacionsoivre() == null) {
					// Es oficio.
					// Apertura y asignacion de expediente (tramitado).
					this.instramexpService.generarTramiteAsignacionInstructor(actuacion.getAtcodigo(),
							censoMonitor.getMocodigo(), acta.getAccomo(), true);

					// Si no existe ya, registro de inspeccion (sin
					// tramitar).
					total = this.tramiteInspeccionDao.findTramiteRegistroInspeccionPorActaCount(acta);
					if (total == 0) {
						this.instramexpService.generarTramiteRegistroInspeccion(actuacion.getAtcodigo(),
								acta.getAccomo(), false);
					}
				} else {
					// Viene de bandeja de inspecciones.
					// Apertura y asignacion de expediente (tramitado).
					this.instramexpService.generarTramiteAsignacionInstructor(actuacion.getAtcodigo(),
							censoMonitor.getMocodigo(), acta.getAccomo(), true);

					// Si no existe ya, registro de inspeccion (tramitado).
					total = this.tramiteInspeccionDao.findTramiteRegistroInspeccionPorActaCount(acta);
					if (total == 0) {
						this.instramexpService.generarTramiteRegistroInspeccion(actuacion.getAtcodigo(),
								acta.getAccomo(), true);
					}
				}

				total++;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return total;
	}

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllLikeInspeccionesBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination) {
		if (pagination != null && pagination.getSidx() != null && pagination.getSidx().equals("acfere")) {
			pagination.setSidx(" to_date(acfere,'DD-MM-YYYY') ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("accoor")) {
			pagination.setSort("ACCOOR ASC, ACNRAN ASC, LPAD(ACNROR, 12) ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("accoor")) {
			pagination.setSort("ACCOOR DESC, ACNRAN DESC, LPAD(ACNROR, 12) ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("atnoprse")) {
			pagination.setSort("ATNOPRSE ASC, ATNOMAPS ASC, ATNOMOPS ASC, ATNRLOPS ");
		}

		if (pagination != null && pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("atnoprse")) {
			pagination.setSort("ATNOPRSE DESC, ATNOMAPS DESC, ATNOMOPS DESC, ATNRLOPS ");
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("tipoorigen")) {
				pagination.setSidx("TIPOORIGEN");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("codigoorigen")) {
				pagination.setSidx("ORIGEN");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("numProdsEncontrados")) {
				pagination.setSidx("NUMPRODSENCONTRADOS");
			}
		}

		List<BusquedaInspeccion> busquedaInspeccion = this.actaDao.findAllActaLikeBusquedaCombinada(busquedaCombinada,
				pagination);

		for (BusquedaInspeccion bInsp : busquedaInspeccion) {

			// Si es un expediente antiguo...
			if (!Y41bConstantes.SI.equals(bInsp.getIskontsumobide())) {

				// buscar establecimiento responsable del producto
				if (bInsp.getAtcoes() != null) {
					Establecimiento rp = new Establecimiento();
					rp.setEscodigo(bInsp.getAtcoes());
					rp = this.establecimientoDao.find(rp);

					bInsp.setRpnombre(rp.getEsnombre());
					bInsp.setRpnoco(rp.getEsnoco());
				}

				// buscar establecimiento destinatario
				if (bInsp.getAccoes() != null) {
					Establecimiento es = new Establecimiento();
					es.setEscodigo(bInsp.getAccoes());
					es = this.establecimientoDao.find(es);

					bInsp.setEsnombre(es.getEsnombre());
					bInsp.setEsnoco(es.getEsnoco());
				}
			}

		}

		return busquedaInspeccion;
	}

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeInspeccionesBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith) {
		return this.actaDao.findAllLikeBusquedaCombinadaCount(busquedaCombinada, startsWith);
	}

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return PlantillaInspeccionDetalle
	 */
	public PlantillaInspeccionDetalle findPlantillaSolicitudDetalle(Actuacion actuacion) {

		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		PlantillaInspeccionDetalle plantillaInspeccionDetalle = new PlantillaInspeccionDetalle();

		plantillaInspeccionDetalle
				.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(actuacion.getAtcodigo()));

		plantillaInspeccionDetalle.setOrigenInspeccion(this.instramexpService
				.findOrigenInspeccionPorIdExpediente(actuacion.getAtcodigo(), new Locale(Y41bConstantes.CASTELLANO)));

		// Establecimiento
		plantillaInspeccionDetalle.setEsnombreVisitado(inspeccionDetalle.getEstablecimientoV().getNombre());
		plantillaInspeccionDetalle
				.setEsnombreMunicipioVisitado(inspeccionDetalle.getEstablecimientoV().getNombreMunicipio());

		// Producto/Servicio
		plantillaInspeccionDetalle.setNombreProducto(inspeccionDetalle.getAtnoprse());
		plantillaInspeccionDetalle.setMarcaProducto(inspeccionDetalle.getAtnomaps());
		plantillaInspeccionDetalle.setModeloProducto(inspeccionDetalle.getAtnomops());
		plantillaInspeccionDetalle.setCodigoBarrasProducto(inspeccionDetalle.getAtcodigobarras());

		// Devolvemos el objeto
		return plantillaInspeccionDetalle;

	}

	/**
	 * Finds an inspection in the temp table
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	public InspeccionMovilidad findInspeccionMovilidad(Actuacion actuacion, CensoMonitor censoMonitor) {
		InspeccionMovilidad inspeccionMovilidad = this.actaDao.findInspeccionMovilidad(actuacion);

		return inspeccionMovilidad;
	}
}
