package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DetalleConstatacion;
import com.ejie.y41b.model.DetalleDocumentos;
import com.ejie.y41b.model.DetalleInfraccion;
import com.ejie.y41b.model.DetalleMuestra;
import com.ejie.y41b.model.DetalleProtocolo;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.InspeccionMovilidad;
import com.ejie.y41b.model.PlantillaInspeccionDetalle;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.Tramite;

/**
 * ActaService  
 * 
 *  
 */

public interface ActaService {

	/**
	 * Inserts a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	Acta add(Acta acta);

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	Acta update(Acta acta);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	public void updateCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor, CensoMonitor censoMonitor)
			throws Exception;

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	public void updateTrasvaseTotalCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor);

	/**
	 * Finds a Vista row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	Acta findVisita(Actuacion actuacion);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Acta
	 */
	Acta findActuacion(Actuacion actuacion);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	List<DetalleConstatacion> findConstatacion(Actuacion actuacion, Pagination pagination);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	List<DetalleProtocolo> findProtocolo(Actuacion actuacion, TipProtocolo tipProtocolo, Pagination pagination);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	List<DetalleProtocolo> findProtocolo(Actuacion actuacion, Pagination pagination);

	/**
	 * Finds a single row in the Protocolo Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return DetalleProtocolo
	 */
	public DetalleProtocolo findRespuestaPreguntaProtocolo(Actuacion actuacion, TipPregProtoc tipPregProtoc);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return Acta
	 */
	List<DetalleDocumentos> findDocumentos(Actuacion actuacion, Pagination pagination);

	/**
	 * Finds a List of rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Acta> findAll(Acta acta, Pagination pagination);

	/**
	 * Counts rows in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return Long
	 */
	Long findAllCount(Acta acta);

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Acta> findAllLike(Acta acta, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List<BusquedaInspeccion>
	 */
	List<BusquedaInspeccion> findAllActaLike(Acta acta, Pagination pagination);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<BusquedaInspeccion>
	 */
	List<DetalleInfraccion> findInfracciones(Actuacion actuacion, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findInfraccionesCount(Actuacion actuacion);

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param acta
	 *            Acta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Acta acta, Boolean startsWith);

	/**
	 * Deletes a single row in the Acta table.
	 * 
	 * @param acta
	 *            Acta
	 * @return
	 */
	void remove(Acta acta);

	/**
	 * Deletes multiple rows in the Acta table.
	 * 
	 * @param actaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Acta> actaList);

	/**
	 * Finds constatacion.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findConstatacionCount(Actuacion actuacion);

	/**
	 * Finds protocolo.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findProtocoloCount(Actuacion actuacion);

	/**
	 * Finds documentos.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findDocumentosCount(Actuacion actuacion);

	/**
	 * Finds muestra.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return DetalleMuestra
	 */
	DetalleMuestra findMuestra(Actuacion actuacion);

	/**
	 * Creates an inspection
	 * 
	 * @param acta
	 *            Acta
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	void generarInspeccion(Acta acta, Actuacion actuacion);

	/**
	 * Finds an inspection
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	public InspeccionDetalle findInspeccion(Actuacion actuacion, CensoMonitor censoMonitor);

	/**
	 * Finds num acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return String
	 */
	String findNumActa(Acta acta);

	/**
	 * Finds num acta.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * 
	 * @return String
	 */
	String findNumExpediente(Actuacion actuacion);

	/**
	 * Finds a single row in the Tramite Inspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Tramite
	 */
	Tramite findUltimoTramite(Actuacion actuacion);

	/**
	 * Finds a single row in the Actdec table.
	 * 
	 * @param actdec
	 *            Actdec
	 * @return Actdec
	 */
	Actdec findDecisionInspeccion(Actdec actdec);

	/**
	 * Updates a single row in the Acta table.
	 * 
	 * @param actas
	 *            List<Acta>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long updateInspector(List<Acta> actas, CensoMonitor censoMonitor);

	/**
	 * Finds rows in the Acta table using like.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllLikeInspeccionesBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination);

	/**
	 * Counts rows in the Acta table using like.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeInspeccionesBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith);

	/**
	 * Finds a single row in the Acta table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return PlantillaInspeccionDetalle
	 */
	public PlantillaInspeccionDetalle findPlantillaSolicitudDetalle(Actuacion actuacion);

	/**
	 * Finds a single row in the inspection temp mobility table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @return InspeccionMovilidad
	 */
	public InspeccionMovilidad findInspeccionMovilidad(Actuacion actuacion, CensoMonitor censoMonitor);
}
