package com.ejie.y41b.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y31.vo.Y31AttachmentBean;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.services.NSHFServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.ActaInfraccionDao;
import com.ejie.y41b.dao.ActaNuevaDao;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjunInfraccHechoDenunDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.TipoDocumentoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.ActaInfraccion;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaActa;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Firma;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.nshf.Body;
import com.ejie.y41b.nshf.EjgvDocument;
import com.ejie.y41b.nshf.EjgvDocumentType;
import com.ejie.y41b.nshf.Header;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * ActaNuevaServiceImpl  
 * 
 *  
 */

@Service(value = "actaNuevaService")
public class ActaNuevaServiceImpl implements ActaNuevaService {

	@Autowired()
	private ActaNuevaDao actaNuevaDao;

	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private AdjunInfraccHechoDenunService adjunInfraccHechoDenunService;

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired()
	private ActuacionDao actuacionDao;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Resource()
	private TramiteInspeccionService tramiteInspeccionService;

	@Autowired()
	private ActaInfraccionDao actaInfraccionDao;

	@Autowired()
	private InfraccHechoDenDao infraccHechoDenDao;

	@Autowired()
	private AdjunInfraccHechoDenunDao adjunInfraccHechoDenunDao;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private ActaDao actaDao;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	@Autowired
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired
	private TipoDocumentoDao tipoDocumentoDao;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private OrganismoDao organismoDao;

	/**
	 * Inserts a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaNueva add(ActaNueva actaNueva) {
		try {
			return this.actaNuevaDao.add(actaNueva);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.acta.existeCodigoActaException", true, new Exception());
		}
	}

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaNueva update(ActaNueva actaNueva) {
		return this.actaNuevaDao.update(actaNueva);
	}

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva find(ActaNueva actaNueva) {
		ActaNueva actaNuevaAux = this.actaNuevaDao.find(actaNueva);

		if (actaNuevaAux != null) {
			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTiaccodigo(actaNueva.getAncodigo());
			Long totalTramitesEjecutados = this.tramiteInspeccionDao.findAllTramitadosCount(tramiteInspeccion, true);

			if (totalTramitesEjecutados > 0) {
				actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			} else {
				actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			}

			actaNuevaAux = this.recuperaActaDocsActaNueva(actaNuevaAux);
		}
		return actaNuevaAux;
	}

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva findByAncodac(ActaNueva actaNueva) {

		ActaNueva actaNuevaBusqueda = new ActaNueva();
		actaNuevaBusqueda.setAncodac(actaNueva.getAncodac());
		List<ActaNueva> actasNuevasAux = this.actaNuevaDao.findAllActaTramitada(actaNuevaBusqueda, null);

		ActaNueva actaNuevaAux = null;

		if (actasNuevasAux != null && actasNuevasAux.size() > 0) {
			actaNuevaAux = actasNuevasAux.get(0);
		}

		if (actaNuevaAux != null) {
			// Obtener establecimiento visitado del acta a reutilizar
			Intervinientes intervinien = new Intervinientes();
			intervinien.setIdExpediente(actaNuevaAux.getAncodins());

			EstablecimientoDetalle establecimientoDetalleActa = this.inspeccionService
					.findIntervinienteEstablecimientoVisitado(intervinien);

			// Obtener establecimiento visitado de la inspeccin
			intervinien = new Intervinientes();
			intervinien.setIdExpediente(actaNueva.getAncodins());

			EstablecimientoDetalle establecimientoDetalleInspeccion = this.inspeccionService
					.findIntervinienteEstablecimientoVisitado(intervinien);

			// Si no es el mismo lanzar error
			if (!establecimientoDetalleActa.getEscodigo().equals(establecimientoDetalleInspeccion.getEscodigo())) {
				throw new Y41bUDAException("error.acta.establecimientoVisitadoException", true, new Exception());
			}
		}

		return actaNuevaAux;
	}

	/**
	 * Obtiene los documentos de acta
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaNueva getDocumentoActaNueva(ActaNueva actaNueva) {

		ActaNueva actaNuevaBusqueda = new ActaNueva();
		actaNuevaBusqueda.setAncodac(actaNueva.getAncodac());
		List<ActaNueva> actasNuevasAux = this.actaNuevaDao.findAllActaTramitada(actaNuevaBusqueda, null);

		ActaNueva actaNuevaAux = null;

		if (actasNuevasAux != null && actasNuevasAux.size() > 0) {
			actaNuevaAux = actasNuevasAux.get(0);
		}

		if (actaNuevaAux != null) {
			DocumentoHecho documentoHecho = new DocumentoHecho();
			TipoDocumento tipoDocumento = new TipoDocumento();
			documentoHecho.setTipoDocumento(tipoDocumento);
			documentoHecho.setQ5tramite(actaNuevaAux.getAncodigo());
			documentoHecho = this.documentoHechoDao.findActa(documentoHecho);

			if (documentoHecho != null && documentoHecho.getQ5idTipodoc() != null
					&& Y41bConstantes.TIPO_DOC_ACTA_INSP.equals(documentoHecho.getQ5idTipodoc())) {
				Adjuntardocs adjuntardocsAux = new Adjuntardocs();

				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThdatafile(documentoHecho.getQ5datafile());
				adjuntardocsAux.setThcontenttypefile(documentoHecho.getQ5contenttypefile());
				adjuntardocsAux.setThnofile(documentoHecho.getQ5nofile());
				adjuntardocsAux.setThsizefile(documentoHecho.getQ5sizefile());

				adjuntardocsAux.setThidExpediente(actaNueva.getAncodins());
				adjuntardocsAux.setThidTramite(actaNueva.getAncodigo());

				adjuntardocsAux.setThtedesfile(documentoHecho.getQ5tedesfile());
				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ACTA_INSP);
				adjuntardocsAux.setTipoDocumento(tipoDocumento);

				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

				adjuntardocsAux.setThfecha(new Date());

				adjuntardocsAux.setThiddocumentum(documentoHecho.getQ5iddocumentum());

				adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);
			}
		}

		return actaNuevaAux;
	}

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaNueva> findAll(ActaNueva actaNueva, Pagination pagination) {
		List<ActaNueva> actasNuevasAux = this.actaNuevaDao.findAll(actaNueva, pagination);

		for (int i = 0; i < actasNuevasAux.size(); i++) {
			ActaNueva actaNuevaAux = actasNuevasAux.get(i);
			if (actaNuevaAux != null) {
				actaNuevaAux = this.recuperaActaDocsActaNueva(actaNuevaAux);

				if (actaNuevaAux.getAnestado() != null
						&& actaNuevaAux.getAnestado().equals(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION)) {
					if (Y41bUtils.isFilled(actaNuevaAux.getAnproceedingsidplatea())
							&& actaNuevaAux.getAnreiniciada() == null) {
						actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_ACTA_REINICIADA);
					} else {
						Parametros parametros = new Parametros();

						parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
						parametros = this.parametrosDao.find(parametros);

						DocumentoHecho documentoHechoAux = actaNuevaAux.getDocumentoHecho();

						if (documentoHechoAux != null && documentoHechoAux.getQ5fechasollocalizador() != null) {
							if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
									&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
											.equalsIgnoreCase(Y41bConstantes.PDF)) {

								int minutos = 0;
								if (parametros != null && parametros.getValor() != null
										&& Y41bUtils.isNumeric(parametros.getValor())) {
									minutos = Integer.parseInt(parametros.getValor());
								}

								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

								Date d1 = null;
								Date d2 = null;
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (60 * 1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}

								if (diffMinutes > minutos) {
									actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
								} else {
									actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
								}
							} else {
								if (documentoHechoAux.getQ5estadodocumento()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
									actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
								} else if (documentoHechoAux.getQ5estadodocumento()
										.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)) {
									actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
								} else {
									actaNuevaAux.setAnestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
								}
							}
						}

					}
				}

				actasNuevasAux.set(i, actaNuevaAux);
			}
		}

		return actasNuevasAux;
	}

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaNueva> findAllActaTramitada(ActaNueva actaNueva, Pagination pagination) {
		List<ActaNueva> actasNuevasAux = this.actaNuevaDao.findAllActaTramitada(actaNueva, pagination);

		for (ActaNueva actaAux : actasNuevasAux) {
			StringBuffer descTipoActa = new StringBuffer();
			descTipoActa.append(actaAux.getAncodac()).append(" (").append(this.recuperaTiposActa(actaAux)).append(")");

			actaAux.setAncodac(descTipoActa.toString());
		}

		return actasNuevasAux;
	}

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return Long
	 */
	public Long findAllActaInfraccionProtocoloTramitadaCount(ActaNueva actaNueva) {
		return this.actaNuevaDao.findAllActaInfraccionProtocoloTramitadaCount(actaNueva);
	}

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return Long
	 */
	public Long findAllCount(ActaNueva actaNueva) {
		return this.actaNuevaDao.findAllCount(actaNueva);
	}

	/**
	 * Finds rows in the ActaNueva table using like.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ActaNueva> findAllLike(ActaNueva actaNueva, Pagination pagination, Boolean startsWith) {
		List<ActaNueva> actasNuevasAux = this.actaNuevaDao.findAllLike(actaNueva, pagination, startsWith);

		for (ActaNueva actaNuevaAux : actasNuevasAux) {
			actaNuevaAux = this.recuperaActaDocsActaNueva(actaNuevaAux);
		}

		return actasNuevasAux;
	}

	/**
	 * Counts rows in the ActaNueva table using like.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(ActaNueva actaNueva, Boolean startsWith) {
		return this.actaNuevaDao.findAllLikeCount(actaNueva, startsWith);
	}

	/**
	 * Deletes a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ActaNueva actaNueva) {

		// Si el acta est tramitada, se le impide borrar.
		ActaNueva actaNuevaAux = this.find(actaNueva);
		if (actaNuevaAux != null && actaNuevaAux.getAnestado() != null
				&& actaNuevaAux.getAnestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
			throw new Y41bUDAException("error.acta.tieneTramitesException", true, new Exception());
		}

		if (actaNuevaAux != null && actaNuevaAux.getAnproceedingsidplatea() != null) {
			if (actaNuevaAux.getAnreiniciada() != null) {
				throw new Y41bUDAException("error.acta.reiniciadaException", true, new Exception());
			}
		}

		// Restar unidades si se habia tramitado
		if (actaNuevaAux != null && actaNuevaAux.getAnproceedingsidplatea() != null) {
			if (actaNuevaAux.getAnreiniciada() == null) {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(actaNuevaAux.getAncodins());
				actuacion = this.actuacionDao.find(actuacion);

				if (actaNuevaAux.getAntipo() != null) {
					if (actaNuevaAux.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)
							&& !actaNuevaAux.getAntipo().contains("TF")) {
						int sacos = 1;
						if (actaNuevaAux.getAnunidadesotrosmu() != null) {
							sacos = actaNuevaAux.getAnunidadesotrosmu().intValue();
						}

						int unidades = 0;
						if (actaNuevaAux.getAnejemplaresunidadmu() != null) {
							unidades = actaNuevaAux.getAnejemplaresunidadmu().intValue();
						}

						// Actualizar contador toma muestras
						BigDecimal tm = new BigDecimal(sacos * unidades);
						if (actuacion.getAtutomamuestras() != null) {
							actuacion.setAtutomamuestras(actuacion.getAtutomamuestras().subtract(tm));
						}

						// Pendientes = Se queda igual

						this.actuacionDao.update(actuacion);
					}

					if (actaNuevaAux.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_INMOVILIZACION_CAUTELAR)) {

						// Actualizar contador inmovilizacion
						if (actaNuevaAux.getAnunidadesinmov() != null) {

							// Se actualizan las unidades inmovilizadas
							if (actuacion.getAtuinmovilizadas() != null) {
								actuacion.setAtuinmovilizadas(
										actuacion.getAtuinmovilizadas().subtract(actaNuevaAux.getAnunidadesinmov()));

							}

							// Recalcular pendientes = se suma las inmovilizadas
							if (actuacion.getAtupendientes() != null) {
								actuacion.setAtupendientes(
										actuacion.getAtupendientes().subtract(actaNuevaAux.getAnunidadesinmov()));
							}

							this.actuacionDao.update(actuacion);
						}
					}

					// actualizar el contador de destruidas y recuperadas en la
					// desinmovilizacion
					if (actaNuevaAux.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESINMOVILIZACION)) {

						if (actaNuevaAux.getAnunidadesrecuperadas() != null) {
							// Se actualizan las unidades recuperadas
							if (actuacion.getAturecuperadas() != null) {
								actuacion.setAturecuperadas(actuacion.getAturecuperadas()
										.subtract(actaNuevaAux.getAnunidadesrecuperadas()));

							}

							// Se actualizan las unidades pendientes, sumando
							// las
							// recuperadas
							if (actuacion.getAtupendientes() != null) {
								actuacion.setAtupendientes(
										actuacion.getAtupendientes().subtract(actaNuevaAux.getAnunidadesrecuperadas()));

							}

							this.actuacionDao.update(actuacion);
						}

						if (actaNuevaAux.getAndestinoinmov().equalsIgnoreCase("D")
								&& actaNuevaAux.getAnlugarinmov().equalsIgnoreCase("I")) {
							if (actaNuevaAux.getAnunidadesdesinmov() != null) {
								// Suma al contador de destruidas
								if (actuacion.getAtudestruidas() != null) {
									actuacion.setAtudestruidas(actuacion.getAtudestruidas()
											.subtract(actaNuevaAux.getAnunidadesdesinmov()));
								}

								// Recalcular pendientes = pendientes -
								// Destruidas
								if (actuacion.getAtupendientes() != null) {
									actuacion.setAtupendientes(
											actuacion.getAtupendientes().add(actaNuevaAux.getAnunidadesdesinmov()));
								}
							}

							this.actuacionDao.update(actuacion);
						}
					}

					// actualizar el contador de toma de muestras en la
					// desinmovilizacion
					if (actaNuevaAux.getAntipo().contains("TF")) {
						// si el destino es toma muestras
						if (actaNuevaAux.getAndestinoinmov().equalsIgnoreCase("L")) {
							int sacos = 1;
							if (actaNuevaAux.getAnunidadesotrosmu() != null) {
								sacos = actaNuevaAux.getAnunidadesotrosmu().intValue();
							}

							int unidades = 0;
							if (actaNuevaAux.getAnejemplaresunidadmu() != null) {
								unidades = actaNuevaAux.getAnejemplaresunidadmu().intValue();
							}

							// Suma al contador de toma de muestras.
							BigDecimal tm = new BigDecimal(sacos * unidades);
							if (actuacion.getAtutomamuestras() != null) {
								actuacion.setAtutomamuestras(actuacion.getAtutomamuestras().subtract(tm));
							}

							// Recalcular pendientes = pendientes - unidades de
							// toma
							// de
							// muestras
							if (actuacion.getAtupendientes() != null) {
								actuacion.setAtupendientes(actuacion.getAtupendientes().add(tm));
							}

							this.actuacionDao.update(actuacion);
						}
					}

					// actualizar el contador de destruidas en caso de acta de
					// destruccion
					if (actaNuevaAux.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESTRUCCION)) {

						// Destruccion in situ
						if (actaNuevaAux.getAnlugarinmov().equalsIgnoreCase("I")) {

							if (actaNuevaAux.getAnunidadesdestruidas() != null) {
								// Suma al contador de destruidas
								if (actuacion.getAtudestruidas() != null) {
									actuacion.setAtudestruidas(actuacion.getAtudestruidas()
											.subtract(actaNuevaAux.getAnunidadesdestruidas()));
								}

								// Se actualizan las unidades recuperadas
								if (actuacion.getAturecuperadas() != null) {
									actuacion.setAturecuperadas(actuacion.getAturecuperadas()
											.subtract(actaNuevaAux.getAnunidadesdestruidas()));

								}

								// Pendientes = Se queda igual
							}

							this.actuacionDao.update(actuacion);
							// Destruccion empresa gestora
						} else if (actaNuevaAux.getAnlugarinmov().equalsIgnoreCase("E")) {
							if (actaNuevaAux.getAnunidadesdestruidas() != null) {
								// Se actualizan las unidades recuperadas
								if (actuacion.getAturecuperadas() != null) {
									actuacion.setAturecuperadas(actuacion.getAturecuperadas()
											.subtract(actaNuevaAux.getAnunidadesdestruidas()));

								}

								// Se actualizan las unidades pendientes
								if (actuacion.getAtupendientes() != null) {
									actuacion.setAtupendientes(actuacion.getAtupendientes()
											.subtract(actaNuevaAux.getAnunidadesdestruidas()));

								}
							}

							this.actuacionDao.update(actuacion);
						}
					}

					// actualizar el contador de recuperadas y pendientes en
					// caso de
					// acta de
					// devolucion
					if (actaNuevaAux.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DEVOLUCION_A_ORIGEN)) {

						if (actaNuevaAux.getAnunidadesdevueltas() != null) {
							// Se actualizan las unidades recuperadas
							if (actuacion.getAturecuperadas() != null) {
								actuacion.setAturecuperadas(
										actuacion.getAturecuperadas().subtract(actaNuevaAux.getAnunidadesdevueltas()));

							}

							// Se actualizan las unidades pendientes
							if (actuacion.getAtupendientes() != null) {
								actuacion.setAtupendientes(
										actuacion.getAtupendientes().subtract(actaNuevaAux.getAnunidadesdevueltas()));

							}
						}

						this.actuacionDao.update(actuacion);
					}
				}

				TramiteComun tramiteComunAux = new TramiteComun();
				tramiteComunAux.setIdExpediente(actaNuevaAux.getAncodigo());

				this.actaInfraccionDao.removeAllInfracciones(tramiteComunAux);
			}

			// Reiniciar acta tramitada
			actaNuevaAux.setAntipo(null);
			actaNuevaAux.setAnreqresumen(null);
			actaNuevaAux.setAninfresumen(null);
			actaNuevaAux.setAninfpropuesta(null);
			actaNuevaAux.setAnaniomu(null);
			actaNuevaAux.setAnnumeromu(null);
			actaNuevaAux.setAnespefificmu(null);
			actaNuevaAux.setAncodcaractermu(null);
			actaNuevaAux.setAncodunidadesmu(null);
			actaNuevaAux.setAnunidadesotrosmu(null);
			actaNuevaAux.setAnejemplaresunidadmu(null);
			actaNuevaAux.setAnimportemu(null);
			actaNuevaAux.setAndepositomu(null);
			actaNuevaAux.setAnnumerolabsmu(null);
			actaNuevaAux.setAnunidadesinmov(null);
			actaNuevaAux.setAnunidadesdesinmov(null);
			actaNuevaAux.setAnunidadesdestruidas(null);
			actaNuevaAux.setAnunidadesdevueltas(null);
			actaNuevaAux.setAnunidadesrecuperadas(null);
			actaNuevaAux.setAndestinoinmov(null);
			actaNuevaAux.setAnlugarinmov(null);
			actaNuevaAux.setAnunidadesexistentesat(null);
			actaNuevaAux.setAnunidadesinmovat(null);
			actaNuevaAux.setAnunidadesdestruidasat(null);
			actaNuevaAux.setAnunidadesdevueltasat(null);
			actaNuevaAux.setAnunidadeslibresat(null);
			actaNuevaAux.setAnunidadestomamuestrasat(null);
			actaNuevaAux.setAnfechainmov(null);
			actaNuevaAux.setAnligadoprotocolo(null);
			actaNuevaAux.setAnunidadesrevisadas(null);

			actaNuevaAux = this.actaNuevaDao.update(actaNuevaAux);

			actaNuevaAux.setAnreiniciada(Y41bConstantes.VALOR_SI);
			this.actaNuevaDao.updateReiniciada(actaNuevaAux);
		} else {
			// borrar los documentos del acta
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5tramite(actaNueva.getAncodigo());
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAll(documentoHecho, null);

			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(actaNuevaAux.getAncodigo());

			this.documentoHechoDao.removeDocsTramiteHecho(documentoTramiteHecho);

			List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
			for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
				listDocumentoExpediente.add(new DocumentoExpediente(documentoHechoAux.getQ5codocumento(),
						documentoHechoAux.getQ5iddocumentum()));
				this.documentoHechoDao.remove(documentoHechoAux);
			}

			this.actaNuevaDao.remove(actaNueva);

			// Eliminamos los documentos de dokusi
			this.eliminarDocumentosDokusi(listDocumentoExpediente);
		}
	}

	/**
	 * Elimina el acta de Mi Carpeta
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMiCarpeta(ActaNueva actaNueva, CensoMonitor censoMonitor) {

		// Si el acta est tramitada, se le impide borrar.
		ActaNueva actaNuevaAux = this.find(actaNueva);

		if (actaNuevaAux != null && actaNuevaAux.getAnproceedingsidplatea() != null) {

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(actaNuevaAux.getAncodigo());
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			// Subimos los documentos a dokusi sin localizar
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				DocumentoHecho documentoHecho = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					if (this.documentoHechoDao.findAllDocTramiteHechoCount(documentoHecho) > 1) {
						throw new Y41bUDAException("error.acta.removeMiCarpetaException", true, new Exception());
					}
				}
			}

			// Generar tramite generico
			try {
				TramiteGenerico tramiteGenerico = new TramiteGenerico();
				tramiteGenerico.setIdExpediente(actaNuevaAux.getAncodins());
				tramiteGenerico.setFechaInicio(new Date());
				tramiteGenerico.setInstructorAsignado(censoMonitor);
				String[] args = new String[2];
				args[0] = actaNuevaAux.getAncodac();
				tramiteGenerico.setComentario(this.appMessageSource.getMessage(
						"tramite.eliminacionActaMiCarpetaComentario", args, LocaleContextHolder.getLocale()));

				String literalNombreTramite = "tramite.eliminacionActaMiCarpeta";
				this.instramexpService.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite);
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}

			// Eliminar Mi Carpeta
			TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
			tramiteinspeccion.setTiatcodigo(actaNuevaAux.getAncodins());
			tramiteinspeccion.setTiproceedingsidplatea(actaNuevaAux.getAnproceedingsidplatea());

			try {
				this.instramexpService.eliminarMisGestiones(tramiteinspeccion);
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}

			actaNuevaAux.setAneliminadamicarpeta(Y41bConstantes.VALOR_SI);
			this.actaNuevaDao.updateEliminadaMiCarpeta(actaNuevaAux);

			// Actualizar codigo de acta
			ActaNueva actaNuevaCodigoActa = new ActaNueva();
			actaNuevaCodigoActa.setAncodigo(actaNuevaAux.getAncodigo());
			actaNuevaCodigoActa.setAncodac(new StringBuffer().append(Y41bConstantes.PREFIFO_ACTA_ELIMINADAMICARPETA)
					.append("-").append(actaNuevaAux.getAncodac()).toString());
			this.actaNuevaDao.updateCodigoActa(actaNuevaCodigoActa);

			// Actualizar codigo de acta en tramites
			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion
					.setTiancodigoNuevo(new StringBuffer().append(Y41bConstantes.PREFIFO_ACTA_ELIMINADAMICARPETA)
							.append("-").append(actaNuevaAux.getAncodac()).toString());
			tramiteInspeccion.setTiatcodigo(actaNuevaAux.getAncodins());
			tramiteInspeccion.setTiancodigo(actaNuevaAux.getAncodac());

			this.tramiteInspeccionDao.updateCodigoActa(tramiteInspeccion);

			actaNuevaAux.setAnproceedingsidplatea(null);
			this.actaNuevaDao.updateProceedingsIdPlatea(actaNuevaAux);
		}

	}

	/**
	 * Deletes multiple rows in the ActaNueva table.
	 * 
	 * @param actaNuevaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<ActaNueva> actaNuevaList) {
		for (ActaNueva actaNuevaAux : actaNuevaList) {
			this.actaNuevaDao.remove(actaNuevaAux);
		}
	}

	/**
	 * Aniade una acta nueva.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva addActaNueva(ActaNueva actaNueva) {

		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)) {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(actaNueva.getAncodins());
			actuacion = this.actuacionDao.find(actuacion);

			if (actuacion != null && actuacion.getAttipo() != null
					&& (actuacion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)
							|| actuacion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS))) {
				throw new Y41bUDAException("error.acta.tipoInspeccionException", true, new Exception());
			}
		}

		ActaNueva actaNuevaAux;
		try {
			if (actaNueva.getAntipo() != null
					&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)) {
				actaNueva.setAnnumeromu(new Long(this.actaNuevaDao.findNumMuestra(actaNueva)));
			}

			Actuacion actuacionaux = new Actuacion();
			actuacionaux.setAtcodigo(actaNueva.getAncodins());

			InspeccionDetalle inspeccionDetalleAux = this.actaDao.findInspeccion(actuacionaux);

			if (Y41bConstantes.SI.equals(inspeccionDetalleAux.getCmonline())
					|| Y41bConstantes.SI.equals(inspeccionDetalleAux.getAtonline())) {
				actaNueva.setAncodac(this.actaNuevaDao.findCodActa(actaNueva));
			}

			actaNuevaAux = this.actaNuevaDao.add(actaNueva);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.acta.existeCodigoActaException", true, new Exception());
		}

		if (actaNueva.getAnyadirPlantilla() == null) {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(actaNueva.getAncodins());
			tramiteComun.setIdTramite(actaNueva.getAncodigo());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

			tramiteComun.setTipoProcedimiento(tipoProcedimiento);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			try {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun);
			} catch (Y41bUDAException udae) {
				throw udae;
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, new Exception());
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdExpediente(actaNueva.getAncodigo());

			this.actaInfraccionDao.removeAllInfracciones(tramiteComunAux);

			this.infraccHechoDenDao.addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(tramiteComunAux);

			this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComunAux);
		}

		return actaNuevaAux;
	}

	/**
	 * Actualiza/tramita una acta nueva.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tramitar
	 *            boolean
	 * @return ActaNueva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaNueva updateActaNueva(ActaNueva actaNueva, CensoMonitor censoMonitor, boolean tramitar) {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(actaNueva.getAncodins());
		actuacion = this.actuacionDao.find(actuacion);

		ActaNueva actaNuevaFind = new ActaNueva();
		actaNuevaFind.setAncodigo(actaNueva.getAncodigo());
		List<ActaNueva> actasAux = this.actaNuevaDao.findAll(actaNuevaFind, null);

		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)
				&& !actaNueva.getAntipo().contains("TF")) {
			if (actuacion != null && actuacion.getAttipo() != null
					&& (actuacion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)
							|| actuacion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS))) {
				throw new Y41bUDAException("error.acta.tipoInspeccionException", true, new Exception());
			}
		}

		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_INFRACCION)) {
			AdjunInfraccHechoDenun adjuninfracchechodenun = new AdjunInfraccHechoDenun();
			adjuninfracchechodenun.setHicohd(actaNueva.getAncodigo());
			Long numInfracciones = this.adjunInfraccHechoDenunDao.findAllCount(adjuninfracchechodenun);

			if (numInfracciones == 0) {
				throw new Y41bUDAException("error.inspecciones.InfraccionesException", true, new Exception());
			}
		}

		if (tramitar) {

			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)
					&& !actaNueva.getAntipo().contains("TF")) {
				int sacos = 1;
				if (actaNueva.getAnunidadesotrosmu() != null) {
					sacos = actaNueva.getAnunidadesotrosmu().intValue();
				}

				int unidades = 0;
				if (actaNueva.getAnejemplaresunidadmu() != null) {
					unidades = actaNueva.getAnejemplaresunidadmu().intValue();
				}

				// Actualizar contador toma muestras
				BigDecimal tm = new BigDecimal(sacos * unidades);
				if (actuacion.getAtutomamuestras() != null) {
					actuacion.setAtutomamuestras(actuacion.getAtutomamuestras().add(tm));
				} else {
					actuacion.setAtutomamuestras(tm);
				}

				// Pendientes = Se queda igual

				this.actuacionDao.update(actuacion);
			}

			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_INMOVILIZACION_CAUTELAR)) {

				// Actualizar contador inmovilizacion
				if (actaNueva.getAnunidadesinmov() != null) {

					// Se actualizan las unidades inmovilizadas
					if (actuacion.getAtuinmovilizadas() != null) {
						actuacion.setAtuinmovilizadas(
								actuacion.getAtuinmovilizadas().add(actaNueva.getAnunidadesinmov()));

					} else {
						actuacion.setAtuinmovilizadas(actaNueva.getAnunidadesinmov());
					}

					// Recalcular pendientes = se suma las inmovilizadas
					if (actuacion.getAtupendientes() != null) {
						actuacion.setAtupendientes(actuacion.getAtupendientes().add(actaNueva.getAnunidadesinmov()));
					} else {
						actuacion.setAtupendientes(actaNueva.getAnunidadesinmov());
					}

					this.actuacionDao.update(actuacion);
				}
			}

			// actualizar el contador de destruidas y recuperadas en la
			// desinmovilizacion
			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESINMOVILIZACION)) {

				if (actaNueva.getAnunidadesrecuperadas() != null) {
					// Se actualizan las unidades recuperadas
					if (actuacion.getAturecuperadas() != null) {
						actuacion.setAturecuperadas(
								actuacion.getAturecuperadas().add(actaNueva.getAnunidadesrecuperadas()));

					} else {
						actuacion.setAturecuperadas(actaNueva.getAnunidadesrecuperadas());
					}

					// Se actualizan las unidades pendientes, sumando las
					// recuperadas
					if (actuacion.getAtupendientes() != null) {
						actuacion.setAtupendientes(
								actuacion.getAtupendientes().add(actaNueva.getAnunidadesrecuperadas()));

					} else {
						actuacion.setAtupendientes(actaNueva.getAnunidadesrecuperadas());
					}

					this.actuacionDao.update(actuacion);
				}

				if (actaNueva.getAndestinoinmov().equalsIgnoreCase("D")
						&& actaNueva.getAnlugarinmov().equalsIgnoreCase("I")) {
					if (actaNueva.getAnunidadesdesinmov() != null) {
						// Suma al contador de destruidas
						if (actuacion.getAtudestruidas() != null) {
							actuacion.setAtudestruidas(
									actuacion.getAtudestruidas().add(actaNueva.getAnunidadesdesinmov()));
						} else {
							actuacion.setAtudestruidas(actaNueva.getAnunidadesdesinmov());
						}

						// Recalcular pendientes = pendientes - Destruidas
						if (actuacion.getAtupendientes() != null) {
							actuacion.setAtupendientes(
									actuacion.getAtupendientes().subtract(actaNueva.getAnunidadesdesinmov()));
						}
					}

					this.actuacionDao.update(actuacion);
				}
			}

			// actualizar el contador de toma de muestras en la
			// desinmovilizacion
			if (actaNueva.getAntipo().contains("TF")) {
				// si el destino es toma muestras
				if (actaNueva.getAndestinoinmov().equalsIgnoreCase("L")) {
					int sacos = 1;
					if (actaNueva.getAnunidadesotrosmu() != null) {
						sacos = actaNueva.getAnunidadesotrosmu().intValue();
					}

					int unidades = 0;
					if (actaNueva.getAnejemplaresunidadmu() != null) {
						unidades = actaNueva.getAnejemplaresunidadmu().intValue();
					}

					// Suma al contador de toma de muestras.
					BigDecimal tm = new BigDecimal(sacos * unidades);
					if (actuacion.getAtutomamuestras() != null) {
						actuacion.setAtutomamuestras(actuacion.getAtutomamuestras().add(tm));
					} else {
						actuacion.setAtutomamuestras(tm);
					}

					// Recalcular pendientes = pendientes - unidades de toma de
					// muestras
					if (actuacion.getAtupendientes() != null) {
						actuacion.setAtupendientes(actuacion.getAtupendientes().subtract(tm));
					}

					this.actuacionDao.update(actuacion);
				}
			}

			// actualizar el contador de destruidas en caso de acta de
			// destruccion
			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESTRUCCION)) {

				// Destruccion in situ
				if (actaNueva.getAnlugarinmov().equalsIgnoreCase("I")) {

					if (actaNueva.getAnunidadesdestruidas() != null) {
						// Suma al contador de destruidas
						if (actuacion.getAtudestruidas() != null) {
							actuacion.setAtudestruidas(
									actuacion.getAtudestruidas().add(actaNueva.getAnunidadesdestruidas()));
						} else {
							actuacion.setAtudestruidas(actaNueva.getAnunidadesdestruidas());
						}

						// Se actualizan las unidades recuperadas
						if (actuacion.getAturecuperadas() != null) {
							actuacion.setAturecuperadas(
									actuacion.getAturecuperadas().add(actaNueva.getAnunidadesdestruidas()));

						} else {
							actuacion.setAturecuperadas(actaNueva.getAnunidadesdestruidas());
						}

						// Pendientes = Se queda igual
					}

					this.actuacionDao.update(actuacion);
					// Destruccion empresa gestora
				} else if (actaNueva.getAnlugarinmov().equalsIgnoreCase("E")) {
					if (actaNueva.getAnunidadesdestruidas() != null) {
						// Se actualizan las unidades recuperadas
						if (actuacion.getAturecuperadas() != null) {
							actuacion.setAturecuperadas(
									actuacion.getAturecuperadas().add(actaNueva.getAnunidadesdestruidas()));

						} else {
							actuacion.setAturecuperadas(actaNueva.getAnunidadesdestruidas());
						}

						// Se actualizan las unidades pendientes
						if (actuacion.getAtupendientes() != null) {
							actuacion.setAtupendientes(
									actuacion.getAtupendientes().add(actaNueva.getAnunidadesdestruidas()));

						} else {
							actuacion.setAtupendientes(actaNueva.getAnunidadesdestruidas());
						}
					}

					this.actuacionDao.update(actuacion);
				}
			}

			// actualizar el contador de recuperadas y pendientes en caso de
			// acta de
			// devolucion
			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DEVOLUCION_A_ORIGEN)) {

				if (actaNueva.getAnunidadesdevueltas() != null) {
					// Se actualizan las unidades recuperadas
					if (actuacion.getAturecuperadas() != null) {
						actuacion.setAturecuperadas(
								actuacion.getAturecuperadas().add(actaNueva.getAnunidadesdevueltas()));

					} else {
						actuacion.setAturecuperadas(actaNueva.getAnunidadesdevueltas());
					}

					// Se actualizan las unidades pendientes
					if (actuacion.getAtupendientes() != null) {
						actuacion
								.setAtupendientes(actuacion.getAtupendientes().add(actaNueva.getAnunidadesdevueltas()));

					} else {
						actuacion.setAtupendientes(actaNueva.getAnunidadesdevueltas());
					}
				}

				this.actuacionDao.update(actuacion);
			}
		}

		ActaNueva actaNuevaAux = null;
		try {
			if (actaNueva.getAnnumeromu() == null && actaNueva.getAntipo() != null
					&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)) {
				actaNueva.setAnnumeromu(new Long(this.actaNuevaDao.findNumMuestra(actaNueva)));
			}

			if (actasAux.size() == 0) {
				Actuacion actuacionaux = new Actuacion();
				actuacionaux.setAtcodigo(actaNueva.getAncodins());

				InspeccionDetalle inspeccionDetalleAux = this.actaDao.findInspeccion(actuacionaux);

				if (Y41bConstantes.SI.equals(inspeccionDetalleAux.getCmonline())
						|| Y41bConstantes.SI.equals(inspeccionDetalleAux.getAtonline())) {
					actaNueva.setAncodac(this.actaNuevaDao.findCodActa(actaNueva));
				}

				actaNuevaAux = this.actaNuevaDao.add(actaNueva);
			} else {
				actaNuevaAux = this.actaNuevaDao.update(actaNueva);
			}
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.acta.existeCodigoActaException", true, new Exception());
		}

		TramiteComun tramiteComunAux = new TramiteComun();
		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		TramiteComun tramiteComun = new TramiteComun();
		if (actaNueva.getAnyadirPlantilla() == null) {

			tramiteComunAux.setIdExpediente(actaNuevaAux.getAncodigo());

			this.actaInfraccionDao.removeAllInfracciones(tramiteComunAux);

			this.infraccHechoDenDao.addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(tramiteComunAux);

			tramiteComun.setIdExpediente(actaNueva.getAncodins());
			tramiteComun.setIdTramite(actaNueva.getAncodigo());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

			tramiteComun.setTipoProcedimiento(tipoProcedimiento);

			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.controlDocumentosPendientesFirmaTramitar(tramiteComun);
			} else {
				try {
					this.controlDocumentosPendientesFirmaGuardar(tramiteComun);
				} catch (Y41bUDAException udae) {
					throw udae;
				} catch (Exception e) {
					throw new Y41bUDAException("error.generico", true, new Exception());
				}
			}
		}

		if (tramitar) {
			// Aadir las infracciones a la tabla ACTA_INFRACCION
			AdjunInfraccHechoDenun adjunInfraccHechoDenunFilter = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunFilter.setHicohd(actaNuevaAux.getAncodigo());

			List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunDao
					.findAll(adjunInfraccHechoDenunFilter, null);

			ActaInfraccion actainfraccion = null;
			Long numInfraccionesAux = null;
			for (AdjunInfraccHechoDenun adjunInfraccHechoDenunAux : listAdjunInfraccHechoDenun) {

				actainfraccion = new ActaInfraccion();
				actainfraccion.setAicoat(actaNueva.getAncodins());
				actainfraccion.setAicotti(adjunInfraccHechoDenunAux.getHicotti());
				numInfraccionesAux = this.actaInfraccionDao.findAllCount(actainfraccion);
				if (numInfraccionesAux == 0) {
					actainfraccion = new ActaInfraccion();
					actainfraccion.setAicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					actainfraccion.setAicoat(actaNueva.getAncodins());
					actainfraccion.setAicotti(adjunInfraccHechoDenunAux.getHicotti());
					String hiinexii = null;
					if (adjunInfraccHechoDenunAux.getHicotti() != null
							&& adjunInfraccHechoDenunAux.getHicotti().indexOf("N0") > -1) {
						// es un articulo
						hiinexii = "S";
					} else {
						hiinexii = "N";
					}
					actainfraccion.setAiinexii(hiinexii);

					actainfraccion.setAicotp(adjunInfraccHechoDenunAux.getHicotp());

					this.actaInfraccionDao.add(actainfraccion);
				}
			}

			// Buscar th

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidTramite(actaNueva.getAncodigo());
			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ACTA_INSP);
			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			TipoProcedimiento tipoProcedimientoAux = new TipoProcedimiento();
			tipoProcedimientoAux.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimientoAux);

			Long totald = this.adjuntardocsDao.findAllActasTramiteCount(adjuntardocsAux);

			// Buscar si tiene un documento del tipo Acta asociado.
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5tramite(actaNueva.getAncodigo());
			documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ACTA_INSP);
			Long total = this.documentoHechoDao.findAllCount(documentoHecho);

			if (total == 0) {
				if (totald > total) {
					throw new Y41bUDAException("error.acta.soloTieneDocumentoActaAdjuntadoException", true,
							new Exception());
				} else {
					throw new Y41bUDAException("error.acta.noTieneDocumentoActaException", true, new Exception());
				}

			}
			try {
				this.realizarTramitesAsociadosAlActaNueva(actaNuevaAux, censoMonitor);

			} catch (Exception e) {
				throw new Y41bUDAException("error.inspeccion.generarTramiteAutomaticoException", true, new Exception());
			}

			try {
				Actuacion actuacionaux = new Actuacion();
				actuacionaux.setAtcodigo(actaNueva.getAncodins());

				InspeccionDetalle inspeccionDetalleAux = this.actaDao.findInspeccion(actuacionaux);

				if (Y41bConstantes.SI.equals(inspeccionDetalleAux.getCmonline())
						|| Y41bConstantes.SI.equals(inspeccionDetalleAux.getAtonline())
						|| (actaNueva.getAncodac() != null
								&& actaNueva.getAncodac().substring(0, 2).equalsIgnoreCase("IM"))) {

					Locale locale = LocaleContextHolder.getLocale();
					String idioma = locale.getLanguage();

					TramiteComun tramiteComunComunicacion = new TramiteComun();
					tramiteComunComunicacion.setIdExpediente(actaNuevaAux.getAncodins());
					tramiteComunComunicacion.setAccodigo(actaNuevaAux.getAncodigo());

					TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
					tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					tramiteComunComunicacion.setTipoProcedimiento(tipoProcedimiento);
					tramiteComunComunicacion
							.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

					TramiteComunicacion tramiteComunicacion = new TramiteComunicacion();

					tramiteComunicacion.setFechaInicio(new Date());
					tramiteComunicacion.setFechaFin(new Date());
					tramiteComunicacion.setInstructorAsignado(censoMonitor);
					tramiteComunicacion.setInstructorEjecucion(censoMonitor);

					tramiteComunicacion.setAccodigo(actaNuevaAux.getAncodigo());

					DatosMailOrigen datosMailOrigen = new DatosMailOrigen();
					datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
					datosMailOrigen = this.instramexpService.findMailOrigen(tramiteComunComunicacion, datosMailOrigen);
					tramiteComunicacion.setMailorigen(datosMailOrigen.getEmail());
					tramiteComunicacion.setFechaComunicacion(new Date());

					// buscar el interviniente
					Intervinientes intervinientes = new Intervinientes();
					intervinientes.setIdExpediente(actaNuevaAux.getAncodins());
					intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

					List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

					Intervinientes intervinientesComunicacion = new Intervinientes();
					if (listIntervinientes != null && listIntervinientes.size() > 0) {
						intervinientesComunicacion = listIntervinientes.get(0);
					}

					tramiteComunicacion.setDestinatario(intervinientesComunicacion.getIdinterviniente());

					tramiteComunicacion.setAsuntoComunicacion(
							this.instramexpService.findNumExpedienteActuacion(actaNueva.getAncodins()));

					// Texto comunicacion
					StringBuffer textoComunicacion = new StringBuffer();
					String[] params1 = new String[Y41bConstantes.NUM_2];
					params1[Y41bConstantes.NUM_0] = actaNuevaAux.getAncodac();
					params1[Y41bConstantes.NUM_1] = tramiteComunicacion.getAsuntoComunicacion();

					// Euskera
					textoComunicacion.append(this.appMessageSource.getMessage("acta.comunicacion.texto", params1,
							new Locale(Y41bConstantes.EUSKERA)));
					// Castellano
					textoComunicacion.append(" / ").append(this.appMessageSource.getMessage("acta.comunicacion.texto",
							params1, new Locale(Y41bConstantes.CASTELLANO)));

					tramiteComunicacion.setTextoComunicacion(textoComunicacion.toString());

					List<DocumentoExpediente> listDocumentoNotificacion = new ArrayList<DocumentoExpediente>();

					// Obtenemos los documentos del tramite
					List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
							.findAllDocumentosTramite(tramiteComun, null);

					DocumentoExpediente documentoExpediente = null;
					// Subimos los documentos a dokusi sin localizar
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
						documentoHecho = null;
						for (int i = 0; i < listDocumentoHecho.size(); i++) {
							documentoHecho = listDocumentoHecho.get(i);
							if (documentoHecho != null && documentoHecho.getQ5idTipodoc() != null
									&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_ACTA_INSP)) {
								documentoExpediente = new DocumentoExpediente();
								documentoExpediente.setCodocumento(documentoHecho.getQ5codocumento());
								documentoExpediente.setPcodigo(documentoHecho.getQ5pcodigo());
								listDocumentoNotificacion.add(documentoExpediente);
							}
						}
					}

					this.soltramexpService.addDocumentosTableTemporal(listDocumentoNotificacion,
							tramiteComunComunicacion);

					if (actaNueva.getAncodac() != null
							&& actaNueva.getAncodac().substring(0, 2).equalsIgnoreCase("IM")) {
						if (Y41bUtils.isValidCIF(intervinientesComunicacion.getNif())
								|| Y41bUtils.isValidNIF(intervinientesComunicacion.getNif())) {
							this.instramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComunComunicacion,
									idioma, true, Y41bConstantes.MODO_POPUP_ALTA,
									Y41bConstantes.TIPO_COMUNICACION_TELEMATICA, null, censoMonitor);
						}

					} else {
						if (Y41bUtils.isValidCIF(intervinientesComunicacion.getNif())
								|| Y41bUtils.isValidNIF(intervinientesComunicacion.getNif())) {
							this.instramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComunComunicacion,
									idioma, true, Y41bConstantes.MODO_POPUP_ALTA,
									Y41bConstantes.TIPO_COMUNICACION_TELEMATICA, null, censoMonitor);
						} else {
							this.instramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComunComunicacion,
									idioma, false, Y41bConstantes.MODO_POPUP_ALTA, null, null, censoMonitor);
						}

					}

				}

				// Obtenemos los documentos del tramite
				List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
						null);

				ActaNueva actaNuevaMisGestiones = this.actaNuevaDao.findProceedingsIdPlatea(actaNueva);

				// Subimos los documentos a dokusi sin localizar
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					documentoHecho = null;
					for (int i = 0; i < listDocumentoHecho.size(); i++) {
						documentoHecho = listDocumentoHecho.get(i);
						if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {
							TramiteComun tramiteComunDokusiAux = new TramiteComun();
							tramiteComunDokusiAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
							tramiteComunDokusiAux.setIdTramite(documentoHecho.getQ5tramite());

							this.soltramexpService.registrarDocumentosDokusiSinLocalizarIns(documentoHecho,
									tramiteComunDokusiAux);
						} else {
							if (!Y41bUtils.isFilled(actaNuevaMisGestiones.getAnproceedingsidplatea())) {

								if (documentoHecho != null && documentoHecho.getQ5origen() != null && documentoHecho
										.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION)) {

									if (documentoHecho != null && documentoHecho.getQ5idTipodoc() != null
											&& documentoHecho.getQ5idTipodoc()
													.equals(Y41bConstantes.TIPO_DOC_ACTA_INSP)) {

										actuacionaux = new Actuacion();
										actuacionaux.setAtcodigo(documentoHecho.getQ5hdcodigo());

										inspeccionDetalleAux = this.actaDao.findInspeccion(actuacionaux);

										if (!Y41bConstantes.SI.equals(inspeccionDetalleAux.getCmonline())
												&& !Y41bConstantes.SI.equals(inspeccionDetalleAux.getAtonline())) {

											TramiteComun tramiteComunDokusiAux = new TramiteComun();
											tramiteComunDokusiAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
											tramiteComunDokusiAux.setIdTramite(documentoHecho.getQ5tramite());

											this.shareDocumentContents(documentoHecho, tramiteComunDokusiAux);
										}
									}
								}

							}
						}
					}
				}

				if (!Y41bUtils.isFilled(actaNuevaMisGestiones.getAnproceedingsidplatea())) {

					this.actualizarMisGestionesActaEstablecimientoVisitado(actaNueva, listDocumentoHecho);
				}

			} catch (Y41bUDAException udae) {
				throw udae;
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, new Exception());
			}

			actaNuevaAux.setAnreiniciada(null);
			this.actaNuevaDao.updateReiniciada(actaNuevaAux);
		}

		if (actaNueva.getAnyadirPlantilla() == null) {
			this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComunAux);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return actaNuevaAux;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 */
	public void eliminarDocumentosDokusi(List<DocumentoExpediente> listDocumentoExpediente) {
		// Eliminamos los documentos de dokusi
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				if (documentoExpediente != null && documentoExpediente.getIddocumentum() != null
						&& !documentoExpediente.getIddocumentum().equals("")) {
					Documento documento = new Documento();
					// 1.User
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoExpediente.getIddocumentum());
					documento.setBoolAllVersions("true");

					this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
				}
			}
		}
	}

	/**
	 * Metodo que comprueba que los documentos se encuentren todos firmados al
	 * tramitar
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	private void controlDocumentosPendientesFirmaTramitar(TramiteComun tramiteComun) {
		// Miramos si hay algun documento pendiente de firma para
		// actualizar el
		// estado del tramite
		boolean isDocPendienteFirma = false;
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())
						|| Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA
								.equals(documentoHecho.getQ5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		}

		if (isDocPendienteFirma) {
			// No se puede tramitar el tramite si tiene algun documento
			// pendiente de firma
			throw new Y41bUDAException("error.acta.nofirmada", true, null);
		}
	}

	/**
	 * Metodo que comprueba que los documentos se encuentren todos firmados al
	 * guardar
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	private void controlDocumentosPendientesFirmaGuardar(TramiteComun tramiteComun) throws Exception {
		// Miramos si hay algun documento pendiente de firma para
		// actualizar el estado del tramite
		boolean isDocPendienteFirma = false;
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		}

		if (isDocPendienteFirma) {
			// Llamamos a un metodo que recorrera la lista de
			// documentos del tramite y actualizara la bandeja de firma
			this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);
		}
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite, registra en DOKUSI
	 * el documento si no tiene oidDokusi y genera el hash
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	private void registrarDocumentosDokusi(List<DocumentoHecho> listDocumentoHecho, TramiteComun tramiteComun)
			throws Exception {
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			DocumentoHecho documentoHecho = null;
			TramiteComun tramiteComunAux = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())) {
					// Si esta pendiente de firma, lo primero lo meto en Dokusi
					// si NO esta dado de alta ya
					if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {

						// Si esta pendiente de firma, lo primero lo meto en
						// Dokusi
						// si NO esta dado de alta ya
						if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {

							tramiteComunAux = new TramiteComun();
							tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
							tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

							this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);
						}
					} else {
						if (documentoHecho.getQ5fechasollocalizador() != null) {
							if (documentoHecho != null && documentoHecho.getQ5nofile() != null
									&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHecho.getQ5nofile())
											.equalsIgnoreCase(Y41bConstantes.PDF)) {

								int minutos = 0;
								if (parametros != null && parametros.getValor() != null
										&& Y41bUtils.isNumeric(parametros.getValor())) {
									minutos = Integer.parseInt(parametros.getValor());
								}

								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

								Date d1 = null;
								Date d2 = null;
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(documentoHecho.getQ5fechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (60 * 1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}

								if (diffMinutes > minutos) {
									Documento documento = new Documento();
									// 1.User
									User user = new User();
									user.setNombre(Y41bConstantes.COD_APLICACION);
									user.setDni(Y41bConstantes.COD_APLICACION);
									documento.setUser(user);
									Procedure procedure = new Procedure();
									procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
									documento.setProcedure(procedure);
									documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
									documento.setBoolAllVersions("true");

									try {
										y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
									} catch (Exception e) {
									}

									documentoHecho.setQ5fechasollocalizador(null);
									documentoHecho.setQ5iddocumentum(null);

									tramiteComunAux = new TramiteComun();
									tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
									tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

									this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho,
											tramiteComunAux);
								}
							}
						}
					}

					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

					Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

					String hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);

					Adjuntardocs adjuntardocsAuxUpdateHash = new Adjuntardocs();

					adjuntardocsAuxUpdateHash.setThcodocumento(documento.getIdDocumento());
					adjuntardocsAuxUpdateHash.setThhashfile(hashDocumento);
					this.adjuntardocsDao.updateHash(adjuntardocsAuxUpdateHash);

					documentoHecho.setQ5hashfile(hashDocumento);
					// Actualizo OID Dokusi en tabla documentos hecho
					// Update oid de documentum
					this.documentoHechoDao.updateHash(documentoHecho);

				}
			}
		}
	}

	/**
	 * Aade las infracciones del protocolo
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addInfraccionProtocolo(ActaNueva actaNueva) {
		ActaInfraccion actainfraccion = new ActaInfraccion();
		actainfraccion.setAicoat(actaNueva.getAncodins());

		List<ActaInfraccion> listActaInfraccion = this.actaInfraccionDao.findAll(actainfraccion, null);

		AdjunInfraccHechoDenun adjuninfracchechodenun = null;
		Long numInfraccionesAux = null;
		for (ActaInfraccion actaInfraccionAux : listActaInfraccion) {

			adjuninfracchechodenun = new AdjunInfraccHechoDenun();
			adjuninfracchechodenun.setHicohd(actaNueva.getAncodigo());
			adjuninfracchechodenun.setHicotti(actaInfraccionAux.getAicotti());
			numInfraccionesAux = this.adjunInfraccHechoDenunDao.findAllCount(adjuninfracchechodenun);
			if (numInfraccionesAux == 0) {
				if (Y41bUtils.isFilled(actaInfraccionAux.getAicotp())) {
					adjuninfracchechodenun = new AdjunInfraccHechoDenun();
					adjuninfracchechodenun
							.setHicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					adjuninfracchechodenun.setHicohd(actaNueva.getAncodigo());
					adjuninfracchechodenun.setHicotti(actaInfraccionAux.getAicotti());
					String hiinexii = null;
					if (adjuninfracchechodenun.getHicotti() != null
							&& adjuninfracchechodenun.getHicotti().indexOf("N0") > -1) {
						// es un articulo
						hiinexii = "S";
					} else {
						hiinexii = "N";
					}
					adjuninfracchechodenun.setHiinexii(hiinexii);

					adjuninfracchechodenun.setHicotp(actaInfraccionAux.getAicotp());

					this.adjunInfraccHechoDenunDao.add(adjuninfracchechodenun);
				}
			}
		}
	}

	/**
	 * Aade las infracciones del protocolo
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInfraccionProtocolo(ActaNueva actaNueva) {
		AdjunInfraccHechoDenun adjuninfracchechodenun = new AdjunInfraccHechoDenun();
		adjuninfracchechodenun.setHicohd(actaNueva.getAncodigo());

		List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunDao
				.findAll(adjuninfracchechodenun, null);

		for (AdjunInfraccHechoDenun adjunInfraccHechoDenunAux : listAdjunInfraccHechoDenun) {

			if (Y41bUtils.isFilled(adjunInfraccHechoDenunAux.getHicotp())) {
				this.adjunInfraccHechoDenunDao.remove(adjunInfraccHechoDenunAux);
			}
		}
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el acta realizada al
	 * establecimiento visitado
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesActaEstablecimientoVisitado(ActaNueva actaNueva,
			List<DocumentoHecho> listDocumentoHecho) throws Exception {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(actaNueva.getAncodins());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		if (insDetalle != null && insDetalle.getAtenplatea() == null) {
			try {
				Calendar aperturaTimestamp = Calendar.getInstance();

				String idioma = LocaleContextHolder.getLocale().getLanguage();

				String fechaActaSinHoras = Y41bUtils.parseDateToString(actaNueva.getAnfecha(), idioma);

				String fechaActaConHoras = "";

				fechaActaConHoras = new StringBuffer().append(fechaActaSinHoras).append(" 00:00:00").toString();
				aperturaTimestamp.setTime(Y41bUtils.parseDateTime(fechaActaConHoras, LocaleContextHolder.getLocale()));

				insDetalle.setAperturaTimestamp(aperturaTimestamp);

				this.instramexpService.abrirExpedienteOficioPlatea(insDetalle, null);

				// Se actualiza campo ATENPLATE a S (indica que el expediente
				// est
				// abierto en PLATEA)
				this.actuacionDao.updateEnPLATEA(actuacion);
			} catch (Y41bUDAException e) {
				throw e;
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido1());
		}

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(insDetalle.getEstablecimientoV().getApellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());

		ActaNueva actaNuevaAux = this.actaNuevaDao.findProceedingsIdPlatea(actaNueva);

		if (Y41bUtils.isFilled(actaNuevaAux.getAnproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(actaNuevaAux.getAnproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
		}

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_ACTA_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_ACTA_EU);

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getQ5nofile());
				documento.setDescripcion(documentoHecho.getQ5tedesfile());
				documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
				documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
				listaDocumentosRdo.add(documento);
			}
		}

		Calendar aportacionTimestamp = Calendar.getInstance();

		String idioma = LocaleContextHolder.getLocale().getLanguage();

		String fechaActaSinHoras = Y41bUtils.parseDateToString(actaNueva.getAnfecha(), idioma);

		String fechaActaConHoras = "";

		fechaActaConHoras = new StringBuffer().append(fechaActaSinHoras).append(" 01:00:00").toString();
		aportacionTimestamp.setTime(Y41bUtils.parseDateTime(fechaActaConHoras, LocaleContextHolder.getLocale()));

		actualizarMisGestiones.setAportacionTimestamp(aportacionTimestamp);

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

		y41bPlateaAdapterService.actualizarMisGestionesActa(actualizarMisGestiones);

		actaNueva.setAnproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.actaNuevaDao.updateProceedingsIdPlatea(actaNueva);
	}

	/**
	 * Realiza los tramites asociados a una acta nueva.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	public void realizarTramitesAsociadosAlActaNueva(ActaNueva actaNueva, CensoMonitor censoMonitor) throws Exception {

		// 1. Generar tramite donde se indicar en un campo texto que tipos de
		// acta se han seleccionado para el acta realizada. Levantamiento de
		// acta.
		TramiteComun tComunLevantamientoActa = new TramiteComun();
		tComunLevantamientoActa.setIdExpediente(actaNueva.getAncodins());
		tComunLevantamientoActa.setAccodigo(actaNueva.getAncodigo());

		TramiteInspeccion tramiteLevantamientoActa = new TramiteInspeccion();
		tramiteLevantamientoActa.setTiancodigo(actaNueva.getAncodac());
		tramiteLevantamientoActa.setTitipactua(this.recuperaTiposActa(actaNueva));
		tramiteLevantamientoActa.setTicomoasignado(censoMonitor.getMocodigo());
		this.instramexpService.generarTramiteLevantamientoActa(tramiteLevantamientoActa, tComunLevantamientoActa);

		// 2. Al tramitar un acta nueva se generaran los siguientes tramites
		// segun el tipo seleccionado.
		if (actaNueva.getAntipo() != null) {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(actaNueva.getAncodins());
			tramiteComun.setAccodigo(actaNueva.getAncodigo());

			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESINMOVILIZACION)) {

				if (actaNueva.getAndestinoinmov().equalsIgnoreCase("D")
						&& !Y41bConstantes.ACTA_NUEVA_LUGAR_INMOVILIZACION_INSITU.equals(actaNueva.getAnlugarinmov())) {
					TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalle.setAtcodigo(actaNueva.getAncodins());
					tramiteInspeccionDetalle
							.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);
					tramiteInspeccionDetalle = this.tramiteInspeccionDao
							.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalle);

					if (tramiteInspeccionDetalle == null
							|| !Y41bUtils.isFilled(tramiteInspeccionDetalle.getTicodigo())) {
						// Si no es in-situ, tramite de recepcion de certificado
						// de
						// destruccion.
						this.instramexpService.generarTramiteAutomatico(tramiteComun,
								Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);
					}
				}
			}

			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESTRUCCION)
					&& !Y41bConstantes.ACTA_NUEVA_LUGAR_INMOVILIZACION_INSITU.equals(actaNueva.getAnlugarinmov())) {

				TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalle.setAtcodigo(actaNueva.getAncodins());
				tramiteInspeccionDetalle
						.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);
				tramiteInspeccionDetalle = this.tramiteInspeccionDao
						.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalle);

				if (tramiteInspeccionDetalle == null || !Y41bUtils.isFilled(tramiteInspeccionDetalle.getTicodigo())) {
					// Si no es in-situ, tramite de recepcion de certificado de
					// destruccion.
					this.instramexpService.generarTramiteAutomatico(tramiteComun,
							Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);

				}
			}

			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DEVOLUCION_A_ORIGEN)) {
				// Tramite de recepcion de certificado de devolucion a origen.
				this.instramexpService.generarTramiteAutomatico(tramiteComun,
						Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_JUSTIFICANTE_DE_DEVOLUCION);
			}
			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_INFRACCION)) {
				// Si hay constacion (si tiene infracciones) y se propone
				// incluir en la red de alerta, tramite de revision para
				// inclusion en la red alerta.
				AdjunInfraccHechoDenun infraccHechoDenun = new AdjunInfraccHechoDenun();

				infraccHechoDenun.setHicohd(actaNueva.getAncodigo());
				Long totalInfrac = this.adjunInfraccHechoDenunService.findAllCount(infraccHechoDenun);

				if (totalInfrac.intValue() > 0 && Y41bConstantes.VALOR_SI.equals(actaNueva.getAninfpropuesta())) {
					// Tramite de Revision para la inclusion en red de alerta.
					this.instramexpService.generarTramiteRevisionInclusionRedAlerta(tramiteComun);
				}
			}
			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_INMOVILIZACION_CAUTELAR)) {

				// Miramos si existe tramite de acuerdo de inicio procedimiento
				boolean isTramiteAcuerdoInicioProcedimiento = this.tramiteInspeccionService.existeTramite(
						actaNueva.getAncodins(), Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);

				if (!isTramiteAcuerdoInicioProcedimiento) {
					// Mirar si no existe un acta de inmovilizacin previa == 1
					if (this.actaNuevaDao.findAllActaInmovilizacionTramitadaCount(actaNueva) == 1) {
						// Tramite de ratificacion de inmovilizacion.
						this.instramexpService.generarTramiteAutomatico(tramiteComun,
								Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);

						this.instramexpService.generarTramiteAutomatico(tramiteComun,
								Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION);
					}
				}
			}
			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_REQUERIMIENTO)) {
				// Tramite de recepcion de requerimiento.
				this.instramexpService.generarTramiteAutomatico(tramiteComun,
						Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO);
			}
			if (actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)) {
				// Recoger a cuantos laboratorios se ha enviado en total y
				// generar tramite por cada uno.
				int laboratorios = 0;
				if (actaNueva.getAnnumerolabsmu() != null) {
					laboratorios = actaNueva.getAnnumerolabsmu().intValue();
				}

				if (actaNueva.getAncodcaractermu().equals(Y41bConstantes.INSPECCIONES_CARACTERMUESTRA_OTROS)) {
					TramiteInspeccion tramiteResultadoEnsayos = new TramiteInspeccion();
					tramiteResultadoEnsayos.setTiancodigo(actaNueva.getAncodigo());
					tramiteResultadoEnsayos.setTicodmuestra(actaNueva.getAnaniomu() + "-" + actaNueva.getAnnumeromu());
					tramiteResultadoEnsayos.setTiaccodigo(actaNueva.getAncodigo());

					this.instramexpService.generarTramiteResultadoEnsayos(tramiteResultadoEnsayos, tramiteComun);

				} else {
					if (laboratorios > 0) {
						// Tramite de remision de muestras a laboratorio.
						for (int i = 0; i < laboratorios; i++) {

							TramiteInspeccion tramiteInspeccionRemision = new TramiteInspeccion();
							tramiteInspeccionRemision.setTiancodigo(actaNueva.getAncodigo());
							tramiteInspeccionRemision
									.setTicodmuestra(actaNueva.getAnaniomu() + "-" + actaNueva.getAnnumeromu());
							tramiteInspeccionRemision.setTiaccodigo(actaNueva.getAncodigo());

							this.instramexpService.generarTramiteRemisionMuestrasAlLaboratorio(
									tramiteInspeccionRemision, tramiteComun);
						}
					}
				}
			}
		}
	}

	/**
	 * Recupera los tipos de acta.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return String
	 */
	private String recuperaTiposActa(ActaNueva actaNueva) {
		// Tipos de acta seleccionados..
		List<String> tiposActa = new ArrayList<String>();

		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_REQUERIMIENTO)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.requerimiento",
					null, LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_INFRACCION)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.infraccion", null,
					LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_TOMA_DE_MUESTRAS)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.tomaMuestras", null,
					LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_INMOVILIZACION_CAUTELAR)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.inmovilizacion",
					null, LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESINMOVILIZACION)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.desinmovilizacion",
					null, LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DESTRUCCION)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.destruccion", null,
					LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_DEVOLUCION_A_ORIGEN)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.devolucion", null,
					LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_LIBRE_COMERCIALIZACION)) {
			tiposActa.add(
					this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.libreComercializacion",
							null, LocaleContextHolder.getLocale()));
		}
		if (actaNueva.getAntipo() != null
				&& actaNueva.getAntipo().contains(Y41bConstantes.ACTA_NUEVA_TIPO_COMPROBACION_SOIVRE)) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.comprobacionSoivre",
					null, LocaleContextHolder.getLocale()));
		}
		if (!Y41bUtils.isFilled(actaNueva.getAntipo())) {
			tiposActa.add(this.appMessageSource.getMessage("inspecciones.tramites.levantamientoacta.notificacion", null,
					LocaleContextHolder.getLocale()));
		}

		StringBuilder comentario = new StringBuilder("");
		if (tiposActa.size() > 0) {
			for (int i = 0; i < tiposActa.size(); i++) {
				if (i > 0) {
					comentario.append(", ");
				}
				comentario.append(tiposActa.get(i));
			}
		}

		return comentario.toString();
	}

	/**
	 * Recupera un documento de Acta.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva recuperaActaDocsActaNueva(ActaNueva actaNueva) {
		try {
			DocumentoHecho documentoHecho = new DocumentoHecho();
			TipoDocumento tipoDocumento = new TipoDocumento();
			documentoHecho.setTipoDocumento(tipoDocumento);
			documentoHecho.setQ5tramite(actaNueva.getAncodigo());
			documentoHecho = this.documentoHechoDao.findActa(documentoHecho);

			if (documentoHecho != null && documentoHecho.getQ5idTipodoc() != null
					&& Y41bConstantes.TIPO_DOC_ACTA_INSP.equals(documentoHecho.getQ5idTipodoc())) {
				actaNueva.setDocumentoHecho(documentoHecho);
			}
		} catch (Exception e) {
			// No encuentra ningun documento.
		}

		return actaNueva;
	}

	/**
	 * Metodo que registra en DOKUSI documentos de Inspecciones Sin Localizar
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public Documento shareDocumentContents(DocumentoHecho documentoHecho, TramiteComun tramiteComun)
			throws SerialException, SQLException, Exception {
		// Obtener el numero de expediente
		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(this.instramexpService.findNumExpedienteActuacion(tramiteComun.getIdExpediente()));

		Documento documento = new Documento();

		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		documento.setProcedure(procedure);

		documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

		// Si no tiene tipo documental, metemos por defecto
		// ejgv_d_archivo
		String tipoDocumental = null;

		if (Y41bUtils.isFilled(documentoHecho.getQ5idTipodoc())) {
			tipoDocumental = documentoHecho.getQ5idTipodoc();
		} else {
			tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		}

		documento.setTipoDocumental(tipoDocumental);

		TipoDocumento tipodocumento = new TipoDocumento();
		tipodocumento.setIdTipodoc(tipoDocumental);
		try {
			tipodocumento = this.tipoDocumentoDao.find(tipodocumento);
			if (tipodocumento != null) {
				documento.setTipoDocumento(tipodocumento.getTdnombre());
			} else {
				documento.setTipoDocumento(".");
			}
		} catch (EmptyResultDataAccessException e) {
			documento.setTipoDocumento(".");
		}

		documento.setIdDocumento(documentoHecho.getQ5codocumento());

		// Para que sepa PLATEA que es un RTF (obligatorio)
		documento.setDescripcion(documentoHecho.getQ5tedesfile());
		documento.setNombre(documentoHecho.getQ5nofile());
		documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getQ5nofile()));

		// Calculo el origen de DOKUSI del documento ini
		documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);

		// Expediente DOKUSI
		documento.setNumeroExpediente(numeroExpediente.toString());

		// Compruebo si tiene OID de Dokusi
		if (Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());
			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			if (inspeccionDetalle.getAtistablet() == null || !inspeccionDetalle.getAtistablet().equals("S")) {
				// Compartir documentoSi no tiene, lo registro en Dokusi y
				// actualizo
				// OID
				documento = y41bDokusiAdapterService.shareDocumentContents(documento);
				// Actualizo OID Dokusi en tabla documentos intermedia
				Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

				adjuntardocsAuxUpdateOID.setThcodocumento(documento.getIdDocumento());
				adjuntardocsAuxUpdateOID.setThiddocumentum(documento.getOidDokusi());
				this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);

				if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				} else {
					this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
				}

				documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

				// Actualizo OID Dokusi en tabla documentos hecho
				// Update oid de documentum
				this.documentoHechoDao.updateOIDDokusi(documentoHecho);

				if (com.ejie.y41b.utils.Y41bUtils.isDocumentoTransformable(documento)) {
				} else {
					this.documentoHechoDao.removeBlobFromOIDDokusi(documentoHecho);
				}
			}
		}

		return documento;
	}

	/**
	 * Metodo que actualiza que guarda en Dokusi la firma del documento.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void saveActaFirmaDocHash(Adjuntardocs adjuntardocs) throws Exception {
		// 1. Actualizamos el estado del documento (L21Q5T00 ->
		// Q5ESTADODOCUMENTO, Q5FECHAFIRMA, Q5COMOFIRMA)
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5codocumento(adjuntardocs.getThcodocumento());
		documentoHecho.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
		documentoHecho.setQ5fechafirma(Calendar.getInstance().getTime());
		documentoHecho.setQ5comofirma(adjuntardocs.getThcomofirma());
		documentoHechoDao.updateDatosFirma(documentoHecho);

		adjuntardocsDao.updateDatosFirma(documentoHecho);

		// 2. Actualizamos en Dokusi la firma
		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		documento.setProcedure(procedure);
		documento.setOidDokusi(adjuntardocs.getThiddocumentum());
		if (adjuntardocs.getThnofile() != null) {
			documento.setNombre(Y41bUtils.getNameFile(adjuntardocs.getThnofile()));
			documento.setExtension(Y41bUtils.getExtensionFile(adjuntardocs.getThnofile()));
		}

		// ******************************************************

		documento = this.obtenerFirmaDocumento(documento, adjuntardocs);

		// ******************************************************

		y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
	}

	/**
	 * Obtiene la firma del documento para enviar a DOKUSI
	 * 
	 * @param documento
	 *            Documento
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * 
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 */
	private Documento obtenerFirmaDocumento(Documento documento, Adjuntardocs adjuntardocs) throws Exception {
		Documento docDokusi = y41bDokusiAdapterService.descargarPifDocumentoDokusi(documento);

		EjgvDocumentType signature = new EjgvDocumentType();
		signature.setEjgvDocument(new EjgvDocument());
		signature.getEjgvDocument().setHeader(new Header());
		signature.getEjgvDocument().getHeader().setType("xades");
		signature.getEjgvDocument().getHeader().setPlacement("detached");
		signature.getEjgvDocument().getHeader().setFormat("ES-T");
		signature.getEjgvDocument().getHeader().setVersion("2.0");
		signature.getEjgvDocument().getHeader().setFlags("0");

		signature.getEjgvDocument().setBody(new Body());
		signature.getEjgvDocument().getBody().setSign(adjuntardocs.getFirma());

		Date fechaHoy = new Date();
		String fechaActual = com.ejie.y41b.utils.Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

		StringBuffer nombreSignature = new StringBuffer().append("updateSignatureLocation")
				.append(documento.getOidDokusi()).append(fechaActual).append(".xml");

		// Create JAXB Context
		JAXBContext jaxbContext = JAXBContext.newInstance(EjgvDocumentType.class);

		// Create Marshaller
		Marshaller jaxbMarshaller = jaxbContext.createMarshaller();

		// Required formatting??
		jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		QName qName = new QName("com.ejie.y41b.nshf.EjgvDocumentType", "ejgvDocumentType");
		JAXBElement<EjgvDocumentType> root = new JAXBElement<EjgvDocumentType>(qName, EjgvDocumentType.class,
				signature);

		// Print XML String to Console
		StringWriter swSignature = new StringWriter();

		// Write XML to StringWriter
		jaxbMarshaller.marshal(root, swSignature);

		InputStream myInputStream = new ByteArrayInputStream(Y41bUtils.removePrefixes(swSignature.toString())
				.replaceAll("<ejgvDocumentType >", "").replaceAll("</ejgvDocumentType>", "").getBytes());

		String idPifSignature = this.y41bPifAdapterService.putFileToPLATEA(myInputStream, nombreSignature.toString());

		Y31AttachmentBean y31AttachmentBeanDoc = this.y41bPifAdapterService.moveToPLATEA(docDokusi.getPifId(), true);

		NSHFServiceImpl nshfService = new NSHFServiceImpl();
		String signatureReturnPifId = nshfService.updateSignatureLocation(idPifSignature,
				y31AttachmentBeanDoc.getFilePath(), Y41bConstantes.COD_APLICACION);
		// *************************************************

		// DESCARGA EL DOCUMENTO DEL PIF
		BufferedInputStream bIS = this.y41bPifAdapterService.getFile(signatureReturnPifId);

		String signaturePifReturn = Y41bUtils.convertInputStreamToString(bIS);

		// Parseo del XML mediante JAXB
		com.ejie.y41b.model.nshf.EjgvDocument signatureReturn = null;

		// Create JAXB Context
		jaxbContext = JAXBContext.newInstance(com.ejie.y41b.model.nshf.EjgvDocument.class);

		Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
		StringReader reader = new StringReader(signaturePifReturn);
		signatureReturn = (com.ejie.y41b.model.nshf.EjgvDocument) jaxbUnmarshaller.unmarshal(reader);
		// *************************************************

		List<Firma> listaFirma = new ArrayList<Firma>();
		Firma firma = new Firma();
		firma.setFirma(signatureReturn.getBody().getSign());
		listaFirma.add(firma);

		documento.setFirmas(listaFirma);

		documento.setTsaSerialNumber(signatureReturn.getHeader().getTsaSerialNumber());

		return documento;
	}

	/**
	 * Metodo que inserta el acta en la pestaa de actas para inspecciones web
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 * @throws Exception
	 */
	public String generarActaInspeccionWeb(ActaNueva actaNueva, CensoMonitor censoMonitor) throws Exception {
		try {
			ActaNueva actaNuevaAux = this.actaNuevaDao.find(actaNueva);

			PlantillaActa plantillaActa = new PlantillaActa();
			plantillaActa.setAncodac(actaNuevaAux.getAncodac());
			plantillaActa.setAnfecha(Y41bUtils.formatearDateToString(actaNuevaAux.getAnfecha(),
					Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));
			plantillaActa.setAnhoraini(actaNuevaAux.getAnhoraini());
			plantillaActa.setAnhorafin(actaNuevaAux.getAnhorafin());

			// buscar el interviniente
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(actaNuevaAux.getAncodins());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				plantillaActa.setEsnombre(listIntervinientes.get(0).getNombre());
				plantillaActa.setEsnif(listIntervinientes.get(0).getNif());
				plantillaActa.setEsnoco(listIntervinientes.get(0).getEsnoco());

				if (listIntervinientes.get(0).getNoraCalleId() == null
						|| listIntervinientes.get(0).getNoraCalleId().equals("")) {
					if (listIntervinientes.get(0).getDireccionNocapv() == null
							|| listIntervinientes.get(0).getDireccionNocapv().equals("")) {

						plantillaActa.setEsdireccion(listIntervinientes.get(0).getDireccionAntigua());
					} else {
						plantillaActa.setEsdireccion(listIntervinientes.get(0).getDireccionNocapv());
					}
				} else {
					StringBuffer domicilio = new StringBuffer();
					domicilio.append(listIntervinientes.get(0).getNombreCalle());

					if (listIntervinientes.get(0).getNombrePortal() != null) {
						domicilio.append(", ").append(listIntervinientes.get(0).getNombrePortal());
					}
					if (listIntervinientes.get(0).getNombrePiso() != null) {
						domicilio.append(" ").append(listIntervinientes.get(0).getNombrePiso());
					}
					plantillaActa.setEsdireccion(domicilio.toString());
				}

				plantillaActa.setEsnombreCp(listIntervinientes.get(0).getNombreCp());
				plantillaActa.setEsnombreProvincia(listIntervinientes.get(0).getNombreProvincia());
				plantillaActa.setEsnombreMunicipio(listIntervinientes.get(0).getNombreMunicipio());
				plantillaActa.setEsnombreLocalidad(listIntervinientes.get(0).getNombreLocalidad());

				plantillaActa.setEsnrtel(listIntervinientes.get(0).getNrtel());
				plantillaActa.setEstecoem(listIntervinientes.get(0).getCoem());
				plantillaActa.setEsteurl(listIntervinientes.get(0).getEsteurl());
			}

			// Inspector
			plantillaActa.setMocodigo(censoMonitor.getMocodigo());
			plantillaActa.setMonombre(censoMonitor.getMonombre());

			Actuacion actuacionaux = new Actuacion();
			actuacionaux.setAtcodigo(actaNuevaAux.getAncodins());

			InspeccionDetalle inspeccionDetalleAux = this.actaDao.findInspeccion(actuacionaux);

			StringBuffer nombreFichero = new StringBuffer();

			if (inspeccionDetalleAux != null) {

				if (Y41bUtils.isFilled(inspeccionDetalleAux.getAdcoor())) {
					Organismo organismo = new Organismo();
					organismo.setCodOrg(inspeccionDetalleAux.getAdcoor());

					organismo = this.organismoDao.find(organismo);

					if (organismo != null) {
						// Organismo
						plantillaActa.setCodOrg(organismo.getCodOrg());
						plantillaActa.setNombreEs(organismo.getNombreEs());
						plantillaActa.setNombreEu(organismo.getNombreEu());
					}
				}

				nombreFichero.append(inspeccionDetalleAux.getAccoor()).append("-")
						.append(inspeccionDetalleAux.getAcnror()).append("-").append(inspeccionDetalleAux.getAcnran())
						.append("-").append(inspeccionDetalleAux.getAtnror());
			}

			nombreFichero.append("-").append("Acta");

			nombreFichero.append("-").append(actaNuevaAux.getAncodac());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String rutaRTF = prop.getProperty("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = prop.getProperty("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_ACTA_INSPECCION_WEB_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_ACTA_INSPECCION_WEB_XML;

			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML, plantillaActa,
					plantilla);

			return strFileDataDecode;

		} catch (Exception e) {
			throw e;
		}
	}
}
