package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;

/**
 * ActaNuevaService  
 * 
 *  
 */

public interface ActaNuevaService {

	/**
	 * Inserts a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	ActaNueva add(ActaNueva actaNueva);

	/**
	 * Updates a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	ActaNueva update(ActaNueva actaNueva);

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	ActaNueva find(ActaNueva actaNueva);

	/**
	 * Finds a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva findByAncodac(ActaNueva actaNueva);

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ActaNueva> findAll(ActaNueva actaNueva, Pagination pagination);

	/**
	 * Finds a List of rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ActaNueva> findAllActaTramitada(ActaNueva actaNueva, Pagination pagination);

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return Long
	 */
	Long findAllCount(ActaNueva actaNueva);

	/**
	 * Counts rows in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return Long
	 */
	public Long findAllActaInfraccionProtocoloTramitadaCount(ActaNueva actaNueva);

	/**
	 * Finds rows in the ActaNueva table using like.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ActaNueva> findAllLike(ActaNueva actaNueva, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the ActaNueva table using like.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(ActaNueva actaNueva, Boolean startsWith);

	/**
	 * Deletes a single row in the ActaNueva table.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return
	 */
	void remove(ActaNueva actaNueva);

	/**
	 * Elimina el acta de Mi Carpeta
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @return
	 */
	public void removeMiCarpeta(ActaNueva actaNueva, CensoMonitor censoMonitor);

	/**
	 * Deletes multiple rows in the ActaNueva table.
	 * 
	 * @param actaNuevaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<ActaNueva> actaNuevaList);

	/**
	 * Aniade una acta nueva.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	ActaNueva addActaNueva(ActaNueva actaNueva);

	/**
	 * Actualiza una acta nueva.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tramitar
	 *            boolean
	 * @return ActaNueva
	 */
	ActaNueva updateActaNueva(ActaNueva actaNueva, CensoMonitor censoMonitor, boolean tramitar);

	/**
	 * Aade las infracciones del protocolo
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 */
	public void addInfraccionProtocolo(ActaNueva actaNueva);

	/**
	 * Aade las infracciones del protocolo
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 */
	public void removeInfraccionProtocolo(ActaNueva actaNueva);

	/**
	 * Obtiene los documentos de acta
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva getDocumentoActaNueva(ActaNueva actaNueva);

	/**
	 * Recupera un documento de Acta.
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @return ActaNueva
	 */
	public ActaNueva recuperaActaDocsActaNueva(ActaNueva actaNueva);

	/**
	 * Metodo que actualiza que guarda en Dokusi la firma del documento.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @throws Exception
	 */
	public void saveActaFirmaDocHash(Adjuntardocs adjuntardocs) throws Exception;

	/**
	 * Metodo que inserta el acta en la pestaa de actas para inspecciones web
	 * 
	 * @param actaNueva
	 *            ActaNueva
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 * @throws Exception
	 */
	public String generarActaInspeccionWeb(ActaNueva actaNueva, CensoMonitor censoMonitor) throws Exception;
}