package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ActaInfraccionDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ActaInfraccion;

/**
 * ActaInfraccionServiceImpl  
 *  
 */

@Service(value = "actaInfraccionService")
public class ActaInfraccionServiceImpl implements ActaInfraccionService {

	@Autowired
	private ActaInfraccionDao actaInfraccionDao;

	/**
	 * Inserts a single row in the ActaInfraccion table.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @return ActaInfraccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaInfraccion add(ActaInfraccion actaInfraccion) {
		return this.actaInfraccionDao.add(actaInfraccion);
	}

	/**
	 * Updates a single row in the ActaInfraccion table.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @return ActaInfraccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ActaInfraccion update(ActaInfraccion actaInfraccion) {
		return this.actaInfraccionDao.update(actaInfraccion);
	 }

	/**
	 * Finds a single row in the ActaInfraccion table.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @return ActaInfraccion
	 */
	public ActaInfraccion find(ActaInfraccion actaInfraccion) {
		return (ActaInfraccion) this.actaInfraccionDao.find(actaInfraccion);
	}

	/**
	 * Finds a List of rows in the ActaInfraccion table.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<ActaInfraccion> findAll(ActaInfraccion actaInfraccion, Pagination pagination) {
		return (List<ActaInfraccion>) this.actaInfraccionDao.findAll(actaInfraccion, pagination);
	}
    
	/**
	 * Counts rows in the ActaInfraccion table.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @return Long
	 */
	public Long findAllCount(ActaInfraccion actaInfraccion) {        
		return  this.actaInfraccionDao.findAllCount(actaInfraccion);
	}

	/**
	 * Finds rows in the ActaInfraccion table using like.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<ActaInfraccion> findAllLike(ActaInfraccion actaInfraccion, Pagination pagination, Boolean startsWith) {
		return (List<ActaInfraccion>) this.actaInfraccionDao.findAllLike(actaInfraccion, pagination, startsWith);
	}

	/**
	 * Counts rows in the ActaInfraccion table using like.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(ActaInfraccion actaInfraccion, Boolean startsWith) {
		return this.actaInfraccionDao.findAllLikeCount(actaInfraccion, startsWith);
	}
	    
	/**
	 * Deletes a single row in the ActaInfraccion table.
	 *
	 * @param actaInfraccion ActaInfraccion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ActaInfraccion actaInfraccion) {
		this.actaInfraccionDao.remove(actaInfraccion);
	}
	
	/**
	 * Deletes multiple rows in the ActaInfraccion table.
	 *
	 * @param actaInfraccionList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<ActaInfraccion> actaInfraccionList) {
		for (ActaInfraccion  actaInfraccionAux:actaInfraccionList) {
			this.actaInfraccionDao.remove(actaInfraccionAux);
		}
	}
	
}

