package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AaccDao;
import com.ejie.y41b.dao.CcarDao;
import com.ejie.y41b.dao.Ccta1Dao;
import com.ejie.y41b.dao.DocCensoDao;
import com.ejie.y41b.dao.DocCensoTempDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.Ccar;
import com.ejie.y41b.model.Ccta1;
import com.ejie.y41b.model.DocCenso;
import com.ejie.y41b.model.DocCensoTemp;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AaccServiceImpl  
 * 
 *  
 */

@Service(value = "aaccService")
public class AaccServiceImpl implements AaccService {

	@Autowired()
	private AaccDao aaccDao;
	@Autowired()
	private OrganismoDao organismoDao;
	@Autowired()
	private CcarDao ccarDao;
	@Autowired()
	private Ccta1Dao ccta1Dao;
	@Autowired()
	private DocCensoTempDao docCensoTempDao;
	@Autowired()
	private DocCensoDao docCensoDao;
	@Autowired()
	private SolarbDao solArbDao;

	/**
	 * Inserts a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aacc add(Aacc aacc) {
		this.aaccDao.add(aacc);
		this.tratarMn(aacc);
		return aacc;
	}

	/**
	 * Updates a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aacc update(Aacc aacc) {
		this.aaccDao.update(aacc);
		this.tratarMn(aacc);
		return aacc;
	}

	/**
	 * 
	 * @param aacc
	 *            Aacc
	 */
	private void tratarMn(Aacc aacc) {
		// Territorios de actuacin: borramos por aacc y aadimos la lista
		Ccta1 ccta1 = new Ccta1();
		ccta1.setAacc(aacc);
		this.ccta1Dao.remove(ccta1);
		if (!Y41bUtils.esNullOCadenaVacia(aacc.getCcThActAraba())) {
			ccta1.setM7cota1(aacc.getCcThActAraba());
			ccta1.setAacc(aacc);
			// Aadimos los territorios de la aacc
			this.ccta1Dao.add(ccta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(aacc.getCcThActBizkaia())) {
			ccta1.setM7cota1(aacc.getCcThActBizkaia());
			ccta1.setAacc(aacc);
			// Aadimos los territorios de la aacc
			this.ccta1Dao.add(ccta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(aacc.getCcThActGipuzkoa())) {
			ccta1.setM7cota1(aacc.getCcThActGipuzkoa());
			ccta1.setAacc(aacc);
			// Aadimos los territorios de la aacc
			this.ccta1Dao.add(ccta1);
		}

		// Arbitros
		Ccar ccar = new Ccar();
		ccar.setAacc(aacc);
		// Borramos de ccar por aacc
		this.ccarDao.removeCcarAacc(ccar);
		// Lista de la temporal
		List<Ccar> ccars = this.ccarDao.findAll(ccar, null);
		for (int i = 0; i < ccars.size(); i++) {
			ccar = ccars.get(i);
			// Aadimos los arbitros a oese
			this.ccarDao.addCcar(ccar);
			// Eliminamos de la temporal
			this.ccarDao.remove(ccar);
		}
		// Documentos
		DocCenso docCenso = new DocCenso();
		docCenso.setEacoentidad(aacc.getCccodigo());
		docCenso.setEatipoentidad(Y41bConstantes.CENSO_ARB_AACC);
		// Borramos de doc_censo por aacc
		this.docCensoDao.remove(docCenso);
		// Insertamos de la temporal a doc_censo
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacoentidad(aacc.getCccodigo());
		docCensoTemp.setEatipoentidad(Y41bConstantes.CENSO_ARB_AACC);
		this.docCensoTempDao.addDocCensoFromTemporal(docCensoTemp);
		// Borramos de la temporal por aacc
		this.docCensoTempDao.removeByEntidad(docCensoTemp);
	}

	/**
	 * Finds a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	public Aacc find(Aacc aacc) {
		Aacc aaccDetalle = this.aaccDao.find(aacc);

		Organismo organismo = new Organismo();
		organismo.setCodOrg(aacc.getCccodigo());
		try {
			organismo = this.organismoDao.find(organismo);
		} catch (Exception e) {
			// Si no encuentra el organismo se "ahoga" la excepcion
		}
		aaccDetalle.setOrganismo(organismo);

		// Volcar en tablas temporales: arbitros y documentos

		this.ccarDao.volcarAaccArbitros(aacc);

		this.docCensoTempDao.addTemporalFromCensoDoc(aacc.getCccodigo(),
				Y41bConstantes.CENSO_ARB_AACC);

		return aaccDetalle;
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Aacc> findAll(Aacc aacc, Pagination pagination) {
		return (List<Aacc>) this.aaccDao.findAll(aacc, pagination);
	}

	/**
	 * Counts rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Long
	 */
	public Long findAllCount(Aacc aacc) {
		return this.aaccDao.findAllCount(aacc);
	}

	/**
	 * Finds rows in the Aacc table using like.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Aacc> findAllLike(Aacc aacc, Pagination pagination,
			Boolean startsWith) {
		return (List<Aacc>) this.aaccDao.findAllLike(aacc, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Aacc table using like.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Aacc aacc, Boolean startsWith) {
		return this.aaccDao.findAllLikeCount(aacc, startsWith);
	}

	/**
	 * Deletes a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aacc aacc) {
		Solarb solarb = new Solarb();
		solarb.setAacc(aacc);
		long numExpedientesAbiertos = this.solArbDao.findAllCount(solarb);
		if (numExpedientesAbiertos > 0) {
			throw new Y41bUDAException(
					"error.aacc.ExpedientesAbiertosException", true,
					new Exception());
		}
		// Borramos de cta1 por aacc
		Ccta1 ccta1 = new Ccta1();
		ccta1.setAacc(aacc);
		this.ccta1Dao.remove(ccta1);

		// Borramos de ccar por aacc
		Ccar ccar = new Ccar();
		ccar.setAacc(aacc);
		this.ccarDao.removeCcarAacc(ccar);

		// Borramos de doc_censo por aacc
		DocCenso docCenso = new DocCenso();
		docCenso.setEacoentidad(aacc.getCccodigo());
		docCenso.setEatipoentidad(Y41bConstantes.CENSO_ARB_AACC);
		this.docCensoDao.remove(docCenso);

		this.borrarTemporales(aacc);
		this.aaccDao.remove(aacc);
	}

	/**
	 * Deletes multiple rows in the Aacc table.
	 * 
	 * @param aaccList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Aacc> aaccList) {
		for (Aacc aaccAux : aaccList) {
			this.aaccDao.remove(aaccAux);
		}
	}

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Aacc> findAllBusqueda(Aacc aacc, Pagination pagination) {

		if (pagination.getSort() != null
				&& pagination.getSort().equals("organismo.nombreEs")) {
			pagination.setSort("OrganismoNOMBREES");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("organismo.nombreEu")) {
			pagination.setSort("OrganismoNOMBREEU");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("organismo.nombreMunicipio")) {
			pagination.setSort("OrganismoNOMBREMUNICIPIO");
		}
		return (List<Aacc>) this.aaccDao.findAllBusqueda(aacc, pagination);
	}

	/**
	 * Counts rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Long
	 */
	public Long findAllBusquedaCount(Aacc aacc) {
		return this.aaccDao.findAllBusquedaCount(aacc);
	}

	/**
	 * Borra los registros temporales
	 * 
	 * @param aacc
	 *            Aacc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void borrarTemporales(Aacc aacc) {

		// Arbitros
		Ccar ccar = new Ccar();
		ccar.setAacc(aacc);
		// Lista de la temporal
		List<Ccar> ccars = this.ccarDao.findAll(ccar, null);
		for (int i = 0; i < ccars.size(); i++) {
			ccar = ccars.get(i);
			// Eliminamos de la temporal
			this.ccarDao.remove(ccar);
		}
		// Documentos
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacoentidad(aacc.getCccodigo());
		docCensoTemp.setEatipoentidad(Y41bConstantes.CENSO_ARB_AACC);
		// Borramos de la temporal por aacc
		this.docCensoTempDao.removeByEntidad(docCensoTemp);

	}

}
