package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Aacc;

/**
 * AaccService  
 * 
 *  
 */

public interface AaccService {

	/**
	 * Inserts a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	Aacc add(Aacc aacc);

	/**
	 * Updates a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	Aacc update(Aacc aacc);

	/**
	 * Finds a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Aacc
	 */
	Aacc find(Aacc aacc);

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Aacc> findAll(Aacc aacc, Pagination pagination);

	/**
	 * Counts rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Long
	 */
	Long findAllCount(Aacc aacc);

	/**
	 * Finds rows in the Aacc table using like.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aacc> findAllLike(Aacc aacc, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Aacc table using like.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Aacc aacc, Boolean startsWith);

	/**
	 * Deletes a single row in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return
	 */
	void remove(Aacc aacc);

	/**
	 * Deletes multiple rows in the Aacc table.
	 * 
	 * @param aaccList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Aacc> aaccList);

	/**
	 * Finds a List of rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Aacc> findAllBusqueda(Aacc aacc, Pagination pagination);

	/**
	 * Counts rows in the Aacc table.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return Long
	 */
	Long findAllBusquedaCount(Aacc aacc);

	/**
	 * Borra los registros temporales
	 * 
	 * @param aacc
	 *            Aacc
	 */
	void borrarTemporales(Aacc aacc);

}
