package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AaccEuskadiConfederacionDao;
import com.ejie.y41b.dao.AaccEuskadiCuotaDao;
import com.ejie.y41b.dao.AaccEuskadiDao;
import com.ejie.y41b.dao.AaccEuskadiFederacionDao;
import com.ejie.y41b.dao.AaccEuskadiOrganoGestorDao;
import com.ejie.y41b.dao.AaccEuskadiSedeDao;
import com.ejie.y41b.dao.CcarDao;
import com.ejie.y41b.dao.Ccta1Dao;
import com.ejie.y41b.dao.DocCensoDao;
import com.ejie.y41b.dao.DocCensoTempDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiConfederacion;
import com.ejie.y41b.model.AaccEuskadiCuota;
import com.ejie.y41b.model.AaccEuskadiFederacion;
import com.ejie.y41b.model.AaccEuskadiOrganoGestor;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.Ccar;
import com.ejie.y41b.model.Contacto;
import com.ejie.y41b.model.DocCenso;
import com.ejie.y41b.model.DocCensoTemp;
import com.ejie.y41b.model.Organismo;

/**
 * AaccServiceImpl  
 * 
 *  
 */

@Service(value = "aaccEuskadiService")
public class AaccEuskadiServiceImpl implements AaccEuskadiService {

	@Autowired()
	private AaccEuskadiDao aaccEuskadiDao;

	@Autowired()
	private AaccEuskadiSedeDao aaccEuskadiSedeDao;

	@Autowired()
	private AaccEuskadiFederacionDao aaccEuskadiFederacionDao;

	@Autowired()
	private AaccEuskadiConfederacionDao aaccEuskadiConfederacionDao;

	@Autowired()
	private AaccEuskadiOrganoGestorDao aaccEuskadiOrganoGestorDao;

	@Autowired()
	private AaccEuskadiCuotaDao aaccEuskadiCuotaDao;

	@Autowired()
	private OrganismoDao organismoDao;
	@Autowired()
	private CcarDao ccarDao;
	@Autowired()
	private Ccta1Dao ccta1Dao;
	@Autowired()
	private DocCensoTempDao docCensoTempDao;
	@Autowired()
	private DocCensoDao docCensoDao;
	@Autowired()
	private SolarbDao solArbDao;

	/**
	 * Inserts a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadi add(AaccEuskadi aaccEuskadi) {

		aaccEuskadi.setAeNumRegistro(this.aaccEuskadiDao.getNewNumRegistro().toString());
		this.aaccEuskadiDao.add(aaccEuskadi);
		this.tratarTemporales(aaccEuskadi);
		return aaccEuskadi;
	}

	/**
	 * Updates a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadi update(AaccEuskadi aaccEuskadi) {
		this.aaccEuskadiDao.update(aaccEuskadi);
		this.tratarTemporales(aaccEuskadi);
		return aaccEuskadi;
	}

	/**
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 */
	private void tratarTemporales(AaccEuskadi aaccEuskadi) {

		// Eliminar finales siempre
		// 1.- eliminar de la final L21YAT00 por codOrg, todos los registros
		// (otras sedes) de ese organismo (sede principal)
		AaccEuskadiSede aaccEuskadiSede = new AaccEuskadiSede();
		aaccEuskadiSede.setCodOrg(aaccEuskadi.getAeCodigo());
		this.aaccEuskadiSedeDao.removeAllFinal(aaccEuskadiSede);

		// 1.- eliminar de la final L21YBT00 por codOrg, todos los registros
		// (asociaciones o cooperativas) de ese organismo (federacion)
		AaccEuskadiFederacion aaccEuskadiFederacion = new AaccEuskadiFederacion();
		aaccEuskadiFederacion.setCodOrgFederacion(aaccEuskadi.getAeCodigo());
		this.aaccEuskadiFederacionDao.removeAllFinal(aaccEuskadiFederacion);

		// 1.- eliminar de la final L21YCT00 por codOrg, todos los registros
		// (federaciones) de ese organismo (confederacion)
		AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
		aaccEuskadiConfederacion.setCodOrgConfederacion(aaccEuskadi.getAeCodigo());
		this.aaccEuskadiConfederacionDao.removeAllFinal(aaccEuskadiConfederacion);

		// Para que funcione bien tanto en el alta como en la edicion
		// solo se copia de la temporal a la final para el tipo org seleccionado
		// OTRAS SEDES ///////////////////////////////////////////////
		if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("A") || aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("C")) {

			// ahora es asoc o coop pero
			// - puede que fuese federacion y una confederacion la tuviese
			// ligada (habria que borrar de la final L21YC confederacones donde
			// el codorg = codfederacion)
			// - puede que fuese una confederacion (sin problemas)

			this.aaccEuskadiConfederacionDao.removeFromConfederacionesFinalByCodFederacion(aaccEuskadi.getAeCodigo());

			// 2- grabar las sedes de la temporal (L21YAT01) a la final
			// (L21YAT00) y borrar de la temporal

			List<AaccEuskadiSede> listaAaccEuskadiSede = this.aaccEuskadiSedeDao.findAll(aaccEuskadiSede, null);
			for (int i = 0; i < listaAaccEuskadiSede.size(); i++) {
				aaccEuskadiSede = listaAaccEuskadiSede.get(i);
				// Aadir registro a la final
				this.aaccEuskadiSedeDao.addFinal(aaccEuskadiSede);
				// Eliminar registro de la temporal
				this.aaccEuskadiSedeDao.remove(aaccEuskadiSede);
			}

			// FEDERACIONES ///////////////////////////////////////////////
		} else if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("F")) {

			// ahora federacion pero
			// - puede que fuese asoc o coop y una federacion la tuviese ligada
			// (habria que borrar de la final L21YB federaciones donde el codorg
			// = codasococoop)
			// - puede que fuese una confederacion (sin problemas)
			this.aaccEuskadiFederacionDao.removeFromFederacionesFinalByCodAsoocOCoop(aaccEuskadi.getAeCodigo());

			// 2- grabar las sedes de la temporal (L21YBT01) a la final
			// (L21YBT00) y borrar de la temporal

			List<AaccEuskadiFederacion> listaAaccEuskadiFederacion = this.aaccEuskadiFederacionDao
					.findAll(aaccEuskadiFederacion, null);
			for (int i = 0; i < listaAaccEuskadiFederacion.size(); i++) {
				aaccEuskadiFederacion = listaAaccEuskadiFederacion.get(i);
				// Aadir registro a la final
				this.aaccEuskadiFederacionDao.addFinal(aaccEuskadiFederacion);
				// Eliminar registro de la temporal
				this.aaccEuskadiFederacionDao.remove(aaccEuskadiFederacion);
			}

			// CONFEDERACIONES ///////////////////////////////////////////////
		} else if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("D")) {

			// ahora confederacion pero
			// - puede que fuese federacion y una confederacion la tuviese
			// ligada (habria que borrar de la final L21YCT00 confederacones
			// donde el codorg = codfederacion)
			// - puede que fuese asoc o coop y una federacion la tuviese ligada
			// (habria que borrar de la final L21YBT00 federaciones donde el
			// codorg = codasococoop)
			this.aaccEuskadiConfederacionDao.removeFromConfederacionesFinalByCodFederacion(aaccEuskadi.getAeCodigo());
			this.aaccEuskadiFederacionDao.removeFromFederacionesFinalByCodAsoocOCoop(aaccEuskadi.getAeCodigo());

			// 2- grabar las sedes de la temporal (L21YCT01) a la final
			// (L21YCT00) y borrar de la temporal

			List<AaccEuskadiConfederacion> listaAaccEuskadiConfederacion = this.aaccEuskadiConfederacionDao
					.findAll(aaccEuskadiConfederacion, null);
			for (int i = 0; i < listaAaccEuskadiConfederacion.size(); i++) {
				aaccEuskadiConfederacion = listaAaccEuskadiConfederacion.get(i);
				// Aadir registro a la final
				this.aaccEuskadiConfederacionDao.addFinal(aaccEuskadiConfederacion);
				// Eliminar registro de la temporal
				this.aaccEuskadiConfederacionDao.remove(aaccEuskadiConfederacion);
			}
		}

		// ORGANO GESTOR ///////////////////////////////////////////////
		AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor = new AaccEuskadiOrganoGestor();
		aaccEuskadiOrganoGestor.setOgCodOrg(aaccEuskadi.getAeCodigo());

		// 1.- eliminar de la final L21YDT00 por codOrg, todos los registros
		// (organo gestor) de ese organismo (organo gestor)
		this.aaccEuskadiOrganoGestorDao.removeAllFinal(aaccEuskadiOrganoGestor);

		// 2- grabar las sedes de la temporal (L21YCT01) a la final
		// (L21YCT00) y borrar de la temporal

		List<AaccEuskadiOrganoGestor> listaAaccEuskadiOrganoGestor = this.aaccEuskadiOrganoGestorDao
				.findAll(aaccEuskadiOrganoGestor, null);
		for (int i = 0; i < listaAaccEuskadiOrganoGestor.size(); i++) {
			aaccEuskadiOrganoGestor = listaAaccEuskadiOrganoGestor.get(i);
			// Aadir registro a la final
			this.aaccEuskadiOrganoGestorDao.addFinal(aaccEuskadiOrganoGestor);
			// Eliminar registro de la temporal
			this.aaccEuskadiOrganoGestorDao.remove(aaccEuskadiOrganoGestor);
		}

		// CUOTAS ///////////////////////////////////////////////
		AaccEuskadiCuota aaccEuskadiCuota = new AaccEuskadiCuota();
		aaccEuskadiCuota.setCuCodOrg(aaccEuskadi.getAeCodigo());

		// 1.- eliminar de la final L21YDT00 por codOrg, todos los registros
		// (organo gestor) de ese organismo (organo gestor)
		this.aaccEuskadiCuotaDao.removeAllFinal(aaccEuskadiCuota);

		// 2- grabar las sedes de la temporal (L21YCT01) a la final
		// (L21YCT00) y borrar de la temporal

		List<AaccEuskadiCuota> listaAaccEuskadiCuota = this.aaccEuskadiCuotaDao.findAll(aaccEuskadiCuota, null);
		for (int i = 0; i < listaAaccEuskadiCuota.size(); i++) {
			aaccEuskadiCuota = listaAaccEuskadiCuota.get(i);
			// Aadir registro a la final
			this.aaccEuskadiCuotaDao.addFinal(aaccEuskadiCuota);
			// Eliminar registro de la temporal
			this.aaccEuskadiCuotaDao.remove(aaccEuskadiCuota);
		}

		// DOCUMENTOS
		DocCenso docCenso = new DocCenso();
		docCenso.setEacoentidad(aaccEuskadi.getAeCodigo());
		docCenso.setEatipoentidad(Y41bConstantes.CENSO_AACC_EUSKADI);
		// borra de la tabla final de docs todos los docs del organismo marcados
		// como aaccEuskadi
		this.docCensoDao.remove(docCenso);
		// Insertamos todos los docs de la temporal a la final correspondientes
		// a la dupla codOrg y aaccEuskadi
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacoentidad(aaccEuskadi.getAeCodigo());
		docCensoTemp.setEatipoentidad(Y41bConstantes.CENSO_AACC_EUSKADI);
		this.docCensoTempDao.addDocCensoFromTemporal(docCensoTemp);
		// Borramos de la temporal todos los docs de la la dupla codOrg y
		// aaccEuskadi
		this.docCensoTempDao.removeByEntidad(docCensoTemp);

	}

	/**
	 * Finds a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	public AaccEuskadi find(AaccEuskadi aaccEuskadi) {
		AaccEuskadi aaccEuskadiDetalle = this.aaccEuskadiDao.find(aaccEuskadi);

		// Organismo
		Organismo organismo = new Organismo();
		organismo.setCodOrg(aaccEuskadi.getAeCodigo());
		try {
			organismo = this.organismoDao.find(organismo);
		} catch (Exception e) {
			// Si no encuentra el organismo se "ahoga" la excepcion
		}
		aaccEuskadiDetalle.setOrganismo(organismo);

		// Contacto
		Contacto contacto = new Contacto();
		try {
			contacto = this.organismoDao.findContacto(organismo);
		} catch (Exception e) {
			// Si no encuentra el organismo se "ahoga" la excepcion
		}
		aaccEuskadiDetalle.setContacto(contacto);

		// Eliminar de las finales
		AaccEuskadiSede aaccEuskadiSede = new AaccEuskadiSede();
		aaccEuskadiSede.setCodOrg(aaccEuskadiDetalle.getAeCodigo());
		// 1.- eliminar de la temporal L21YAT01 todos los registros (otras
		// sedes) de ese org
		this.aaccEuskadiSedeDao.removeAllTemp(aaccEuskadiSede);

		AaccEuskadiFederacion aaccEuskadiFederacion = new AaccEuskadiFederacion();
		aaccEuskadiFederacion.setCodOrgFederacion(aaccEuskadi.getAeCodigo());
		// 1.- eliminar de la temporal L21YBT01 todos los registros (asoc o
		// coop) por codorg
		this.aaccEuskadiFederacionDao.removeAllTemp(aaccEuskadiFederacion);

		AaccEuskadiConfederacion aaccEuskadiConfederacion = new AaccEuskadiConfederacion();
		aaccEuskadiConfederacion.setCodOrgConfederacion(aaccEuskadi.getAeCodigo());
		// 1.- eliminar de la temporal L21YCT01 por codOrg, todos los
		// registros
		// (federaciones)
		this.aaccEuskadiConfederacionDao.removeAllTemp(aaccEuskadiConfederacion);

		// Volcar en tablas temporales

		// ASOCIACIONES O COOPERATIVAS //////////////////////////////////
		if (aaccEuskadiDetalle.getAeTipoOrg().equalsIgnoreCase("A")
				|| aaccEuskadiDetalle.getAeTipoOrg().equalsIgnoreCase("C")) {

			// grabar las sedes de la final (L21YAT00) a la temporal
			// (L21YAT01)

			List<AaccEuskadiSede> listaAaccEuskadiSede = this.aaccEuskadiSedeDao.findAllFinal(aaccEuskadiSede, null);
			for (int i = 0; i < listaAaccEuskadiSede.size(); i++) {
				aaccEuskadiSede = listaAaccEuskadiSede.get(i);
				// Aadir registro a la temporal
				this.aaccEuskadiSedeDao.addTemp(aaccEuskadiSede);

			}

		} else if (aaccEuskadiDetalle.getAeTipoOrg().equalsIgnoreCase("F")) {
			// FEDERACIONES ////////////////////////////////////////////////

			// 2- grabar las sedes de la final (L21YBT00) a la temporal
			// (L21YBT01)

			List<AaccEuskadiFederacion> listaAaccEuskadiFederacion = this.aaccEuskadiFederacionDao
					.findAllFinal(aaccEuskadiFederacion, null);
			for (int i = 0; i < listaAaccEuskadiFederacion.size(); i++) {
				aaccEuskadiFederacion = listaAaccEuskadiFederacion.get(i);
				// Aadir registro a la temporal
				this.aaccEuskadiFederacionDao.addTemp(aaccEuskadiFederacion);

			}

		} else if (aaccEuskadiDetalle.getAeTipoOrg().equalsIgnoreCase("D")) {
			// CONFEDERACIONES ////////////////////////////////////////////////

			// 2- grabar las sedes de la final (L21YCT00) a la temporal
			// (L21YCT01)

			List<AaccEuskadiConfederacion> listaAaccEuskadiConfederacion = this.aaccEuskadiConfederacionDao
					.findAllFinal(aaccEuskadiConfederacion, null);
			for (int i = 0; i < listaAaccEuskadiConfederacion.size(); i++) {
				aaccEuskadiConfederacion = listaAaccEuskadiConfederacion.get(i);
				// Aadir registro a la final
				this.aaccEuskadiConfederacionDao.addTemp(aaccEuskadiConfederacion);

			}
		}

		// ORGANO GESTOR //////////////////////////////////////////////////
		AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor = new AaccEuskadiOrganoGestor();
		aaccEuskadiOrganoGestor.setOgCodOrg(aaccEuskadi.getAeCodigo());

		// 1.- eliminar de la temporal L21YDT01 por codOrg, todos los
		// registros (organos gestor)
		this.aaccEuskadiOrganoGestorDao.removeAllTemp(aaccEuskadiOrganoGestor);

		// 2- grabar las sedes de la final (L21YDT00) a la temporal
		// (L21YDT01)
		List<AaccEuskadiOrganoGestor> listaAaccEuskadiOrganoGestor = this.aaccEuskadiOrganoGestorDao
				.findAllFinal(aaccEuskadiOrganoGestor, null);
		for (int i = 0; i < listaAaccEuskadiOrganoGestor.size(); i++) {
			aaccEuskadiOrganoGestor = listaAaccEuskadiOrganoGestor.get(i);
			// Aadir registro a la final
			this.aaccEuskadiOrganoGestorDao.addTemp(aaccEuskadiOrganoGestor);
		}

		// CUOTAS /////////////////////////////////////////////////////////
		AaccEuskadiCuota aaccEuskadiCuota = new AaccEuskadiCuota();
		aaccEuskadiCuota.setCuCodOrg(aaccEuskadi.getAeCodigo());

		// 1.- eliminar de la temporal L21YET01 por codOrg, todos los
		// registros (cuotas)
		this.aaccEuskadiCuotaDao.removeAllTemp(aaccEuskadiCuota);

		// 2- grabar las sedes de la final (L21YDT00) a la temporal
		// (L21YDT01)
		List<AaccEuskadiCuota> listaAaccEuskadiCuota = this.aaccEuskadiCuotaDao.findAllFinal(aaccEuskadiCuota, null);
		for (int i = 0; i < listaAaccEuskadiCuota.size(); i++) {
			aaccEuskadiCuota = listaAaccEuskadiCuota.get(i);
			// Aadir registro a la final
			this.aaccEuskadiCuotaDao.addTemp(aaccEuskadiCuota);
		}

		// DOCS
		// ////////////////////////////////////////////////////////////////////
		this.docCensoTempDao.addTemporalFromCensoDoc(aaccEuskadi.getAeCodigo(), Y41bConstantes.CENSO_AACC_EUSKADI);

		return aaccEuskadiDetalle;
	}

	// /**
	// * Finds a List of rows in the Aacc table.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @return List
	// */
	// public List<Aacc> findAll(Aacc aacc, Pagination pagination) {
	// return (List<Aacc>) this.aaccDao.findAll(aacc, pagination);
	// }
	//
	/**
	 * Counts rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadi aaccEuskadi) {
		return this.aaccEuskadiDao.findAllCount(aaccEuskadi);
	}

	//
	// /**
	// * Finds rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @param startsWith
	// * Boolean
	// * @return List
	// */
	// public List<Aacc> findAllLike(Aacc aacc, Pagination pagination,
	// Boolean startsWith) {
	// return (List<Aacc>) this.aaccDao.findAllLike(aacc, pagination,
	// startsWith);
	// }
	//
	// /**
	// * Counts rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param startsWith
	// * Boolean
	// * @return Long
	// */
	// public Long findAllLikeCount(Aacc aacc, Boolean startsWith) {
	// return this.aaccDao.findAllLikeCount(aacc, startsWith);
	// }
	//
	/**
	 * Deletes a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AaccEuskadi aaccEuskadi) {
		this.aaccEuskadiDao.remove(aaccEuskadi);
	}

	//
	// /**
	// * Deletes multiple rows in the Aacc table.
	// *
	// * @param aaccList
	// * List
	// * @return
	// */
	// @Transactional(rollbackFor = Throwable.class)
	// public void removeMultiple(List<Aacc> aaccList) {
	// for (Aacc aaccAux : aaccList) {
	// this.aaccDao.remove(aaccAux);
	// }
	// }
	//
	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadi> findAllBusqueda(AaccEuskadi aaccEuskadi, Pagination pagination) {

		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreEs")) {
		// pagination.setSort("OrganismoNOMBREES");
		// }
		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreEu")) {
		// pagination.setSort("OrganismoNOMBREEU");
		// }
		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreMunicipio")) {
		// pagination.setSort("OrganismoNOMBREMUNICIPIO");
		// }
		return (List<AaccEuskadi>) this.aaccEuskadiDao.findAllBusqueda(aaccEuskadi, pagination);
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	public Long findAllBusquedaCount(AaccEuskadi aaccEuskadi) {
		return this.aaccEuskadiDao.findAllBusquedaCount(aaccEuskadi);
	}

	/**
	 * Borra los registros temporales
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void borrarTemporales(AaccEuskadi aaccEuskadi) {

		// OTRAS SEDES
		// eliminar de la temporal L21YAT01 por codOrg, todos los registros
		// (otras sedes) de ese organismo (sede principal)
		AaccEuskadiSede aaccEuskadiSedeTemp = new AaccEuskadiSede();
		aaccEuskadiSedeTemp.setCodOrg(aaccEuskadi.getAeCodigo());

		this.aaccEuskadiSedeDao.removeAllTemp(aaccEuskadiSedeTemp);

		// FEDERACIONES
		AaccEuskadiFederacion aaccEuskadiFederacionTemp = new AaccEuskadiFederacion();
		aaccEuskadiFederacionTemp.setCodOrgFederacion(aaccEuskadi.getAeCodigo());

		// eliminar de la temporal L21YAT01 por codOrg, todos los registros
		// (asociaciones o cooperativas) de ese organismo (federacion)
		this.aaccEuskadiFederacionDao.removeAllTemp(aaccEuskadiFederacionTemp);

		// CONFEDERACIONES
		AaccEuskadiConfederacion aaccEuskadiConfederacionTemp = new AaccEuskadiConfederacion();
		aaccEuskadiConfederacionTemp.setCodOrgConfederacion(aaccEuskadi.getAeCodigo());

		// eliminar de la temporal L21YCT01 por codOrg, todos los registros
		// (federaciones) de ese organismo (confederacion)
		this.aaccEuskadiConfederacionDao.removeAllTemp(aaccEuskadiConfederacionTemp);

		// ORGANO GESTOR
		AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor = new AaccEuskadiOrganoGestor();
		aaccEuskadiOrganoGestor.setOgCodOrg(aaccEuskadi.getAeCodigo());
		// 1.- eliminar de la temporal L21YDT01 por codOrg, todos los
		// registros (organos gestor)
		this.aaccEuskadiOrganoGestorDao.removeAllTemp(aaccEuskadiOrganoGestor);

		// CUOTAS
		AaccEuskadiCuota aaccEuskadiCuota = new AaccEuskadiCuota();
		aaccEuskadiCuota.setCuCodOrg(aaccEuskadi.getAeCodigo());
		// 1.- eliminar de la temporal L21YET01 por codOrg, todos los
		// registros (cuotas)
		this.aaccEuskadiCuotaDao.removeAllTemp(aaccEuskadiCuota);
		// DOCUMENTOS
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacoentidad(aaccEuskadi.getAeCodigo());
		docCensoTemp.setEatipoentidad(Y41bConstantes.CENSO_AACC_EUSKADI);
		// Borramos de la temporal por aacc
		this.docCensoTempDao.removeByEntidad(docCensoTemp);

	}

	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadi> findAllAsocCoop(AaccEuskadi aaccEuskadi, Pagination pagination) {

		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreEs")) {
		// pagination.setSort("OrganismoNOMBREES");
		// }
		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreEu")) {
		// pagination.setSort("OrganismoNOMBREEU");
		// }
		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreMunicipio")) {
		// pagination.setSort("OrganismoNOMBREMUNICIPIO");
		// }
		return (List<AaccEuskadi>) this.aaccEuskadiDao.findAllAsocCoop(aaccEuskadi, pagination);
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	public Long findAllAsocCoopCount(AaccEuskadi aaccEuskadi) {
		return this.aaccEuskadiDao.findAllAsocCoopCount(aaccEuskadi);
	}

	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadi> findAllFederaciones(AaccEuskadi aaccEuskadi, Pagination pagination) {

		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreEs")) {
		// pagination.setSort("OrganismoNOMBREES");
		// }
		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreEu")) {
		// pagination.setSort("OrganismoNOMBREEU");
		// }
		// if (pagination.getSort() != null &&
		// pagination.getSort().equals("organismo.nombreMunicipio")) {
		// pagination.setSort("OrganismoNOMBREMUNICIPIO");
		// }
		return (List<AaccEuskadi>) this.aaccEuskadiDao.findAllFederaciones(aaccEuskadi, pagination);
	}

	/**
	 * Counts rows in the AaccEuskadi table.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	public Long findAllFederacionesCount(AaccEuskadi aaccEuskadi) {
		return this.aaccEuskadiDao.findAllFederacionesCount(aaccEuskadi);
	}

}
