package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;

/**
 * AaccService  
 * 
 *  
 */

public interface AaccEuskadiService {

	/**
	 * Inserts a single row in the Aacc table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	AaccEuskadi add(AaccEuskadi aaccEuskadi);

	/**
	 * Updates a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	AaccEuskadi update(AaccEuskadi aaccEuskadi);

	/**
	 * Finds a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return AaccEuskadi
	 */
	AaccEuskadi find(AaccEuskadi aaccEuskadi);

	// /**
	// * Finds a List of rows in the Aacc table.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @return List
	// */
	// List<Aacc> findAll(Aacc aacc, Pagination pagination);
	//
	/**
	 * Counts rows in the Aacc table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllCount(AaccEuskadi aaccEuskadi);

	//
	// /**
	// * Finds rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param pagination
	// * Pagination
	// * @param startsWith
	// * Boolean
	// * @return List
	// */
	// List<Aacc> findAllLike(Aacc aacc, Pagination pagination, Boolean
	// startsWith);
	//
	// /**
	// * Counts rows in the Aacc table using like.
	// *
	// * @param aacc
	// * Aacc
	// * @param startsWith
	// * Boolean
	// * @return Long
	// */
	// Long findAllLikeCount(Aacc aacc, Boolean startsWith);
	//
	/**
	 * Deletes a single row in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return
	 */
	void remove(AaccEuskadi aaccEuskadi);

	//
	// /**
	// * Deletes multiple rows in the Aacc table.
	// *
	// * @param aaccList
	// * List
	// * @return
	// */
	// void removeMultiple(List<Aacc> aaccList);
	//
	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AaccEuskadi> findAllBusqueda(AaccEuskadi aaccEuskadi, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllBusquedaCount(AaccEuskadi aaccEuskadi);

	// /**
	// * Borra los registros temporales
	// *
	// * @param aacc
	// * Aacc
	// */
	// void borrarTemporales(Aacc aacc);

	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AaccEuskadi> findAllAsocCoop(AaccEuskadi aaccEuskadi, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllAsocCoopCount(AaccEuskadi aaccEuskadi);

	/**
	 * Finds a List of rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AaccEuskadi> findAllFederaciones(AaccEuskadi aaccEuskadi, Pagination pagination);

	/**
	 * Counts rows in the AaccEuskadi table.
	 *
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return Long
	 */
	Long findAllFederacionesCount(AaccEuskadi aaccEuskadi);

	/**
	 * Borra los registros temporales
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 */
	void borrarTemporales(AaccEuskadi aaccEuskadi);

}
