package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AaccEuskadiSedeDao;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AaccServiceImpl  
 * 
 *  
 */

@Service(value = "aaccEuskadiSedeService")
public class AaccEuskadiSedeServiceImpl implements AaccEuskadiSedeService {

	@Autowired()
	private AaccEuskadiSedeDao aaccEuskadiSedeDao;

	/**
	 * Inserts a single row in the Aacc table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadiSede addTemp(AaccEuskadiSede aaccEuskadiSede) {
		aaccEuskadiSede.setIdSede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		this.aaccEuskadiSedeDao.addTemp(aaccEuskadiSede);
		return aaccEuskadiSede;
	}

	/**
	 * Updates a single row in the AaccEuskadiSede table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return AaccEuskadiSede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadiSede update(AaccEuskadiSede aaccEuskadiSede) {
		this.aaccEuskadiSedeDao.update(aaccEuskadiSede);
		return aaccEuskadiSede;
	}

	/**
	 * Finds a List of rows in the AaccEuskadiSede table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiSede> findAll(AaccEuskadiSede aaccEuskadiSede, Pagination pagination) {
		return (List<AaccEuskadiSede>) this.aaccEuskadiSedeDao.findAll(aaccEuskadiSede, pagination);
	}

	/**
	 * Counts rows in the AaccEuskadiSede table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadiSede aaccEuskadiSede) {
		return this.aaccEuskadiSedeDao.findAllCount(aaccEuskadiSede);
	}

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AaccEuskadiSede aaccEuskadiSede) {
		this.aaccEuskadiSedeDao.remove(aaccEuskadiSede);
	}

	/**
	 * Finds a rows in the AaccEuskadiSede table.
	 *
	 * @param aaccEuskadiSede
	 *            AaccEuskadiSede
	 * @return List
	 */
	public AaccEuskadiSede findSede(AaccEuskadiSede aaccEuskadiSede) {
		return (AaccEuskadiSede) this.aaccEuskadiSedeDao.findSede(aaccEuskadiSede);
	}

}
