package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AaccEuskadiOrganoGestorDao;
import com.ejie.y41b.model.AaccEuskadiOrganoGestor;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AaccServiceImpl  
 * 
 *  
 */

@Service(value = "aaccEuskadiOrganoGestorService")
public class AaccEuskadiOrganoGestorServiceImpl implements AaccEuskadiOrganoGestorService {

	@Autowired()
	private AaccEuskadiOrganoGestorDao aaccEuskadiOrganoGestorDao;

	/**
	 * Finds a List of rows in the AaccEuskadiOrganoGestor table.
	 *
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiOrganoGestor> findAll(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor,
			Pagination pagination) {
		return (List<AaccEuskadiOrganoGestor>) this.aaccEuskadiOrganoGestorDao.findAll(aaccEuskadiOrganoGestor,
				pagination);
	}

	/**
	 * Counts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		return this.aaccEuskadiOrganoGestorDao.findAllCount(aaccEuskadiOrganoGestor);
	}

	/**
	 * Inserts a single row in the AaccEuskadiOrganoGestor table.
	 *
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return AaccEuskadiOrganoGestor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadiOrganoGestor addTemp(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		aaccEuskadiOrganoGestor.setOgId(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		this.aaccEuskadiOrganoGestorDao.addTemp(aaccEuskadiOrganoGestor);
		return aaccEuskadiOrganoGestor;
	}

	/**
	 * Deletes a single row in the AaccEuskadiOrganoGestor table.
	 * 
	 * @param aaccEuskadiOrganoGestor
	 *            AaccEuskadiOrganoGestor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AaccEuskadiOrganoGestor aaccEuskadiOrganoGestor) {
		this.aaccEuskadiOrganoGestorDao.remove(aaccEuskadiOrganoGestor);
	}

}
