package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AaccEuskadiFederacionDao;
import com.ejie.y41b.dao.AaccEuskadiSedeDao;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.AaccEuskadiFederacion;
import com.ejie.y41b.model.AaccEuskadiSede;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AaccServiceImpl  
 * 
 *  
 */

@Service(value = "aaccEuskadiFederacionService")
public class AaccEuskadiFederacionServiceImpl implements AaccEuskadiFederacionService {

	@Autowired()
	private AaccEuskadiFederacionDao aaccEuskadiFederacionDao;

	// /**
	// * Inserts rows in the AaccEuskadiFederacion table.
	// *
	// * @param codOrgFederacion
	// * String
	// * @param codOrgAsocOCop
	// * String
	// * @return void
	// */
	// @Transactional(rollbackFor = Throwable.class)
	// public void addMiembroFederacion(String codOrgFederacion, String
	// codOrgAsocOCop) {
	// this.aaccEuskadiFederacionDao.addMiembroFederacion(codOrgFederacion,
	// codOrgAsocOCop);
	// }

	/**
	 * Inserts rows in the AaccEuskadiFederacion table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @return AaccEuskadiFederacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadiFederacion addTemp(AaccEuskadiFederacion aaccEuskadiFederacion) {
		return this.aaccEuskadiFederacionDao.addTemp(aaccEuskadiFederacion);
	}

	/**
	 * Finds a List of rows in the AaccEuskadiFederacion table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiFederacion> findAll(AaccEuskadiFederacion aaccEuskadiFederacion, Pagination pagination) {
		return (List<AaccEuskadiFederacion>) this.aaccEuskadiFederacionDao.findAll(aaccEuskadiFederacion, pagination);
	}

	/**
	 * Counts rows in the AaccEuskadiFederacion table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadiFederacion aaccEuskadiFederacion) {
		return this.aaccEuskadiFederacionDao.findAllCount(aaccEuskadiFederacion);
	}

	/**
	 * Counts rows in the AaccEuskadiFederacion table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @return Long
	 */
	public Long existeCount(AaccEuskadiFederacion aaccEuskadiFederacion) {
		return this.aaccEuskadiFederacionDao.existeCount(aaccEuskadiFederacion);
	}

	/**
	 * Deletes a single row in the AaccEuskadiFederacion table.
	 * 
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AaccEuskadiFederacion aaccEuskadiFederacion) {
		this.aaccEuskadiFederacionDao.remove(aaccEuskadiFederacion);
	}

	/**
	 * Counts rows in the AaccEuskadiFederacion table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @return Long
	 */
	public Long findAllFederacionesCount(AaccEuskadiFederacion aaccEuskadiFederacion) {
		return this.aaccEuskadiFederacionDao.findAllFederacionesCount(aaccEuskadiFederacion);
	}

	/**
	 * Finds a List of rows in the AaccEuskadiFederacion table.
	 *
	 * @param aaccEuskadiFederacion
	 *            AaccEuskadiFederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiFederacion> findAllFederaciones(AaccEuskadiFederacion aaccEuskadiFederacion,
			Pagination pagination) {
		return (List<AaccEuskadiFederacion>) this.aaccEuskadiFederacionDao.findAllFederaciones(aaccEuskadiFederacion,
				pagination);
	}

}
