package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AaccEuskadiCuotaDao;
import com.ejie.y41b.model.AaccEuskadiCuota;
import com.ejie.y41b.model.AaccEuskadiOrganoGestor;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * AaccServiceImpl  
 * 
 *  
 */

@Service(value = "aaccEuskadiCuotaService")
public class AaccEuskadiCuotaServiceImpl implements AaccEuskadiCuotaService {

	@Autowired()
	private AaccEuskadiCuotaDao aaccEuskadiCuotaDao;

	/**
	 * Finds a List of rows in the AaccEuskadiCuota table.
	 *
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiCuota> findAll(AaccEuskadiCuota aaccEuskadiCuota, Pagination pagination) {
		return (List<AaccEuskadiCuota>) this.aaccEuskadiCuotaDao.findAll(aaccEuskadiCuota, pagination);
	}

	/**
	 * Counts rows in the AaccEuskadiCuota table.
	 *
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadiCuota aaccEuskadiCuota) {
		return this.aaccEuskadiCuotaDao.findAllCount(aaccEuskadiCuota);
	}

	/**
	 * Inserts a single row in the AaccEuskadiCuota table.
	 *
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return AaccEuskadiCuota
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadiCuota addTemp(AaccEuskadiCuota aaccEuskadiCuota) {
		aaccEuskadiCuota.setCuId(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		this.aaccEuskadiCuotaDao.addTemp(aaccEuskadiCuota);
		return aaccEuskadiCuota;
	}

	/**
	 * Deletes a single row in the AaccEuskadiCuota table.
	 * 
	 * @param aaccEuskadiCuota
	 *            AaccEuskadiCuota
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AaccEuskadiCuota aaccEuskadiCuota) {
		this.aaccEuskadiCuotaDao.remove(aaccEuskadiCuota);
	}
}
