package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.AaccEuskadiConfederacionDao;
import com.ejie.y41b.model.AaccEuskadiConfederacion;
import com.ejie.y41b.model.AaccEuskadiFederacion;

/**
 * AaccServiceImpl  
 * 
 *  
 */

@Service(value = "aaccEuskadiConfederacionService")
public class AaccEuskadiConfederacionServiceImpl implements AaccEuskadiConfederacionService {

	@Autowired()
	private AaccEuskadiConfederacionDao aaccEuskadiConfederacionDao;

	/**
	 * Inserts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return AaccEuskadiConfederacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AaccEuskadiConfederacion addTemp(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		return this.aaccEuskadiConfederacionDao.addTemp(aaccEuskadiConfederacion);
	}

	/**
	 * Finds a List of rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiConfederacion> findAll(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination) {
		return (List<AaccEuskadiConfederacion>) this.aaccEuskadiConfederacionDao.findAll(aaccEuskadiConfederacion,
				pagination);
	}

	/**
	 * Counts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return Long
	 */
	public Long findAllCount(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		return this.aaccEuskadiConfederacionDao.findAllCount(aaccEuskadiConfederacion);
	}

	/**
	 * Counts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return Long
	 */
	public Long existeCount(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		return this.aaccEuskadiConfederacionDao.existeCount(aaccEuskadiConfederacion);
	}

	/**
	 * Deletes a single row in the AaccEuskadiConfederacion table.
	 * 
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		this.aaccEuskadiConfederacionDao.remove(aaccEuskadiConfederacion);
	}

	/**
	 * Counts rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @return Long
	 */
	public Long findAllConfederacionesCount(AaccEuskadiConfederacion aaccEuskadiConfederacion) {
		return this.aaccEuskadiConfederacionDao.findAllConfederacionesCount(aaccEuskadiConfederacion);
	}

	/**
	 * Finds a List of rows in the AaccEuskadiConfederacion table.
	 *
	 * @param aaccEuskadiConfederacion
	 *            AaccEuskadiConfederacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AaccEuskadiConfederacion> findAllConfederaciones(AaccEuskadiConfederacion aaccEuskadiConfederacion,
			Pagination pagination) {
		return (List<AaccEuskadiConfederacion>) this.aaccEuskadiConfederacionDao
				.findAllConfederaciones(aaccEuskadiConfederacion, pagination);
	}
}
