package com.ejie.y41b.security;

import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import n38c.exe.N38API;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.w3c.dom.Document;

import com.ejie.x38.security.XlnetCore;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

public class PreAuthenticateProcessingFilter extends
		com.ejie.x38.security.PreAuthenticateProcessingFilter {

	@Autowired
	private CensoMonitorService censoMonitorService;

	@Resource
	private ReloadableResourceBundleMessageSource messageSource;

	@Autowired
	private CookieLocaleResolver localeResolver;

	private Locale currentLanguage;

	private static final Logger logger = LoggerFactory
			.getLogger(PreAuthenticateProcessingFilter.class);

	protected synchronized Object getPreAuthenticatedPrincipal(
			HttpServletRequest httpRequest) {
		Object object = super.getPreAuthenticatedPrincipal(httpRequest);
		if (object != null) {
			try {
				if (super.getPerimetralSecurityWrapper() != null) {
					if (httpRequest.getSession().getAttribute(
							Y41bConstantes.SESSIONCENSOMONITORCONNECTED) == null) {
						String username = super.getPerimetralSecurityWrapper()
								.getUserConnectedUserName(httpRequest);

						String nif = "";

						boolean isCertificate = super
								.getPerimetralSecurityWrapper()
								.getIsCertificate(httpRequest);

						logger.info("######################################isCertificate["
								+ isCertificate + "]");

						N38API n38Api = XlnetCore.getN38API(httpRequest);
						if (!isCertificate) {
							nif = super.getPerimetralSecurityWrapper().getNif(
									httpRequest);
							if (nif != null
									&& nif.length() == Y41bConstantes.NUM_8
									&& Y41bUtils.isNumeric(nif)) {
								nif = new StringBuffer(nif).append(
										Y41bUtils.calcularLetraNIF(nif))
										.toString();
							}
						} else {
							Document xmlSesion = null;
							xmlSesion = XlnetCore.getN38ItemSesion(n38Api);

							HashMap userInfo = XlnetCore
									.getN38SubjectCert(xmlSesion);
							nif = (String) userInfo.get("SERIALNUMBER");
							logger.info("######################################nif["
									+ nif + "]");

						}

						String puestoDelUsuario = "";
						try {
							String[] personaPuestoUids = n38Api
									.n38ItemSesion("n38puestouid");
							if ((personaPuestoUids != null)
									&& (personaPuestoUids.length > 0)) {
								logger.info("######################################n38puestouid["
										+ personaPuestoUids[0] + "]");
								puestoDelUsuario = personaPuestoUids[0];
							}
						} catch (Throwable ex) {
							puestoDelUsuario = "Y41BU001";
						}

						HashMap<String, String> userData = super
								.getPerimetralSecurityWrapper()
								.getUserDataInfo(httpRequest, isCertificate);
						String fullName = userData.get("fullName");

						Vector<String> perfiles = (Vector) super
								.getPerimetralSecurityWrapper()
								.getUserInstances(httpRequest);

						if (perfiles != null
								&& !perfiles
										.contains(Y41bConstantes.ROLE_XLNET_APLICACION)) {
							throw new AccessDeniedException("");
						}

						if (username != null
								&& username.equals("udaAnonymousUser")) {
							return null;
						}
						CensoMonitor censoMonitor = new CensoMonitor();
						censoMonitor.setUsuarioxlnet(username);
						censoMonitor.setPuestoxlnet(puestoDelUsuario);
						censoMonitor.setMonombre(fullName);
						censoMonitor.setModni(nif);

						try {
							censoMonitor = censoMonitorService
									.getAutorizacionKonbide(censoMonitor);
							httpRequest
									.getSession()
									.setAttribute(
											Y41bConstantes.SESSIONCENSOMONITORCONNECTED,
											censoMonitor);
							httpRequest
									.getSession()
									.setAttribute(
											Y41bConstantes.SESSIONFULLNAMECENSOMONITORCONNECTED,
											fullName);
							CensoMonitorThreadLocal.set(censoMonitor);

							censoMonitorService.comprobarActualizacionAa66();
						} catch (Y41bUDAException e) {
							this.currentLanguage = localeResolver
									.resolveLocale(httpRequest);
							httpRequest
									.getSession()
									.setAttribute(
											Y41bConstantes.SESSIONLOGINERROR,
											messageSource
													.getMessage(
															"error.censomonitor.errorUsuarioActivo",
															null,
															this.currentLanguage));
							throw new AccessDeniedException("");

						}

					}
				}
			} catch (EmptyResultDataAccessException e) {
				throw new AccessDeniedException("");
			} catch (Throwable ex) {
				throw new AccessDeniedException("");
			}
		}
		return object;
	}
}
