package com.ejie.y41b.security;

import com.ejie.y41b.model.CensoMonitor;

/**
 * Thread local para guardado de datos de usuario identificado en el sistema.
 * 
 *  
 * 
 */
public class CensoMonitorThreadLocal {

	/**
	 * Constructor.
	 */
	private CensoMonitorThreadLocal() {
	}

	public static final ThreadLocal<CensoMonitor> userThreadLocal = new ThreadLocal<CensoMonitor>();

	/**
	 * Guardado de los datos de usuario conectado
	 * 
	 * @param CensoMonitor
	 *            monitor
	 */
	public static void set(CensoMonitor CensoMonitor) {
		CensoMonitorThreadLocal.userThreadLocal.set(CensoMonitor);
	}

	/**
	 * Borrado de los datos de usuario conectado
	 */
	public static void unset() {
		CensoMonitorThreadLocal.userThreadLocal.remove();
	}

	/**
	 * Obtencion de los datos de usuario conectado
	 * 
	 * @return monitor
	 */
	public static CensoMonitor get() {
		return CensoMonitorThreadLocal.userThreadLocal.get();
	}
}
