package com.ejie.y41b.report.model.listadonotificaciones;

import java.io.InputStream;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;

/**
 * * NotificacionReport  
 * 
 *  
 */

public class NotificacionReport implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String numNotificacion;
	private String numExpediente;
	private String nombre;
	private String direccion1;
	private String direccion2;
	private InputStream codigoBarras;

	/**
	 * Method 'NotificacionReport'.
	 * 
	 */
	public NotificacionReport() {
	}

	/**
	 * Method 'NotificacionReport'.
	 * 
	 */
	public NotificacionReport(NotificacionesComunicacionesBusqueda notificacion) {
		if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(notificacion
				.getRmtipoExpediente())) {
			this.numExpediente = Y41bConstantes.TIPO_PROC_SANCIONES + "-"
					+ notificacion.getDecoor() + "-" + notificacion.getDenror()
					+ "-" + notificacion.getDenran();
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(notificacion
				.getRmtipoExpediente())) {
			this.numExpediente = Y41bConstantes.TIPO_PROC_INSPECCIONES + "-"
					+ notificacion.getDecoor() + "-" + notificacion.getDenran()
					+ "-" + notificacion.getDenror() + "-"
					+ notificacion.getHdnror();
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(notificacion
				.getRmtipoExpediente())) {
			this.numExpediente = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA + "-"
					+ notificacion.getDecoor() + "-" + notificacion.getDenror()
					+ "-" + notificacion.getDenran();
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(notificacion
				.getRmtipoExpediente())) {
			this.numExpediente = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA + "-"
					+ notificacion.getDecoor() + "-" + notificacion.getDenror()
					+ "-" + notificacion.getDenran();
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(notificacion
				.getRmtipoExpediente())) {
			this.numExpediente = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD + "-"
					+ notificacion.getDecoor() + "-" + notificacion.getDenror()
					+ "-" + notificacion.getDenran();
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(notificacion
				.getRmtipoExpediente())) {
			this.numExpediente = Y41bConstantes.TIPO_PROC_ARBITRAJE + "-"
					+ notificacion.getDecoor() + "-" + notificacion.getDenror()
					+ "-" + notificacion.getDenran();
		} else {
			this.numExpediente = Y41bConstantes.TIPO_PROC_SOLICITUDES + "-"
					+ notificacion.getDecoor() + "-" + notificacion.getDenran()
					+ "-" + notificacion.getDenror() + "-"
					+ notificacion.getHdnror();
		}
		this.nombre = notificacion.getNombreDestinatario();
		this.direccion1 = notificacion.getDireccion1();
		this.direccion2 = notificacion.getDireccion2();
		this.codigoBarras = notificacion.getCodigoBarras();

	}

	/**
	 * @return the numNotificacion
	 */
	public String getNumNotificacion() {
		return numNotificacion;
	}

	/**
	 * @param numNotificacion
	 *            the numNotificacion to set
	 */
	public void setNumNotificacion(String numNotificacion) {
		this.numNotificacion = numNotificacion;
	}

	/**
	 * @return the numExpediente
	 */
	public String getNumExpediente() {
		return numExpediente;
	}

	/**
	 * @param numExpediente
	 *            the numExpediente to set
	 */
	public void setNumExpediente(String numExpediente) {
		this.numExpediente = numExpediente;
	}

	/**
	 * @return the nombre
	 */
	public String getNombre() {
		return nombre;
	}

	/**
	 * @param nombre
	 *            the nombre to set
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * @return the direccion
	 */
	public String getDireccion1() {
		return direccion1;
	}

	/**
	 * @param direccion
	 *            the direccion to set
	 */
	public void setDireccion1(String direccion1) {
		this.direccion1 = direccion1;
	}

	/**
	 * @return the direccion2
	 */
	public String getDireccion2() {
		return direccion2;
	}

	/**
	 * @param direccion2
	 *            the direccion2 to set
	 */
	public void setDireccion2(String direccion2) {
		this.direccion2 = direccion2;
	}

	/**
	 * @return the codigoBarras
	 */
	public InputStream getCodigoBarras() {
		return codigoBarras;
	}

	/**
	 * @param codigoBarras
	 *            the codigoBarras to set
	 */
	public void setCodigoBarras(InputStream codigoBarras) {
		this.codigoBarras = codigoBarras;
	}

}
