package com.ejie.y41b.report.model.listadonotificaciones;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.commons.lang.StringUtils;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.utils.config.Y41bConfig;

/**
 * * ListadoNotificacionesReport  
 * 
 *  
 */

public class ListadoNotificacionesReport implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String fecha;
	private String numRemesa;
	private String nombreOrganico;
	private String logoCabecera;
	private String logoPie;
	private List<NotificacionReport> notificaciones = new ArrayList<NotificacionReport>();

	/**
	 * Method 'Actuacion'.
	 * 
	 */
	public ListadoNotificacionesReport() {
	}

	/**
	 * Method 'Actuacion'.
	 * 
	 */
	public ListadoNotificacionesReport(Remesa remesa,
			List<NotificacionesComunicacionesBusqueda> notificaciones) {
		this.fecha = new SimpleDateFormat("dd/MM/yyyy").format(remesa
				.getRmfechageneracion());
		this.numRemesa = remesa.getRmcodigo();
		this.nombreOrganico = remesa.getRmnombremonitor();

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// SE especifica la ruta temporal de las remesas
		String strTmpRemesasImgRepot = prop
				.getProperty("URL_IMAGENES_REPORT_LISTADO");

		this.logoCabecera = strTmpRemesasImgRepot
				+ "y41b-logo-kontsumo-report.png";
		this.logoPie = strTmpRemesasImgRepot + "y41b-logo-gv-report.png";

		int contador = 1;
		for (NotificacionesComunicacionesBusqueda notificacion : notificaciones) {
			NotificacionReport notificiacionReport = new NotificacionReport(
					notificacion);
			notificiacionReport.setNumNotificacion(StringUtils.leftPad(""
					+ contador, Y41bConstantes.NUM_3, "0")
					+ "/" + notificaciones.size());
			this.notificaciones.add(notificiacionReport);
			contador++;
		}

	}

	/**
	 * @return the fecha
	 */
	public String getFecha() {
		return fecha;
	}

	/**
	 * @param fecha
	 *            the fecha to set
	 */
	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	/**
	 * @return the numRemesa
	 */
	public String getNumRemesa() {
		return numRemesa;
	}

	/**
	 * @param numRemesa
	 *            the numRemesa to set
	 */
	public void setNumRemesa(String numRemesa) {
		this.numRemesa = numRemesa;
	}

	/**
	 * @return the notificaciones
	 */
	public List<NotificacionReport> getNotificaciones() {
		return notificaciones;
	}

	/**
	 * @param notificaciones
	 *            the notificaciones to set
	 */
	public void setNotificaciones(List<NotificacionReport> notificaciones) {
		this.notificaciones = notificaciones;
	}

	/**
	 * @return the nombreOrganico
	 */
	public String getNombreOrganico() {
		return nombreOrganico;
	}

	/**
	 * @param nombreOrganico
	 *            the nombreOrganico to set
	 */
	public void setNombreOrganico(String nombreOrganico) {
		this.nombreOrganico = nombreOrganico;
	}

	/**
	 * @return the logoCabecera
	 */
	public String getLogoCabecera() {
		return logoCabecera;
	}

	/**
	 * @param logoCabecera
	 *            the logoCabecera to set
	 */
	public void setLogoCabecera(String logoCabecera) {
		this.logoCabecera = logoCabecera;
	}

	/**
	 * @return the logoPie
	 */
	public String getLogoPie() {
		return logoPie;
	}

	/**
	 * @param logoPie
	 *            the logoPie to set
	 */
	public void setLogoPie(String logoPie) {
		this.logoPie = logoPie;
	}

	public static ArrayList<ListadoNotificacionesReport> getListadoNotificacionesReport() {

		ArrayList<ListadoNotificacionesReport> listListadoNotificacionesReport = new ArrayList<ListadoNotificacionesReport>();

		ListadoNotificacionesReport listadoNotificacionesReport = new ListadoNotificacionesReport();
		listadoNotificacionesReport.setFecha("15/10/2014");
		listadoNotificacionesReport.setNumRemesa("2014-0032");
		listadoNotificacionesReport.setNombreOrganico("ANA ARMENTIA");
		listadoNotificacionesReport
				.setLogoCabecera("C:\\aplic\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\images\\y41b-logo-kontsumo-report.png");
		listadoNotificacionesReport
				.setLogoPie("C:\\aplic\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\images\\y41b-logo-gv-report.png");

		// TODO Crear carpeta con el id de remesa
		// Properties prop =
		// Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// // SE especifica la ruta temporal de las remesas
		// String strTmpRemesasImgRepot = prop
		// .getProperty("URL_IMAGENES_REPORT_LISTADO");
		//
		// listadoNotificacionesReport.setLogoCabecera(strTmpRemesasImgRepot
		// + "y41b-logo-kontsumo-report.png");
		// listadoNotificacionesReport.setLogoPie(strTmpRemesasImgRepot
		// + "y41b-logo-gv-report.png");

		NotificacionReport notificacionReport1 = new NotificacionReport();
		notificacionReport1.setNumNotificacion("001/6");
		notificacionReport1.setNumExpediente("01A001 995 2014 1");
		notificacionReport1.setDireccion1("Gran Vía, 1");
		notificacionReport1.setDireccion2("48001 - BILBAO");
		notificacionReport1.setNombre("BBVA, S.A.");

		NotificacionReport notificacionReport2 = new NotificacionReport();
		notificacionReport2.setNumNotificacion("002/6");
		notificacionReport2.setNumExpediente("01A001 2125 2013 1");
		notificacionReport2.setDireccion1("Plaza de los Fueros, 1");
		notificacionReport2.setDireccion2("31003 - PAMPLONA");
		notificacionReport2.setNombre("CAJA RURAL DE NAVARRA, S. COOP.");

		NotificacionReport notificacionReport3 = new NotificacionReport();
		notificacionReport3.setNumNotificacion("003/6");
		notificacionReport3.setNumExpediente("01A001 1148 2014 1");
		notificacionReport3.setDireccion1("Avenida de América, 115");
		notificacionReport3.setDireccion2("28042 - MADRID");
		notificacionReport3.setNombre("VODAFONE ESPAÑA, S.A.U.");

		List<NotificacionReport> listNotificacionReport = new ArrayList<NotificacionReport>();
		listNotificacionReport.add(notificacionReport1);
		listNotificacionReport.add(notificacionReport2);
		listNotificacionReport.add(notificacionReport3);

		listadoNotificacionesReport.setNotificaciones(listNotificacionReport);

		listListadoNotificacionesReport.add(listadoNotificacionesReport);

		return listListadoNotificacionesReport;
	}
}
