package com.ejie.y41b.report;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.model.RemesaDocumentos;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;

/**
 * <p>
 * Titulo: Y41bReportGeneratorServiceImpl
 * </p>
 * <p>
 * Descipcion: Genera Reports con Tecnología JasperReport
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "Y41bReportMergeServiceImpl")
public class Y41bReportMergeServiceImpl implements Y41bReportMergeService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(Y41bReportMergeServiceImpl.class);

	/**
	 * Metodo concatena Pdf con Itext
	 * 
	 * @param listaPdfs
	 *            Pdfs de la remesa
	 * @param outputStream
	 *            OutputStream
	 * @param paginate
	 *            boolean
	 */
	public void concatDocumentosPDFs(List<RemesaDocumentos> listaPdfs,
			OutputStream outputStream, boolean paginate) {
		Y41bReportMergeServiceImpl.logger
				.info("Y41bReportMergeServiceImpl - concatPdf: INICIO");

		Document document = new Document();

		try {
			List<RemesaDocumentos> pdfs = listaPdfs;
			// pdfs = streamOfPDFFiles;
			List<PdfReader> readers = new ArrayList<PdfReader>();
			int totalPages = 0;
			Iterator<RemesaDocumentos> iteratorPDFs = pdfs.iterator();

			// Create Readers for the pdfs.
			while (iteratorPDFs.hasNext()) {
				RemesaDocumentos pdf = iteratorPDFs.next();
				PdfReader pdfReader = new PdfReader(pdf.getDocumento());
				readers.add(pdfReader);
				totalPages += pdfReader.getNumberOfPages();
			}
			// Create a writer for the outputstream
			PdfWriter writer = PdfWriter.getInstance(document, outputStream);

			document.open();
			BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA,
					BaseFont.CP1252, BaseFont.NOT_EMBEDDED);
			PdfContentByte cb = writer.getDirectContent(); // Holds the PDF
			// data

			PdfImportedPage page;
			int currentPageNumber = 0;
			int pageOfCurrentReaderPDF = 0;
			Iterator<PdfReader> iteratorPDFReader = readers.iterator();

			// Loop through the PDF files and add to the output.
			while (iteratorPDFReader.hasNext()) {
				PdfReader pdfReader = iteratorPDFReader.next();
				// Create a new page in the target for each source page.
				while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
					Rectangle r = pdfReader.getPageSize(pdfReader
							.getPageN(pageOfCurrentReaderPDF + 1));

					document.setPageSize(PageSize.A4);

					document.newPage();
					pageOfCurrentReaderPDF++;
					currentPageNumber++;

					page = writer.getImportedPage(pdfReader,
							pageOfCurrentReaderPDF);
					if (r.getWidth() > r.getHeight()) {
						cb.addTemplate(page, 0, 1f, -1f, 0,
								PageSize.A4.getWidth(), 0);
					} else {
						cb.addTemplate(page, 0, 0);
					}

					// Code for pagination.
					if (paginate) {
						cb.beginText();
						cb.setFontAndSize(bf, 9);
						cb.showTextAligned(PdfContentByte.ALIGN_CENTER, ""
								+ currentPageNumber + " of " + totalPages, 520,
								5, 0);
						cb.endText();
					}
				}

				if (pdfReader.getNumberOfPages() % 2 == 0) {
					// Son paginas pares
				} else {
					// Si el numero de paginas no es par se pone una pagina
					// en blanco
					document.newPage();
					writer.setPageEmpty(false);
					pageOfCurrentReaderPDF++;
					currentPageNumber++;
				}

				pageOfCurrentReaderPDF = 0;
				pdfReader.close();
			}

			if (document.isOpen()) {
				document.close();
			}
			writer.close();
			Y41bReportMergeServiceImpl.logger
					.info("Y41bReportMergeServiceImpl - concatPdf: Finished");
		} catch (Exception e_merge) {
			logger.error("Y41bReportGeneratorServiceImpl.generate", e_merge);
			throw new Y41bUDAException("error.generico", true, e_merge);
		} finally {
			if (document.isOpen())
				document.close();

		}
	}

	/**
	 * Metodo concatena Pdf con Itext
	 * 
	 * @param listaPdfs
	 *            Pdfs de la remesa
	 * @param outputStream
	 *            OutputStream
	 * @param paginate
	 *            boolean
	 */
	public void concatAcusePDFs(List<InputStream> listaPdfs,
			OutputStream outputStream, boolean paginate) {
		Y41bReportMergeServiceImpl.logger
				.info("Y41bReportMergeServiceImpl - concatPdf: INICIO");

		Document document = new Document();

		try {
			List<InputStream> pdfs = listaPdfs;
			// pdfs = streamOfPDFFiles;
			List<PdfReader> readers = new ArrayList<PdfReader>();
			int totalPages = 0;
			Iterator<InputStream> iteratorPDFs = pdfs.iterator();

			// Create Readers for the pdfs.
			while (iteratorPDFs.hasNext()) {
				InputStream pdf = iteratorPDFs.next();
				PdfReader pdfReader = new PdfReader(pdf);
				readers.add(pdfReader);
				totalPages += pdfReader.getNumberOfPages();
				pdf.close();
			}
			// Create a writer for the outputstream
			PdfWriter writer = PdfWriter.getInstance(document, outputStream);

			document.open();
			BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA,
					BaseFont.CP1252, BaseFont.NOT_EMBEDDED);
			PdfContentByte cb = writer.getDirectContent(); // Holds the PDF
			// data

			PdfImportedPage page;
			int currentPageNumber = 0;
			int pageOfCurrentReaderPDF = 0;
			Iterator<PdfReader> iteratorPDFReader = readers.iterator();

			// Loop through the PDF files and add to the output.
			while (iteratorPDFReader.hasNext()) {
				PdfReader pdfReader = iteratorPDFReader.next();
				// Create a new page in the target for each source page.
				while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
					Rectangle r = pdfReader.getPageSize(pdfReader
							.getPageN(pageOfCurrentReaderPDF + 1));

					document.setPageSize(PageSize.A4);

					document.newPage();
					pageOfCurrentReaderPDF++;
					currentPageNumber++;

					page = writer.getImportedPage(pdfReader,
							pageOfCurrentReaderPDF);
					if (r.getWidth() > r.getHeight()) {
						cb.addTemplate(page, 0, 1f, -1f, 0,
								PageSize.A4.getWidth(), 0);
					} else {
						cb.addTemplate(page, 0, 0);
					}

					// Code for pagination.
					if (paginate) {
						cb.beginText();
						cb.setFontAndSize(bf, 9);
						cb.showTextAligned(PdfContentByte.ALIGN_CENTER, ""
								+ currentPageNumber + " of " + totalPages, 520,
								5, 0);
						cb.endText();
					}
				}
				pageOfCurrentReaderPDF = 0;
				pdfReader.close();
			}

			if (document.isOpen()) {
				document.close();
			}
			writer.close();
			Y41bReportMergeServiceImpl.logger
					.info("Y41bReportMergeServiceImpl - concatPdf: Finished");
		} catch (Exception e_merge) {
			logger.error("Y41bReportGeneratorServiceImpl.generate", e_merge);
			throw new Y41bUDAException("error.generico", true, e_merge);
		} finally {
			if (document.isOpen())
				document.close();

		}
	}
}
