package com.ejie.y41b.report;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * <p>
 * Titulo: Y41bReportGeneratorServiceImpl
 * </p>
 * <p>
 * Descipcion: Genera Reports con Tecnología JasperReport
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "Y41bReportGeneratorServiceImpl")
public class Y41bReportGeneratorServiceImpl implements
		Y41bReportGeneratorService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(Y41bReportGeneratorServiceImpl.class);

	/**
	 * Metodo genera un documento con JasperReport
	 * 
	 * @param template
	 *            Plantilla de Jasper recibida como InputStream
	 * @param data
	 *            Mapa con datos a introducir en la plantilla
	 * @param out
	 *            OutputStream que representa la salida del documento resultante
	 */
	public void generate(InputStream template, Map<String, Object> data,
			OutputStream out) {
		this.logger.info("Y41bReportGeneratorServiceImpl.generate - Inicio");
		try {
			JasperReport jasperReport = JasperCompileManager
					.compileReport(template);

			JRDataSource jrxmlds = new JREmptyDataSource();
			JasperPrint jasperPrint = JasperFillManager.fillReport(
					jasperReport, data, jrxmlds);
			JRExporter exporter = new JRPdfExporter();
			exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
			exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, out);
			exporter.exportReport();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_generate) {
			logger.error("Y41bReportGeneratorServiceImpl.generate", e_generate);
			throw new Y41bUDAException("error.generico", true, e_generate);
		} finally {
			logger.info("Y41bReportGeneratorServiceImpl.generate - Final");
		}
	}

	/**
	 * Metodo genera un documento con JasperReport
	 * 
	 * @param template
	 *            Plantilla de Jasper recibida como InputStream
	 * @param data
	 *            Mapa con datos a introducir en la plantilla
	 * @param out
	 *            OutputStream que representa la salida del documento resultante
	 */
	public void generate(InputStream template, Map<String, Object> data,
			List<?> model, OutputStream out) {
		this.logger.info("Y41bReportGeneratorServiceImpl.generate - Inicio");
		try {
			JasperReport jasperReport = JasperCompileManager
					.compileReport(template);

			// JRDataSource jrxmlds = new JREmptyDataSource();
			JRBeanCollectionDataSource jrxmlds = new JRBeanCollectionDataSource(
					model);

			JasperPrint jasperPrint = JasperFillManager.fillReport(
					jasperReport, data, jrxmlds);
			JRExporter exporter = new JRPdfExporter();
			exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
			exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, out);
			exporter.exportReport();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_generate) {
			e_generate.printStackTrace();
			logger.error("Y41bReportGeneratorServiceImpl.generate", e_generate);
			throw new Y41bUDAException("error.generico", true, e_generate);
		} finally {
			logger.info("Y41bReportGeneratorServiceImpl.generate - Final");
		}
	}

	public static void main(String[] args) throws Exception {
		Y41bReportGeneratorServiceImpl y41bReportGeneratorServiceImpl = new Y41bReportGeneratorServiceImpl();
		Map<String, Object> data = new HashMap<String, Object>();

		// Plantilla de Listado
		// FileOutputStream out = new FileOutputStream(
		// "C:\\aplic\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\SRPL6.pdf");
		// FileInputStream template = new FileInputStream(
		// "C:\\aplic\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\SRPL6.jrxml");
		// ArrayList<ListadoNotificacionesReport>
		// listListadoNotificacionesReport = new
		// ArrayList<ListadoNotificacionesReport>();
		// listListadoNotificacionesReport = ListadoNotificacionesReport
		// .getListadoNotificacionesReport();
		// y41bReportGeneratorServiceImpl.generate(template, data,
		// listListadoNotificacionesReport, out);
		// out.close();

		// Plantilla de Acuses
		// FileOutputStream out2 = new FileOutputStream(
		// "C:\\aplic\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\SRPL5.pdf");
		// FileInputStream template2 = new FileInputStream(
		// "C:\\aplic\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\SRA05.jrxml");
		// data.put("EXPEDIENTE", "01 A001 134 2014 1");
		// data.put("NOMBREDS", "BBVA, S.A.");
		// data.put("DIRECCIONDS", "Gran Vía, 1");
		// data.put("COPODS", "48001");
		// data.put("LOCALIDADS", "BILBAO");
		// data.put("PROVINCDS", "BIZKAIA");
		// data.put("ORNOMBRE", "DELEGACION BIZKAIA");
		// data.put("ORNODIR", "Gran Via, 89");
		// data.put("ORNRCOPO", "48001");
		// data.put("LONOMBREOR", "BIZKAIA");
		// y41bReportGeneratorServiceImpl.generate(template2, data, out2);
		// out2.close();
		// template2.close();

		// Plantilla de Caratula
		FileOutputStream out3 = new FileOutputStream(
				"C:\\aplic_WL11\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\SRACaratula.pdf");
		FileInputStream template3 = new FileInputStream(
				"C:\\aplic_WL11\\y41b\\y41bDatos\\file\\Plantillas\\remesas\\SRACaratula.jrxml");
		data.put("EXPEDIENTE", "01 A001 134 2014 1");
		data.put("NOMBREDS", "BBVA, S.A.");
		data.put("DIRECCIONDS", "Gran Va, 1");
		data.put("COPODS", "48001");
		data.put("LOCALIDADS", "BILBAO");
		data.put("PROVINCDS", "BIZKAIA");
		data.put("REGSALIDA", "2015RTS00010945");
		y41bReportGeneratorServiceImpl.generate(template3, data, out3);
		out3.close();
		template3.close();

	}
}
