package com.ejie.y41b.pasarela;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

import p12d.exe.pasarelapagos.services.P12DPaymentFactoryAPI;
import p12d.exe.pasarelapagos.services.P12DPaymentManagerAPI;
import p12f.exe.pasarelapagos.objects.DatoAdicional;
import p12f.exe.pasarelapagos.objects.DatosPago;
import p12f.exe.pasarelapagos.objects.Emisor;
import p12f.exe.pasarelapagos.objects.Expediente;
import p12f.exe.pasarelapagos.objects.Imagen;
import p12f.exe.pasarelapagos.objects.Mensaje;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.Tercero;
import p12f.exe.pasarelapagos.objects.Url;
import p12f.exe.pasarelapagos.paymentrequest.Aplicacion;
import p12f.exe.pasarelapagos.paymentrequest.Backend;
import p12f.exe.pasarelapagos.paymentrequest.BackendData;
import p12f.exe.pasarelapagos.paymentrequest.ConceptoPeticion;
import p12f.exe.pasarelapagos.paymentrequest.PaymentGatewayData;
import p12f.exe.pasarelapagos.paymentrequest.PaymentMode;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.paymentrequest.PresentationRequestData;

import com.ejie.cp.xml.ProcedureDocument.Procedure;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.xml.Y41bXMLUtils;
import com.ejie.y41b.model.pasarela.ConceptosPago;
import com.ejie.y41b.model.pasarela.ConstPasarela;
import com.ejie.y41b.model.pasarela.ObjPasarela;

/**
 * Clase de conexion con la pasarela de pagos
 * 
 *  
 */

public class Pasarela {

	private static final Logger logger = LoggerFactory.getLogger(Pasarela.class);

	private static final Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
	private static final String APLICACION_PRESUPUESTARIA = "aplicPresupuestaria";
	private static final String TERRITORIO_APLICACION_PRESUPUESTARIA = "territorioAplicacionPresupuestaria";
	private static final String ELEMENTO_PEP = "elementoPEP";
	private static final String CODIGO_INGRESO = "codigoIngreso";
	private static final String CONCEPTO_IVA = "conceptoIVA";
	private static final String TERRITORIO_IVA = "territorioIVA";
	private static final String CODIGO_SUBVENCION = "codigoSubvencion";
	private static final String FECHA_REINTEGRO = "fechaReintegro";
	private static final String CAUSA_REINTEGRO = "causaReintegro";

	/**
	 * 
	 * Comentario de constructor Pasarela.
	 */

	public Pasarela() {
		// super();
	}

	/**
	 * Method composePeticionPago Compone una peticion de pago.
	 * 
	 * @param objPasarela
	 *            valores necesarios para pasar a la pasarela
	 * @param procedureCatalog
	 *            Procedure
	 * @param conceptosPagos
	 *            conceptosPagos
	 * @return PeticionPago
	 * @throws IOException
	 *             excepcion
	 * @throws Exception
	 */
	public PeticionPago composePeticionPago(ObjPasarela objPasarela, Procedure procedureCatalog,
			List<ConceptosPago> conceptosPagos) throws IOException, ParseException {

		Pasarela.logger.info("llego al composePeticionPago");

		objPasarela.setFamiliaID(procedureCatalog.getFamilyId());
		objPasarela.setEntidadEmisora(procedureCatalog.getEntityCode());
		// try {
		// objPasarela.setEntidadEmisoraNombCast(Pasarela.prop
		// .getProperty("entidad.ejie.cas"));

		// objDatos.setEntidadEmisoraNombCast("EJIE");
		// } catch (IOException e) {
		// objPasarela.setEntidadEmisoraNombCast(null);
		// }
		// try {
		// objPasarela.setEntidadEmisoraNombEusk(Pasarela.prop
		// .getProperty("entidad.ejie.eus"));
		// objDatos.setEntidadEmisoraNombEusk("EJIE_EU");
		// } catch (IOException e) {
		// objPasarela.setEntidadEmisoraNombEusk(null);
		// }
		// try {
		objPasarela.setCodAplicacion(Y41bConstantes.COD_APLICACION_PASARELA);
		// } catch (IOException e) {
		// objPasarela.setCodAplicacion(null);
		// }
		/*
		 * try { objDatos.setUrlImagenCabecera(prop.getProperty
		 * ("URL_IMAGEN_CABECERA")); } catch (IOException e) {
		 * objDatos.setUrlImagenCabecera(null); } try {
		 * objDatos.setUrlImagenMedio(prop.getProperty ("URL_IMAGEN_MEDIO")); }
		 * catch (IOException e) { objDatos.setUrlImagenMedio(null); }
		 */
		String procedureNameEs = "";
		String procedureNameEu = "";
		if (procedureCatalog.getProcedureName() != null) {
			try {
				String descriptionXML = Y41bXMLUtils.quitarNameSpacesString(procedureCatalog.getProcedureName().copy());
				procedureNameEs = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.CASTELLANO, descriptionXML);
				procedureNameEu = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.EUSKERA, descriptionXML);
			} catch (Exception e) {
				throw new Y41bUDAException("Excepcin en procesamiento nombre procedimiento", false, e);
			}
		}
		objPasarela.setNombreCastAplicacion(procedureNameEs);
		objPasarela.setNombreEuskAplicacion(procedureNameEu);

		// objDatos.setNombreCastAplicacion("PUERTOS");
		// objDatos.setNombreEuskAplicacion("PUERTOS_EU");
		PeticionPago peticionPago = new PeticionPago();

		String tipoPeticion = objPasarela.getTipoDevengo();

		if ("1".equalsIgnoreCase(tipoPeticion)) {
			peticionPago.devengo = PeticionPago.DEVENGO_EMISION;
		} else {
			peticionPago.devengo = PeticionPago.DEVENGO_PAGO;
		}

		/**
		 * **************************************** DATOS PETICION PAGO
		 * *******************************
		 */
		DatosPago datosPeticionPago = new DatosPago();
		datosPeticionPago.formato = objPasarela.getFormato();// "507";
		datosPeticionPago.validar = 1;
		datosPeticionPago.cpr = objPasarela.getCodigoRecaudacion();
		datosPeticionPago.emisor = objPasarela.getEntidadEmisora() + "-" + objPasarela.getSufijo(); // "04833001-502";
		datosPeticionPago.referencia = objPasarela.getReferencia();
		/*
		 * datosPeticionPago.codigo = datosPeticionPago.cpr +
		 * objDatos.getEntidadEmisora() + objDatos.getSufijo() +
		 * datosPeticionPago.referencia;
		 */

		// //
		// emisor
		// -
		// sufijo
		// (obligatorio)

		datosPeticionPago.tipo = objPasarela.getSufijo();

		/**
		 * **************************************** PERIODOS PETICION PAGO
		 * *******************************
		 */
		datosPeticionPago.periodosPago = new HashMap<String, PeriodoPago>();
		PeriodoPago periodoPago = new PeriodoPago();
		periodoPago.id = PeriodoPago.PERIODO_NORMAL;
		periodoPago.identificacion = objPasarela.getFechaLimitePago();

		// periodoPago.fechaFin; // Identificacion
		// del pago en este
		// periodo
		String strImportePeticion = objPasarela.getImporte();

		if (strImportePeticion.indexOf(",") != -1) {
			strImportePeticion = strImportePeticion.replaceAll(",", ".");
		}

		double importe = Double.valueOf(strImportePeticion).doubleValue();

		periodoPago.importe = (long) (Y41bUtils.round2DecimalDouble(importe * Y41bConstantes.NUM_100));
		periodoPago.fechaInicio = objPasarela.getFechaIncioPago();
		periodoPago.fechaFin = objPasarela.getFechaLimitePago();
		periodoPago.activo = true; // Importante si se quiere visualizar.

		Map<String, PeriodoPago> periodosPagoMap = new HashMap<String, PeriodoPago>();
		periodosPagoMap.put(periodoPago.id, periodoPago);
		datosPeticionPago.periodosPago = periodosPagoMap;

		/*********************************
		 ****** CONCEPTOS DE PAGO ********
		 ********************************/
		// Hay que recorrer los conceptos que se envían
		List<ConceptoPeticion> conceptosPeticionPagoList = this.getConceptoPeticion(conceptosPagos, objPasarela);

		/****************************
		 *** FIN CONCEPTOS DE PAGO **
		 *****************************/

		Pasarela.logger.info("llego al Fin conceptos pago");

		/**
		 * ************ DESCRIPCION APLICACION *******************************
		 */
		Aplicacion app = new Aplicacion();
		app.codigo = objPasarela.getCodAplicacion();

		Pasarela.logger.info("Codigo aplicacion ->" + objPasarela.getCodAplicacion() + ".");

		Map<String, Object> nombreApp = new HashMap<String, Object>();

		Pasarela.logger.info("getNombreCastAplicacion ->" + objPasarela.getNombreCastAplicacion() + ".");

		nombreApp.put(Y41bConstantes.CASTELLANO.toLowerCase(), objPasarela.getNombreCastAplicacion());
		nombreApp.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getNombreEuskAplicacion());
		app.nombre = nombreApp;
		app.responsable = objPasarela.getResponsableAplicacion();

		/**
		 * ********* DESCRIPCION EMISOR **************************************
		 */
		Emisor emisor = new Emisor();
		emisor.codigo = objPasarela.getEntidadEmisora(); // + "-" +
		// objDatos.getSufijo();
		// // "04833001-502"; //
		// emisor - sufijo
		// (obligatorio)
		Map<String, String> nombreEmisor = new HashMap<String, String>();
		nombreEmisor.put(Y41bConstantes.CASTELLANO.toLowerCase(), objPasarela.getEntidadEmisoraNombCast());
		nombreEmisor.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getEntidadEmisoraNombEusk());
		emisor.cif = objPasarela.getEntidadEmisora(); // "04833001";
		emisor.nombre = nombreEmisor;
		emisor.municipio = objPasarela.getEntidadEmisoraMunicipio();
		/*
		 * emisor.calle = "Avda. Mediterraneo"; emisor.municipio = "Vitoria";
		 * emisor.territorio = "Alava"; emisor.pais = "Spain";
		 * emisor.codigoPostal = "30000";
		 */

		/**
		 * ********* DESCRIPCION EXPEDIENTE Y TERCERO
		 * **************************************
		 */
		Expediente expediente = new Expediente();
		expediente.codigo = objPasarela.getNumExpFactura();
		expediente.familia = objPasarela.getFamiliaID();

		expediente.tercero = new Tercero();
		expediente.tercero.dniNif = (objPasarela.getDatosTerceroDni() != null
				? objPasarela.getDatosTerceroDni().toUpperCase() : null);
		if (Y41bUtils.isValidNIF(objPasarela.getDatosTerceroDni())) {
			expediente.tercero.tipoTercero = Tercero.TIPO_NIF;
			expediente.tercero.primerApellido = Y41bUtils
					.reemplazarAmpersandPasarela(objPasarela.getDatosTerceroApellido1());
			expediente.tercero.segundoApellido = Y41bUtils
					.reemplazarAmpersandPasarela(objPasarela.getDatosTerceroApellido2());
			expediente.tercero.razonSocial = Y41bUtils.reemplazarAmpersandPasarela(objPasarela.getDatosTerceroNombre());
		} else if (Y41bUtils.isValidCIF(objPasarela.getDatosTerceroDni())) {
			expediente.tercero.tipoTercero = Tercero.TIPO_CIF;
			expediente.tercero.razonSocial = Y41bUtils
					.reemplazarAmpersandPasarela(objPasarela.getDatosTerceroNombreCompleto());
			expediente.tercero.primerApellido = null;
			expediente.tercero.segundoApellido = null;
		} else if (Y41bUtils.isValidNIE(objPasarela.getDatosTerceroDni())) {
			expediente.tercero.tipoTercero = Tercero.TIPO_EXTRANJERO;
			expediente.tercero.primerApellido = Y41bUtils
					.reemplazarAmpersandPasarela(objPasarela.getDatosTerceroApellido1());
			expediente.tercero.segundoApellido = Y41bUtils
					.reemplazarAmpersandPasarela(objPasarela.getDatosTerceroApellido2());
			expediente.tercero.razonSocial = Y41bUtils.reemplazarAmpersandPasarela(objPasarela.getDatosTerceroNombre());
		}

		expediente.tercero.calle = objPasarela.getDatosTerceroDireccion();
		expediente.tercero.municipio = objPasarela.getDatosTerceroMunicipio();
		expediente.tercero.territorio = objPasarela.getDatosTerceroProvincia();
		expediente.tercero.pais = objPasarela.getDatosTerceroPais();
		expediente.tercero.codigoPostal = objPasarela.getDatosTerceroCodigoPostal();

		// lista de datos adicionales
		List<DatoAdicional> datosAdicionalesTercero = new ArrayList<DatoAdicional>();

		DatoAdicional datoAdicional = new DatoAdicional();
		datoAdicional.id = "localidad";
		Map<String, String> descDatoAdicional = new HashMap<String, String>();
		descDatoAdicional.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getDatosTerceroLocalidad());
		descDatoAdicional.put(Y41bConstantes.CASTELLANO.toLowerCase(), objPasarela.getDatosTerceroLocalidad());
		datoAdicional.texto = descDatoAdicional;
		datoAdicional.valor = objPasarela.getDatosTerceroLocalidad();
		datosAdicionalesTercero.add(datoAdicional);

		datoAdicional = new DatoAdicional();
		datoAdicional.id = "NumExpediente";
		descDatoAdicional = new HashMap<String, String>();
		descDatoAdicional.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getDatosTerceroTextoEuskNumExp());
		descDatoAdicional.put(Y41bConstantes.CASTELLANO.toLowerCase(), objPasarela.getDatosTerceroTextoCastNumExp());
		datoAdicional.texto = descDatoAdicional;
		datoAdicional.valor = objPasarela.getNumExpFactura();
		datosAdicionalesTercero.add(datoAdicional);

		// Esto se repite con los datos adicionales que se quiera
		datoAdicional = new DatoAdicional();
		datoAdicional.id = "NumFactura";
		descDatoAdicional = new HashMap<String, String>();
		descDatoAdicional.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getDatosTerceroTextoEuskNumFactura()); // num
		// factura";
		descDatoAdicional.put(Y41bConstantes.CASTELLANO.toLowerCase(),
				objPasarela.getDatosTerceroTextoCastNumFactura()); // num
		// factura";
		datoAdicional.texto = descDatoAdicional;
		datoAdicional.valor = objPasarela.getNumFactura();
		datosAdicionalesTercero.add(datoAdicional);
		// Esto se repite con los datos adicionales que se quiera

		datoAdicional = new DatoAdicional();
		datoAdicional.id = "Telefono";
		descDatoAdicional = new HashMap<String, String>();
		descDatoAdicional.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getDatosTerceroTextoEuskTelefono()); // "Tfnoa.";
		descDatoAdicional.put(Y41bConstantes.CASTELLANO.toLowerCase(), objPasarela.getDatosTerceroTextoCastTelefono()); // "Tfno.";

		datoAdicional.texto = descDatoAdicional;
		datoAdicional.valor = objPasarela.getDatosTerceroTelefono();
		datosAdicionalesTercero.add(datoAdicional); // Esto se repite con los
		// datos adicionales que se
		// quiera
		datoAdicional = new DatoAdicional();
		datoAdicional.id = "E-mail";
		descDatoAdicional = new HashMap<String, String>();
		descDatoAdicional.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getDatosTerceroTextoEuskEmail()); // E-mail";
		descDatoAdicional.put(Y41bConstantes.CASTELLANO.toLowerCase(), objPasarela.getDatosTerceroTextoCastEmail()); // "e-mail";
		datoAdicional.texto = descDatoAdicional;
		datoAdicional.valor = objPasarela.getDatosTerceroEmail();
		datosAdicionalesTercero.add(datoAdicional); // Esto se repite con los
		// datos adicionales que se
		// quiera

		expediente.tercero.datosAdicionales = datosAdicionalesTercero;

		/** ********* DESCRIPCION PAGO ************************************** */
		Map<String, String> descripcionPeticionPago = new HashMap<String, String>();
		descripcionPeticionPago.put(Y41bConstantes.CASTELLANO.toLowerCase(), objPasarela.getCodTasaCast());
		descripcionPeticionPago.put(Y41bConstantes.EUSKERA.toLowerCase(), objPasarela.getCodTasaEusk());

		/** ********* BACKEND DATA ************************************** */
		Backend backEnd = new Backend();
		backEnd.put(new BackendData(BackendData.GASTO_GV, "false"));
		backEnd.put(new BackendData(BackendData.INFORMAR_SIPCA, "true"));
		if (objPasarela.isExentoPago()) {// si true
			backEnd.put(new BackendData(BackendData.EXENTO_PAGO, "true"));
		} else {
			backEnd.put(new BackendData(BackendData.EXENTO_PAGO, "false"));
		}
		backEnd.put(new BackendData(BackendData.EJERCICIO_CONTABLE, objPasarela.getEjercicioContable()));
		peticionPago.backend = backEnd;
		/**
		 * ***************** Imagenes del ******** ********************* PDF
		 * *************
		 */
		Map<String, Imagen> imagenes = new HashMap<String, Imagen>();

		Pasarela.logger.info("************URL IMAGEN CABECERA:" + Pasarela.prop.getProperty("URL_IMAGEN_CABECERA"));

		Imagen imagen1 = new Imagen();
		imagen1.id = "logo1";
		imagen1.url = Pasarela.prop.getProperty("URL_IMAGEN_CABECERA");
		imagenes.put(imagen1.id, imagen1);

		Imagen imagen2 = new Imagen();
		imagen2.id = "logo2";
		imagen2.url = Pasarela.prop.getProperty("URL_IMAGEN_MEDIO");

		imagenes.put(imagen2.id, imagen2);

		peticionPago.liquidacion.imagenes = imagenes;

		/**
		 * ***************** Mensajes del ******** ********************* PDF
		 * *************
		 */
		Map<String, Mensaje> mensajes = new HashMap<String, Mensaje>();
		Map<String, Map<String, String>> listamensajes = objPasarela.getListamensajes();
		if (listamensajes != null) {
			Mensaje mensaje = null;
			for (Map.Entry<String, Map<String, String>> entry : listamensajes.entrySet()) {
				mensaje = new Mensaje();
				mensaje.id = entry.getKey();
				mensaje.texto = entry.getValue();
				mensajes.put(mensaje.id, mensaje);
			}
			peticionPago.liquidacion.mensajes = mensajes;
		}

		// peticionPago.liquidacion.paymentGatewayVersion = "2";
		peticionPago.liquidacion.paymentGatewayVersion = "3";

		peticionPago.liquidacion.urlPlantilla = Pasarela.prop.getProperty("PATH_XSL_PDF");

		peticionPago.id = datosPeticionPago.cpr + datosPeticionPago.emisor + datosPeticionPago.referencia;

		peticionPago.aplicacion = app;

		// peticionPago.mensajes = mensajes;
		peticionPago.datosPago = datosPeticionPago;
		peticionPago.descripcion = descripcionPeticionPago;

		peticionPago.conceptos = conceptosPeticionPagoList;
		peticionPago.emisor = emisor;
		peticionPago.expediente = expediente;

		peticionPago.backend = backEnd;

		Pasarela.logger.info("Fin composePeticionPago");

		return peticionPago;
	}

	/**
	 * Metodo que devuelve la Lista de Concepto peticion
	 * 
	 * @param conceptosPagos
	 *            List<ConceptosPago>
	 * @param objPasarela
	 *            ObjPasarela
	 * @return List<ConceptoPeticion> List<ConceptoPeticion>
	 */
	private List<ConceptoPeticion> getConceptoPeticion(List<ConceptosPago> conceptosPagos, ObjPasarela objPasarela)
			throws ParseException {
		List<ConceptoPeticion> conceptosPeticionPagoList = new ArrayList<ConceptoPeticion>();
		Pasarela.logger.info("NUEVO conceptosPagos.size: " + conceptosPagos.size());
		if (conceptosPagos != null && conceptosPagos.size() > 0) {
			String strTipoIva = objPasarela.getTipoIVA();
			Pasarela.logger.info("strTipoIva: " + strTipoIva);

			if (strTipoIva.indexOf(",") != -1) {
				strTipoIva = strTipoIva.replaceAll(",", ".");
			}
			double tipoIVA = 0;
			try {
				tipoIVA = Double.valueOf(strTipoIva).doubleValue();
			} catch (Exception e) {
				tipoIVA = 0;
			}
			Pasarela.logger.info("tipoIVA: " + tipoIVA);
			if (tipoIVA > 0) {
				conceptosPeticionPagoList = this.getConceptoPeticionIVA(conceptosPagos, objPasarela);
			} else {
				conceptosPeticionPagoList = this.getConceptoPeticionIVAZero(conceptosPagos, objPasarela);
			}
		}

		Pasarela.logger.info("conceptosPeticionPagoList.size: " + conceptosPeticionPagoList.size());

		return conceptosPeticionPagoList;
	}

	/**
	 * Metoso que devuelve la lista de conceptos para la peticion con IVA 0
	 * 
	 * @param conceptosPagos
	 *            List<ConceptosPago>
	 * @param objPasarela
	 *            ObjPasarela
	 * @return List<ConceptoPeticion> ConceptoPeticion
	 */
	private List<ConceptoPeticion> getConceptoPeticionIVAZero(List<ConceptosPago> conceptosPagos,
			ObjPasarela objPasarela) throws ParseException {
		Pasarela.logger.info("getConceptoPeticionIVAZero");
		List<ConceptoPeticion> conceptosPeticionPagoList = new ArrayList<ConceptoPeticion>();
		for (int j = 0; j < conceptosPagos.size(); j++) {
			// Concepto sin IVA o IVA 0
			ConceptoPeticion conceptoPeticion = new ConceptoPeticion(); // NOPMD

			Map<String, String> conceptoPeticionDescripcion = new HashMap<String, String>(); // NOPMD
			Pasarela.logger
					.info("conceptosPagos.get(j).getDescConceptoCas(): " + conceptosPagos.get(j).getDescConceptoCas());
			conceptoPeticionDescripcion.put(Y41bConstantes.CASTELLANO.toLowerCase(),
					conceptosPagos.get(j).getDescConceptoCas());
			conceptoPeticionDescripcion.put(Y41bConstantes.EUSKERA.toLowerCase(),
					conceptosPagos.get(j).getDescConceptoEus());
			conceptoPeticion.descripcion = conceptoPeticionDescripcion;

			String strBaseImponible = objPasarela.getBaseImponible();
			if (strBaseImponible.indexOf(",") != -1) {
				strBaseImponible = strBaseImponible.replaceAll(",", ".");
			}
			// double baseImponible = Double.valueOf(strBaseImponible)
			// .doubleValue();
			double importeConcepto = Double.valueOf(conceptosPagos.get(j).getImporteConcepto()).doubleValue();
			// IMPORTE
			conceptoPeticion.importe = (long) (Y41bUtils.round2DecimalDouble(importeConcepto * Y41bConstantes.NUM_100));

			Map<String, BackendData> conceptoPeticionBackendDataMap = new HashMap<String, BackendData>();// NOPMD
			// Aplicacion presupuestaria
			conceptoPeticionBackendDataMap.put(Pasarela.APLICACION_PRESUPUESTARIA,
					new BackendData(Pasarela.APLICACION_PRESUPUESTARIA, conceptosPagos // NOPMD
							.get(j).getAppPresupuestaria()));
			conceptoPeticionBackendDataMap.put(Pasarela.TERRITORIO_APLICACION_PRESUPUESTARIA,
					new BackendData(Pasarela.TERRITORIO_APLICACION_PRESUPUESTARIA, conceptosPagos // NOPMD
							.get(j).getTerritorioAppPresupuestaria()));
			conceptoPeticionBackendDataMap.put(Pasarela.ELEMENTO_PEP,
					new BackendData(Pasarela.ELEMENTO_PEP, conceptosPagos // NOPMD
							.get(j).getElementoPEP()));
			conceptoPeticionBackendDataMap.put(Pasarela.CODIGO_INGRESO,
					new BackendData(Pasarela.CODIGO_INGRESO, conceptosPagos // NOPMD
							.get(j).getCodigoIngreso()));
			if (Y41bUtils.zeroPad(Y41bConstantes.CONCEPTOPAGO_SIPCA_REINTEGRO_SUBVENCION, Y41bConstantes.NUM_6)
					.equalsIgnoreCase(conceptosPagos.get(j).getCodigoIngreso())) {

				String codigoSubvencion = Y41bConstantes.CODIGO_SUBVENCION_REINTEGRO_SUBVENCION;
				if (!Y41bUtils.esNullOCadenaVacia(objPasarela.getCodsubvencion())) {
					codigoSubvencion = objPasarela.getCodsubvencion();
				}
				conceptoPeticionBackendDataMap.put(Pasarela.CODIGO_SUBVENCION,
						new BackendData(Pasarela.CODIGO_SUBVENCION, codigoSubvencion));

				String fechaReintegro = Y41bUtils.formatearDateToString(Y41bUtils.hoy(),
						Y41bConstantes.FORMATO_FECHA_PASARELA);
				if (!Y41bUtils.esNullOCadenaVacia(objPasarela.getFechareintegro())) {
					fechaReintegro = objPasarela.getFechareintegro();
				}
				conceptoPeticionBackendDataMap.put(Pasarela.FECHA_REINTEGRO,
						new BackendData(Pasarela.FECHA_REINTEGRO, fechaReintegro));

				String causaReintegro = Y41bConstantes.CAUSA_REINTEGRO_REINTEGRO_SUBVENCION;
				if (!Y41bUtils.esNullOCadenaVacia(objPasarela.getCausareintegro())) {
					causaReintegro = objPasarela.getCausareintegro();
				}
				conceptoPeticionBackendDataMap.put(Pasarela.CAUSA_REINTEGRO,
						new BackendData(Pasarela.CAUSA_REINTEGRO, causaReintegro));

				Pasarela.logger.info("Pasarela.CODIGO_SUBVENCION backendDataMap(" + Pasarela.CODIGO_SUBVENCION + "): "
						+ codigoSubvencion);
				Pasarela.logger.info(
						"Pasarela.FECHA_REINTEGRO backendDataMap(" + Pasarela.FECHA_REINTEGRO + "): " + fechaReintegro);
				Pasarela.logger.info(
						"Pasarela.CAUSA_REINTEGRO backendDataMap(" + Pasarela.CAUSA_REINTEGRO + "): " + causaReintegro);
			}
			conceptoPeticion.backendDataMap = conceptoPeticionBackendDataMap;

			conceptoPeticion.numeroLinea = j + 1;
			conceptoPeticion.baseImponible = 0;
			conceptoPeticion.importeIVA = 0;
			conceptoPeticion.unidades = 1;
			conceptoPeticion.IVARepercutido = false;

			conceptosPeticionPagoList.add(conceptoPeticion);
		}
		return conceptosPeticionPagoList;
	}

	/**
	 * Metoso que devuelve la lista de conceptos para la peticion
	 * 
	 * @param conceptosPagos
	 *            List<ConceptosPago>
	 * @param objPasarela
	 *            ObjPasarela
	 * @return List<ConceptoPeticion> ConceptoPeticion
	 */
	private List<ConceptoPeticion> getConceptoPeticionIVA(List<ConceptosPago> conceptosPagos, ObjPasarela objPasarela)
			throws ParseException {
		Pasarela.logger.info("getConceptoPeticionIVA");
		List<ConceptoPeticion> conceptosPeticionPagoList = new ArrayList<ConceptoPeticion>();
		for (int j = 0; j < conceptosPagos.size(); j++) {
			// Concepto sin IVA -- se repetira tantas veces como conceptos
			// tengamos
			ConceptoPeticion conceptoPeticion = new ConceptoPeticion();// NOPMD
			conceptoPeticion.numeroLinea = j + 1; // 1

			Map<String, BackendData> conceptoPeticionBackendDataMap = new HashMap<String, BackendData>();// NOPMD

			/**
			 * Aplicacion
			 */
			conceptoPeticionBackendDataMap.put(Pasarela.APLICACION_PRESUPUESTARIA,
					new BackendData(Pasarela.APLICACION_PRESUPUESTARIA, conceptosPagos // NOPMD
							.get(0).getAppPresupuestaria()));
			conceptoPeticionBackendDataMap.put(Pasarela.TERRITORIO_APLICACION_PRESUPUESTARIA,
					new BackendData(Pasarela.TERRITORIO_APLICACION_PRESUPUESTARIA, conceptosPagos // NOPMD
							.get(0).getTerritorioAppPresupuestaria()));
			conceptoPeticionBackendDataMap.put(Pasarela.ELEMENTO_PEP,
					new BackendData(Pasarela.ELEMENTO_PEP, conceptosPagos // NOPMD
							.get(0).getElementoPEP()));
			conceptoPeticionBackendDataMap.put(Pasarela.CODIGO_INGRESO,
					new BackendData(Pasarela.CODIGO_INGRESO, conceptosPagos // NOPMD
							.get(j).getCodigoIngreso()));
			if (Y41bUtils.zeroPad(Y41bConstantes.CONCEPTOPAGO_SIPCA_REINTEGRO_SUBVENCION, Y41bConstantes.NUM_6)
					.equalsIgnoreCase(conceptosPagos.get(j).getCodigoIngreso())) {
				String codigoSubvencion = Y41bConstantes.CODIGO_SUBVENCION_REINTEGRO_SUBVENCION;
				if (!Y41bUtils.esNullOCadenaVacia(objPasarela.getCodsubvencion())) {
					codigoSubvencion = objPasarela.getCodsubvencion();
				}
				conceptoPeticionBackendDataMap.put(Pasarela.CODIGO_SUBVENCION,
						new BackendData(Pasarela.CODIGO_SUBVENCION, codigoSubvencion));

				String fechaReintegro = Y41bUtils.formatearDateToString(Y41bUtils.hoy(),
						Y41bConstantes.FORMATO_FECHA_PASARELA);
				if (!Y41bUtils.esNullOCadenaVacia(objPasarela.getFechareintegro())) {
					fechaReintegro = objPasarela.getFechareintegro();
				}
				conceptoPeticionBackendDataMap.put(Pasarela.FECHA_REINTEGRO,
						new BackendData(Pasarela.FECHA_REINTEGRO, fechaReintegro));

				String causaReintegro = Y41bConstantes.CAUSA_REINTEGRO_REINTEGRO_SUBVENCION;
				if (!Y41bUtils.esNullOCadenaVacia(objPasarela.getCausareintegro())) {
					causaReintegro = objPasarela.getCausareintegro();
				}
				conceptoPeticionBackendDataMap.put(Pasarela.CAUSA_REINTEGRO,
						new BackendData(Pasarela.CAUSA_REINTEGRO, causaReintegro));

				Pasarela.logger.info("Pasarela.CODIGO_SUBVENCION backendDataMap(" + Pasarela.CODIGO_SUBVENCION + "): "
						+ codigoSubvencion);
				Pasarela.logger.info(
						"Pasarela.FECHA_REINTEGRO backendDataMap(" + Pasarela.FECHA_REINTEGRO + "): " + fechaReintegro);
				Pasarela.logger.info(
						"Pasarela.CAUSA_REINTEGRO backendDataMap(" + Pasarela.CAUSA_REINTEGRO + "): " + causaReintegro);
			}

			// base Imponible
			String strImporteConcepto = conceptosPagos.get(j).getImporteConcepto();
			if (strImporteConcepto.indexOf(",") != -1) {
				strImporteConcepto = strImporteConcepto.replaceAll(",", ".");
			}
			double importeConcepto = Double.valueOf(strImporteConcepto).doubleValue();

			// tipo iva
			String strTipoIva = objPasarela.getTipoIVA();
			if (strTipoIva.indexOf(",") != -1) {
				strTipoIva = strTipoIva.replaceAll(",", ".");
			}
			double tipoIVA = 0;
			try {
				tipoIVA = Double.valueOf(strTipoIva).doubleValue();
			} catch (Exception e) {
				tipoIVA = 0;
			}
			conceptoPeticionBackendDataMap.put("tipoIVA", this.crearBackendData("tipoIVA", strTipoIva));

			conceptoPeticionBackendDataMap.put("ivaRepercutido", this.crearBackendData("ivaRepercutido", "false"));

			String strImporteIva = "";

			if (conceptosPagos.size() > 1) {
				if (tipoIVA > 0) {
					try {
						strImporteIva = String.valueOf(
								Y41bUtils.round2DecimalDouble(importeConcepto * tipoIVA / Y41bConstantes.NUM_100));
					} catch (Exception e) {
						strImporteIva = "0";
					}
				}
			} else {
				strImporteIva = objPasarela.getImporteIVA();
				if (strImporteIva.indexOf(",") != -1) {
					strImporteIva = strImporteIva.replaceAll(",", ".");
				}
			}
			double importeIVA = Double.valueOf(strImporteIva).doubleValue();
			conceptoPeticionBackendDataMap.put("importeIVA", this.crearBackendData("importeIVA", strImporteIva));

			conceptoPeticionBackendDataMap.put("baseImponible",
					this.crearBackendData("baseImponible", importeConcepto + importeIVA + ""));// NOPMD

			conceptoPeticion.backendDataMap = conceptoPeticionBackendDataMap;

			Map<String, String> conceptoPeticionDescripcion = new HashMap<String, String>(); // NOPMD

			conceptoPeticionDescripcion.put(Y41bConstantes.CASTELLANO.toLowerCase(),
					conceptosPagos.get(j).getDescConceptoCas());
			conceptoPeticionDescripcion.put(Y41bConstantes.EUSKERA.toLowerCase(),
					conceptosPagos.get(j).getDescConceptoEus());
			conceptoPeticion.descripcion = conceptoPeticionDescripcion;

			// CONCEPTO AL QUE SE RELACIONA EL IVA
			conceptoPeticionBackendDataMap.put(Pasarela.CONCEPTO_IVA, this.crearBackendData(Pasarela.CONCEPTO_IVA,
					Y41bUtils.zeroPad(objPasarela.getCodigoConceptoIVA(), Y41bConstantes.NUM_6)));

			// territorio historico
			String TH = "2";
			if ("3".equals(objPasarela.getTerritorioHist())) {
				TH = "3";
			}
			conceptoPeticionBackendDataMap.put(Pasarela.TERRITORIO_IVA, new BackendData(Pasarela.TERRITORIO_IVA, TH)); // NOPMD
			// by
			// ifernandez on
			// 14/08/13 9:37

			// IMPORTE
			conceptoPeticion.importe = (long) (Y41bUtils
					.round2DecimalDouble((importeConcepto + importeIVA) * Y41bConstantes.NUM_100));
			conceptoPeticion.importeIVA = (long) (Y41bUtils.round2DecimalDouble(importeIVA * Y41bConstantes.NUM_100));
			conceptoPeticion.tipoIVA = (long) (Y41bUtils.round2DecimalDouble(tipoIVA * Y41bConstantes.NUM_100));
			// base imponible
			String strBaseImponible = objPasarela.getBaseImponible();
			if (strBaseImponible.indexOf(",") != -1) {
				strBaseImponible = strBaseImponible.replaceAll(",", ".");
			}
			double baseImponible = Double.valueOf(strBaseImponible).doubleValue();
			conceptoPeticion.baseImponible = (long) (Y41bUtils
					.round2DecimalDouble(baseImponible * Y41bConstantes.NUM_100));
			conceptoPeticion.tieneIVARepercutido = false;
			conceptoPeticion.IVARepercutido = false;
			conceptoPeticion.unidades = 1;

			conceptosPeticionPagoList.add(conceptoPeticion);

		}
		return conceptosPeticionPagoList;
	}

	/**
	 * Method enviarPago fucnion que realiza la llamada a la pasarela.
	 * 
	 * @param constPasarela
	 *            Y12bConstPasarela
	 * @param request
	 *            request
	 * @param response
	 *            response
	 * @param tipoCanal
	 *            tipoCanal
	 * @param peticionPagoList
	 *            List<PeticionPago>
	 * @return String String
	 * @throws Y41bUDAException
	 *             Y41bUDAException
	 * @throws UnsupportedEncodingException
	 */

	public String enviarPago(ConstPasarela constPasarela, HttpServletRequest request, HttpServletResponse response,
			String tipoCanal, List<PeticionPago> peticionPagoList) throws Y41bUDAException {

		String resultado = "";
		Pasarela.logger.info("llego a enviarPago");

		try {

			Pasarela.logger.info("En el try de enviarPago");

			// 1. Inicializar el Lote Pagos.
			PaymentRequestData paymentRequestData = new PaymentRequestData();
			Pasarela.logger.info("Despues del new en enviarPago");
			// 1.1 .Componer una Peticion de Pago
			// PeticionPago peticionPago = peticionPagoTot;//
			// this.composePeticionPago(objDatos);
			// Pasarela.logger
			// .info("Se ha solicitado:" + peticionPago.toXML());
			// 1.2 Se introduce al lote.

			// Pasarela.logger
			// .info("antes del Put en enviarPago -- ID peticion: "
			// + peticionPago.id);

			// paymentRequestData.peticionesPago.put(peticionPago.id,
			// peticionPago);

			/**
			 * INTRODUCIR LAS PETICIONES
			 */
			Map<String, PeticionPago> peticionesPagoMap = new HashMap<String, PeticionPago>();
			for (PeticionPago peticionPago : peticionPagoList) {
				peticionesPagoMap.put(peticionPago.id, peticionPago);
			}

			paymentRequestData.peticionesPago = peticionesPagoMap;
			// 1.3 Se llama al API para inicializar la Petici�n de Pago :
			// En este momento el API se comunica via HTTP con la Pasarela de
			// Pagos para inicializar el Pago :
			// paymentManagerBZD
			// paymentManagerBZDByRPC

			Pasarela.logger.info("Se ha solicitado paymentRequestData:" + paymentRequestData.toXML());

			Pasarela.logger.info("antes de llamar al API en enviarPago");
			P12DPaymentManagerAPI paymentAPI = P12DPaymentFactoryAPI
					.getPaymentManagerAPIByOID("paymentManagerBZDByRPC");

			Pasarela.logger.info("Se ha obtenido el P12DPaymentManagerAPI");
			// byte[] btval = paymentRequestData.toXML().getBytes("UTF-8");
			// String paramValor = new String(btval, "ISO8859-1");
			//
			// Enviando solo este no se abre la pasarela -- SOLO PARA EL CASO DE
			// TELEMATICA
			// Enviando solo este no se abre la pasarela

			OperationResult operationResult = paymentAPI.initializePayment(paymentRequestData);

			Pasarela.logger.info("Despues de initializePayment");

			if (operationResult.resultado.resultadoOK) {
				Pasarela.logger.info("Resultado OK");

				if (Y41bConstantes.PASARELA_CANAL_NOTIFICACION_POSTAL.equalsIgnoreCase(tipoCanal)) {
					PaymentRequestData newPaymentRequestData = null;

					Pasarela.logger.info("Entro Liq Postal");

					// Se ha obtenido un lote de Peticiones de Pago
					// inicializadas y
					// validadas.
					newPaymentRequestData = PaymentRequestData.getObject(operationResult.resultado.returnValue);

					if (newPaymentRequestData.peticionesPago == null
							|| newPaymentRequestData.peticionesPago.size() == 0) {
						throw new Y41bUDAException("No hay ninguna peticion de pago...", false, null);
					}

					for (Iterator<String> it = newPaymentRequestData.peticionesPago.keySet().iterator(); it
							.hasNext();) {
						PeticionPago peticionPagoRet = (PeticionPago) newPaymentRequestData.peticionesPago
								.get(it.next());

						if (peticionPagoRet.validacion != null && !peticionPagoRet.validacion.valido) {
							// Y12bTrazas.mostrarTraza("Y41bUDAException: "
							// +
							// "Error de validacion: "
							// + peticionPago.validacion.mensaje);
							throw new Y41bUDAException("Error de validacion: " + peticionPagoRet.validacion.mensaje,
									false, null);
						}

						// peticionPagoRet = peticionPagoRet;
						// Y12bTrazas
						//
						// .mostrarTraza("Se ha solicitado con exito a la
						// pasarela de Pagos el PagoID:"
						// + peticionPago.toXML());
					}

					// 2.Datos de Presentaci�n
					PresentationRequestData presentationRequestData = new PresentationRequestData();
					// Control de idioma de la pasarela
					// HttpSession session = request.getSession();
					// Y12bIdioma idioma = (Y12bIdioma)
					// session.getAttribute(Y12bCteSession.SESSION_IDIOMA);
					// int intIdioma = idioma.getIdioma();
					// // se inicializa por si acaso a idioma opresor
					// presentationRequestData.idioma = "es";
					// if (intIdioma == 1) {
					// presentationRequestData.idioma = "es";
					// } else if (intIdioma == 2) {
					// presentationRequestData.idioma = "eu";
					// }

					presentationRequestData.idioma = LocaleContextHolder.getLocale().getLanguage().toLowerCase();

					// ODEI Comentado el modo de pago online
					// PaymentMode modeON = new PaymentMode();
					// modeON.oid = PaymentMode.BANCA_ONLINE;
					Map<String, PaymentMode> paymentModesMap = new HashMap<String, PaymentMode>();
					// paymentModesMap.put(modeON.oid, modeON);

					PaymentMode modeOFF = new PaymentMode();
					modeOFF.oid = PaymentMode.LIQUIDACION;
					paymentModesMap.put(modeOFF.oid, modeOFF);

					presentationRequestData.paymentModes = paymentModesMap;
					/**
					 * ***************** Imagenes del ********
					 * ********************* PDF *************
					 */

					Map<String, Imagen> imagenes = new HashMap<String, Imagen>();

					Pasarela.logger.info("************URL IMAGEN CABECERA:" + constPasarela.getUrlImagenCabecera());

					Imagen imagen1 = new Imagen();
					imagen1.id = "logo1";
					imagen1.url = constPasarela.getUrlImagenCabecera();
					imagenes.put(imagen1.id, imagen1);

					Imagen imagen2 = new Imagen();
					imagen2.id = "logo2";
					imagen2.url = constPasarela.getUrlImagenMedio();
					imagenes.put(imagen2.id, imagen2);

					// presentationRequestData.imagenes = imagenes;

					// Datos de Procolo.
					ProtocolData protocolData = new ProtocolData();
					protocolData.sourceSessionId = (request.getSession()).getId();

					Pasarela.logger.info("protocolData.sourceSessionId:" + protocolData.sourceSessionId);
					protocolData.timeStamp = System.currentTimeMillis();
					Url urlVuelta = new Url();
					urlVuelta.id = "urlVuelta";

					// HttpSession session = request.getSession();

					// Y12bIdioma idioma =
					// (Y12bIdioma)session.getAttribute(Y12bCteSession.SESSION_IDIOMA);
					// int intIdioma = idioma.getIdioma();
					// if (intIdioma == 1) {
					// urlVuelta.url = objDatos.getUrlVueltaApp1()
					// +
					// LocaleContextHolder.getLocale().getLanguage().toLowerCase()
					// + objDatos.getUrlVueltaApp2();
					// } else if (intIdioma == 2) {
					// urlVuelta.url = objDatos.getUrlVueltaApp_1() + "eu" +
					// objDatos.getUrlVueltaApp_2();
					// }

					urlVuelta.url = constPasarela.getUrlVueltaApp();

					// urlVuelta.url = "httk://www.google.es";
					Map<String, Url> protocolDataUrlsMap = new HashMap<String, Url>();
					protocolDataUrlsMap.put(urlVuelta.id, urlVuelta);
					protocolData.urls = protocolDataUrlsMap;

					// Enviando esto se abrirá la pasarela
					PaymentGatewayData dataToSend = new PaymentGatewayData();
					dataToSend.paymentRequestData = newPaymentRequestData;
					dataToSend.protocolData = protocolData;
					dataToSend.presentationData = presentationRequestData;
					Pasarela.logger.info("Se Solicita POST:" + dataToSend.toXML());

					paymentAPI.sendUsingPost(dataToSend, request, response);
				}

			} else {
				// Se ha producido alg�n error en el lado servidor de la
				// Pasarela de Pago y se devuelve a este cliente
				// departamental,
				// Se captura el error,
				// En este caso "returnValue", contiene la excepci�n que
				// ha
				// ocurrido en el lado servidor de la Pasarela.
				resultado = null;
				Pasarela.logger.info("Resultado NO OK");
				// throw new
				// Y41bUDAException(operationResult.resultado.returnValue);
			}

			Pasarela.logger.info("Fin enviar peticion");

		} catch (XOMarshallerException e) {
			// Y12bTrazas.mostrarTraza("Y41bUDAException: " +
			// e.getMessage());
			logger.error("Error R01 Marshaling: " + e.getMessage(), e);
			throw new Y41bUDAException("Error R01 Marshaling", false, e);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en Pasarela: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
		return resultado;
	}

	/**
	 * Method composePeticionPagoFianza Compone una peticion de pago.
	 * 
	 * @param objDatos
	 *            valores necesarios para pasar a la pasarela
	 * @param procedureCatalog
	 *            Procedure
	 * @param conceptoPago
	 *            ConceptosPago
	 * @return PeticionPago
	 * @throws IOException
	 *             excepcion
	 * @throws Exception
	 */
	public PeticionPago composePeticionPagoFianza(ObjPasarela objDatos, Procedure procedureCatalog,
			ConceptosPago conceptoPago) throws IOException, ParseException {
		Pasarela.logger.info("llego al composePeticionPago");

		objDatos.setFamiliaID(procedureCatalog.getFamilyId());
		objDatos.setEntidadEmisora(procedureCatalog.getEntityCode());
		// try {
		objDatos.setEntidadEmisoraNombCast(Pasarela.prop.getProperty("entidad.ejie.cas"));

		// objDatos.setEntidadEmisoraNombCast("EJIE");
		// } catch (IOException e) {
		// objDatos.setEntidadEmisoraNombCast(null);
		// }
		// try {
		objDatos.setEntidadEmisoraNombEusk(Pasarela.prop.getProperty("entidad.ejie.eus"));
		// objDatos.setEntidadEmisoraNombEusk("EJIE_EU");
		// } catch (IOException e) {
		// objDatos.setEntidadEmisoraNombEusk(null);
		// }
		// try {
		objDatos.setCodAplicacion(Y41bConstantes.COD_APLICACION_PASARELA);
		// } catch (IOException e) {
		// objDatos.setCodAplicacion(null);
		// }

		String procedureNameEs = "";
		String procedureNameEu = "";
		if (procedureCatalog.getProcedureName() != null) {
			try {
				String descriptionXML = Y41bXMLUtils.quitarNameSpacesString(procedureCatalog.getProcedureName().copy());
				procedureNameEs = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.CASTELLANO, descriptionXML);
				procedureNameEu = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.EUSKERA, descriptionXML);
			} catch (Exception e) {
				throw new Y41bUDAException("Excepcin en procesamiento nombre procedimiento", false, e);
			}
		}
		objDatos.setNombreCastAplicacion(procedureNameEs);
		objDatos.setNombreEuskAplicacion(procedureNameEu);

		PeticionPago peticionPago = new PeticionPago();
		peticionPago.devengo = objDatos.getTipoDevengo();

		/**
		 * **************************************** DATOS PETICION PAGO
		 * *******************************
		 */
		DatosPago datosPeticionPago = new DatosPago();
		datosPeticionPago.formato = objDatos.getFormato();// "532";
		datosPeticionPago.validar = 1;
		datosPeticionPago.cpr = objDatos.getCodigoRecaudacion();
		datosPeticionPago.emisor = objDatos.getEntidadEmisora() + "-" + objDatos.getSufijo(); // "04833001-502";
		datosPeticionPago.referencia = objDatos.getReferencia();
		datosPeticionPago.codigo = datosPeticionPago.cpr + datosPeticionPago.emisor + datosPeticionPago.referencia;

		// //
		// emisor
		// -
		// sufijo
		// (obligatorio)

		datosPeticionPago.tipo = objDatos.getSufijo();

		/**
		 * **************************************** PERIODOS PETICION PAGO
		 * *******************************
		 */
		datosPeticionPago.periodosPago = new HashMap<String, PeriodoPago>();
		PeriodoPago periodoPago = new PeriodoPago();
		periodoPago.id = PeriodoPago.PERIODO_NORMAL;
		periodoPago.identificacion = objDatos.getFechaLimitePago();

		// periodoPago.fechaFin; // Identificaci�n
		// del pago en este
		// periodo
		String strImportePeticion = objDatos.getImporte();

		if (strImportePeticion.indexOf(",") != -1) {
			strImportePeticion = strImportePeticion.replaceAll("[.]", "").replaceAll(",", ".");
		}

		double importe = Double.valueOf(strImportePeticion).doubleValue();

		periodoPago.importe = (long) (Y41bUtils.round2DecimalDouble(importe * Y41bConstantes.NUM_100));
		periodoPago.fechaInicio = objDatos.getFechaIncioPago();
		periodoPago.fechaFin = objDatos.getFechaLimitePago();
		periodoPago.activo = true; // Importante si se quiere visualizar.

		Map<String, PeriodoPago> periodosPagoMap = new HashMap<String, PeriodoPago>();
		periodosPagoMap.put(periodoPago.id, periodoPago);
		datosPeticionPago.periodosPago = periodosPagoMap;

		/**
		 * **************************************** CONCEPTOS DE PAGO
		 * *******************************
		 */
		List<ConceptoPeticion> conceptosPeticionPagoList = new ArrayList<ConceptoPeticion>();
		// Concepto sin IVA
		ConceptoPeticion conceptoPeticion = new ConceptoPeticion();
		conceptoPeticion.descripcion = new HashMap<String, String>();
		Map<String, String> conceptoPeticionDescMap = new HashMap<String, String>();
		conceptoPeticionDescMap.put(Y41bConstantes.CASTELLANO.toLowerCase(), conceptoPago.getDescConceptoCas());
		conceptoPeticionDescMap.put(Y41bConstantes.EUSKERA.toLowerCase(), conceptoPago.getDescConceptoEus());

		conceptoPeticion.descripcion = conceptoPeticionDescMap;
		conceptoPeticion.importe = (long) (Y41bUtils.round2DecimalDouble(importe * Y41bConstantes.NUM_100)); // impoerte

		conceptoPeticion.baseImponible = (long) (Y41bUtils.round2DecimalDouble(importe * Y41bConstantes.NUM_100));

		conceptoPeticion.numeroLinea = 1;
		conceptoPeticion.IVARepercutido = false;
		conceptoPeticion.backendDataMap = new HashMap<String, BackendData>();

		Map<String, BackendData> backendDataMap = new HashMap<String, BackendData>();
		// NO TIENE APLICACION PRESUPUESTARIA II
		backendDataMap.put(Pasarela.APLICACION_PRESUPUESTARIA, new BackendData(Pasarela.APLICACION_PRESUPUESTARIA, ""));
		backendDataMap.put(Pasarela.TERRITORIO_APLICACION_PRESUPUESTARIA,
				new BackendData(Pasarela.TERRITORIO_APLICACION_PRESUPUESTARIA, ""));
		backendDataMap.put(Pasarela.ELEMENTO_PEP, new BackendData(Pasarela.ELEMENTO_PEP, ""));
		backendDataMap.put(Pasarela.CODIGO_INGRESO,
				new BackendData(Pasarela.CODIGO_INGRESO, objDatos.getConceptoCodigoIngreso()));
		// Si el codigo concepto SIPCA es de reintegro anyadimos info adicional
		if (Y41bUtils.zeroPad(Y41bConstantes.CONCEPTOPAGO_SIPCA_REINTEGRO_SUBVENCION, Y41bConstantes.NUM_6)
				.equalsIgnoreCase(objDatos.getConceptoCodigoIngreso())) {

			String codigoSubvencion = Y41bConstantes.CODIGO_SUBVENCION_REINTEGRO_SUBVENCION;
			if (!Y41bUtils.esNullOCadenaVacia(objDatos.getCodsubvencion())) {
				codigoSubvencion = objDatos.getCodsubvencion();
			}
			backendDataMap.put(Pasarela.CODIGO_SUBVENCION,
					new BackendData(Pasarela.CODIGO_SUBVENCION, codigoSubvencion));

			String fechaReintegro = Y41bUtils.formatearDateToString(Y41bUtils.hoy(),
					Y41bConstantes.FORMATO_FECHA_PASARELA);
			if (!Y41bUtils.esNullOCadenaVacia(objDatos.getFechareintegro())) {
				fechaReintegro = objDatos.getFechareintegro();
			}
			backendDataMap.put(Pasarela.FECHA_REINTEGRO, new BackendData(Pasarela.FECHA_REINTEGRO, fechaReintegro));

			String causaReintegro = Y41bConstantes.CAUSA_REINTEGRO_REINTEGRO_SUBVENCION;
			if (!Y41bUtils.esNullOCadenaVacia(objDatos.getCausareintegro())) {
				causaReintegro = objDatos.getCausareintegro();
			}
			backendDataMap.put(Pasarela.CAUSA_REINTEGRO, new BackendData(Pasarela.CAUSA_REINTEGRO, causaReintegro));

			Pasarela.logger.info("Pasarela.CODIGO_SUBVENCION backendDataMap(" + Pasarela.CODIGO_SUBVENCION + "): "
					+ codigoSubvencion);
			Pasarela.logger.info(
					"Pasarela.FECHA_REINTEGRO backendDataMap(" + Pasarela.FECHA_REINTEGRO + "): " + fechaReintegro);
			Pasarela.logger.info(
					"Pasarela.CAUSA_REINTEGRO backendDataMap(" + Pasarela.CAUSA_REINTEGRO + "): " + causaReintegro);
		}
		conceptoPeticion.backendDataMap = backendDataMap;

		conceptosPeticionPagoList.add(conceptoPeticion);

		/**
		 * ************ DESCRIPCION APLICACION *******************************
		 */
		Aplicacion app = new Aplicacion();
		app.codigo = objDatos.getCodAplicacion();
		Map<String, String> nombreApp = new HashMap<String, String>();
		nombreApp.put(Y41bConstantes.CASTELLANO.toLowerCase(), objDatos.getNombreCastAplicacion());
		nombreApp.put(Y41bConstantes.EUSKERA.toLowerCase(), objDatos.getNombreEuskAplicacion());
		app.nombre = nombreApp;
		app.responsable = objDatos.getResponsableAplicacion();

		/**
		 * ********* DESCRIPCION EMISOR **************************************
		 */
		Emisor emisor = new Emisor();
		emisor.codigo = objDatos.getEntidadEmisora(); // + "-" +
		// objDatos.getSufijo();
		// // "04833001-502"; //
		// emisor - sufijo
		// (obligatorio)
		Map<String, String> nombreEmisor = new HashMap<String, String>();
		nombreEmisor.put(Y41bConstantes.CASTELLANO.toLowerCase(), objDatos.getEntidadEmisoraNombCast());
		nombreEmisor.put(Y41bConstantes.EUSKERA.toLowerCase(), objDatos.getEntidadEmisoraNombEusk());
		emisor.cif = objDatos.getEntidadEmisora(); // "04833001";

		/**
		 * ********* DESCRIPCION EXPEDIENTE Y TERCERO
		 * **************************************
		 */
		Expediente expediente = new Expediente();
		expediente.codigo = objDatos.getNumExpFactura();
		expediente.familia = objDatos.getFamiliaID();

		expediente.tercero = new Tercero();
		expediente.tercero.razonSocial = objDatos.getDatosTerceroNombreCompleto();
		expediente.tercero.dniNif = (objDatos.getDatosTerceroDni() != null ? objDatos.getDatosTerceroDni().toUpperCase()
				: null);
		expediente.tercero.calle = objDatos.getDatosTerceroDireccion();
		expediente.tercero.municipio = objDatos.getDatosTerceroMunicipio();
		expediente.tercero.codigoPostal = objDatos.getDatosTerceroCodigoPostal();
		expediente.tercero.territorio = objDatos.getDatosTerceroProvincia();
		expediente.tercero.pais = objDatos.getDatosTerceroPais();

		List<DatoAdicional> datosAdicionalesTercero = new ArrayList<DatoAdicional>();

		DatoAdicional datoAdicional = new DatoAdicional();
		datoAdicional.id = "localidad";
		Map<String, String> descDatoAdicional = new HashMap<String, String>();
		descDatoAdicional.put("eu", objDatos.getDatosTerceroLocalidad());
		descDatoAdicional.put("es", objDatos.getDatosTerceroLocalidad());
		datoAdicional.texto = descDatoAdicional;
		datosAdicionalesTercero.add(datoAdicional);
		expediente.tercero.datosAdicionales = datosAdicionalesTercero;

		/*
		 * Map<String, String> descDatoAdicional = new HashMap<String,
		 * String>(); datoAdicional = new DatoAdicional(); datoAdicional.id =
		 * "Telefono"; descDatoAdicional = new HashMap<String, String>();
		 * descDatoAdicional .put("eu",
		 * objDatos.getDatosTerceroTextoEuskTelefono()); // "Tfnoa.";
		 * descDatoAdicional .put("es",
		 * objDatos.getDatosTerceroTextoCastTelefono()); // "Tfno.";
		 * 
		 * datoAdicional.texto = descDatoAdicional; datoAdicional.valor =
		 * objDatos.getDatosTerceroTelefono();
		 * datosAdicionalesTercero.add(datoAdicional);
		 */// Esto se repite con los
			// datos adicionales que se
			// quiera
		/*
		 * datoAdicional = new DatoAdicional(); datoAdicional.id = "e-mail";
		 * descDatoAdicional = new HashMap<String, String>();
		 * descDatoAdicional.put("eu",
		 * objDatos.getDatosTerceroTextoEuskEmail()); // E-mail";
		 * descDatoAdicional.put("es",
		 * objDatos.getDatosTerceroTextoCastEmail()); // "e-mail";
		 * datoAdicional.texto = descDatoAdicional; datoAdicional.valor =
		 * objDatos.getDatosTerceroEmail();
		 * datosAdicionalesTercero.add(datoAdicional);
		 */// Esto se repite con los
			// datos adicionales que se
			// quiera

		// expediente.tercero.datosAdicionales = datosAdicionalesTercero;

		/** ********* DESCRIPCION PAGO ************************************** */
		Map<String, String> descripcionPeticionPago = new HashMap<String, String>();
		descripcionPeticionPago.put("es", objDatos.getCodTasaCast());
		descripcionPeticionPago.put("eu", objDatos.getCodTasaEusk());

		/** ********* BACKEND DATA ************************************** */
		Backend backEnd = new Backend();
		backEnd.put(new BackendData(BackendData.GASTO_GV, "false"));
		backEnd.put(new BackendData(BackendData.INFORMAR_SIPCA, "true"));
		if (objDatos.isExentoPago()) {
			backEnd.put(new BackendData(BackendData.EXENTO_PAGO, "true"));
		} else {
			backEnd.put(new BackendData(BackendData.EXENTO_PAGO, "false"));
		}

		backEnd.put(new BackendData(BackendData.EJERCICIO_CONTABLE, objDatos.getEjercicioContable())); // año
																										// codigo
																										// de
		// aplicacion
		// presupuestaria));

		/**
		 * ***************** Imagenes del ******** ********************* PDF
		 * *************
		 */
		Map<String, Imagen> imagenes = new HashMap<String, Imagen>();

		Pasarela.logger.info("************URL IMAGEN CABECERA:" + Pasarela.prop.getProperty("URL_IMAGEN_CABECERA"));

		Imagen imagen1 = new Imagen();
		imagen1.id = "logo1";
		imagen1.url = Pasarela.prop.getProperty("URL_IMAGEN_CABECERA");
		imagenes.put(imagen1.id, imagen1);

		Imagen imagen2 = new Imagen();
		imagen2.id = "logo2";
		imagen2.url = Pasarela.prop.getProperty("URL_IMAGEN_MEDIO");

		imagenes.put(imagen2.id, imagen2);

		peticionPago.liquidacion.imagenes = imagenes;

		// peticionPago.liquidacion.paymentGatewayVersion = "2";
		peticionPago.liquidacion.paymentGatewayVersion = "3";

		peticionPago.liquidacion.urlPlantilla = Pasarela.prop.getProperty("PATH_XSL_PDF_FIANZA");

		peticionPago.id = datosPeticionPago.cpr + datosPeticionPago.emisor + datosPeticionPago.referencia;
		peticionPago.datosPago = datosPeticionPago;
		peticionPago.aplicacion = app;
		peticionPago.conceptos = conceptosPeticionPagoList;
		peticionPago.descripcion = descripcionPeticionPago;
		peticionPago.expediente = expediente;
		peticionPago.emisor = emisor;
		peticionPago.backend = backEnd;

		return peticionPago;
	}

	/**
	 * Creacin de objeto backendData
	 * 
	 * @param id
	 *            String
	 * @param value
	 *            String
	 * @return BackendData
	 */
	private BackendData crearBackendData(String id, String value) {
		return new BackendData(id, value);
	}

}
