package com.ejie.y41b.model.sipca.line;

import java.io.Serializable;

/**
 * Clase de numero de cuenta
 * 
 *  
 * 
 */
public class NumCuenta implements Serializable {

	/**
	 * 
	 */
	public NumCuenta() {

	}

	/**
	 * Serial version
	 */
	private static final long serialVersionUID = -7491563459232229879L;

	// Numero de entidad. 4 posiciones numericas
	private String numeroEntidad;

	// Numero de la oficina donde se encuentra la cuenta del cliente
	// ordenante
	// 4 posiciones numericas
	private String numeroOficina;

	// Digito de control de la Entidad
	private String digitoControl;

	// Num cuenta
	private String numCuenta;

	/**
	 * Constructor
	 * 
	 * @param numeroEntidad
	 *            numero de entidad
	 * @param numeroOficina
	 *            numero de oficina
	 * @param digitoControl
	 *            digito de control
	 * @param numCuenta
	 *            numero de cuenta
	 */
	public NumCuenta(String numeroEntidad, String numeroOficina,
			String digitoControl, String numCuenta) {
		super();
		this.numeroEntidad = numeroEntidad;
		this.numeroOficina = numeroOficina;
		this.digitoControl = digitoControl;
		this.numCuenta = numCuenta;
	}

	/**********************************************************************************************
	 * 
	 * GETTERS && SETTERS
	 * 
	 **********************************************************************************************/
	/**
	 * @return the numeroEntidad
	 */
	public String getNumeroEntidad() {
		return this.numeroEntidad;
	}

	/**
	 * @param numeroEntidad
	 *            the numeroEntidad to set
	 */
	public void setNumeroEntidad(String numeroEntidad) {
		this.numeroEntidad = numeroEntidad;
	}

	/**
	 * @return the numeroOficina
	 */
	public String getNumeroOficina() {
		return this.numeroOficina;
	}

	/**
	 * @param numeroOficina
	 *            the numeroOficina to set
	 */
	public void setNumeroOficina(String numeroOficina) {
		this.numeroOficina = numeroOficina;
	}

	/**
	 * @return the digitoControl
	 */
	public String getDigitoControl() {
		return this.digitoControl;
	}

	/**
	 * @param digitoControl
	 *            the digitoControl to set
	 */
	public void setDigitoControl(String digitoControl) {
		this.digitoControl = digitoControl;
	}

	/**
	 * @return the numCuenta
	 */
	public String getNumCuenta() {
		return this.numCuenta;
	}

	/**
	 * @param numCuenta
	 *            the numCuenta to set
	 */
	public void setNumCuenta(String numCuenta) {
		this.numCuenta = numCuenta;
	}

}
