package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto SolicitudPresencial.
 * 
 *  
 */
public class SolicitudOficio implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	private String idParticipacion;

	// El numero de expediente
	private String numeroExpediente;

	// Los datos del solicitante
	private DatosPersona sancionado;

	// Los datos del respesentante si los hubiera
	private DatosPersona representante;

	// Los datos del respesentante si los hubiera
	private DatosPersona sender;

	// El tipo de notificacion:Como se desea recibir las notificaciones.
	// 2:postal,1:telemáticas
	private String tipoNotificacion;

	// El idioma de la notificacio:Idioma en que se desea recibir las
	// notificaciones. ES:castellano, EU:euskara
	private String idiomaNotificacion;

	// Los datos postales de la notificacion
	private NotificacionPostal notificacionPostal;

	private DatosRegistro datosRegistro;

	// Los documentos de la solicitud
	private List<Documento> documentosAdjuntos = new ArrayList<Documento>();

	private Procedure procedure;

	private String proceedingIdAcuerdoIncoacion;

	private Calendar aperturaTimestamp;

	/**
	 * 
	 */
	public SolicitudOficio() {
		super();
	}

	/**
	 * Instantiates a new solicitud oficio.
	 * 
	 * @param idExpediente
	 *            the id expediente
	 * @param numeroExpediente
	 *            the numero expediente
	 * @param solicitante
	 *            the solicitante
	 * @param representante
	 *            the representante
	 * @param tipoNotificacion
	 *            the tipo notificacion
	 * @param idiomaNotificacion
	 *            the idioma notificacion
	 * @param notificacionPostal
	 *            the notificacion postal
	 * @param datosRegistro
	 *            the datos registro
	 * @param documentosAdjuntos
	 *            the documentos adjuntos
	 * @param procedure
	 *            the procedure
	 */
	public SolicitudOficio(String idExpediente, String numeroExpediente,
			DatosPersona sancionado, DatosPersona representante,
			DatosPersona sender, String tipoNotificacion,
			String idiomaNotificacion, NotificacionPostal notificacionPostal,
			DatosRegistro datosRegistro, List<Documento> documentosAdjuntos,
			Procedure procedure) {
		super();
		this.idExpediente = idExpediente;
		this.numeroExpediente = numeroExpediente;
		this.sancionado = sancionado;
		this.representante = representante;
		this.sender = sender;
		this.tipoNotificacion = tipoNotificacion;
		this.idiomaNotificacion = idiomaNotificacion;
		this.notificacionPostal = notificacionPostal;
		this.datosRegistro = datosRegistro;
		this.documentosAdjuntos = documentosAdjuntos;
		this.procedure = procedure;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSancionado() {
		return sancionado;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSancionado(DatosPersona sancionado) {
		this.sancionado = sancionado;
	}

	/**
	 * @return the representante
	 */
	public DatosPersona getRepresentante() {
		return representante;
	}

	/**
	 * @param representante
	 *            the representante to set
	 */
	public void setRepresentante(DatosPersona representante) {
		this.representante = representante;
	}

	/**
	 * @return the sender
	 */
	public DatosPersona getSender() {
		return sender;
	}

	/**
	 * @param sender
	 *            the sender to set
	 */
	public void setSender(DatosPersona sender) {
		this.sender = sender;
	}

	/**
	 * @return the tipoNotificacion
	 */
	public String getTipoNotificacion() {
		return tipoNotificacion;
	}

	/**
	 * @param tipoNotificacion
	 *            the tipoNotificacion to set
	 */
	public void setTipoNotificacion(String tipoNotificacion) {
		this.tipoNotificacion = tipoNotificacion;
	}

	/**
	 * @return the idiomaNotificacion
	 */
	public String getIdiomaNotificacion() {
		return idiomaNotificacion;
	}

	/**
	 * @param idiomaNotificacion
	 *            the idiomaNotificacion to set
	 */
	public void setIdiomaNotificacion(String idiomaNotificacion) {
		this.idiomaNotificacion = idiomaNotificacion;
	}

	/**
	 * @return the notificacionPostal
	 */
	public NotificacionPostal getNotificacionPostal() {
		return notificacionPostal;
	}

	/**
	 * @param notificacionPostal
	 *            the notificacionPostal to set
	 */
	public void setNotificacionPostal(NotificacionPostal notificacionPostal) {
		this.notificacionPostal = notificacionPostal;
	}

	/**
	 * @return the datosRegistro
	 */
	public DatosRegistro getDatosRegistro() {
		return datosRegistro;
	}

	/**
	 * @param datosRegistro
	 *            the datosRegistro to set
	 */
	public void setDatosRegistro(DatosRegistro datosRegistro) {
		this.datosRegistro = datosRegistro;
	}

	/**
	 * @return the documentosAdjuntos
	 */
	public List<Documento> getDocumentosAdjuntos() {
		return documentosAdjuntos;
	}

	/**
	 * @param documentosAdjuntos
	 *            the documentosAdjuntos to set
	 */
	public void setDocumentosAdjuntos(List<Documento> documentosAdjuntos) {
		this.documentosAdjuntos = documentosAdjuntos;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "SolicitudPresencial [idExpediente=" + idExpediente
				+ ", numeroExpediente=" + numeroExpediente + ", sancionado="
				+ sancionado + ", representante=" + representante
				+ ", tipoNotificacion=" + tipoNotificacion
				+ ", idiomaNotificacion=" + idiomaNotificacion
				+ ", notificacionPostal=" + notificacionPostal
				+ ", datosRegistro=" + datosRegistro + ", documentosAdjuntos="
				+ documentosAdjuntos + ", procedure=" + procedure + "]";
	}

	/**
	 * @return the proceedingIdAcuerdoIncoacion
	 */
	public String getProceedingIdAcuerdoIncoacion() {
		return proceedingIdAcuerdoIncoacion;
	}

	/**
	 * @param proceedingIdAcuerdoIncoacion
	 *            the proceedingIdAcuerdoIncoacion to set
	 */
	public void setProceedingIdAcuerdoIncoacion(
			String proceedingIdAcuerdoIncoacion) {
		this.proceedingIdAcuerdoIncoacion = proceedingIdAcuerdoIncoacion;
	}

	/**
	 * @return the aperturaTimestamp
	 */
	public Calendar getAperturaTimestamp() {
		return aperturaTimestamp;
	}

	/**
	 * @param aperturaTimestamp
	 *            the aperturaTimestamp to set
	 */
	public void setAperturaTimestamp(Calendar aperturaTimestamp) {
		this.aperturaTimestamp = aperturaTimestamp;
	}

        /**
	 * @return the idParticipacion
	 */
	public String getIdParticipacion() {
		return idParticipacion;
	}

	/**
	 * @param idParticipacion
	 *            the idParticipacion to set
	 */
	public void setIdParticipacion(String idParticipacion) {
		this.idParticipacion = idParticipacion;
	}

}
