package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto RespuestaSolicitudPresencial.
 * 
 *  
 */
public class RespuestaSolicitudPresencial implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	// El numero de expediente
	private String numeroExpediente;

	private String codigoRespuesta;
	private String errorDescripcion;

	private String folderID;

	private String estadoExpediente;

	// Los documentos de la solicitud
	private List<Documento> documentosAdjuntos = new ArrayList<Documento>();

	/**
	 * 
	 */
	public RespuestaSolicitudPresencial() {
		super();
	}

	/**
	 * @param idExpediente
	 * @param numeroExpediente
	 * @param codigoRespuesta
	 * @param errorDescripcion
	 * @param folderID
	 * @param estadoExpediente
	 * @param documentosAdjuntos
	 */
	public RespuestaSolicitudPresencial(String idExpediente,
			String numeroExpediente, String codigoRespuesta,
			String errorDescripcion, String folderID, String estadoExpediente,
			List<Documento> documentosAdjuntos) {
		super();
		this.idExpediente = idExpediente;
		this.numeroExpediente = numeroExpediente;
		this.codigoRespuesta = codigoRespuesta;
		this.errorDescripcion = errorDescripcion;
		this.folderID = folderID;
		this.estadoExpediente = estadoExpediente;
		this.documentosAdjuntos = documentosAdjuntos;
	}

	/**
	 * @return the documentosAdjuntos
	 */
	public List<Documento> getDocumentosAdjuntos() {
		return documentosAdjuntos;
	}

	/**
	 * @param documentosAdjuntos
	 *            the documentosAdjuntos to set
	 */
	public void setDocumentosAdjuntos(List<Documento> documentosAdjuntos) {
		this.documentosAdjuntos = documentosAdjuntos;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the codigoRespuesta
	 */
	public String getCodigoRespuesta() {
		return codigoRespuesta;
	}

	/**
	 * @param codigoRespuesta
	 *            the codigoRespuesta to set
	 */
	public void setCodigoRespuesta(String codigoRespuesta) {
		this.codigoRespuesta = codigoRespuesta;
	}

	/**
	 * @return the errorDescripcion
	 */
	public String getErrorDescripcion() {
		return errorDescripcion;
	}

	/**
	 * @param errorDescripcion
	 *            the errorDescripcion to set
	 */
	public void setErrorDescripcion(String errorDescripcion) {
		this.errorDescripcion = errorDescripcion;
	}

	/**
	 * @return the folderID
	 */
	public String getFolderID() {
		return folderID;
	}

	/**
	 * @param folderID
	 *            the folderID to set
	 */
	public void setFolderID(String folderID) {
		this.folderID = folderID;
	}

	/**
	 * @return the estadoExpediente
	 */
	public String getEstadoExpediente() {
		return estadoExpediente;
	}

	/**
	 * @param estadoExpediente
	 *            the estadoExpediente to set
	 */
	public void setEstadoExpediente(String estadoExpediente) {
		this.estadoExpediente = estadoExpediente;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "RespuestaSolicitudPresencial [idExpediente=" + idExpediente
				+ ", numeroExpediente=" + numeroExpediente
				+ ", codigoRespuesta=" + codigoRespuesta
				+ ", errorDescripcion=" + errorDescripcion + ", folderID="
				+ folderID + ", estadoExpediente=" + estadoExpediente
				+ ", documentosAdjuntos=" + documentosAdjuntos + "]";
	}

}
