package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto RegistroSalida.
 * 
 *  
 */
public class RegistroSalida implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	// El numero de expediente
	private String numeroExpediente;

	// El idioma de la notificacio:Idioma en que se desea recibir las
	// notificaciones. ES:castellano, EU:euskara
	private String idioma;

	// Los datos del solicitante
	private DatosPersona solicitante;

	// Los documentos
	private List<Documento> documentosAdjuntos = new ArrayList<Documento>();

	private Procedure procedure;

	// Numero de registro de salida
	private String registryNumber;
	// Fecha de registro de salida
	private String registryTimestamp;

	// Fecha de registro de entrada
	private Date registryDate;

	/**
	 * 
	 */
	public RegistroSalida() {
		super();
	}

	/**
	 * @param idExpediente
	 * @param numeroExpediente
	 * @param idioma
	 * @param solicitante
	 * @param documentosAdjuntos
	 * @param procedure
	 */
	public RegistroSalida(String idExpediente, String numeroExpediente,
			String idioma, DatosPersona solicitante,
			List<Documento> documentosAdjuntos, Procedure procedure) {
		super();
		this.idExpediente = idExpediente;
		this.numeroExpediente = numeroExpediente;
		this.idioma = idioma;
		this.solicitante = solicitante;
		this.documentosAdjuntos = documentosAdjuntos;
		this.procedure = procedure;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the idioma
	 */
	public String getIdioma() {
		return idioma;
	}

	/**
	 * @param idioma
	 *            the idioma to set
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(DatosPersona solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the documentosAdjuntos
	 */
	public List<Documento> getDocumentosAdjuntos() {
		return documentosAdjuntos;
	}

	/**
	 * @param documentosAdjuntos
	 *            the documentosAdjuntos to set
	 */
	public void setDocumentosAdjuntos(List<Documento> documentosAdjuntos) {
		this.documentosAdjuntos = documentosAdjuntos;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the registryNumber
	 */
	public String getRegistryNumber() {
		return registryNumber;
	}

	/**
	 * @param registryNumber
	 *            the registryNumber to set
	 */
	public void setRegistryNumber(String registryNumber) {
		this.registryNumber = registryNumber;
	}

	/**
	 * @return the registryTimestamp
	 */
	public String getRegistryTimestamp() {
		return registryTimestamp;
	}

	/**
	 * @param registryTimestamp
	 *            the registryTimestamp to set
	 */
	public void setRegistryTimestamp(String registryTimestamp) {
		this.registryTimestamp = registryTimestamp;
	}

	/**
	 * @return the registryDate
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getRegistryDate() {
		return registryDate;
	}

	/**
	 * @param registryDate
	 *            the registryDate to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setRegistryDate(Date registryDate) {
		this.registryDate = registryDate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "RegistroSalida [idExpediente=" + idExpediente
				+ ", numeroExpediente=" + numeroExpediente + ", idioma="
				+ idioma + ", solicitante=" + solicitante
				+ ", documentosAdjuntos=" + documentosAdjuntos + ", procedure="
				+ procedure + ", registryNumber=" + registryNumber
				+ ", registryTimestamp=" + registryTimestamp
				+ ", registryDate=" + registryDate + "]";
	}

}
