package com.ejie.y41b.model.platea;

/**
 * Objeto ExpedienteOficio.
 * 
 *  
 */
public class ExpedienteOficio implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Procedimiento
	private Procedure procedure;

	// En el expediente de oficio seria la fecha de apertura del expediente
	private String aperturaTimeStamp;

	// En el expediente de oficio seria el identificador del buzon que inicia el
	// expediente
	private String buzonId;

	// En el expediente de oficio seria el nombre del buzon que inicia el
	// expediente
	private String buzonName;

	// Los datos del solicitante
	private DatosPersona solicitante;

	// Los datos del respesentante si los hubiera
	private DatosPersona representante;

	// Los datos postales de la notificacion
	private NotificacionPostal notificacionPostal;

	// El folderId del Expediente
	private String folderId;

	// El estado del Expediente
	private String estadoExpediente;

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the aperturaTimeStamp
	 */
	public String getAperturaTimeStamp() {
		return aperturaTimeStamp;
	}

	/**
	 * @param aperturaTimeStamp
	 *            the aperturaTimeStamp to set
	 */
	public void setAperturaTimeStamp(String aperturaTimeStamp) {
		this.aperturaTimeStamp = aperturaTimeStamp;
	}

	/**
	 * @return the buzonId
	 */
	public String getBuzonId() {
		return buzonId;
	}

	/**
	 * @param buzonId
	 *            the buzonId to set
	 */
	public void setBuzonId(String buzonId) {
		this.buzonId = buzonId;
	}

	/**
	 * @return the buzonName
	 */
	public String getBuzonName() {
		return buzonName;
	}

	/**
	 * @param buzonName
	 *            the buzonName to set
	 */
	public void setBuzonName(String buzonName) {
		this.buzonName = buzonName;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(DatosPersona solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the representante
	 */
	public DatosPersona getRepresentante() {
		return representante;
	}

	/**
	 * @param representante
	 *            the representante to set
	 */
	public void setRepresentante(DatosPersona representante) {
		this.representante = representante;
	}

	/**
	 * @return the notificacionPostal
	 */
	public NotificacionPostal getNotificacionPostal() {
		return notificacionPostal;
	}

	/**
	 * @param notificacionPostal
	 *            the notificacionPostal to set
	 */
	public void setNotificacionPostal(NotificacionPostal notificacionPostal) {
		this.notificacionPostal = notificacionPostal;
	}

	/**
	 * @return the folderId
	 */
	public String getFolderId() {
		return folderId;
	}

	/**
	 * @param folderId
	 *            the folderId to set
	 */
	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	/**
	 * @return the estadoExpediente
	 */
	public String getEstadoExpediente() {
		return estadoExpediente;
	}

	/**
	 * @param estadoExpediente
	 *            the estadoExpediente to set
	 */
	public void setEstadoExpediente(String estadoExpediente) {
		this.estadoExpediente = estadoExpediente;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ExpedienteOficio [procedure=" + procedure
				+ ", aperturaTimeStamp=" + aperturaTimeStamp + ", buzonId="
				+ buzonId + ", buzonName=" + buzonName + ", solicitante="
				+ solicitante + ", representante=" + representante
				+ ", notificacionPostal=" + notificacionPostal + ", folderId="
				+ folderId + ", estadoExpediente=" + estadoExpediente + "]";
	}

}
