package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto EnvioEJGV.
 * 
 *  
 */

public class EnvioEJGV implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	// El numero de expediente
	private String numeroExpediente;

	private String ejgvDocument;

	private String firma;

	// Los documentos de la solicitud
	private List<Documento> documentosAdjuntos = new ArrayList<Documento>();

	private Procedure procedure;

	// Los datos del solicitante
	private DatosPersona solicitante;

	// El tipo de notificacion:Como se desea recibir las notificaciones.
	// 2:postal,1:telemáticas
	private String tipoNotificacion;

	// El idioma de la notificacio:Idioma en que se desea recibir las
	// notificaciones. ES:castellano, EU:euskara
	private String idiomaNotificacion;

	// Los datos del respesentante si los hubiera
	private DatosPersona representante;

	// Los datos postales de la notificacion
	private NotificacionPostal notificacionPostal;

	/**
	 * 
	 */
	public EnvioEJGV() {
		super();
	}

	/**
	 * @param idExpediente
	 * @param numeroExpediente
	 * @param ejgvDocument
	 * @param firma
	 * @param documentosAdjuntos
	 * @param procedure
	 */
	public EnvioEJGV(String idExpediente, String numeroExpediente,
			String ejgvDocument, String firma,
			List<Documento> documentosAdjuntos, Procedure procedure) {
		super();
		this.idExpediente = idExpediente;
		this.numeroExpediente = numeroExpediente;
		this.ejgvDocument = ejgvDocument;
		this.firma = firma;
		this.documentosAdjuntos = documentosAdjuntos;
		this.procedure = procedure;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the ejgvDocument
	 */
	public String getEjgvDocument() {
		return ejgvDocument;
	}

	/**
	 * @param ejgvDocument
	 *            the ejgvDocument to set
	 */
	public void setEjgvDocument(String ejgvDocument) {
		this.ejgvDocument = ejgvDocument;
	}

	/**
	 * @return the firma
	 */
	public String getFirma() {
		return firma;
	}

	/**
	 * @param firma
	 *            the firma to set
	 */
	public void setFirma(String firma) {
		this.firma = firma;
	}

	/**
	 * @return the documentosAdjuntos
	 */
	public List<Documento> getDocumentosAdjuntos() {
		return documentosAdjuntos;
	}

	/**
	 * @param documentosAdjuntos
	 *            the documentosAdjuntos to set
	 */
	public void setDocumentosAdjuntos(List<Documento> documentosAdjuntos) {
		this.documentosAdjuntos = documentosAdjuntos;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(DatosPersona solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the representante
	 */
	public DatosPersona getRepresentante() {
		return representante;
	}

	/**
	 * @param representante
	 *            the representante to set
	 */
	public void setRepresentante(DatosPersona representante) {
		this.representante = representante;
	}

	/**
	 * @return the tipoNotificacion
	 */
	public String getTipoNotificacion() {
		return tipoNotificacion;
	}

	/**
	 * @param tipoNotificacion
	 *            the tipoNotificacion to set
	 */
	public void setTipoNotificacion(String tipoNotificacion) {
		this.tipoNotificacion = tipoNotificacion;
	}

	/**
	 * @return the idiomaNotificacion
	 */
	public String getIdiomaNotificacion() {
		return idiomaNotificacion;
	}

	/**
	 * @param idiomaNotificacion
	 *            the idiomaNotificacion to set
	 */
	public void setIdiomaNotificacion(String idiomaNotificacion) {
		this.idiomaNotificacion = idiomaNotificacion;
	}

	/**
	 * @return the notificacionPostal
	 */
	public NotificacionPostal getNotificacionPostal() {
		return notificacionPostal;
	}

	/**
	 * @param notificacionPostal
	 *            the notificacionPostal to set
	 */
	public void setNotificacionPostal(NotificacionPostal notificacionPostal) {
		this.notificacionPostal = notificacionPostal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "EnvioEJGV [idExpediente=" + idExpediente
				+ ", numeroExpediente=" + numeroExpediente + ", ejgvDocument="
				+ ejgvDocument + ", firma=" + firma + ", documentosAdjuntos="
				+ documentosAdjuntos + ", procedure=" + procedure + "]";
	}

}
