package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto CrearNotifEJGV.
 * 
 *  
 */

public class CrearNotifEJGV implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Serie documental
	private String serieDocumental;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	// El numero de expediente
	private String numeroExpediente;

	// El ejercicio
	private String ejercicio;

	// Los datos del solicitante
	private DatosPersona solicitante;

	// Los datos de quien envia la notificacion
	private DatosPersona sender;

	// Identificador del tipo de notificacion
	private String idTipoNotificacion;

	// Descripcion del tipo de notificacion: REQ_SUB, RESOL, RESOL_RECUR
	private String descTipoNotificacion;

	// El idioma de la notificacion: ES:castellano, EU:euskara
	private String idiomaNotificacion;

	// El texto de la notificacion
	private String textoNotificacion;

	// Los documentos de la solicitud
	private List<Documento> documentosAdjuntos = new ArrayList<Documento>();

	private Procedure procedure;

	/**
	 * 
	 */
	public CrearNotifEJGV() {
		super();
	}

	/**
	 * @param serieDocumental
	 * @param idExpediente
	 * @param numeroExpediente
	 * @param solicitante
	 * @param tipoNotificacion
	 * @param idiomaNotificacion
	 * @param textoNotificacion
	 * @param documentosAdjuntos
	 * @param procedure
	 */
	public CrearNotifEJGV(String serieDocumental, String idExpediente,
			String numeroExpediente, DatosPersona solicitante,
			String idTipoNotificacion, String descTipoNotificacion,
			String idiomaNotificacion, String textoNotificacion,
			List<Documento> documentosAdjuntos, Procedure procedure) {
		super();
		this.serieDocumental = serieDocumental;
		this.idExpediente = idExpediente;
		this.numeroExpediente = numeroExpediente;
		this.solicitante = solicitante;
		this.idTipoNotificacion = idTipoNotificacion;
		this.descTipoNotificacion = descTipoNotificacion;
		this.idiomaNotificacion = idiomaNotificacion;
		this.textoNotificacion = textoNotificacion;
		this.documentosAdjuntos = documentosAdjuntos;
		this.procedure = procedure;
	}

	/**
	 * @return the serieDocumental
	 */
	public String getSerieDocumental() {
		return serieDocumental;
	}

	/**
	 * @param serieDocumental
	 *            the serieDocumental to set
	 */
	public void setSerieDocumental(String serieDocumental) {
		this.serieDocumental = serieDocumental;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(DatosPersona solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the idiomaNotificacion
	 */
	public String getIdiomaNotificacion() {
		return idiomaNotificacion;
	}

	/**
	 * @param idiomaNotificacion
	 *            the idiomaNotificacion to set
	 */
	public void setIdiomaNotificacion(String idiomaNotificacion) {
		this.idiomaNotificacion = idiomaNotificacion;
	}

	/**
	 * @return the textoNotificacion
	 */
	public String getTextoNotificacion() {
		return textoNotificacion;
	}

	/**
	 * @param textoNotificacion
	 *            the textoNotificacion to set
	 */
	public void setTextoNotificacion(String textoNotificacion) {
		this.textoNotificacion = textoNotificacion;
	}

	/**
	 * @return the documentosAdjuntos
	 */
	public List<Documento> getDocumentosAdjuntos() {
		return documentosAdjuntos;
	}

	/**
	 * @param documentosAdjuntos
	 *            the documentosAdjuntos to set
	 */
	public void setDocumentosAdjuntos(List<Documento> documentosAdjuntos) {
		this.documentosAdjuntos = documentosAdjuntos;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the idTipoNotificacion
	 */
	public String getIdTipoNotificacion() {
		return idTipoNotificacion;
	}

	/**
	 * @param idTipoNotificacion
	 *            the idTipoNotificacion to set
	 */
	public void setIdTipoNotificacion(String idTipoNotificacion) {
		this.idTipoNotificacion = idTipoNotificacion;
	}

	/**
	 * @return the descTipoNotificacion
	 */
	public String getDescTipoNotificacion() {
		return descTipoNotificacion;
	}

	/**
	 * @param descTipoNotificacion
	 *            the descTipoNotificacion to set
	 */
	public void setDescTipoNotificacion(String descTipoNotificacion) {
		this.descTipoNotificacion = descTipoNotificacion;
	}

	/**
	 * @return the sender
	 */
	public DatosPersona getSender() {
		return sender;
	}

	/**
	 * @param sender
	 *            the sender to set
	 */
	public void setSender(DatosPersona sender) {
		this.sender = sender;
	}

	/**
	 * @return the ejercicio
	 */
	public String getEjercicio() {
		return ejercicio;
	}

	/**
	 * @param ejercicio
	 *            the ejercicio to set
	 */
	public void setEjercicio(String ejercicio) {
		this.ejercicio = ejercicio;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "CrearNotifEJGV [serieDocumental=" + serieDocumental
				+ ", idExpediente=" + idExpediente + ", numeroExpediente="
				+ numeroExpediente + ", ejercicio=" + ejercicio
				+ ", solicitante=" + solicitante + ", sender=" + sender
				+ ", idTipoNotificacion=" + idTipoNotificacion
				+ ", descTipoNotificacion=" + descTipoNotificacion
				+ ", idiomaNotificacion=" + idiomaNotificacion
				+ ", textoNotificacion=" + textoNotificacion
				+ ", documentosAdjuntos=" + documentosAdjuntos + ", procedure="
				+ procedure + "]";
	}

}
