package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto CrearEJGV.
 * 
 *  
 */

public class CrearEJGV implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	// El numero de expediente
	private String numeroExpediente;

	// Los datos del solicitante
	private DatosPersona solicitante;

	// Los datos del respesentante si los hubiera
	private DatosPersona representante;

	// El tipo de notificacion:Como se desea recibir las notificaciones.
	// 2:postal,1:telemáticas
	private String tipoNotificacion;

	// El idioma de la notificacio:Idioma en que se desea recibir las
	// notificaciones. ES:castellano, EU:euskara
	private String idiomaNotificacion;

	// Los datos postales de la notificacion
	private NotificacionPostal notificacionPostal;

	private DatosRegistro datosRegistro;

	// Los documentos de la solicitud
	private List<Documento> documentosAdjuntos = new ArrayList<Documento>();

	private Procedure procedure;

	private Map mapaSolicitud = new LinkedHashMap();

	/**
	 * 
	 */
	public CrearEJGV() {
		super();
	}

	/**
	 * @param idExpediente
	 * @param numeroExpediente
	 * @param solicitante
	 * @param representante
	 * @param tipoNotificacion
	 * @param idiomaNotificacion
	 * @param notificacionPostal
	 * @param datosRegistro
	 * @param documentosAdjuntos
	 * @param procedure
	 */
	public CrearEJGV(String idExpediente, String numeroExpediente,
			DatosPersona solicitante, DatosPersona representante,
			String tipoNotificacion, String idiomaNotificacion,
			NotificacionPostal notificacionPostal, DatosRegistro datosRegistro,
			List<Documento> documentosAdjuntos, Procedure procedure) {
		super();
		this.idExpediente = idExpediente;
		this.numeroExpediente = numeroExpediente;
		this.solicitante = solicitante;
		this.representante = representante;
		this.tipoNotificacion = tipoNotificacion;
		this.idiomaNotificacion = idiomaNotificacion;
		this.notificacionPostal = notificacionPostal;
		this.datosRegistro = datosRegistro;
		this.documentosAdjuntos = documentosAdjuntos;
		this.procedure = procedure;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(DatosPersona solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the representante
	 */
	public DatosPersona getRepresentante() {
		return representante;
	}

	/**
	 * @param representante
	 *            the representante to set
	 */
	public void setRepresentante(DatosPersona representante) {
		this.representante = representante;
	}

	/**
	 * @return the tipoNotificacion
	 */
	public String getTipoNotificacion() {
		return tipoNotificacion;
	}

	/**
	 * @param tipoNotificacion
	 *            the tipoNotificacion to set
	 */
	public void setTipoNotificacion(String tipoNotificacion) {
		this.tipoNotificacion = tipoNotificacion;
	}

	/**
	 * @return the idiomaNotificacion
	 */
	public String getIdiomaNotificacion() {
		return idiomaNotificacion;
	}

	/**
	 * @param idiomaNotificacion
	 *            the idiomaNotificacion to set
	 */
	public void setIdiomaNotificacion(String idiomaNotificacion) {
		this.idiomaNotificacion = idiomaNotificacion;
	}

	/**
	 * @return the notificacionPostal
	 */
	public NotificacionPostal getNotificacionPostal() {
		return notificacionPostal;
	}

	/**
	 * @param notificacionPostal
	 *            the notificacionPostal to set
	 */
	public void setNotificacionPostal(NotificacionPostal notificacionPostal) {
		this.notificacionPostal = notificacionPostal;
	}

	/**
	 * @return the datosRegistro
	 */
	public DatosRegistro getDatosRegistro() {
		return datosRegistro;
	}

	/**
	 * @param datosRegistro
	 *            the datosRegistro to set
	 */
	public void setDatosRegistro(DatosRegistro datosRegistro) {
		this.datosRegistro = datosRegistro;
	}

	/**
	 * @return the documentosAdjuntos
	 */
	public List<Documento> getDocumentosAdjuntos() {
		return documentosAdjuntos;
	}

	/**
	 * @param documentosAdjuntos
	 *            the documentosAdjuntos to set
	 */
	public void setDocumentosAdjuntos(List<Documento> documentosAdjuntos) {
		this.documentosAdjuntos = documentosAdjuntos;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the mapaSolicitud
	 */
	public Map getMapaSolicitud() {
		return mapaSolicitud;
	}

	/**
	 * @param mapaSolicitud
	 *            the mapaSolicitud to set
	 */
	public void setMapaSolicitud(Map mapaSolicitud) {
		this.mapaSolicitud = mapaSolicitud;
	}

	/**
	 * 
	 * @param key
	 *            the key
	 * @param value
	 *            the value
	 */
	public void anyadirCampoSolicitud(final String key, final String value) {
		if (value == null) {
			this.mapaSolicitud.put(key, "");
		} else {
			this.mapaSolicitud.put(key, value);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "CrearEJGV [idExpediente=" + idExpediente
				+ ", numeroExpediente=" + numeroExpediente + ", solicitante="
				+ solicitante + ", representante=" + representante
				+ ", tipoNotificacion=" + tipoNotificacion
				+ ", idiomaNotificacion=" + idiomaNotificacion
				+ ", notificacionPostal=" + notificacionPostal
				+ ", datosRegistro=" + datosRegistro + ", documentosAdjuntos="
				+ documentosAdjuntos + ", procedure=" + procedure
				+ ", mapaSolicitud=" + mapaSolicitud + "]";
	}

}
