package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto MensajeAportacionDocumentacion.
 * 
 *  
 */

public class AportacionDocumentacion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Fecha aportacion
	private Date fechaAportacion;

	// Los documentos de la aportacion
	private List<Documento> documentosAportados = new ArrayList<Documento>();

	/**
	 * @return the fechaAportacion
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaAportacion() {
		return fechaAportacion;
	}

	/**
	 * @param fechaAportacion
	 *            the fechaAportacion to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaAportacion(Date fechaAportacion) {
		this.fechaAportacion = fechaAportacion;
	}

	/**
	 * @return the documentosAportados
	 */
	public List<Documento> getDocumentosAportados() {
		return documentosAportados;
	}

	/**
	 * @param documentosAportados
	 *            the documentosAportados to set
	 */
	public void setDocumentosAportados(List<Documento> documentosAportados) {
		this.documentosAportados = documentosAportados;
	}

}
