package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.ejie.y41b.model.dokusi.Documento;

/**
 * Objeto ActualizarMisGestiones.
 * 
 *  
 */
public class ActualizarMisGestiones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	// El ejercicio
	private String ejercicio;

	// El numero de expediente
	private String numeroExpediente;

	private String idParticipacion;

	// Los datos del solicitante
	private DatosPersona solicitante;

	// Los datos del respesentante si los hubiera
	private DatosPersona representante;

	// El tipo de notificacion:Como se desea recibir las notificaciones.
	// 2:postal,1:telemáticas
	private String tipoNotificacion;

	// El idioma de la notificacio:Idioma en que se desea recibir las
	// notificaciones. ES:castellano, EU:euskara
	private String idiomaNotificacion;

	// Los datos postales de la notificacion
	private NotificacionPostal notificacionPostal;

	private DatosRegistro datosRegistro;

	private String proceedingsID;

	private String idnotificacionplatea;

	private String idTiponotificacionplatea;

	private Calendar notificacionPublicationTimestamp;
	private Calendar notificacionDeliveryTimestamp;

	private String situacionNotificacionAcuseRecibo;

	private String descripcionTramiteCas;
	private String descripcionTramiteEus;

	private String decisionCas;
	private String decisionEus;

	private Calendar decisionTimestamp;

	private Calendar aportacionTimestamp;

	// Los documentos de la solicitud
	private List<Documento> documentos = new ArrayList<Documento>();

	private Procedure procedure;

	/**
	 * 
	 */
	public ActualizarMisGestiones() {
		super();
	}

	/**
	 * @param idExpediente
	 * @param numeroExpediente
	 * @param solicitante
	 * @param representante
	 * @param tipoNotificacion
	 * @param idiomaNotificacion
	 * @param notificacionPostal
	 * @param datosRegistro
	 * @param documentos
	 * @param procedure
	 */
	public ActualizarMisGestiones(String idExpediente, String numeroExpediente,
			DatosPersona solicitante, DatosPersona representante,
			String tipoNotificacion, String idiomaNotificacion,
			NotificacionPostal notificacionPostal, DatosRegistro datosRegistro,
			List<Documento> documentos, Procedure procedure) {
		super();
		this.idExpediente = idExpediente;
		this.numeroExpediente = numeroExpediente;
		this.solicitante = solicitante;
		this.representante = representante;
		this.tipoNotificacion = tipoNotificacion;
		this.idiomaNotificacion = idiomaNotificacion;
		this.notificacionPostal = notificacionPostal;
		this.datosRegistro = datosRegistro;
		this.documentos = documentos;
		this.procedure = procedure;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(DatosPersona solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the representante
	 */
	public DatosPersona getRepresentante() {
		return representante;
	}

	/**
	 * @param representante
	 *            the representante to set
	 */
	public void setRepresentante(DatosPersona representante) {
		this.representante = representante;
	}

	/**
	 * @return the tipoNotificacion
	 */
	public String getTipoNotificacion() {
		return tipoNotificacion;
	}

	/**
	 * @param tipoNotificacion
	 *            the tipoNotificacion to set
	 */
	public void setTipoNotificacion(String tipoNotificacion) {
		this.tipoNotificacion = tipoNotificacion;
	}

	/**
	 * @return the idiomaNotificacion
	 */
	public String getIdiomaNotificacion() {
		return idiomaNotificacion;
	}

	/**
	 * @param idiomaNotificacion
	 *            the idiomaNotificacion to set
	 */
	public void setIdiomaNotificacion(String idiomaNotificacion) {
		this.idiomaNotificacion = idiomaNotificacion;
	}

	/**
	 * @return the notificacionPostal
	 */
	public NotificacionPostal getNotificacionPostal() {
		return notificacionPostal;
	}

	/**
	 * @param notificacionPostal
	 *            the notificacionPostal to set
	 */
	public void setNotificacionPostal(NotificacionPostal notificacionPostal) {
		this.notificacionPostal = notificacionPostal;
	}

	/**
	 * @return the datosRegistro
	 */
	public DatosRegistro getDatosRegistro() {
		return datosRegistro;
	}

	/**
	 * @param datosRegistro
	 *            the datosRegistro to set
	 */
	public void setDatosRegistro(DatosRegistro datosRegistro) {
		this.datosRegistro = datosRegistro;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the ejercicio
	 */
	public String getEjercicio() {
		return ejercicio;
	}

	/**
	 * @param ejercicio
	 *            the ejercicio to set
	 */
	public void setEjercicio(String ejercicio) {
		this.ejercicio = ejercicio;
	}

	/**
	 * @return the documentos
	 */
	public List<Documento> getDocumentos() {
		return documentos;
	}

	/**
	 * @param documentos
	 *            the documentos to set
	 */
	public void setDocumentos(List<Documento> documentos) {
		this.documentos = documentos;
	}

	/**
	 * @return the proceedingsID
	 */
	public String getProceedingsID() {
		return proceedingsID;
	}

	/**
	 * @param proceedingsID
	 *            the proceedingsID to set
	 */
	public void setProceedingsID(String proceedingsID) {
		this.proceedingsID = proceedingsID;
	}

	/**
	 * @return the idnotificacionplatea
	 */
	public String getIdnotificacionplatea() {
		return idnotificacionplatea;
	}

	/**
	 * @param idnotificacionplatea
	 *            the idnotificacionplatea to set
	 */
	public void setIdnotificacionplatea(String idnotificacionplatea) {
		this.idnotificacionplatea = idnotificacionplatea;
	}

	/**
	 * @return the idTiponotificacionplatea
	 */
	public String getIdTiponotificacionplatea() {
		return idTiponotificacionplatea;
	}

	/**
	 * @param idTiponotificacionplatea
	 *            the idTiponotificacionplatea to set
	 */
	public void setIdTiponotificacionplatea(String idTiponotificacionplatea) {
		this.idTiponotificacionplatea = idTiponotificacionplatea;
	}

	/**
	 * @return the notificacionPublicationTimestamp
	 */
	public Calendar getNotificacionPublicationTimestamp() {
		return notificacionPublicationTimestamp;
	}

	/**
	 * @param notificacionPublicationTimestamp
	 *            the notificacionPublicationTimestamp to set
	 */
	public void setNotificacionPublicationTimestamp(
			Calendar notificacionPublicationTimestamp) {
		this.notificacionPublicationTimestamp = notificacionPublicationTimestamp;
	}

	/**
	 * @return the notificacionDeliveryTimestamp
	 */
	public Calendar getNotificacionDeliveryTimestamp() {
		return notificacionDeliveryTimestamp;
	}

	/**
	 * @param notificacionDeliveryTimestamp
	 *            the notificacionDeliveryTimestamp to set
	 */
	public void setNotificacionDeliveryTimestamp(
			Calendar notificacionDeliveryTimestamp) {
		this.notificacionDeliveryTimestamp = notificacionDeliveryTimestamp;
	}

	/**
	 * @return the situacionNotificacionAcuseRecibo
	 */
	public String getSituacionNotificacionAcuseRecibo() {
		return situacionNotificacionAcuseRecibo;
	}

	/**
	 * @param situacionNotificacionAcuseRecibo
	 *            the situacionNotificacionAcuseRecibo to set
	 */
	public void setSituacionNotificacionAcuseRecibo(
			String situacionNotificacionAcuseRecibo) {
		this.situacionNotificacionAcuseRecibo = situacionNotificacionAcuseRecibo;
	}

	/**
	 * @return the descripcionTramiteCas
	 */
	public String getDescripcionTramiteCas() {
		return descripcionTramiteCas;
	}

	/**
	 * @param descripcionTramiteCas
	 *            the descripcionTramiteCas to set
	 */
	public void setDescripcionTramiteCas(String descripcionTramiteCas) {
		this.descripcionTramiteCas = descripcionTramiteCas;
	}

	/**
	 * @return the descripcionTramiteEus
	 */
	public String getDescripcionTramiteEus() {
		return descripcionTramiteEus;
	}

	/**
	 * @param descripcionTramiteEus
	 *            the descripcionTramiteEus to set
	 */
	public void setDescripcionTramiteEus(String descripcionTramiteEus) {
		this.descripcionTramiteEus = descripcionTramiteEus;
	}

	/**
	 * @return the decisionCas
	 */
	public String getDecisionCas() {
		return decisionCas;
	}

	/**
	 * @param decisionCas
	 *            the decisionCas to set
	 */
	public void setDecisionCas(String decisionCas) {
		this.decisionCas = decisionCas;
	}

	/**
	 * @return the decisionEus
	 */
	public String getDecisionEus() {
		return decisionEus;
	}

	/**
	 * @param decisionEus
	 *            the decisionEus to set
	 */
	public void setDecisionEus(String decisionEus) {
		this.decisionEus = decisionEus;
	}

	/**
	 * @return the decisionTimestamp
	 */
	public Calendar getDecisionTimestamp() {
		return decisionTimestamp;
	}

	/**
	 * @param decisionTimestamp
	 *            the decisionTimestamp to set
	 */
	public void setDecisionTimestamp(Calendar decisionTimestamp) {
		this.decisionTimestamp = decisionTimestamp;
	}

	/**
	 * @return the aportacionTimestamp
	 */
	public Calendar getAportacionTimestamp() {
		return aportacionTimestamp;
	}

	/**
	 * @param aportacionTimestamp
	 *            the aportacionTimestamp to set
	 */
	public void setAportacionTimestamp(Calendar aportacionTimestamp) {
		this.aportacionTimestamp = aportacionTimestamp;
	}

        /**
	 * @return the idParticipacion
	 */
	public String getIdParticipacion() {
		return idParticipacion;
	}

	/**
	 * @param idParticipacion
	 *            the idParticipacion to set
	 */
	public void setIdParticipacion(String idParticipacion) {
		this.idParticipacion = idParticipacion;
	}

}
