package com.ejie.y41b.model.platea;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * Objeto ActualizarExpediente.
 * 
 *  
 */
public class ActualizarExpediente implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// ID del expediente en BBDD (L21)
	private String idExpediente;

	// El ejercicio
	private String ejercicio;

	// El numero de expediente
	private String numeroExpediente;

	private String idParticipacion;
	private String idParticipacionInteresado;

	// Los datos del solicitante
	private DatosPersona solicitante;

	// los datos de otro interesado
	private DatosPersona interesado;

	// Los datos del respesentante si los hubiera
	private DatosPersona representante;

	// Los datos del respesentante si los hubiera
	private DatosPersona representanteInteresado;

	// El tipo de notificacion:Como se desea recibir las notificaciones.
	// 2:postal,1:telemáticas
	private String tipoNotificacion;

	// El idioma de la notificacio:Idioma en que se desea recibir las
	// notificaciones. ES:castellano, EU:euskara
	private String idiomaNotificacion;

	// El idioma de la notificacio:Idioma en que se desea recibir las
	// notificaciones. ES:castellano, EU:euskara
	private String idiomaNotificacionInteresado;

	// Los datos postales de la notificacion
	private NotificacionPostal notificacionPostal;

	private DatosRegistro datosRegistro;

	private Calendar startTimestamp;

	// Tramites expediente
	private List<Proceedings> proceedings = new ArrayList<Proceedings>();

	// Tramites expediente
	private List<Proceedings> proceedingsInteresado = new ArrayList<Proceedings>();

	private Procedure procedure;

	// Los datos del respesentante si los hubiera
	private DatosPersona sender;

	/**
	 * 
	 */
	public ActualizarExpediente() {
		super();
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the solicitante
	 */
	public DatosPersona getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(DatosPersona solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the representante
	 */
	public DatosPersona getRepresentante() {
		return representante;
	}

	/**
	 * @param representante
	 *            the representante to set
	 */
	public void setRepresentante(DatosPersona representante) {
		this.representante = representante;
	}

	/**
	 * @return the tipoNotificacion
	 */
	public String getTipoNotificacion() {
		return tipoNotificacion;
	}

	/**
	 * @param tipoNotificacion
	 *            the tipoNotificacion to set
	 */
	public void setTipoNotificacion(String tipoNotificacion) {
		this.tipoNotificacion = tipoNotificacion;
	}

	/**
	 * @return the idiomaNotificacion
	 */
	public String getIdiomaNotificacion() {
		return idiomaNotificacion;
	}

	/**
	 * @param idiomaNotificacion
	 *            the idiomaNotificacion to set
	 */
	public void setIdiomaNotificacion(String idiomaNotificacion) {
		this.idiomaNotificacion = idiomaNotificacion;
	}

	/**
	 * @return the notificacionPostal
	 */
	public NotificacionPostal getNotificacionPostal() {
		return notificacionPostal;
	}

	/**
	 * @param notificacionPostal
	 *            the notificacionPostal to set
	 */
	public void setNotificacionPostal(NotificacionPostal notificacionPostal) {
		this.notificacionPostal = notificacionPostal;
	}

	/**
	 * @return the datosRegistro
	 */
	public DatosRegistro getDatosRegistro() {
		return datosRegistro;
	}

	/**
	 * @param datosRegistro
	 *            the datosRegistro to set
	 */
	public void setDatosRegistro(DatosRegistro datosRegistro) {
		this.datosRegistro = datosRegistro;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the idExpediente
	 */
	public String getIdExpediente() {
		return idExpediente;
	}

	/**
	 * @param idExpediente
	 *            the idExpediente to set
	 */
	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * @return the ejercicio
	 */
	public String getEjercicio() {
		return ejercicio;
	}

	/**
	 * @param ejercicio
	 *            the ejercicio to set
	 */
	public void setEjercicio(String ejercicio) {
		this.ejercicio = ejercicio;
	}

	/**
	 * @return the proceedings
	 */
	public List<Proceedings> getProceedings() {
		return proceedings;
	}

	/**
	 * @param proceedings
	 *            the proceedings to set
	 */
	public void setProceedings(List<Proceedings> proceedings) {
		this.proceedings = proceedings;
	}

	/**
	 * @return the proceedings
	 */
	public List<Proceedings> getProceedingsInteresado() {
		return proceedingsInteresado;
	}

	/**
	 * @param proceedings
	 *            the proceedings to set
	 */
	public void setProceedingsInteresado(List<Proceedings> proceedingsInteresado) {
		this.proceedingsInteresado = proceedingsInteresado;
	}

	/**
	 * @return the startTimestamp
	 */
	public Calendar getStartTimestamp() {
		return startTimestamp;
	}

	/**
	 * @param startTimestamp
	 *            the startTimestamp to set
	 */
	public void setStartTimestamp(Calendar startTimestamp) {
		this.startTimestamp = startTimestamp;
	}

	/**
	 * @return the sender
	 */
	public DatosPersona getSender() {
		return sender;
	}

	/**
	 * @param sender
	 *            the sender to set
	 */
	public void setSender(DatosPersona sender) {
		this.sender = sender;
	}

	/**
	 * @return the interesado
	 */
	public DatosPersona getInteresado() {
		return interesado;
	}

	/**
	 * @param interesado
	 *            the interesado to set
	 */
	public void setInteresado(DatosPersona interesado) {
		this.interesado = interesado;
	}

	/**
	 * @return the representanteInteresado
	 */
	public DatosPersona getRepresentanteInteresado() {
		return representanteInteresado;
	}

	/**
	 * @param representanteInteresado
	 *            the representanteInteresado to set
	 */
	public void setRepresentanteInteresado(DatosPersona representanteInteresado) {
		this.representanteInteresado = representanteInteresado;
	}

	/**
	 * @return the idiomaNotificacionInteresado
	 */
	public String getIdiomaNotificacionInteresado() {
		return idiomaNotificacionInteresado;
	}

	/**
	 * @param idiomaNotificacionInteresado
	 *            the idiomaNotificacionInteresado to set
	 */
	public void setIdiomaNotificacionInteresado(
			String idiomaNotificacionInteresado) {
		this.idiomaNotificacionInteresado = idiomaNotificacionInteresado;
	}

	/**
	 * @return the idParticipacion
	 */
	public String getIdParticipacion() {
		return idParticipacion;
	}

	/**
	 * @param idParticipacion
	 *            the idParticipacion to set
	 */
	public void setIdParticipacion(String idParticipacion) {
		this.idParticipacion = idParticipacion;
	}

	/**
	 * @return the idParticipacionInteresado
	 */
	public String getIdParticipacionInteresado() {
		return idParticipacionInteresado;
	}

	/**
	 * @param idParticipacionInteresado
	 *            the idParticipacionInteresado to set
	 */
	public void setIdParticipacionInteresado(String idParticipacionInteresado) {
		this.idParticipacionInteresado = idParticipacionInteresado;
	}

}
