/**
 * 
 */
package com.ejie.y41b.model.pasarela;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

import com.ejie.y41b.model.sipca.line.NumCuenta;

//import com.ejie.y12b.util.common.Y12bPlateaHelper;

/**
 * Objeto de la pasarela de pagos
 * 
 *  
 * 
 */
public class ObjPasarela implements Serializable {

	/**
	 * Serial version
	 */
	private static final long serialVersionUID = -8520159163838879367L;

	// /////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// ATRIBUTOS
	//
	// /////////////////////////////////////////////////////////////////////////////////////////////////////

	private String tipoAcceso; // 1-recibo Bancario 2- banca electronica
	private String idioma; // 1-castellano 2- euskera
	private String codTasaCast; // (73.03) Tasa de ...
	private String codTasaEusk; // (73.03) Tasa de ...
	private String referencia; // 9104000000112
	private String identificacion; // 011204 ddMMyy
	private String fechaIncioPago; // 311204 ddMMyy
	private String fechaLimitePago; // 311204 ddMMyy
	private String importe; // 12,50
	private String sufijo; // 502
	private String numExpFactura;
	private String numFactura;
	private String familiaID;
	private String formato;
	private String tipoDevengo;
	private String territorioHist;
	private String fechaLimiteAnul; // Fecha limite de anulación del pago
	private String importeIVA;
	private String tipoIVA;
	private String baseImponible;
	private String codigoConceptoIVA;

	private String fechaIncioPagoLiq;
	private String fechaLimitePagoLiq; // dd/MM/yyyy - es la que se guarda en BD
	private String fechaLimiteAnulLiq; // dd/MM/yyyy - es la que se guarda en BD

	private String codigoRecaudacion; // 9050794

	private boolean exentoPago; // true - exento de pago false - no exento

	private String entidadEmisora; // 04833001

	private String entidadEmisoraNombCast; // "Direcci�n de Juventud"
	private String entidadEmisoraNombEusk; // "Gazteria Zuzendaritza";

	private String entidadEmisoraMunicipio; // "Gazteria Zuzendaritza";

	private String conceptoAplicPresupuestaria; // 2001020914000043126232220000J

	private String conceptoCodigoIngreso; // 622

	private String datosTerceroDni; // 14611614J
	private String datosTerceroNombreCompleto; // Areizaga Sanchez, Jorge

	private String datosTerceroDireccion; // avda madariaga
	private String datosTerceroMunicipio; // bilbao
	private String datosTerceroLocalidad; // Bilbao
	private String datosTerceroProvincia; // Bizkaia
	private String datosTerceroPais; // Espa�a
	private String datosTerceroCodigoPostal; // 48014
	private String datosTerceroCodMunicipio;
	private String datosTerceroCodLocalidad;

	private String datosTerceroTelefono; // 94125412
	private String datosTerceroTextoCastTelefono; // "Tfnoa."
	private String datosTerceroTextoEuskTelefono; // "Tfno."
	private String datosTerceroEmail; // jaraizaga@bilbomatica.es
	private String datosTerceroTextoCastEmail; // "e-mail"
	private String datosTerceroTextoEuskEmail; // "e-mail"
	private String datosTerceroTextoCastNumFactura;
	private String datosTerceroTextoCastNumExp;
	private String datosTerceroTextoEuskNumFactura;
	private String datosTerceroTextoEuskNumExp;
	private String datosTerceroNombre;
	private String datosTerceroDeudorApremiable;
	private String datosTerceroResidente;
	/**
	 * Apellidos
	 */
	private String datosTerceroApellido1;
	private String datosTerceroApellido2;
	/**
	 * Tipo ident.
	 */
	private String datosTerceroTipoIdentificacion;

	private String datosTerceroCodProvincia;

	// private String mensajeCastCabecera;
	//
	// private String mensajeEuskCabecera;
	//
	// private String mensajeCastMedio;
	//
	// private String mensajeEuskMedio;
	//
	// private String mensajeCastPie;
	//
	// private String mensajeEuskPie;
	// 1254-04 . Para nosotros puede que no sea obligatorio.
	private String numeroLiquidacion;
	private String codAplicacion; // q92b
	private String nombreCastAplicacion; // escuela de deportes
	private String nombreEuskAplicacion; // Escuela de deportes
	private String responsableAplicacion; // ejie
	// private String urlVueltaApp; // url
	private String urlVueltaApp1; // url
	private String urlVueltaApp2; // url
	private String sessionID; // session id
	// numero de tercero de IKUS
	private String tercero;
	// private String urlImagenCabecera;
	// private String urlImagenMedio;

	// Evolutivo: 0207107
	// Se aaden 3 campos del objeto Pagos para crear
	// getConceptoPeticionIVAZero()
	private String codsubvencion;
	private String fechareintegro;
	private String causareintegro;

	/**
	 * Numero de cuenta
	 */
	private NumCuenta numCuenta;
	/**
	 * Ejercicio contable
	 */
	private String ejercicioContable;

	/**
	 * Numero de referencia de la fianzas para la ejecucion
	 */
	private String numReferenciaAnticipoCuenta;

	private Map<String, Map<String, String>> listamensajes;

	// //////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// CONSTRUCTORES
	//
	// //////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * 
	 */
	public ObjPasarela() {

		try {
			this.tipoAcceso = "1"; // 1-recibo Bancario 2- banca electronica
			this.idioma = "1"; // 1-castellano 2- euskera
			this.codTasaCast = null; // (73.03) Tasa de ...
			this.codTasaEusk = null; // (73.03) Tasa de ...
			this.referencia = null; // 9104000000112
			this.identificacion = null; // 011204 ddMMyy
			this.fechaIncioPago = null; // 311204 ddMMyy
			this.fechaLimitePago = null; // 311204 ddMMyy
			this.importe = null; // 12,50
			this.sufijo = null; // 502
			this.formato = null;
			this.codigoRecaudacion = null; // 9050794
			// boolean exentoPago = false; // true - exento de pago false - no
			// exento
			this.entidadEmisora = null; // 04833001

			this.conceptoAplicPresupuestaria = null; // 2001020914000043126232220000J
			this.conceptoCodigoIngreso = null; // 622

			this.datosTerceroDni = null; // 14611614J
			this.datosTerceroNombreCompleto = null; // Areizaga Sanchez, Jorge
			this.datosTerceroDireccion = null; // avda madariaga
			this.datosTerceroMunicipio = null; // bilbao
			this.datosTerceroLocalidad = null; // Bilbao
			this.datosTerceroProvincia = null; // Bizkaia
			this.datosTerceroPais = null; // Espa�a
			this.datosTerceroCodigoPostal = null; // 48014

			this.datosTerceroTelefono = null; // 94125412
			this.datosTerceroTextoCastTelefono = "Teléfono";
			this.datosTerceroTextoEuskTelefono = "Telefonoa";
			this.datosTerceroEmail = null; // jaraizaga@bilbomatica.es
			this.datosTerceroTextoCastEmail = "e-mail";
			this.datosTerceroTextoEuskEmail = "e-mail";

		} catch (Exception e) {
			// Y12bTrazas.mostrarTraza("ERROR Y12bObjPasarela");
			e.printStackTrace();
		}

	}

	// //////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// GET & SET
	//
	// //////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @return the codAplicacion
	 */
	public String getCodAplicacion() {
		return this.codAplicacion;
	}

	/**
	 * @param codAplicacion
	 *            the codAplicacion to set
	 */
	public void setCodAplicacion(String codAplicacion) {
		this.codAplicacion = codAplicacion;
	}

	/**
	 * @return the codigoRecaudacion
	 */
	public String getCodigoRecaudacion() {
		return this.codigoRecaudacion;
	}

	/**
	 * @param codigoRecaudacion
	 *            the codigoRecaudacion to set
	 */
	public void setCodigoRecaudacion(String codigoRecaudacion) {
		this.codigoRecaudacion = codigoRecaudacion;
	}

	/**
	 * @return the codTasaCast
	 */
	public String getCodTasaCast() {
		return this.codTasaCast;
	}

	/**
	 * @param codTasaCast
	 *            the codTasaCast to set
	 */
	public void setCodTasaCast(String codTasaCast) {
		this.codTasaCast = codTasaCast;
	}

	/**
	 * @return the codTasaEusk
	 */
	public String getCodTasaEusk() {
		return this.codTasaEusk;
	}

	/**
	 * @param codTasaEusk
	 *            the codTasaEusk to set
	 */
	public void setCodTasaEusk(String codTasaEusk) {
		this.codTasaEusk = codTasaEusk;
	}

	/**
	 * @return the conceptoAplicPresupuestaria
	 */
	public String getConceptoAplicPresupuestaria() {
		return this.conceptoAplicPresupuestaria;
	}

	/**
	 * @param conceptoAplicPresupuestaria
	 *            the conceptoAplicPresupuestaria to set
	 */
	public void setConceptoAplicPresupuestaria(String conceptoAplicPresupuestaria) {
		this.conceptoAplicPresupuestaria = conceptoAplicPresupuestaria;
	}

	/**
	 * @return the conceptoCodigoIngreso
	 */
	public String getConceptoCodigoIngreso() {
		return this.conceptoCodigoIngreso;
	}

	/**
	 * @param conceptoCodigoIngreso
	 *            the conceptoCodigoIngreso to set
	 */
	public void setConceptoCodigoIngreso(String conceptoCodigoIngreso) {
		this.conceptoCodigoIngreso = conceptoCodigoIngreso;
	}

	/**
	 * @return the datosTerceroCodigoPostal
	 */
	public String getDatosTerceroCodigoPostal() {
		return this.datosTerceroCodigoPostal;
	}

	/**
	 * @param datosTerceroCodigoPostal
	 *            the datosTerceroCodigoPostal to set
	 */
	public void setDatosTerceroCodigoPostal(String datosTerceroCodigoPostal) {
		this.datosTerceroCodigoPostal = datosTerceroCodigoPostal;
	}

	/**
	 * @return the datosTerceroDireccion
	 */
	public String getDatosTerceroDireccion() {
		return this.datosTerceroDireccion;
	}

	/**
	 * @param datosTerceroDireccion
	 *            the datosTerceroDireccion to set
	 */
	public void setDatosTerceroDireccion(String datosTerceroDireccion) {
		this.datosTerceroDireccion = datosTerceroDireccion;
	}

	/**
	 * @return the datosTerceroDni
	 */
	public String getDatosTerceroDni() {
		return this.datosTerceroDni;
	}

	/**
	 * @param datosTerceroDni
	 *            the datosTerceroDni to set
	 */
	public void setDatosTerceroDni(String datosTerceroDni) {
		this.datosTerceroDni = datosTerceroDni;
	}

	/**
	 * @return the datosTerceroEmail
	 */
	public String getDatosTerceroEmail() {
		return this.datosTerceroEmail;
	}

	/**
	 * @param datosTerceroEmail
	 *            the datosTerceroEmail to set
	 */
	public void setDatosTerceroEmail(String datosTerceroEmail) {
		this.datosTerceroEmail = datosTerceroEmail;
	}

	/**
	 * @return the datosTerceroLocalidad
	 */
	public String getDatosTerceroLocalidad() {
		return this.datosTerceroLocalidad;
	}

	/**
	 * @param datosTerceroLocalidad
	 *            the datosTerceroLocalidad to set
	 */
	public void setDatosTerceroLocalidad(String datosTerceroLocalidad) {
		this.datosTerceroLocalidad = datosTerceroLocalidad;
	}

	/**
	 * @return the datosTerceroMunicipio
	 */
	public String getDatosTerceroMunicipio() {
		return this.datosTerceroMunicipio;
	}

	/**
	 * @param datosTerceroMunicipio
	 *            the datosTerceroMunicipio to set
	 */
	public void setDatosTerceroMunicipio(String datosTerceroMunicipio) {
		this.datosTerceroMunicipio = datosTerceroMunicipio;
	}

	/**
	 * @return the datosTerceroNombreCompleto
	 */
	public String getDatosTerceroNombreCompleto() {
		return this.datosTerceroNombreCompleto;
	}

	/**
	 * @param datosTerceroNombreCompleto
	 *            the datosTerceroNombreCompleto to set
	 */
	public void setDatosTerceroNombreCompleto(String datosTerceroNombreCompleto) {
		this.datosTerceroNombreCompleto = datosTerceroNombreCompleto;
	}

	/**
	 * @return the datosTerceroPais
	 */
	public String getDatosTerceroPais() {
		return this.datosTerceroPais;
	}

	/**
	 * @param datosTerceroPais
	 *            the datosTerceroPais to set
	 */
	public void setDatosTerceroPais(String datosTerceroPais) {
		this.datosTerceroPais = datosTerceroPais;
	}

	/**
	 * @return the datosTerceroProvincia
	 */
	public String getDatosTerceroProvincia() {
		return this.datosTerceroProvincia;
	}

	/**
	 * @param datosTerceroProvincia
	 *            the datosTerceroProvincia to set
	 */
	public void setDatosTerceroProvincia(String datosTerceroProvincia) {
		this.datosTerceroProvincia = datosTerceroProvincia;
	}

	/**
	 * @return the datosTerceroTelefono
	 */
	public String getDatosTerceroTelefono() {
		return this.datosTerceroTelefono;
	}

	/**
	 * @param datosTerceroTelefono
	 *            the datosTerceroTelefono to set
	 */
	public void setDatosTerceroTelefono(String datosTerceroTelefono) {
		this.datosTerceroTelefono = datosTerceroTelefono;
	}

	/**
	 * @return the datosTerceroTextoCastEmail
	 */
	public String getDatosTerceroTextoCastEmail() {
		return this.datosTerceroTextoCastEmail;
	}

	/**
	 * @param datosTerceroTextoCastEmail
	 *            the datosTerceroTextoCastEmail to set
	 */
	public void setDatosTerceroTextoCastEmail(String datosTerceroTextoCastEmail) {
		this.datosTerceroTextoCastEmail = datosTerceroTextoCastEmail;
	}

	/**
	 * @return the datosTerceroTextoCastTelefono
	 */
	public String getDatosTerceroTextoCastTelefono() {
		return this.datosTerceroTextoCastTelefono;
	}

	/**
	 * @param datosTerceroTextoCastTelefono
	 *            the datosTerceroTextoCastTelefono to set
	 */
	public void setDatosTerceroTextoCastTelefono(String datosTerceroTextoCastTelefono) {
		this.datosTerceroTextoCastTelefono = datosTerceroTextoCastTelefono;
	}

	/**
	 * @return the datosTerceroTextoEuskEmail
	 */
	public String getDatosTerceroTextoEuskEmail() {
		return this.datosTerceroTextoEuskEmail;
	}

	/**
	 * @param datosTerceroTextoEuskEmail
	 *            the datosTerceroTextoEuskEmail to set
	 */
	public void setDatosTerceroTextoEuskEmail(String datosTerceroTextoEuskEmail) {
		this.datosTerceroTextoEuskEmail = datosTerceroTextoEuskEmail;
	}

	/**
	 * @return the datosTerceroTextoEuskTelefono
	 */
	public String getDatosTerceroTextoEuskTelefono() {
		return this.datosTerceroTextoEuskTelefono;
	}

	/**
	 * @param datosTerceroTextoEuskTelefono
	 *            the datosTerceroTextoEuskTelefono to set
	 */
	public void setDatosTerceroTextoEuskTelefono(String datosTerceroTextoEuskTelefono) {
		this.datosTerceroTextoEuskTelefono = datosTerceroTextoEuskTelefono;
	}

	/**
	 * @return the entidadEmisora
	 */
	public String getEntidadEmisora() {
		return this.entidadEmisora;
	}

	/**
	 * @param entidadEmisora
	 *            the entidadEmisora to set
	 */
	public void setEntidadEmisora(String entidadEmisora) {
		this.entidadEmisora = entidadEmisora;
	}

	/**
	 * @return the entidadEmisoraNombCast
	 */
	public String getEntidadEmisoraNombCast() {
		return this.entidadEmisoraNombCast;
	}

	/**
	 * @param entidadEmisoraNombCast
	 *            the entidadEmisoraNombCast to set
	 */
	public void setEntidadEmisoraNombCast(String entidadEmisoraNombCast) {
		this.entidadEmisoraNombCast = entidadEmisoraNombCast;
	}

	/**
	 * @return the entidadEmisoraNombEusk
	 */
	public String getEntidadEmisoraNombEusk() {
		return this.entidadEmisoraNombEusk;
	}

	/**
	 * @param entidadEmisoraNombEusk
	 *            the entidadEmisoraNombEusk to set
	 */
	public void setEntidadEmisoraNombEusk(String entidadEmisoraNombEusk) {
		this.entidadEmisoraNombEusk = entidadEmisoraNombEusk;
	}

	/**
	 * @return the exentoPago
	 */
	public boolean isExentoPago() {
		return this.exentoPago;
	}

	/**
	 * @param exentoPago
	 *            the exentoPago to set
	 */
	public void setExentoPago(boolean exentoPago) {
		this.exentoPago = exentoPago;
	}

	/**
	 * @return the fechaIncioPago
	 */
	public String getFechaIncioPago() {
		return this.fechaIncioPago;
	}

	/**
	 * @param fechaIncioPago
	 *            the fechaIncioPago to set
	 */
	public void setFechaIncioPago(String fechaIncioPago) {
		this.fechaIncioPago = fechaIncioPago;
	}

	/**
	 * @return the fechaLimitePago
	 */
	public String getFechaLimitePago() {
		return this.fechaLimitePago;
	}

	/**
	 * @param fechaLimitePago
	 *            the fechaLimitePago to set
	 */
	public void setFechaLimitePago(String fechaLimitePago) {
		this.fechaLimitePago = fechaLimitePago;
	}

	/**
	 * @return the identificacion
	 */
	public String getIdentificacion() {
		return this.identificacion;
	}

	/**
	 * @param identificacion
	 *            the identificacion to set
	 */
	public void setIdentificacion(String identificacion) {
		this.identificacion = identificacion;
	}

	/**
	 * @return the idioma
	 */
	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * @param idioma
	 *            the idioma to set
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * @return the importe
	 */
	public String getImporte() {
		return this.importe;
	}

	/**
	 * @param importe
	 *            the importe to set
	 */
	public void setImporte(String importe) {
		this.importe = importe;
	}

	// /**
	// * @return the mensajeCastCabecera
	// */
	// public String getMensajeCastCabecera() {
	// return this.mensajeCastCabecera;
	// }
	//
	// /**
	// * @param mensajeCastCabecera
	// * the mensajeCastCabecera to set
	// */
	// public void setMensajeCastCabecera(String mensajeCastCabecera) {
	// this.mensajeCastCabecera = mensajeCastCabecera;
	// }
	//
	// /**
	// * @return the mensajeCastMedio
	// */
	// public String getMensajeCastMedio() {
	// return this.mensajeCastMedio;
	// }
	//
	// /**
	// * @param mensajeCastMedio
	// * the mensajeCastMedio to set
	// */
	// public void setMensajeCastMedio(String mensajeCastMedio) {
	// this.mensajeCastMedio = mensajeCastMedio;
	// }
	//
	// /**
	// * @return the mensajeCastPie
	// */
	// public String getMensajeCastPie() {
	// return this.mensajeCastPie;
	// }
	//
	// /**
	// * @param mensajeCastPie
	// * the mensajeCastPie to set
	// */
	// public void setMensajeCastPie(String mensajeCastPie) {
	// this.mensajeCastPie = mensajeCastPie;
	// }
	//
	// /**
	// * @return the mensajeEuskCabecera
	// */
	// public String getMensajeEuskCabecera() {
	// return this.mensajeEuskCabecera;
	// }
	//
	// /**
	// * @param mensajeEuskCabecera
	// * the mensajeEuskCabecera to set
	// */
	// public void setMensajeEuskCabecera(String mensajeEuskCabecera) {
	// this.mensajeEuskCabecera = mensajeEuskCabecera;
	// }
	//
	// /**
	// * @return the mensajeEuskMedio
	// */
	// public String getMensajeEuskMedio() {
	// return this.mensajeEuskMedio;
	// }
	//
	// /**
	// * @param mensajeEuskMedio
	// * the mensajeEuskMedio to set
	// */
	// public void setMensajeEuskMedio(String mensajeEuskMedio) {
	// this.mensajeEuskMedio = mensajeEuskMedio;
	// }
	//
	// /**
	// * @return the mensajeEuskPie
	// */
	// public String getMensajeEuskPie() {
	// return this.mensajeEuskPie;
	// }
	//
	// /**
	// * @param mensajeEuskPie
	// * the mensajeEuskPie to set
	// */
	// public void setMensajeEuskPie(String mensajeEuskPie) {
	// this.mensajeEuskPie = mensajeEuskPie;
	// }

	/**
	 * @return the nombreCastAplicacion
	 */
	public String getNombreCastAplicacion() {
		return this.nombreCastAplicacion;
	}

	/**
	 * @param nombreCastAplicacion
	 *            the nombreCastAplicacion to set
	 */
	public void setNombreCastAplicacion(String nombreCastAplicacion) {
		this.nombreCastAplicacion = nombreCastAplicacion;
	}

	/**
	 * @return the nombreEuskAplicacion
	 */
	public String getNombreEuskAplicacion() {
		return this.nombreEuskAplicacion;
	}

	/**
	 * @param nombreEuskAplicacion
	 *            the nombreEuskAplicacion to set
	 */
	public void setNombreEuskAplicacion(String nombreEuskAplicacion) {
		this.nombreEuskAplicacion = nombreEuskAplicacion;
	}

	/**
	 * @return the numeroLiquidacion
	 */
	public String getNumeroLiquidacion() {
		return this.numeroLiquidacion;
	}

	/**
	 * @param numeroLiquidacion
	 *            the numeroLiquidacion to set
	 */
	public void setNumeroLiquidacion(String numeroLiquidacion) {
		this.numeroLiquidacion = numeroLiquidacion;
	}

	/**
	 * @return the referencia
	 */
	public String getReferencia() {
		return this.referencia;
	}

	/**
	 * @param referencia
	 *            the referencia to set
	 */
	public void setReferencia(String referencia) {
		this.referencia = referencia;
	}

	/**
	 * @return the responsableAplicacion
	 */
	public String getResponsableAplicacion() {
		return this.responsableAplicacion;
	}

	/**
	 * @param responsableAplicacion
	 *            the responsableAplicacion to set
	 */
	public void setResponsableAplicacion(String responsableAplicacion) {
		this.responsableAplicacion = responsableAplicacion;
	}

	/**
	 * @return the sessionID
	 */
	public String getSessionID() {
		return this.sessionID;
	}

	/**
	 * @param sessionID
	 *            the sessionID to set
	 */
	public void setSessionID(String sessionID) {
		this.sessionID = sessionID;
	}

	/**
	 * @return the sufijo
	 */
	public String getSufijo() {
		return this.sufijo;
	}

	/**
	 * @param sufijo
	 *            the sufijo to set
	 */
	public void setSufijo(String sufijo) {
		this.sufijo = sufijo;
	}

	/**
	 * @return the tipoAcceso
	 */
	public String getTipoAcceso() {
		return this.tipoAcceso;
	}

	/**
	 * @param tipoAcceso
	 *            the tipoAcceso to set
	 */
	public void setTipoAcceso(String tipoAcceso) {
		this.tipoAcceso = tipoAcceso;
	}

	/**
	 * @return the urlVueltaApp1
	 */
	public String getUrlVueltaApp1() {
		return this.urlVueltaApp1;
	}

	/**
	 * @return the urlVueltaApp2
	 */
	public String getUrlVueltaApp2() {
		return this.urlVueltaApp2;
	}

	/**
	 * 
	 * @param numFactura
	 *            numFactura
	 */
	public void setNumFactura(String numFactura) {
		this.numFactura = numFactura;
	}

	/**
	 * 
	 * @return numFactura
	 */
	public String getNumFactura() {
		return this.numFactura;
	}

	/**
	 * 
	 * @param numExpFactura
	 *            numExpFactura
	 */
	public void setNumExpFactura(String numExpFactura) {
		this.numExpFactura = numExpFactura;
	}

	/**
	 * 
	 * @return numExpFactura
	 */
	public String getNumExpFactura() {
		return this.numExpFactura;
	}

	/**
	 * @param familiaID
	 *            familiaID
	 */

	public void setFamiliaID(String familiaID) {
		this.familiaID = familiaID;
	}

	/**
	 * 
	 * @return familiaID
	 */
	public String getFamiliaID() {
		return this.familiaID;
	}

	/**
	 * 
	 * @param datosTerceroCodProvincia
	 *            datosTerceroCodProvincia
	 */
	public void setDatosTerceroCodProvincia(String datosTerceroCodProvincia) {
		this.datosTerceroCodProvincia = datosTerceroCodProvincia;
	}

	/**
	 * 
	 * @return datosTerceroCodProvincia
	 */
	public String getDatosTerceroCodProvincia() {
		return this.datosTerceroCodProvincia;
	}

	/**
	 * 
	 * @param formato
	 *            formato
	 */
	public void setFormato(String formato) {
		this.formato = formato;
	}

	/**
	 * 
	 * @return formato
	 */
	public String getFormato() {
		return this.formato;
	}

	/**
	 * 
	 * @param tipoDevengo
	 *            tipoDevengo
	 */
	public void setTipoDevengo(String tipoDevengo) {
		this.tipoDevengo = tipoDevengo;
	}

	/**
	 * 
	 * @return tipoDevengo
	 */
	public String getTipoDevengo() {
		return this.tipoDevengo;
	}

	/**
	 * 
	 * @param territorioHist
	 *            territorioHist
	 */
	public void setTerritorioHist(String territorioHist) {
		this.territorioHist = territorioHist;
	}

	/**
	 * 
	 * @return territorioHist
	 */
	public String getTerritorioHist() {
		return this.territorioHist;
	}

	/**
	 * 
	 * @return fechaLimiteAnul
	 */
	public String getFechaLimiteAnul() {
		return this.fechaLimiteAnul;
	}

	/**
	 * 
	 * @param fechaLimiteAnul
	 *            fechaLimiteAnul
	 */
	public void setFechaLimiteAnul(String fechaLimiteAnul) {
		this.fechaLimiteAnul = fechaLimiteAnul;
	}

	/**
	 * 
	 * @return importeIVA
	 */
	public String getImporteIVA() {
		return this.importeIVA;
	}

	/**
	 * 
	 * @param importeIVA
	 *            importeIVA
	 */
	public void setImporteIVA(String importeIVA) {
		this.importeIVA = importeIVA;
	}

	/**
	 * 
	 * @return tipoIVA
	 */
	public String getTipoIVA() {
		return this.tipoIVA;
	}

	/**
	 * 
	 * @param tipoIVA
	 *            tipoIVA
	 */
	public void setTipoIVA(String tipoIVA) {
		this.tipoIVA = tipoIVA;
	}

	/**
	 * 
	 * @return fechaLimitePagoLiq
	 */
	public String getFechaLimitePagoLiq() {
		return this.fechaLimitePagoLiq;
	}

	/**
	 * 
	 * @param fechaLimitePagoLiq
	 *            fechaLimitePagoLiq
	 */
	public void setFechaLimitePagoLiq(String fechaLimitePagoLiq) {
		this.fechaLimitePagoLiq = fechaLimitePagoLiq;
	}

	/**
	 * 
	 * @return fechaLimiteAnulLiq
	 */
	public String getFechaLimiteAnulLiq() {
		return this.fechaLimiteAnulLiq;
	}

	/**
	 * 
	 * @param fechaLimiteAnulLiq
	 *            fechaLimiteAnulLiq
	 */
	public void setFechaLimiteAnulLiq(String fechaLimiteAnulLiq) {
		this.fechaLimiteAnulLiq = fechaLimiteAnulLiq;
	}

	/**
	 * 
	 * @return datosTerceroTextoCastNumFactura
	 */
	public String getDatosTerceroTextoCastNumFactura() {
		return this.datosTerceroTextoCastNumFactura;
	}

	/**
	 * 
	 * @param datosTerceroTextoCastNumFactura
	 *            datosTerceroTextoCastNumFactura
	 */
	public void setDatosTerceroTextoCastNumFactura(String datosTerceroTextoCastNumFactura) {
		this.datosTerceroTextoCastNumFactura = datosTerceroTextoCastNumFactura;
	}

	/**
	 * 
	 * @return datosTerceroTextoCastNumExp
	 */
	public String getDatosTerceroTextoCastNumExp() {
		return this.datosTerceroTextoCastNumExp;
	}

	/**
	 * 
	 * @param datosTerceroTextoCastNumExp
	 *            datosTerceroTextoCastNumExp
	 */
	public void setDatosTerceroTextoCastNumExp(String datosTerceroTextoCastNumExp) {
		this.datosTerceroTextoCastNumExp = datosTerceroTextoCastNumExp;
	}

	/**
	 * 
	 * @return datosTerceroTextoEuskNumFactura
	 */
	public String getDatosTerceroTextoEuskNumFactura() {
		return this.datosTerceroTextoEuskNumFactura;
	}

	/**
	 * 
	 * @param datosTerceroTextoEuskNumFactura
	 *            datosTerceroTextoEuskNumFactura
	 */
	public void setDatosTerceroTextoEuskNumFactura(String datosTerceroTextoEuskNumFactura) {
		this.datosTerceroTextoEuskNumFactura = datosTerceroTextoEuskNumFactura;
	}

	/**
	 * 
	 * @return datosTerceroTextoEuskNumExp
	 */
	public String getDatosTerceroTextoEuskNumExp() {
		return this.datosTerceroTextoEuskNumExp;
	}

	/**
	 * 
	 * @param datosTerceroTextoEuskNumExp
	 *            datosTerceroTextoEuskNumExp
	 */
	public void setDatosTerceroTextoEuskNumExp(String datosTerceroTextoEuskNumExp) {
		this.datosTerceroTextoEuskNumExp = datosTerceroTextoEuskNumExp;
	}

	/**
	 * @param numCuenta
	 *            the numCuenta to set
	 */
	public void setNumCuenta(NumCuenta numCuenta) {
		this.numCuenta = numCuenta;
	}

	/**
	 * @return the numCuenta
	 */
	public NumCuenta getNumCuenta() {
		return this.numCuenta;
	}

	/**
	 * @param ejercicioContable
	 *            the ejercicioContable to set
	 */
	public void setEjercicioContable(String ejercicioContable) {
		this.ejercicioContable = ejercicioContable;
	}

	/**
	 * @return the ejercicioContable
	 */
	public String getEjercicioContable() {
		return this.ejercicioContable;
	}

	/**
	 * @param datosTerceroApellido1
	 *            the datosTerceroApellido1 to set
	 */
	public void setDatosTerceroApellido1(String datosTerceroApellido1) {
		this.datosTerceroApellido1 = datosTerceroApellido1;
	}

	/**
	 * @return the datosTerceroApellido1
	 */
	public String getDatosTerceroApellido1() {
		return this.datosTerceroApellido1;
	}

	/**
	 * @param datosTerceroApellido2
	 *            the datosTerceroApellido2 to set
	 */
	public void setDatosTerceroApellido2(String datosTerceroApellido2) {
		this.datosTerceroApellido2 = datosTerceroApellido2;
	}

	/**
	 * @return the datosTerceroApellido2
	 */
	public String getDatosTerceroApellido2() {
		return this.datosTerceroApellido2;
	}

	/**
	 * @param datosTerceroTipoIdentificacion
	 *            the datosTerceroTipoIdentificacion to set
	 */
	public void setDatosTerceroTipoIdentificacion(String datosTerceroTipoIdentificacion) {
		this.datosTerceroTipoIdentificacion = datosTerceroTipoIdentificacion;
	}

	/**
	 * @return the datosTerceroTipoIdentificacion
	 */
	public String getDatosTerceroTipoIdentificacion() {
		return this.datosTerceroTipoIdentificacion;
	}

	/**
	 * @param baseImponible
	 *            the baseImponible to set
	 */
	public void setBaseImponible(String baseImponible) {
		this.baseImponible = baseImponible;
	}

	/**
	 * @return the baseImponible
	 */
	public String getBaseImponible() {
		return this.baseImponible;
	}

	/**
	 * @param codigoConceptoIVA
	 *            the codigoConceptoIVA to set
	 */
	public void setCodigoConceptoIVA(String codigoConceptoIVA) {
		this.codigoConceptoIVA = codigoConceptoIVA;
	}

	/**
	 * @return the codigoConceptoIVA
	 */
	public String getCodigoConceptoIVA() {
		return this.codigoConceptoIVA;
	}

	/**
	 * @param fechaIncioPagoLiq
	 *            the fechaIncioPagoLiq to set
	 */
	public void setFechaIncioPagoLiq(String fechaIncioPagoLiq) {
		this.fechaIncioPagoLiq = fechaIncioPagoLiq;
	}

	/**
	 * @return the fechaIncioPagoLiq
	 */
	public String getFechaIncioPagoLiq() {
		return this.fechaIncioPagoLiq;
	}

	/**
	 * @param numReferenciaAnticipoCuenta
	 *            the numReferenciaAnticipoCuenta to set
	 */
	public void setNumReferenciaAnticipoCuenta(String numReferenciaAnticipoCuenta) {
		this.numReferenciaAnticipoCuenta = numReferenciaAnticipoCuenta;
	}

	/**
	 * @return the numReferenciaAnticipoCuenta
	 */
	public String getNumReferenciaAnticipoCuenta() {
		return this.numReferenciaAnticipoCuenta;
	}

	/**
	 * @param tercero
	 *            the tercero to set
	 */
	public void setTercero(String tercero) {
		this.tercero = tercero;
	}

	/**
	 * @return the tercero
	 */
	public String getTercero() {
		return this.tercero;
	}

	/**
	 * @param datosTerceroNombre
	 *            the datosTerceroNombre to set
	 */
	public void setDatosTerceroNombre(String datosTerceroNombre) {
		this.datosTerceroNombre = datosTerceroNombre;
	}

	/**
	 * @return the datosTerceroNombre
	 */
	public String getDatosTerceroNombre() {
		return this.datosTerceroNombre;
	}

	/**
	 * @param datosTerceroDeudorApremiable
	 *            the datosTerceroDeudorApremiable to set
	 */
	public void setDatosTerceroDeudorApremiable(String datosTerceroDeudorApremiable) {
		this.datosTerceroDeudorApremiable = datosTerceroDeudorApremiable;
	}

	/**
	 * @return the datosTerceroDeudorApremiable
	 */
	public String getDatosTerceroDeudorApremiable() {
		return this.datosTerceroDeudorApremiable;
	}

	/**
	 * @return the datosTerceroResidente
	 */
	public String getDatosTerceroResidente() {
		return this.datosTerceroResidente;
	}

	/**
	 * @param datosTerceroResidente
	 *            the datosTerceroResidente to set
	 */
	public void setDatosTerceroResidente(String datosTerceroResidente) {
		this.datosTerceroResidente = datosTerceroResidente;
	}

	/**
	 * @return the datosTerceroCodMunicipio
	 */
	public String getDatosTerceroCodMunicipio() {
		return this.datosTerceroCodMunicipio;
	}

	/**
	 * @param datosTerceroCodMunicipio
	 *            the datosTerceroCodMunicipio to set
	 */
	public void setDatosTerceroCodMunicipio(String datosTerceroCodMunicipio) {
		this.datosTerceroCodMunicipio = datosTerceroCodMunicipio;
	}

	/**
	 * @return the datosTerceroCodLocalidad
	 */
	public String getDatosTerceroCodLocalidad() {
		return this.datosTerceroCodLocalidad;
	}

	/**
	 * @param datosTerceroCodLocalidad
	 *            the datosTerceroCodLocalidad to set
	 */
	public void setDatosTerceroCodLocalidad(String datosTerceroCodLocalidad) {
		this.datosTerceroCodLocalidad = datosTerceroCodLocalidad;
	}

	/**
	 * @return the listamensajes
	 */
	public Map<String, Map<String, String>> getListamensajes() {
		return listamensajes;
	}

	/**
	 * @param listamensajes
	 *            the listamensajes to set
	 */
	public void setListamensajes(Map<String, Map<String, String>> listamensajes) {
		this.listamensajes = listamensajes;
	}

	/**
	 * @return the entidadEmisoraMunicipio
	 */
	public String getEntidadEmisoraMunicipio() {
		return entidadEmisoraMunicipio;
	}

	/**
	 * @param entidadEmisoraMunicipio
	 *            the entidadEmisoraMunicipio to set
	 */
	public void setEntidadEmisoraMunicipio(String entidadEmisoraMunicipio) {
		this.entidadEmisoraMunicipio = entidadEmisoraMunicipio;
	}

	/**
	 * @return the codsubvencion
	 */
	public String getCodsubvencion() {
		return codsubvencion;
	}

	/**
	 * @param codsubvencion
	 *            the codsubvencion to set
	 */
	public void setCodsubvencion(String codsubvencion) {
		this.codsubvencion = codsubvencion;
	}

	/**
	 * @return the fechareintegro
	 */
	public String getFechareintegro() {
		return fechareintegro;
	}

	/**
	 * @param fechareintegro
	 *            the fechareintegro to set
	 */
	public void setFechareintegro(String fechareintegro) {
		this.fechareintegro = fechareintegro;
	}

	/**
	 * @return the causareintegro
	 */
	public String getCausareintegro() {
		return causareintegro;
	}

	/**
	 * @param causareintegro
	 *            the causareintegro to set
	 */
	public void setCausareintegro(String causareintegro) {
		this.causareintegro = causareintegro;
	}

}
