package com.ejie.y41b.model.dokusi;

import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.dokusi.Metadato;
import com.ejie.y41b.model.platea.Procedure;

/**
 * Objeto DatosPersona.
 * 
 *  
 */

public class Documento implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Id de Documento en BBDD
	private String idDocumento;
	// Oid de Dokusi
	private String oidDokusi;
	// Tipologia documental (ej. ejgv_d_archivo)
	private String tipoDocumental;
	private String tipoDocumento;
	private String descripcion;
	private String nombre;
	private String extension;
	// Bytes del documento en Base64
	private String bytes;

	// Content type del documento
	private String contentType;
	// Tamaño del documento
	private long length;

	// Indicar de borrado de todas las versiones del documento
	// True: borrar todas las versiones
	// False: borrar la versión indicada en el identificador
	private String boolAllVersions;

	// Para la modificacion del documento
	private String boolSetCurrent;
	private String saveAsVersion;

	// "CIUDADANIA" o "ADMINISTRACION" o "ORGANISMO_EXTERNO"
	private String origenDocumento;

	// El numero de expediente
	private String numeroExpediente;

	private User user;
	private Procedure procedure;
	private List<Firma> firmas = new ArrayList<Firma>();
	private List<Metadato> metadatos = new ArrayList<Metadato>();

	// Numero de registro de entrada
	private String registryNumber;
	// Fecha de registro de entrada
	private String registryTimestamp;
	// E-Entrada, S-Salida
	private String entradaSalida;
	// S-Si, N-No
	private String tieneLocalizador;

	// S-Si, N-No
	private String nolocalizable;

	// Path del documento en PIF
	private String pifId;

	private String tsaSerialNumber;

	private String naturaleza;

	/**
	 * 
	 */
	public Documento() {
		super();
	}

	/**
	 * @param idDocumento
	 * @param oidDokusi
	 * @param tipoDocumental
	 * @param nombre
	 * @param extension
	 * @param bytes
	 * @param origenDocumento
	 * @param numeroExpediente
	 * @param user
	 * @param procedure
	 * @param firmas
	 * @param metadatos
	 */
	public Documento(String idDocumento, String oidDokusi,
			String tipoDocumental, String nombre, String extension,
			String bytes, String origenDocumento, String numeroExpediente,
			User user, Procedure procedure, List<Firma> firmas,
			List<Metadato> metadatos) {
		super();
		this.idDocumento = idDocumento;
		this.oidDokusi = oidDokusi;
		this.tipoDocumental = tipoDocumental;
		this.nombre = nombre;
		this.extension = extension;
		this.bytes = bytes;
		this.origenDocumento = origenDocumento;
		this.numeroExpediente = numeroExpediente;
		this.user = user;
		this.procedure = procedure;
		this.firmas = firmas;
		this.metadatos = metadatos;
	}

	/**
	 * @return the idDocumento
	 */
	public String getIdDocumento() {
		return idDocumento;
	}

	/**
	 * @param idDocumento
	 *            the idDocumento to set
	 */
	public void setIdDocumento(String idDocumento) {
		this.idDocumento = idDocumento;
	}

	/**
	 * @return the oidDokusi
	 */
	public String getOidDokusi() {
		return oidDokusi;
	}

	/**
	 * @param oidDokusi
	 *            the oidDokusi to set
	 */
	public void setOidDokusi(String oidDokusi) {
		this.oidDokusi = oidDokusi;
	}

	/**
	 * @return the tipoDocumental
	 */
	public String getTipoDocumental() {
		return tipoDocumental;
	}

	/**
	 * 
	 * @return the tipoDocumental
	 */
	public String getTipoDocumentalTipoSubtipo() {
		StringBuffer str = new StringBuffer("");
		if (this.getTipoDocumental() != null
				&& this.getTipoDocumental().indexOf(".") != -1) {
			str.append(this.getTipoDocumental());
		} else {
			str.append(this.getTipoDocumental()).append(
					Y41bConstantes.TIPO_DOC_SUFIJOTIPOSUBTIPO);
		}
		return str.toString();
	}

	/**
	 * @param tipoDocumental
	 *            the tipoDocumental to set
	 */
	public void setTipoDocumental(String tipoDocumental) {
		this.tipoDocumental = tipoDocumental;
	}

	/**
	 * @return the nombre
	 */
	public String getNombre() {
		return nombre;
	}

	/**
	 * @param nombre
	 *            the nombre to set
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * @return the extension
	 */
	public String getExtension() {
		return extension;
	}

	/**
	 * @param extension
	 *            the extension to set
	 */
	public void setExtension(String extension) {
		this.extension = extension;
	}

	/**
	 * @return the bytes
	 */
	public String getBytes() {
		return bytes;
	}

	/**
	 * @param bytes
	 *            the bytes to set
	 */
	public void setBytes(String bytes) {
		this.bytes = bytes;
	}

	/**
	 * @return the user
	 */
	public User getUser() {
		return user;
	}

	/**
	 * @param user
	 *            the user to set
	 */
	public void setUser(User user) {
		this.user = user;
	}

	/**
	 * @return the procedure
	 */
	public Procedure getProcedure() {
		return procedure;
	}

	/**
	 * @param procedure
	 *            the procedure to set
	 */
	public void setProcedure(Procedure procedure) {
		this.procedure = procedure;
	}

	/**
	 * @return the firmas
	 */
	public List<Firma> getFirmas() {
		return firmas;
	}

	/**
	 * @param firmas
	 *            the firmas to set
	 */
	public void setFirmas(List<Firma> firmas) {
		this.firmas = firmas;
	}

	/**
	 * @return the metadatos
	 */
	public List<Metadato> getMetadatos() {
		return metadatos;
	}

	/**
	 * @param metadatos
	 *            the metadatos to set
	 */
	public void setMetadatos(List<Metadato> metadatos) {
		this.metadatos = metadatos;
	}

	/**
	 * @return the origenDocumento
	 */
	public String getOrigenDocumento() {
		return origenDocumento;
	}

	/**
	 * @param origenDocumento
	 *            the origenDocumento to set
	 */
	public void setOrigenDocumento(String origenDocumento) {
		this.origenDocumento = origenDocumento;
	}

	/**
	 * @return the numeroExpediente
	 */
	public String getNumeroExpediente() {
		return numeroExpediente;
	}

	/**
	 * @param numeroExpediente
	 *            the numeroExpediente to set
	 */
	public void setNumeroExpediente(String numeroExpediente) {
		this.numeroExpediente = numeroExpediente;
	}

	/**
	 * @return the contentType
	 */
	public String getContentType() {
		return contentType;
	}

	/**
	 * @param contentType
	 *            the contentType to set
	 */
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	/**
	 * @return the length
	 */
	public long getLength() {
		return length;
	}

	/**
	 * @param length
	 *            the length to set
	 */
	public void setLength(long length) {
		this.length = length;
	}

	/**
	 * @return the boolAllVersions
	 */
	public String getBoolAllVersions() {
		return boolAllVersions;
	}

	/**
	 * @param boolAllVersions
	 *            the boolAllVersions to set
	 */
	public void setBoolAllVersions(String boolAllVersions) {
		this.boolAllVersions = boolAllVersions;
	}

	/**
	 * @return the registryNumber
	 */
	public String getRegistryNumber() {
		return registryNumber;
	}

	/**
	 * @param registryNumber
	 *            the registryNumber to set
	 */
	public void setRegistryNumber(String registryNumber) {
		this.registryNumber = registryNumber;
	}

	/**
	 * @return the registryTimestamp
	 */
	public String getRegistryTimestamp() {
		return registryTimestamp;
	}

	/**
	 * @param registryTimestamp
	 *            the registryTimestamp to set
	 */
	public void setRegistryTimestamp(String registryTimestamp) {
		this.registryTimestamp = registryTimestamp;
	}

	/**
	 * @return the entradaSalida
	 */
	public String getEntradaSalida() {
		return entradaSalida;
	}

	/**
	 * @param entradaSalida
	 *            the entradaSalida to set
	 */
	public void setEntradaSalida(String entradaSalida) {
		this.entradaSalida = entradaSalida;
	}

	/**
	 * @return the tipoDocumento
	 */
	public String getTipoDocumento() {
		return tipoDocumento;
	}

	/**
	 * @param tipoDocumento
	 *            the tipoDocumento to set
	 */
	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return descripcion;
	}

	/**
	 * @param descripcion
	 *            the descripcion to set
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * @return the tieneLocalizador
	 */
	public String getTieneLocalizador() {
		return tieneLocalizador;
	}

	/**
	 * @param tieneLocalizador
	 *            the tieneLocalizador to set
	 */
	public void setTieneLocalizador(String tieneLocalizador) {
		this.tieneLocalizador = tieneLocalizador;
	}

	/**
	 * @return the boolSetCurrent
	 */
	public String getBoolSetCurrent() {
		return boolSetCurrent;
	}

	/**
	 * @param boolSetCurrent
	 *            the boolSetCurrent to set
	 */
	public void setBoolSetCurrent(String boolSetCurrent) {
		this.boolSetCurrent = boolSetCurrent;
	}

	/**
	 * @return the saveAsVersion
	 */
	public String getSaveAsVersion() {
		return saveAsVersion;
	}

	/**
	 * @param saveAsVersion
	 *            the saveAsVersion to set
	 */
	public void setSaveAsVersion(String saveAsVersion) {
		this.saveAsVersion = saveAsVersion;
	}

	/**
	 * @return the nolocalizable
	 */
	public String getNolocalizable() {
		return nolocalizable;
	}

	/**
	 * @param nolocalizable
	 *            the nolocalizable to set
	 */
	public void setNolocalizable(String nolocalizable) {
		this.nolocalizable = nolocalizable;
	}

	/**
	 * @return the pifId
	 */
	public String getPifId() {
		return pifId;
	}

	/**
	 * @param pifId
	 *            the pifId to set
	 */
	public void setPifId(String pifId) {
		this.pifId = pifId;
	}

	/**
	 * @return the tsaSerialNumber
	 */
	public String getTsaSerialNumber() {
		return tsaSerialNumber;
	}

	/**
	 * @param tsaSerialNumber
	 *            the tsaSerialNumber to set
	 */
	public void setTsaSerialNumber(String tsaSerialNumber) {
		this.tsaSerialNumber = tsaSerialNumber;
	}

	/**
	 * @return the naturaleza
	 */
	public String getNaturaleza() {
		return naturaleza;
	}

	/**
	 * @param naturaleza
	 *            the naturaleza to set
	 */
	public void setNaturaleza(String naturaleza) {
		this.naturaleza = naturaleza;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Documento [idDocumento=" + idDocumento + ", oidDokusi="
				+ oidDokusi + ", tipoDocumental=" + tipoDocumental
				+ ", tipoDocumento=" + tipoDocumento + ", descripcion="
				+ descripcion + ", nombre=" + nombre + ", extension="
				+ extension + ", bytes=" + bytes + ", contentType="
				+ contentType + ", length=" + length + ", boolAllVersions="
				+ boolAllVersions + ", boolSetCurrent=" + boolSetCurrent
				+ ", saveAsVersion=" + saveAsVersion + ", origenDocumento="
				+ origenDocumento + ", numeroExpediente=" + numeroExpediente
				+ ", user=" + user + ", procedure=" + procedure + ", firmas="
				+ firmas + ", metadatos=" + metadatos + ", registryNumber="
				+ registryNumber + ", registryTimestamp=" + registryTimestamp
				+ ", entradaSalida=" + entradaSalida + ", tieneLocalizador="
				+ tieneLocalizador + "]";
	}

}
