package com.ejie.y41b.model.arbitrajeWS;

/**
 * EstablecimientoWS  
 * 
 *  
 */

public class EstablecimientoWS implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Clave compuesta
	private String razonSocial;
	private String nombreComercial;
	private String cif;
	private String fechaAltaAdhesion;
	private String fechaAltaAdhesionEus;
	private Integer numeroAdhesion;
	private EstablecimientoDireccionWS direccionPostal;

	/**
	 * Method 'EstablecimientoWS'.
	 */
	public EstablecimientoWS() {
	}

	/**
	 * Method 'EstablecimientoWS'.
	 * 
	 * @param razonSocial
	 *            String
	 * @param nombreComercial
	 *            String
	 * @param cif
	 *            String
	 * @param fechaAltaAdhesion
	 *            String
	 * @param fechaAltaAdhesionEus
	 *            String
	 * @param numeroAdhesion
	 *            Integer
	 * @param codigoPostal
	 *            String
	 * @param idPais
	 *            String
	 * @param pais
	 *            String
	 * @param idProvincia
	 *            String
	 * @param provincia
	 *            String
	 * @param idMunicipio
	 *            String
	 * @param municipio
	 *            String
	 * @param idLocalidad
	 *            String
	 * @param localidad
	 *            String
	 * @param idCalle
	 *            String
	 * @param calle
	 *            String
	 * @param idPortal
	 *            String
	 * @param numeroPortal
	 *            String
	 * @param restoDireccion
	 *            String
	 */
	public EstablecimientoWS(String razonSocial, String nombreComercial,
			String cif, String fechaAltaAdhesion, String fechaAltaAdhesionEus,
			Integer numeroAdhesion, String codigoPostal, String idPais,
			String pais, String idProvincia, String provincia,
			String idMunicipio, String municipio, String idLocalidad,
			String localidad, String idCalle, String calle, String idPortal,
			String numeroPortal, String restoDireccion) {

		this.razonSocial = razonSocial;
		this.nombreComercial = nombreComercial;
		this.cif = cif;
		this.fechaAltaAdhesion = fechaAltaAdhesion;
		this.fechaAltaAdhesionEus = fechaAltaAdhesionEus;
		this.numeroAdhesion = numeroAdhesion;
		this.direccionPostal = new EstablecimientoDireccionWS(codigoPostal,
				idPais, pais, idProvincia, provincia, idMunicipio, municipio,
				idLocalidad, localidad, idCalle, calle, idPortal, numeroPortal,
				restoDireccion);
	}

	/**
	 * Method 'getRazonSocial'.
	 * 
	 * @return String
	 */

	public String getRazonSocial() {
		return this.razonSocial;
	}

	/**
	 * Method 'setRazonSocial'.
	 * 
	 * @param razonSocial
	 *            String
	 * @return
	 */

	public void setRazonSocial(String razonSocial) {
		this.razonSocial = razonSocial;
	}

	/**
	 * Method 'getNombreComercial'.
	 * 
	 * @return String
	 */

	public String getNombreComercial() {
		return this.nombreComercial;
	}

	/**
	 * Method 'setNombreComercial'.
	 * 
	 * @param nombreComercial
	 *            String
	 * @return
	 */

	public void setNombreComercial(String nombreComercial) {
		this.nombreComercial = nombreComercial;
	}

	/**
	 * Method 'getCif'.
	 * 
	 * @return String
	 */

	public String getCif() {
		return this.cif;
	}

	/**
	 * Method 'setCif'.
	 * 
	 * @param cif
	 *            String
	 * @return
	 */

	public void setCif(String cif) {
		this.cif = cif;
	}

	/**
	 * Method 'getFechaAltaAdhesion'.
	 * 
	 * @return String
	 */

	public String getFechaAltaAdhesion() {
		return this.fechaAltaAdhesion;
	}

	/**
	 * Method 'setFechaAltaAdhesion'.
	 * 
	 * @param fechaAltaAdhesion
	 *            String
	 * @return
	 */

	public void setFechaAltaAdhesion(String fechaAltaAdhesion) {
		this.fechaAltaAdhesion = fechaAltaAdhesion;
	}

	/**
	 * Method 'getFechaAltaAdhesionEus'.
	 * 
	 * @return String
	 */

	public String getFechaAltaAdhesionEus() {
		return this.fechaAltaAdhesionEus;
	}

	/**
	 * Method 'setFechaAltaAdhesionEus'.
	 * 
	 * @param fechaAltaAdhesionEus
	 *            String
	 * @return
	 */

	public void setFechaAltaAdhesionEus(String fechaAltaAdhesionEus) {
		this.fechaAltaAdhesionEus = fechaAltaAdhesionEus;
	}

	/**
	 * Method 'getNumeroAdhesion'.
	 * 
	 * @return Integer
	 */

	public Integer getNumeroAdhesion() {
		return this.numeroAdhesion;
	}

	/**
	 * Method 'setNumeroAdhesion'.
	 * 
	 * @param numeroAdhesion
	 *            Integer
	 * @return
	 */

	public void setNumeroAdhesion(Integer numeroAdhesion) {
		this.numeroAdhesion = numeroAdhesion;
	}

	/**
	 * Method 'getDireccionPostal'.
	 * 
	 * @return EstablecimientoDireccionWS
	 */

	public EstablecimientoDireccionWS getDireccionpostal() {
		return this.direccionPostal;
	}

	/**
	 * Method 'setDireccionPostal'.
	 * 
	 * @param direccionPostal
	 *            EstablecimientoDireccionWS
	 * @return
	 */

	public void setDireccionPostal(EstablecimientoDireccionWS direccionPostal) {
		this.direccionPostal = direccionPostal;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		// Clave compuesta

		result.append("[ razonSocial: ").append(this.razonSocial).append(" ]");

		result.append(", [ nombreComercial: ").append(this.nombreComercial)
				.append(" ]");

		result.append(", [ cif: ").append(this.cif).append(" ]");

		result.append(", [ fechaAltaAdhesion: ").append(this.fechaAltaAdhesion)
				.append(" ]");

		result.append(", [ fechaAltaAdhesionEus: ")
				.append(this.fechaAltaAdhesionEus).append(" ]");

		result.append(", [ numeroAdhesion: ").append(this.numeroAdhesion)
				.append(" ]");

		result.append(", [ direccionPostal: ").append(this.direccionPostal)
				.append(" ]");

		result.append("}");
		return result.toString();
	}

}
