package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * fechaAcuerdoIncoacion  
 * 
 *  
 */

public class TramiteSANPropuestaResolucion extends TramiteDatosBasicos
		implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private Date fechaResolucion;
	private String tipoResolucion;
	private BigDecimal tipoSancionAccesoria;
	private String importeSancion;

	private String anyadirPlantilla;

	/**
	 * @return the tipoResolucion
	 */
	public String getTipoResolucion() {
		return tipoResolucion;
	}

	/**
	 * @param tipoResolucion
	 *            the tipoResolucion to set
	 */
	public void setTipoResolucion(String tipoResolucion) {
		this.tipoResolucion = tipoResolucion;
	}

	/**
	 * 
	 */
	public TramiteSANPropuestaResolucion() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TramiteSANPropuestaResolucion [fechaResolucion="
				+ fechaResolucion + ", tipoResolucion=" + tipoResolucion
				+ ", tipoSancionAccesoria=" + tipoSancionAccesoria
				+ ", importeSancion=" + importeSancion + ", anyadirPlantilla="
				+ anyadirPlantilla + "]";
	}

	public void setTipoSancionAccesoria(BigDecimal tipoSancionAccesoria) {
		this.tipoSancionAccesoria = tipoSancionAccesoria;
	}

	public BigDecimal getTipoSancionAccesoria() {
		return tipoSancionAccesoria;
	}

	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setFechaResolucion(Date fechaResolucion) {
		this.fechaResolucion = fechaResolucion;
	}

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getFechaResolucion() {
		return fechaResolucion;
	}

	public void setImporteSancion(String importeSancion) {
		this.importeSancion = importeSancion;
	}

	public String getImporteSancion() {
		return importeSancion;
	}

	/**
	 * @return the anyadirPlantilla
	 */
	public String getAnyadirPlantilla() {
		return anyadirPlantilla;
	}

	/**
	 * @param anyadirPlantilla
	 *            the anyadirPlantilla to set
	 */
	public void setAnyadirPlantilla(String anyadirPlantilla) {
		this.anyadirPlantilla = anyadirPlantilla;
	}

}
