package com.ejie.y41b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * fechaAcuerdoIncoacion  
 * 
 *  
 */

public class TramiteSANAcuerdoIncoacion extends TramiteDatosBasicos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private Date fechaAcuerdoIncoacion;

	private String importeInicial;

	private String anyadirPlantilla;

	// Utiliza estas constantes, via se utiliza para saber que via hay que
	// utilizar para el acuerdo de incoacin
	// TIPO_NOTIFICACION_TELEMATICA = "T";
	// TIPO_NOTIFICACION_ORDINARIA = "C";
	private String via;

	/**
	 * 
	 */
	public TramiteSANAcuerdoIncoacion() {
		super();
	}

	/**
	 * @return the fechaAcuerdoIncoacion
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getFechaAcuerdoIncoacion() {
		return fechaAcuerdoIncoacion;
	}

	/**
	 * @param nombfechaAcuerdoIncoacionreTramite
	 *            the fechaAcuerdoIncoacion to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setFechaAcuerdoIncoacion(Date fechaAcuerdoIncoacion) {
		this.fechaAcuerdoIncoacion = fechaAcuerdoIncoacion;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TramiteSANAcuerdoIncoacion [fechaAcuerdoIncoacion=" + fechaAcuerdoIncoacion + ", importeInicial="
				+ importeInicial + ", anyadirPlantilla=" + anyadirPlantilla + ", " + "via=" + via + "]";
	}

	/**
	 * @return the importeInicial
	 */
	public String getImporteInicial() {
		return importeInicial;
	}

	/**
	 * @param importeInicial
	 *            the importeInicial to set
	 */
	public void setImporteInicial(String importeInicial) {
		this.importeInicial = importeInicial;
	}

	/**
	 * @return the anyadirPlantilla
	 */
	public String getAnyadirPlantilla() {
		return anyadirPlantilla;
	}

	/**
	 * @param anyadirPlantilla
	 *            the anyadirPlantilla to set
	 */
	public void setAnyadirPlantilla(String anyadirPlantilla) {
		this.anyadirPlantilla = anyadirPlantilla;
	}

	/**
	 * @return the via
	 */
	public String getVia() {
		return via;
	}

	/**
	 * @param via
	 *            the via to set
	 */
	public void setVia(String via) {
		this.via = via;
	}

}
